#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2018 BetaRays
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Kero Blaster series:
# - Kero Blaster
# - Pink Heaven
# - Pink Hour
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250612.1

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID_BLASTER='kero-blaster'
GAME_NAME_BLASTER='Kero Blaster'

GAME_ID_HEAVEN='pink-heaven'
GAME_NAME_HEAVEN='Pink Heaven'

GAME_ID_HOUR='pink-hour'
GAME_NAME_HOUR='Pink Hour'

# The following archives used to be sold from Playism store,
# before it closed down in favour of Steam.

ARCHIVE_BASE_BLASTER_0_NAME='KeroBlaster_EN_v1501a.zip'
ARCHIVE_BASE_BLASTER_0_MD5='c6ba58d37b5344d08c7d9a94506266b0'
ARCHIVE_BASE_BLASTER_0_SIZE='20000'
ARCHIVE_BASE_BLASTER_0_VERSION='1.501-playism1501a'

ARCHIVE_BASE_HEAVEN_0_NAME='PinkHeavenEn-v1430a.zip'
ARCHIVE_BASE_HEAVEN_0_MD5='7d1b3e193a5ba9618cba1ffb0c977762'
ARCHIVE_BASE_HEAVEN_0_SIZE='15000'
ARCHIVE_BASE_HEAVEN_0_VERSION='1.43-playism1430a'

ARCHIVE_BASE_HOUR_0_NAME='PinkHourEn-v1430a.zip'
ARCHIVE_BASE_HOUR_0_MD5='7cd38735bf02634474eb8bf5a39439b2'
ARCHIVE_BASE_HOUR_0_SIZE='15000'
ARCHIVE_BASE_HOUR_0_VERSION='1.43-playism1430a'

CONTENT_PATH_DEFAULT_BLASTER='KeroBlasterEn'
CONTENT_PATH_DEFAULT_HEAVEN='PinkHeavenEn'
CONTENT_PATH_DEFAULT_HOUR='PinkHourEn'
CONTENT_GAME_BIN_FILES_BLASTER='
KeroBlaster.exe'
CONTENT_GAME_BIN_FILES_HEAVEN='
PinkHeaven.exe'
CONTENT_GAME_BIN_FILES_HOUR='
PinkHour.exe'
CONTENT_GAME_DATA_FILES='
rsc_?'
CONTENT_DOC_DATA_FILES='
ReadmeEn.txt'

APP_MAIN_EXE_BLASTER='KeroBlaster.exe'
APP_MAIN_EXE_HEAVEN='PinkHeaven.exe'
APP_MAIN_EXE_HOUR='PinkHour.exe'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN_DEPENDENCIES_LIBRARIES='
libasound.so.2
libmpg123.so.0'

PKG_DATA_ID_BLASTER="${GAME_ID_BLASTER}-data"
PKG_DATA_ID_HEAVEN="${GAME_ID_HEAVEN}-data"
PKG_DATA_ID_HOUR="${GAME_ID_HOUR}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
