#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2023 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Scarf
# send your bug reports to bugs@dotslashplay.it
###

script_version=20251011.6

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID='scarf'
GAME_NAME='Scarf'

ARCHIVE_BASE_0_NAME='setup_scarf_1.1_(64bit)_(53216).exe'
ARCHIVE_BASE_0_MD5='128b44bb5ba007934e91ad2a0ff6f693'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_PART1_NAME='setup_scarf_1.1_(64bit)_(53216)-1.bin'
ARCHIVE_BASE_0_PART1_MD5='ef5faab9ebab9772dd159d5cafde0311'
ARCHIVE_BASE_0_PART2_NAME='setup_scarf_1.1_(64bit)_(53216)-2.bin'
ARCHIVE_BASE_0_PART2_MD5='e388bd53a584a6bb9e58ae9b4af0b3b4'
ARCHIVE_BASE_0_PART3_NAME='setup_scarf_1.1_(64bit)_(53216)-3.bin'
ARCHIVE_BASE_0_PART3_MD5='000370e5c0bac838f8f50f9b2cfc3f18'
ARCHIVE_BASE_0_PART4_NAME='setup_scarf_1.1_(64bit)_(53216)-4.bin'
ARCHIVE_BASE_0_PART4_MD5='761da3606e1e2dfa741b5e8be51cd9f3'
ARCHIVE_BASE_0_SIZE='14000000'
ARCHIVE_BASE_0_VERSION='1.1-gog53216'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/scarf'

UNREALENGINE4_NAME='scarf'

CONTENT_PATH_DEFAULT='.'

HUGE_FILES_DATA="
${UNREALENGINE4_NAME}/content/paks/${UNREALENGINE4_NAME}-windowsnoeditor.pak"

APP_MAIN_EXE="${UNREALENGINE4_NAME}/binaries/win64/${UNREALENGINE4_NAME}-win64-shipping.exe"
## Override the default wrestool options for Unreal Engine 4 games.
APP_MAIN_ICON_WRESTOOL_OPTIONS='--type=14 --name=123'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'

PKG_MOVIES_ID="${GAME_ID}-movies"
PKG_MOVIES_DESCRIPTION='movies'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'
## Easier upgrades from pre-20251011.5 packages
PKG_DATA_PROVIDES='
scarf-movies'

# Load common functions.

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run default initialisation actions.

initialization_default "$@"

# Extract game data.

archive_extraction_default
## Delete unused debug symbols.
find "${PLAYIT_WORKDIR}/gamedata/$(content_path_default)" -type f -name '*.pdb' -delete
## Delete unused UE Prerequisites installer.
rm --recursive "${PLAYIT_WORKDIR}/gamedata/$(content_path_default)/engine/extras"

# Include game data.

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers.

## Do not install the Visual C++ Runtime, as it triggers a loop of UE Prerequisites install on launch.
unrealengine4_wine_winetricks_verbs_default() { return 0; }

launchers_generation

# Build packages.

packages_generation
print_instructions

# Clean up.

working_directory_cleanup

exit 0
