      SUBROUTINE SYMRHF2(IRREP,NUML,NUMR,DISSIZE,BUF1,BUF2,
     &                   ISCRL,ISCRR,LIST)
C
C  THIS ROUTINE FORMS THE TERM 
C
C   A(I,J,K,L) --> A(I,J,K,L) + A(J,I,L,K)  
C
C  WHICH IS REQUIRED IN RHF CCSD CALCULATIONS
C
C  THIS IS THE OUT OF CORE VERSION
C
C  INPUT :  IRREP  ...   IRREP OF   G(K)*G(L) = G(I)*G(J)
C           NUMR   ....  POPULATION VECTOR FOR K,L
C           NUML   ....  POPULATION VECTOR FOR I,J
C           DISSIZE ...  DISTRIBUTION SIZE OF A
C           BUF1, BUF2 . BUFFERS FOR HOLDING THE A MATRIX
C           ISCRL,ISCRR  TWO SCRATCH ARRAYS OF SIZE DISSIZE
C           LIST ....... LISTNUMBER
C
C  OUTPUT :  A     ....  THE RHF SYMMETRIZED MATRIX
C
CEND
C
C  WRITTEN IN SEPTEMBER/90   JG
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      INTEGER DISSIZE,DIRPRD
      DIMENSION BUF1(1),BUF2(1),ISCRL(1),ISCRR(2),NUMR(8),NUML(8)
      COMMON /SYMINF/NSTART,NIRREP,IRREPA(255),IRREPB(255),
     &DIRPRD(8,8)
      DIMENSION IPL(8),IPR(8)
C
      IPR(1)=0
      IPL(1)=0          
      DO 10 IRREPJ=1,NIRREP-1
       IRREPI=DIRPRD(IRREP,IRREPJ)
       IPR(IRREPJ+1)=IPR(IRREPJ)+NUMR(IRREPJ)*NUMR(IRREPI)
       IPL(IRREPJ+1)=IPL(IRREPJ)+NUML(IRREPJ)*NUML(IRREPI)
10    CONTINUE
       
C
C  GET FIRST THE NEW ADDRESSES AND STORE THEM IN ISCR
C
C ADDRESSES FOR THE RIGHT SIDE
C
      NTOTAL=0
      DO 20  IRREPJ=1,NIRREP
       NUMJ=NUMR(IRREPJ)
       IRREPI=DIRPRD(IRREP,IRREPJ)
       NUMI=NUMR(IRREPI)
       NTOTAL=NTOTAL+NUMI*NUMJ
       DO 15 J=1,NUMJ
       DO 15 I=1,NUMI
        IND1=IPR(IRREPJ)+(J-1)*NUMI+I
        IND2=IPR(IRREPI)+(I-1)*NUMJ+J
        ISCRR(IND1)=IND2
15     CONTINUE
20    CONTINUE
C
C  ADDRESSES FOR THE LEFT SIDE
C
      DO 120  IRREPJ=1,NIRREP
       NUMJ=NUML(IRREPJ)
       IRREPI=DIRPRD(IRREP,IRREPJ)
       NUMI=NUML(IRREPI)
        DO 115 J=1,NUMJ
        DO 115 I=1,NUMI
         IND1=IPL(IRREPJ)+(J-1)*NUMI+I
         IND2=IPL(IRREPI)+(I-1)*NUMJ+J
         ISCRL(IND1)=IND2
115     CONTINUE
120    CONTINUE
C
C  NOW FORM A(IJ,KL) + A(JI,LK)
C
      DO 100 IJ=1,NTOTAL
       IF(ISCRR(IJ).NE.0) THEN
        IJTR=ISCRR(IJ) 
        ISCRR(IJTR)=0
        CALL GETLST(BUF1,IJ,1,1,IRREP,LIST)
        CALL GETLST(BUF2,IJTR,1,1,IRREP,LIST)
        DO 3 L=1,DISSIZE
         BUF1(L)=BUF1(L)+BUF2(ISCRL(L))
3       CONTINUE
c        DO 4 L=1,DISSIZE
c         BUF1(L,IJ)=SCR(L)
c4       CONTINUE
        CALL PUTLST(BUF1,IJ,1,1,IRREP,LIST)
CDIR$ IVDEP
*VOCL LOOP,NOVREC
        DO 5 L=1,DISSIZE
         BUF2(ISCRL(L))=BUF1(L)
5       CONTINUE
        CALL PUTLST(BUF2,IJTR,1,1,IRREP,LIST)
       ENDIF
100   CONTINUE
      RETURN
      END
