# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------


from .. import try_manual


# EXAMPLE: /Galleries/get/Get a gallery.
@try_manual
def step_image_definition_list_shared(test, rg, checks=None):
    if checks is None:
        checks = []
    test.cmd('az sig image-definition list-shared '
             '--gallery-unique-name "galleryUniqueName" '
             '--location "myLocation"',
             checks=checks)


# EXAMPLE: /SharedGalleryImages/get/Get a gallery.
@try_manual
def step_image_definition_show_shared(test, rg, checks=None):
    if checks is None:
        checks = []
    test.cmd('az sig image-definition show-shared '
             '--gallery-image-definition "myGalleryImageName" '
             '--gallery-unique-name "galleryUniqueName" '
             '--location "myLocation"',
             checks=checks)


# EXAMPLE: /SharedGalleryImageVersions/get/Get a gallery.
@try_manual
def step_image_version_show_shared(test, rg, checks=None):
    if checks is None:
        checks = []
    test.cmd('az sig image-version show-shared '
             '--gallery-image-definition "myGalleryImageName" '
             '--gallery-image-version "myGalleryImageVersionName" '
             '--gallery-unique-name "galleryUniqueName" '
             '--location "myLocation"',
             checks=checks)


# EXAMPLE: /SshPublicKeys/put/Create a new SSH public key resource.
@try_manual
def step_create(test, rg, checks=None):
    if checks is None:
        checks = []
    test.cmd('az sshkey create '
             '--location "westus" '
             '--public-key "{{ssh-rsa public key}}" '
             '--resource-group "{rg}" '
             '--name "{mySshPublicKey}"',
             checks=checks)


# EXAMPLE: /SshPublicKeys/get/Get an ssh public key.
@try_manual
def step_show(test, rg, checks=None):
    if checks is None:
        checks = []
    test.cmd('az sshkey show '
             '--resource-group "{rg}" '
             '--name "{mySshPublicKey}"',
             checks=checks)

