/*
Cloud Hypervisor API

Local HTTP based API for managing and inspecting a cloud-hypervisor virtual machine.

API version: 0.3.0
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package openapi

import (
	"encoding/json"
)

// TokenBucket Defines a token bucket with a maximum capacity (_size_), an initial burst size (_one_time_burst_) and an interval for refilling purposes (_refill_time_). The refill-rate is derived from _size_ and _refill_time_, and it is the constant rate at which the tokens replenish. The refill process only starts happening after the initial burst budget is consumed. Consumption from the token bucket is unbounded in speed which allows for bursts bound in size by the amount of tokens available. Once the token bucket is empty, consumption speed is bound by the refill-rate.
type TokenBucket struct {
	// The total number of tokens this bucket can hold.
	Size int64 `json:"size"`
	// The initial size of a token bucket.
	OneTimeBurst *int64 `json:"one_time_burst,omitempty"`
	// The amount of milliseconds it takes for the bucket to refill.
	RefillTime int64 `json:"refill_time"`
}

// NewTokenBucket instantiates a new TokenBucket object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewTokenBucket(size int64, refillTime int64) *TokenBucket {
	this := TokenBucket{}
	this.Size = size
	this.RefillTime = refillTime
	return &this
}

// NewTokenBucketWithDefaults instantiates a new TokenBucket object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewTokenBucketWithDefaults() *TokenBucket {
	this := TokenBucket{}
	return &this
}

// GetSize returns the Size field value
func (o *TokenBucket) GetSize() int64 {
	if o == nil {
		var ret int64
		return ret
	}

	return o.Size
}

// GetSizeOk returns a tuple with the Size field value
// and a boolean to check if the value has been set.
func (o *TokenBucket) GetSizeOk() (*int64, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Size, true
}

// SetSize sets field value
func (o *TokenBucket) SetSize(v int64) {
	o.Size = v
}

// GetOneTimeBurst returns the OneTimeBurst field value if set, zero value otherwise.
func (o *TokenBucket) GetOneTimeBurst() int64 {
	if o == nil || o.OneTimeBurst == nil {
		var ret int64
		return ret
	}
	return *o.OneTimeBurst
}

// GetOneTimeBurstOk returns a tuple with the OneTimeBurst field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *TokenBucket) GetOneTimeBurstOk() (*int64, bool) {
	if o == nil || o.OneTimeBurst == nil {
		return nil, false
	}
	return o.OneTimeBurst, true
}

// HasOneTimeBurst returns a boolean if a field has been set.
func (o *TokenBucket) HasOneTimeBurst() bool {
	if o != nil && o.OneTimeBurst != nil {
		return true
	}

	return false
}

// SetOneTimeBurst gets a reference to the given int64 and assigns it to the OneTimeBurst field.
func (o *TokenBucket) SetOneTimeBurst(v int64) {
	o.OneTimeBurst = &v
}

// GetRefillTime returns the RefillTime field value
func (o *TokenBucket) GetRefillTime() int64 {
	if o == nil {
		var ret int64
		return ret
	}

	return o.RefillTime
}

// GetRefillTimeOk returns a tuple with the RefillTime field value
// and a boolean to check if the value has been set.
func (o *TokenBucket) GetRefillTimeOk() (*int64, bool) {
	if o == nil {
		return nil, false
	}
	return &o.RefillTime, true
}

// SetRefillTime sets field value
func (o *TokenBucket) SetRefillTime(v int64) {
	o.RefillTime = v
}

func (o TokenBucket) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if true {
		toSerialize["size"] = o.Size
	}
	if o.OneTimeBurst != nil {
		toSerialize["one_time_burst"] = o.OneTimeBurst
	}
	if true {
		toSerialize["refill_time"] = o.RefillTime
	}
	return json.Marshal(toSerialize)
}

type NullableTokenBucket struct {
	value *TokenBucket
	isSet bool
}

func (v NullableTokenBucket) Get() *TokenBucket {
	return v.value
}

func (v *NullableTokenBucket) Set(val *TokenBucket) {
	v.value = val
	v.isSet = true
}

func (v NullableTokenBucket) IsSet() bool {
	return v.isSet
}

func (v *NullableTokenBucket) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableTokenBucket(val *TokenBucket) *NullableTokenBucket {
	return &NullableTokenBucket{value: val, isSet: true}
}

func (v NullableTokenBucket) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableTokenBucket) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
