
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2023 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQAbstractAudioInput.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QAbstractAudioInput>
#include <QAudioFormat>
#include <QChildEvent>
#include <QEvent>
#include <QIODevice>
#include <QMetaMethod>
#include <QObject>
#include <QThread>
#include <QTimerEvent>
#include "gsiQt.h"
#include "gsiQtMultimediaCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QAbstractAudioInput

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QAbstractAudioInput::staticMetaObject);
}


// int QAbstractAudioInput::bufferSize()


static void _init_f_bufferSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_bufferSize_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QAbstractAudioInput *)cls)->bufferSize ());
}


// int QAbstractAudioInput::bytesReady()


static void _init_f_bytesReady_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_bytesReady_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QAbstractAudioInput *)cls)->bytesReady ());
}


// qint64 QAbstractAudioInput::elapsedUSecs()


static void _init_f_elapsedUSecs_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_elapsedUSecs_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QAbstractAudioInput *)cls)->elapsedUSecs ());
}


// QAudio::Error QAbstractAudioInput::error()


static void _init_f_error_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QAudio::Error>::target_type > ();
}

static void _call_f_error_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QAudio::Error>::target_type > ((qt_gsi::Converter<QAudio::Error>::target_type)qt_gsi::CppToQtAdaptor<QAudio::Error>(((QAbstractAudioInput *)cls)->error ()));
}


// void QAbstractAudioInput::errorChanged(QAudio::Error)


static void _init_f_errorChanged_1653 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QAudio::Error>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_errorChanged_1653 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QAudio::Error>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QAudio::Error>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractAudioInput *)cls)->errorChanged (qt_gsi::QtToCppAdaptor<QAudio::Error>(arg1).cref());
}


// QAudioFormat QAbstractAudioInput::format()


static void _init_f_format_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QAudioFormat > ();
}

static void _call_f_format_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QAudioFormat > ((QAudioFormat)((QAbstractAudioInput *)cls)->format ());
}


// void QAbstractAudioInput::notify()


static void _init_f_notify_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_notify_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractAudioInput *)cls)->notify ();
}


// int QAbstractAudioInput::notifyInterval()


static void _init_f_notifyInterval_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_notifyInterval_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QAbstractAudioInput *)cls)->notifyInterval ());
}


// int QAbstractAudioInput::periodSize()


static void _init_f_periodSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_periodSize_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QAbstractAudioInput *)cls)->periodSize ());
}


// qint64 QAbstractAudioInput::processedUSecs()


static void _init_f_processedUSecs_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_f_processedUSecs_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QAbstractAudioInput *)cls)->processedUSecs ());
}


// void QAbstractAudioInput::reset()


static void _init_f_reset_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_reset_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractAudioInput *)cls)->reset ();
}


// void QAbstractAudioInput::resume()


static void _init_f_resume_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_resume_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractAudioInput *)cls)->resume ();
}


// void QAbstractAudioInput::setBufferSize(int value)


static void _init_f_setBufferSize_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("value");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setBufferSize_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractAudioInput *)cls)->setBufferSize (arg1);
}


// void QAbstractAudioInput::setFormat(const QAudioFormat &fmt)


static void _init_f_setFormat_2509 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fmt");
  decl->add_arg<const QAudioFormat & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFormat_2509 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QAudioFormat &arg1 = gsi::arg_reader<const QAudioFormat & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractAudioInput *)cls)->setFormat (arg1);
}


// void QAbstractAudioInput::setNotifyInterval(int milliSeconds)


static void _init_f_setNotifyInterval_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("milliSeconds");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setNotifyInterval_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractAudioInput *)cls)->setNotifyInterval (arg1);
}


// void QAbstractAudioInput::setVolume(double)


static void _init_f_setVolume_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setVolume_1071 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = gsi::arg_reader<double >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractAudioInput *)cls)->setVolume (arg1);
}


// void QAbstractAudioInput::start(QIODevice *device)


static void _init_f_start_1447 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("device");
  decl->add_arg<QIODevice * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_start_1447 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QIODevice *arg1 = gsi::arg_reader<QIODevice * >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractAudioInput *)cls)->start (arg1);
}


// QIODevice *QAbstractAudioInput::start()


static void _init_f_start_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QIODevice * > ();
}

static void _call_f_start_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QIODevice * > ((QIODevice *)((QAbstractAudioInput *)cls)->start ());
}


// QAudio::State QAbstractAudioInput::state()


static void _init_f_state_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QAudio::State>::target_type > ();
}

static void _call_f_state_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QAudio::State>::target_type > ((qt_gsi::Converter<QAudio::State>::target_type)qt_gsi::CppToQtAdaptor<QAudio::State>(((QAbstractAudioInput *)cls)->state ()));
}


// void QAbstractAudioInput::stateChanged(QAudio::State)


static void _init_f_stateChanged_1644 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QAudio::State>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_stateChanged_1644 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QAudio::State>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QAudio::State>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractAudioInput *)cls)->stateChanged (qt_gsi::QtToCppAdaptor<QAudio::State>(arg1).cref());
}


// void QAbstractAudioInput::stop()


static void _init_f_stop_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_stop_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractAudioInput *)cls)->stop ();
}


// void QAbstractAudioInput::suspend()


static void _init_f_suspend_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_suspend_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractAudioInput *)cls)->suspend ();
}


// double QAbstractAudioInput::volume()


static void _init_f_volume_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_volume_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QAbstractAudioInput *)cls)->volume ());
}


// static QString QAbstractAudioInput::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QAbstractAudioInput::tr (arg1, arg2, arg3));
}


// static QString QAbstractAudioInput::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QAbstractAudioInput::trUtf8 (arg1, arg2, arg3));
}


namespace gsi
{

static gsi::Methods methods_QAbstractAudioInput () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod (":bufferSize", "@brief Method int QAbstractAudioInput::bufferSize()\n", true, &_init_f_bufferSize_c0, &_call_f_bufferSize_c0);
  methods += new qt_gsi::GenericMethod ("bytesReady", "@brief Method int QAbstractAudioInput::bytesReady()\n", true, &_init_f_bytesReady_c0, &_call_f_bytesReady_c0);
  methods += new qt_gsi::GenericMethod ("elapsedUSecs", "@brief Method qint64 QAbstractAudioInput::elapsedUSecs()\n", true, &_init_f_elapsedUSecs_c0, &_call_f_elapsedUSecs_c0);
  methods += new qt_gsi::GenericMethod ("error", "@brief Method QAudio::Error QAbstractAudioInput::error()\n", true, &_init_f_error_c0, &_call_f_error_c0);
  methods += new qt_gsi::GenericMethod ("errorChanged", "@brief Method void QAbstractAudioInput::errorChanged(QAudio::Error)\n", false, &_init_f_errorChanged_1653, &_call_f_errorChanged_1653);
  methods += new qt_gsi::GenericMethod (":format", "@brief Method QAudioFormat QAbstractAudioInput::format()\n", true, &_init_f_format_c0, &_call_f_format_c0);
  methods += new qt_gsi::GenericMethod ("notify", "@brief Method void QAbstractAudioInput::notify()\n", false, &_init_f_notify_0, &_call_f_notify_0);
  methods += new qt_gsi::GenericMethod (":notifyInterval", "@brief Method int QAbstractAudioInput::notifyInterval()\n", true, &_init_f_notifyInterval_c0, &_call_f_notifyInterval_c0);
  methods += new qt_gsi::GenericMethod ("periodSize", "@brief Method int QAbstractAudioInput::periodSize()\n", true, &_init_f_periodSize_c0, &_call_f_periodSize_c0);
  methods += new qt_gsi::GenericMethod ("processedUSecs", "@brief Method qint64 QAbstractAudioInput::processedUSecs()\n", true, &_init_f_processedUSecs_c0, &_call_f_processedUSecs_c0);
  methods += new qt_gsi::GenericMethod ("reset", "@brief Method void QAbstractAudioInput::reset()\n", false, &_init_f_reset_0, &_call_f_reset_0);
  methods += new qt_gsi::GenericMethod ("resume", "@brief Method void QAbstractAudioInput::resume()\n", false, &_init_f_resume_0, &_call_f_resume_0);
  methods += new qt_gsi::GenericMethod ("setBufferSize|bufferSize=", "@brief Method void QAbstractAudioInput::setBufferSize(int value)\n", false, &_init_f_setBufferSize_767, &_call_f_setBufferSize_767);
  methods += new qt_gsi::GenericMethod ("setFormat|format=", "@brief Method void QAbstractAudioInput::setFormat(const QAudioFormat &fmt)\n", false, &_init_f_setFormat_2509, &_call_f_setFormat_2509);
  methods += new qt_gsi::GenericMethod ("setNotifyInterval|notifyInterval=", "@brief Method void QAbstractAudioInput::setNotifyInterval(int milliSeconds)\n", false, &_init_f_setNotifyInterval_767, &_call_f_setNotifyInterval_767);
  methods += new qt_gsi::GenericMethod ("setVolume|volume=", "@brief Method void QAbstractAudioInput::setVolume(double)\n", false, &_init_f_setVolume_1071, &_call_f_setVolume_1071);
  methods += new qt_gsi::GenericMethod ("start", "@brief Method void QAbstractAudioInput::start(QIODevice *device)\n", false, &_init_f_start_1447, &_call_f_start_1447);
  methods += new qt_gsi::GenericMethod ("start", "@brief Method QIODevice *QAbstractAudioInput::start()\n", false, &_init_f_start_0, &_call_f_start_0);
  methods += new qt_gsi::GenericMethod ("state", "@brief Method QAudio::State QAbstractAudioInput::state()\n", true, &_init_f_state_c0, &_call_f_state_c0);
  methods += new qt_gsi::GenericMethod ("stateChanged", "@brief Method void QAbstractAudioInput::stateChanged(QAudio::State)\n", false, &_init_f_stateChanged_1644, &_call_f_stateChanged_1644);
  methods += new qt_gsi::GenericMethod ("stop", "@brief Method void QAbstractAudioInput::stop()\n", false, &_init_f_stop_0, &_call_f_stop_0);
  methods += new qt_gsi::GenericMethod ("suspend", "@brief Method void QAbstractAudioInput::suspend()\n", false, &_init_f_suspend_0, &_call_f_suspend_0);
  methods += new qt_gsi::GenericMethod (":volume", "@brief Method double QAbstractAudioInput::volume()\n", true, &_init_f_volume_c0, &_call_f_volume_c0);
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QAbstractAudioInput::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QAbstractAudioInput::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  return methods;
}

gsi::Class<QObject> &qtdecl_QObject ();

qt_gsi::QtNativeClass<QAbstractAudioInput> decl_QAbstractAudioInput (qtdecl_QObject (), "QtMultimedia", "QAbstractAudioInput_Native",
  methods_QAbstractAudioInput (),
  "@hide\n@alias QAbstractAudioInput");

GSI_QTMULTIMEDIA_PUBLIC gsi::Class<QAbstractAudioInput> &qtdecl_QAbstractAudioInput () { return decl_QAbstractAudioInput; }

}


class QAbstractAudioInput_Adaptor : public QAbstractAudioInput, public qt_gsi::QtObjectBase
{
public:

  virtual ~QAbstractAudioInput_Adaptor();

  //  [adaptor ctor] QAbstractAudioInput::QAbstractAudioInput()
  QAbstractAudioInput_Adaptor() : QAbstractAudioInput()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] bool QAbstractAudioInput::isSignalConnected(const QMetaMethod &signal)
  bool fp_QAbstractAudioInput_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QAbstractAudioInput::isSignalConnected(signal);
  }

  //  [expose] int QAbstractAudioInput::receivers(const char *signal)
  int fp_QAbstractAudioInput_receivers_c1731 (const char *signal) const {
    return QAbstractAudioInput::receivers(signal);
  }

  //  [expose] QObject *QAbstractAudioInput::sender()
  QObject * fp_QAbstractAudioInput_sender_c0 () const {
    return QAbstractAudioInput::sender();
  }

  //  [expose] int QAbstractAudioInput::senderSignalIndex()
  int fp_QAbstractAudioInput_senderSignalIndex_c0 () const {
    return QAbstractAudioInput::senderSignalIndex();
  }

  //  [adaptor impl] int QAbstractAudioInput::bufferSize()
  int cbs_bufferSize_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("bufferSize");
  }

  virtual int bufferSize() const
  {
    if (cb_bufferSize_c0_0.can_issue()) {
      return cb_bufferSize_c0_0.issue<QAbstractAudioInput_Adaptor, int>(&QAbstractAudioInput_Adaptor::cbs_bufferSize_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("bufferSize");
    }
  }

  //  [adaptor impl] int QAbstractAudioInput::bytesReady()
  int cbs_bytesReady_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("bytesReady");
  }

  virtual int bytesReady() const
  {
    if (cb_bytesReady_c0_0.can_issue()) {
      return cb_bytesReady_c0_0.issue<QAbstractAudioInput_Adaptor, int>(&QAbstractAudioInput_Adaptor::cbs_bytesReady_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("bytesReady");
    }
  }

  //  [adaptor impl] qint64 QAbstractAudioInput::elapsedUSecs()
  qint64 cbs_elapsedUSecs_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("elapsedUSecs");
  }

  virtual qint64 elapsedUSecs() const
  {
    if (cb_elapsedUSecs_c0_0.can_issue()) {
      return cb_elapsedUSecs_c0_0.issue<QAbstractAudioInput_Adaptor, qint64>(&QAbstractAudioInput_Adaptor::cbs_elapsedUSecs_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("elapsedUSecs");
    }
  }

  //  [adaptor impl] QAudio::Error QAbstractAudioInput::error()
  qt_gsi::Converter<QAudio::Error>::target_type cbs_error_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("error");
  }

  virtual QAudio::Error error() const
  {
    if (cb_error_c0_0.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QAudio::Error>(cb_error_c0_0.issue<QAbstractAudioInput_Adaptor, qt_gsi::Converter<QAudio::Error>::target_type>(&QAbstractAudioInput_Adaptor::cbs_error_c0_0)).cref();
    } else {
      throw qt_gsi::AbstractMethodCalledException("error");
    }
  }

  //  [adaptor impl] bool QAbstractAudioInput::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QAbstractAudioInput::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QAbstractAudioInput_Adaptor, bool, QEvent *>(&QAbstractAudioInput_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QAbstractAudioInput::event(arg1);
    }
  }

  //  [adaptor impl] bool QAbstractAudioInput::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QAbstractAudioInput::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QAbstractAudioInput_Adaptor, bool, QObject *, QEvent *>(&QAbstractAudioInput_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QAbstractAudioInput::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] QAudioFormat QAbstractAudioInput::format()
  QAudioFormat cbs_format_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("format");
  }

  virtual QAudioFormat format() const
  {
    if (cb_format_c0_0.can_issue()) {
      return cb_format_c0_0.issue<QAbstractAudioInput_Adaptor, QAudioFormat>(&QAbstractAudioInput_Adaptor::cbs_format_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("format");
    }
  }

  //  [adaptor impl] int QAbstractAudioInput::notifyInterval()
  int cbs_notifyInterval_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("notifyInterval");
  }

  virtual int notifyInterval() const
  {
    if (cb_notifyInterval_c0_0.can_issue()) {
      return cb_notifyInterval_c0_0.issue<QAbstractAudioInput_Adaptor, int>(&QAbstractAudioInput_Adaptor::cbs_notifyInterval_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("notifyInterval");
    }
  }

  //  [adaptor impl] int QAbstractAudioInput::periodSize()
  int cbs_periodSize_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("periodSize");
  }

  virtual int periodSize() const
  {
    if (cb_periodSize_c0_0.can_issue()) {
      return cb_periodSize_c0_0.issue<QAbstractAudioInput_Adaptor, int>(&QAbstractAudioInput_Adaptor::cbs_periodSize_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("periodSize");
    }
  }

  //  [adaptor impl] qint64 QAbstractAudioInput::processedUSecs()
  qint64 cbs_processedUSecs_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("processedUSecs");
  }

  virtual qint64 processedUSecs() const
  {
    if (cb_processedUSecs_c0_0.can_issue()) {
      return cb_processedUSecs_c0_0.issue<QAbstractAudioInput_Adaptor, qint64>(&QAbstractAudioInput_Adaptor::cbs_processedUSecs_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("processedUSecs");
    }
  }

  //  [adaptor impl] void QAbstractAudioInput::reset()
  void cbs_reset_0_0()
  {
    throw qt_gsi::AbstractMethodCalledException("reset");
  }

  virtual void reset()
  {
    if (cb_reset_0_0.can_issue()) {
      cb_reset_0_0.issue<QAbstractAudioInput_Adaptor>(&QAbstractAudioInput_Adaptor::cbs_reset_0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("reset");
    }
  }

  //  [adaptor impl] void QAbstractAudioInput::resume()
  void cbs_resume_0_0()
  {
    throw qt_gsi::AbstractMethodCalledException("resume");
  }

  virtual void resume()
  {
    if (cb_resume_0_0.can_issue()) {
      cb_resume_0_0.issue<QAbstractAudioInput_Adaptor>(&QAbstractAudioInput_Adaptor::cbs_resume_0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("resume");
    }
  }

  //  [adaptor impl] void QAbstractAudioInput::setBufferSize(int value)
  void cbs_setBufferSize_767_0(int value)
  {
    __SUPPRESS_UNUSED_WARNING (value);
    throw qt_gsi::AbstractMethodCalledException("setBufferSize");
  }

  virtual void setBufferSize(int value)
  {
    if (cb_setBufferSize_767_0.can_issue()) {
      cb_setBufferSize_767_0.issue<QAbstractAudioInput_Adaptor, int>(&QAbstractAudioInput_Adaptor::cbs_setBufferSize_767_0, value);
    } else {
      throw qt_gsi::AbstractMethodCalledException("setBufferSize");
    }
  }

  //  [adaptor impl] void QAbstractAudioInput::setFormat(const QAudioFormat &fmt)
  void cbs_setFormat_2509_0(const QAudioFormat &fmt)
  {
    __SUPPRESS_UNUSED_WARNING (fmt);
    throw qt_gsi::AbstractMethodCalledException("setFormat");
  }

  virtual void setFormat(const QAudioFormat &fmt)
  {
    if (cb_setFormat_2509_0.can_issue()) {
      cb_setFormat_2509_0.issue<QAbstractAudioInput_Adaptor, const QAudioFormat &>(&QAbstractAudioInput_Adaptor::cbs_setFormat_2509_0, fmt);
    } else {
      throw qt_gsi::AbstractMethodCalledException("setFormat");
    }
  }

  //  [adaptor impl] void QAbstractAudioInput::setNotifyInterval(int milliSeconds)
  void cbs_setNotifyInterval_767_0(int milliSeconds)
  {
    __SUPPRESS_UNUSED_WARNING (milliSeconds);
    throw qt_gsi::AbstractMethodCalledException("setNotifyInterval");
  }

  virtual void setNotifyInterval(int milliSeconds)
  {
    if (cb_setNotifyInterval_767_0.can_issue()) {
      cb_setNotifyInterval_767_0.issue<QAbstractAudioInput_Adaptor, int>(&QAbstractAudioInput_Adaptor::cbs_setNotifyInterval_767_0, milliSeconds);
    } else {
      throw qt_gsi::AbstractMethodCalledException("setNotifyInterval");
    }
  }

  //  [adaptor impl] void QAbstractAudioInput::setVolume(double)
  void cbs_setVolume_1071_0(double arg1)
  {
    __SUPPRESS_UNUSED_WARNING (arg1);
    throw qt_gsi::AbstractMethodCalledException("setVolume");
  }

  virtual void setVolume(double arg1)
  {
    if (cb_setVolume_1071_0.can_issue()) {
      cb_setVolume_1071_0.issue<QAbstractAudioInput_Adaptor, double>(&QAbstractAudioInput_Adaptor::cbs_setVolume_1071_0, arg1);
    } else {
      throw qt_gsi::AbstractMethodCalledException("setVolume");
    }
  }

  //  [adaptor impl] void QAbstractAudioInput::start(QIODevice *device)
  void cbs_start_1447_0(QIODevice *device)
  {
    __SUPPRESS_UNUSED_WARNING (device);
    throw qt_gsi::AbstractMethodCalledException("start");
  }

  virtual void start(QIODevice *device)
  {
    if (cb_start_1447_0.can_issue()) {
      cb_start_1447_0.issue<QAbstractAudioInput_Adaptor, QIODevice *>(&QAbstractAudioInput_Adaptor::cbs_start_1447_0, device);
    } else {
      throw qt_gsi::AbstractMethodCalledException("start");
    }
  }

  //  [adaptor impl] QIODevice *QAbstractAudioInput::start()
  QIODevice * cbs_start_0_0()
  {
    throw qt_gsi::AbstractMethodCalledException("start");
  }

  virtual QIODevice * start()
  {
    if (cb_start_0_0.can_issue()) {
      return cb_start_0_0.issue<QAbstractAudioInput_Adaptor, QIODevice *>(&QAbstractAudioInput_Adaptor::cbs_start_0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("start");
    }
  }

  //  [adaptor impl] QAudio::State QAbstractAudioInput::state()
  qt_gsi::Converter<QAudio::State>::target_type cbs_state_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("state");
  }

  virtual QAudio::State state() const
  {
    if (cb_state_c0_0.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QAudio::State>(cb_state_c0_0.issue<QAbstractAudioInput_Adaptor, qt_gsi::Converter<QAudio::State>::target_type>(&QAbstractAudioInput_Adaptor::cbs_state_c0_0)).cref();
    } else {
      throw qt_gsi::AbstractMethodCalledException("state");
    }
  }

  //  [adaptor impl] void QAbstractAudioInput::stop()
  void cbs_stop_0_0()
  {
    throw qt_gsi::AbstractMethodCalledException("stop");
  }

  virtual void stop()
  {
    if (cb_stop_0_0.can_issue()) {
      cb_stop_0_0.issue<QAbstractAudioInput_Adaptor>(&QAbstractAudioInput_Adaptor::cbs_stop_0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("stop");
    }
  }

  //  [adaptor impl] void QAbstractAudioInput::suspend()
  void cbs_suspend_0_0()
  {
    throw qt_gsi::AbstractMethodCalledException("suspend");
  }

  virtual void suspend()
  {
    if (cb_suspend_0_0.can_issue()) {
      cb_suspend_0_0.issue<QAbstractAudioInput_Adaptor>(&QAbstractAudioInput_Adaptor::cbs_suspend_0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("suspend");
    }
  }

  //  [adaptor impl] double QAbstractAudioInput::volume()
  double cbs_volume_c0_0() const
  {
    throw qt_gsi::AbstractMethodCalledException("volume");
  }

  virtual double volume() const
  {
    if (cb_volume_c0_0.can_issue()) {
      return cb_volume_c0_0.issue<QAbstractAudioInput_Adaptor, double>(&QAbstractAudioInput_Adaptor::cbs_volume_c0_0);
    } else {
      throw qt_gsi::AbstractMethodCalledException("volume");
    }
  }

  //  [adaptor impl] void QAbstractAudioInput::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QAbstractAudioInput::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QAbstractAudioInput_Adaptor, QChildEvent *>(&QAbstractAudioInput_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QAbstractAudioInput::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QAbstractAudioInput::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QAbstractAudioInput::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QAbstractAudioInput_Adaptor, QEvent *>(&QAbstractAudioInput_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QAbstractAudioInput::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QAbstractAudioInput::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QAbstractAudioInput::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QAbstractAudioInput_Adaptor, const QMetaMethod &>(&QAbstractAudioInput_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QAbstractAudioInput::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QAbstractAudioInput::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QAbstractAudioInput::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QAbstractAudioInput_Adaptor, QTimerEvent *>(&QAbstractAudioInput_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QAbstractAudioInput::timerEvent(arg1);
    }
  }

  gsi::Callback cb_bufferSize_c0_0;
  gsi::Callback cb_bytesReady_c0_0;
  gsi::Callback cb_elapsedUSecs_c0_0;
  gsi::Callback cb_error_c0_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_format_c0_0;
  gsi::Callback cb_notifyInterval_c0_0;
  gsi::Callback cb_periodSize_c0_0;
  gsi::Callback cb_processedUSecs_c0_0;
  gsi::Callback cb_reset_0_0;
  gsi::Callback cb_resume_0_0;
  gsi::Callback cb_setBufferSize_767_0;
  gsi::Callback cb_setFormat_2509_0;
  gsi::Callback cb_setNotifyInterval_767_0;
  gsi::Callback cb_setVolume_1071_0;
  gsi::Callback cb_start_1447_0;
  gsi::Callback cb_start_0_0;
  gsi::Callback cb_state_c0_0;
  gsi::Callback cb_stop_0_0;
  gsi::Callback cb_suspend_0_0;
  gsi::Callback cb_volume_c0_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QAbstractAudioInput_Adaptor::~QAbstractAudioInput_Adaptor() { }

//  Constructor QAbstractAudioInput::QAbstractAudioInput() (adaptor class)

static void _init_ctor_QAbstractAudioInput_Adaptor_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QAbstractAudioInput_Adaptor> ();
}

static void _call_ctor_QAbstractAudioInput_Adaptor_0 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QAbstractAudioInput_Adaptor *> (new QAbstractAudioInput_Adaptor ());
}


// int QAbstractAudioInput::bufferSize()

static void _init_cbs_bufferSize_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_bufferSize_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QAbstractAudioInput_Adaptor *)cls)->cbs_bufferSize_c0_0 ());
}

static void _set_callback_cbs_bufferSize_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAudioInput_Adaptor *)cls)->cb_bufferSize_c0_0 = cb;
}


// int QAbstractAudioInput::bytesReady()

static void _init_cbs_bytesReady_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_bytesReady_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QAbstractAudioInput_Adaptor *)cls)->cbs_bytesReady_c0_0 ());
}

static void _set_callback_cbs_bytesReady_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAudioInput_Adaptor *)cls)->cb_bytesReady_c0_0 = cb;
}


// void QAbstractAudioInput::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractAudioInput_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAudioInput_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QAbstractAudioInput::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractAudioInput_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAudioInput_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// void QAbstractAudioInput::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractAudioInput_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAudioInput_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// qint64 QAbstractAudioInput::elapsedUSecs()

static void _init_cbs_elapsedUSecs_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_cbs_elapsedUSecs_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QAbstractAudioInput_Adaptor *)cls)->cbs_elapsedUSecs_c0_0 ());
}

static void _set_callback_cbs_elapsedUSecs_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAudioInput_Adaptor *)cls)->cb_elapsedUSecs_c0_0 = cb;
}


// QAudio::Error QAbstractAudioInput::error()

static void _init_cbs_error_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QAudio::Error>::target_type > ();
}

static void _call_cbs_error_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QAudio::Error>::target_type > ((qt_gsi::Converter<QAudio::Error>::target_type)((QAbstractAudioInput_Adaptor *)cls)->cbs_error_c0_0 ());
}

static void _set_callback_cbs_error_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAudioInput_Adaptor *)cls)->cb_error_c0_0 = cb;
}


// bool QAbstractAudioInput::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QAbstractAudioInput_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAudioInput_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QAbstractAudioInput::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QAbstractAudioInput_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAudioInput_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// QAudioFormat QAbstractAudioInput::format()

static void _init_cbs_format_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QAudioFormat > ();
}

static void _call_cbs_format_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QAudioFormat > ((QAudioFormat)((QAbstractAudioInput_Adaptor *)cls)->cbs_format_c0_0 ());
}

static void _set_callback_cbs_format_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAudioInput_Adaptor *)cls)->cb_format_c0_0 = cb;
}


// exposed bool QAbstractAudioInput::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QAbstractAudioInput_Adaptor *)cls)->fp_QAbstractAudioInput_isSignalConnected_c2394 (arg1));
}


// int QAbstractAudioInput::notifyInterval()

static void _init_cbs_notifyInterval_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_notifyInterval_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QAbstractAudioInput_Adaptor *)cls)->cbs_notifyInterval_c0_0 ());
}

static void _set_callback_cbs_notifyInterval_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAudioInput_Adaptor *)cls)->cb_notifyInterval_c0_0 = cb;
}


// int QAbstractAudioInput::periodSize()

static void _init_cbs_periodSize_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_periodSize_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QAbstractAudioInput_Adaptor *)cls)->cbs_periodSize_c0_0 ());
}

static void _set_callback_cbs_periodSize_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAudioInput_Adaptor *)cls)->cb_periodSize_c0_0 = cb;
}


// qint64 QAbstractAudioInput::processedUSecs()

static void _init_cbs_processedUSecs_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qint64 > ();
}

static void _call_cbs_processedUSecs_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qint64 > ((qint64)((QAbstractAudioInput_Adaptor *)cls)->cbs_processedUSecs_c0_0 ());
}

static void _set_callback_cbs_processedUSecs_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAudioInput_Adaptor *)cls)->cb_processedUSecs_c0_0 = cb;
}


// exposed int QAbstractAudioInput::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QAbstractAudioInput_Adaptor *)cls)->fp_QAbstractAudioInput_receivers_c1731 (arg1));
}


// void QAbstractAudioInput::reset()

static void _init_cbs_reset_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_reset_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractAudioInput_Adaptor *)cls)->cbs_reset_0_0 ();
}

static void _set_callback_cbs_reset_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAudioInput_Adaptor *)cls)->cb_reset_0_0 = cb;
}


// void QAbstractAudioInput::resume()

static void _init_cbs_resume_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_resume_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractAudioInput_Adaptor *)cls)->cbs_resume_0_0 ();
}

static void _set_callback_cbs_resume_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAudioInput_Adaptor *)cls)->cb_resume_0_0 = cb;
}


// exposed QObject *QAbstractAudioInput::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QAbstractAudioInput_Adaptor *)cls)->fp_QAbstractAudioInput_sender_c0 ());
}


// exposed int QAbstractAudioInput::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QAbstractAudioInput_Adaptor *)cls)->fp_QAbstractAudioInput_senderSignalIndex_c0 ());
}


// void QAbstractAudioInput::setBufferSize(int value)

static void _init_cbs_setBufferSize_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("value");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setBufferSize_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractAudioInput_Adaptor *)cls)->cbs_setBufferSize_767_0 (arg1);
}

static void _set_callback_cbs_setBufferSize_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAudioInput_Adaptor *)cls)->cb_setBufferSize_767_0 = cb;
}


// void QAbstractAudioInput::setFormat(const QAudioFormat &fmt)

static void _init_cbs_setFormat_2509_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("fmt");
  decl->add_arg<const QAudioFormat & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setFormat_2509_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QAudioFormat &arg1 = args.read<const QAudioFormat & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractAudioInput_Adaptor *)cls)->cbs_setFormat_2509_0 (arg1);
}

static void _set_callback_cbs_setFormat_2509_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAudioInput_Adaptor *)cls)->cb_setFormat_2509_0 = cb;
}


// void QAbstractAudioInput::setNotifyInterval(int milliSeconds)

static void _init_cbs_setNotifyInterval_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("milliSeconds");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setNotifyInterval_767_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = args.read<int > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractAudioInput_Adaptor *)cls)->cbs_setNotifyInterval_767_0 (arg1);
}

static void _set_callback_cbs_setNotifyInterval_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAudioInput_Adaptor *)cls)->cb_setNotifyInterval_767_0 = cb;
}


// void QAbstractAudioInput::setVolume(double)

static void _init_cbs_setVolume_1071_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setVolume_1071_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  double arg1 = args.read<double > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractAudioInput_Adaptor *)cls)->cbs_setVolume_1071_0 (arg1);
}

static void _set_callback_cbs_setVolume_1071_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAudioInput_Adaptor *)cls)->cb_setVolume_1071_0 = cb;
}


// void QAbstractAudioInput::start(QIODevice *device)

static void _init_cbs_start_1447_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("device");
  decl->add_arg<QIODevice * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_start_1447_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QIODevice *arg1 = args.read<QIODevice * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractAudioInput_Adaptor *)cls)->cbs_start_1447_0 (arg1);
}

static void _set_callback_cbs_start_1447_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAudioInput_Adaptor *)cls)->cb_start_1447_0 = cb;
}


// QIODevice *QAbstractAudioInput::start()

static void _init_cbs_start_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QIODevice * > ();
}

static void _call_cbs_start_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QIODevice * > ((QIODevice *)((QAbstractAudioInput_Adaptor *)cls)->cbs_start_0_0 ());
}

static void _set_callback_cbs_start_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAudioInput_Adaptor *)cls)->cb_start_0_0 = cb;
}


// QAudio::State QAbstractAudioInput::state()

static void _init_cbs_state_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QAudio::State>::target_type > ();
}

static void _call_cbs_state_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<qt_gsi::Converter<QAudio::State>::target_type > ((qt_gsi::Converter<QAudio::State>::target_type)((QAbstractAudioInput_Adaptor *)cls)->cbs_state_c0_0 ());
}

static void _set_callback_cbs_state_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAudioInput_Adaptor *)cls)->cb_state_c0_0 = cb;
}


// void QAbstractAudioInput::stop()

static void _init_cbs_stop_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_stop_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractAudioInput_Adaptor *)cls)->cbs_stop_0_0 ();
}

static void _set_callback_cbs_stop_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAudioInput_Adaptor *)cls)->cb_stop_0_0 = cb;
}


// void QAbstractAudioInput::suspend()

static void _init_cbs_suspend_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_suspend_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractAudioInput_Adaptor *)cls)->cbs_suspend_0_0 ();
}

static void _set_callback_cbs_suspend_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAudioInput_Adaptor *)cls)->cb_suspend_0_0 = cb;
}


// void QAbstractAudioInput::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QAbstractAudioInput_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAudioInput_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


// double QAbstractAudioInput::volume()

static void _init_cbs_volume_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_cbs_volume_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<double > ((double)((QAbstractAudioInput_Adaptor *)cls)->cbs_volume_c0_0 ());
}

static void _set_callback_cbs_volume_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QAbstractAudioInput_Adaptor *)cls)->cb_volume_c0_0 = cb;
}


namespace gsi
{

gsi::Class<QAbstractAudioInput> &qtdecl_QAbstractAudioInput ();

static gsi::Methods methods_QAbstractAudioInput_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QAbstractAudioInput::QAbstractAudioInput()\nThis method creates an object of class QAbstractAudioInput.", &_init_ctor_QAbstractAudioInput_Adaptor_0, &_call_ctor_QAbstractAudioInput_Adaptor_0);
  methods += new qt_gsi::GenericMethod ("bufferSize", "@brief Virtual method int QAbstractAudioInput::bufferSize()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_bufferSize_c0_0, &_call_cbs_bufferSize_c0_0);
  methods += new qt_gsi::GenericMethod ("bufferSize", "@hide", true, &_init_cbs_bufferSize_c0_0, &_call_cbs_bufferSize_c0_0, &_set_callback_cbs_bufferSize_c0_0);
  methods += new qt_gsi::GenericMethod ("bytesReady", "@brief Virtual method int QAbstractAudioInput::bytesReady()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_bytesReady_c0_0, &_call_cbs_bytesReady_c0_0);
  methods += new qt_gsi::GenericMethod ("bytesReady", "@hide", true, &_init_cbs_bytesReady_c0_0, &_call_cbs_bytesReady_c0_0, &_set_callback_cbs_bytesReady_c0_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QAbstractAudioInput::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QAbstractAudioInput::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QAbstractAudioInput::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("elapsedUSecs", "@brief Virtual method qint64 QAbstractAudioInput::elapsedUSecs()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_elapsedUSecs_c0_0, &_call_cbs_elapsedUSecs_c0_0);
  methods += new qt_gsi::GenericMethod ("elapsedUSecs", "@hide", true, &_init_cbs_elapsedUSecs_c0_0, &_call_cbs_elapsedUSecs_c0_0, &_set_callback_cbs_elapsedUSecs_c0_0);
  methods += new qt_gsi::GenericMethod ("error", "@brief Virtual method QAudio::Error QAbstractAudioInput::error()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_error_c0_0, &_call_cbs_error_c0_0);
  methods += new qt_gsi::GenericMethod ("error", "@hide", true, &_init_cbs_error_c0_0, &_call_cbs_error_c0_0, &_set_callback_cbs_error_c0_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QAbstractAudioInput::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QAbstractAudioInput::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("format", "@brief Virtual method QAudioFormat QAbstractAudioInput::format()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_format_c0_0, &_call_cbs_format_c0_0);
  methods += new qt_gsi::GenericMethod ("format", "@hide", true, &_init_cbs_format_c0_0, &_call_cbs_format_c0_0, &_set_callback_cbs_format_c0_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QAbstractAudioInput::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("notifyInterval", "@brief Virtual method int QAbstractAudioInput::notifyInterval()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_notifyInterval_c0_0, &_call_cbs_notifyInterval_c0_0);
  methods += new qt_gsi::GenericMethod ("notifyInterval", "@hide", true, &_init_cbs_notifyInterval_c0_0, &_call_cbs_notifyInterval_c0_0, &_set_callback_cbs_notifyInterval_c0_0);
  methods += new qt_gsi::GenericMethod ("periodSize", "@brief Virtual method int QAbstractAudioInput::periodSize()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_periodSize_c0_0, &_call_cbs_periodSize_c0_0);
  methods += new qt_gsi::GenericMethod ("periodSize", "@hide", true, &_init_cbs_periodSize_c0_0, &_call_cbs_periodSize_c0_0, &_set_callback_cbs_periodSize_c0_0);
  methods += new qt_gsi::GenericMethod ("processedUSecs", "@brief Virtual method qint64 QAbstractAudioInput::processedUSecs()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_processedUSecs_c0_0, &_call_cbs_processedUSecs_c0_0);
  methods += new qt_gsi::GenericMethod ("processedUSecs", "@hide", true, &_init_cbs_processedUSecs_c0_0, &_call_cbs_processedUSecs_c0_0, &_set_callback_cbs_processedUSecs_c0_0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QAbstractAudioInput::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("reset", "@brief Virtual method void QAbstractAudioInput::reset()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_reset_0_0, &_call_cbs_reset_0_0);
  methods += new qt_gsi::GenericMethod ("reset", "@hide", false, &_init_cbs_reset_0_0, &_call_cbs_reset_0_0, &_set_callback_cbs_reset_0_0);
  methods += new qt_gsi::GenericMethod ("resume", "@brief Virtual method void QAbstractAudioInput::resume()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_resume_0_0, &_call_cbs_resume_0_0);
  methods += new qt_gsi::GenericMethod ("resume", "@hide", false, &_init_cbs_resume_0_0, &_call_cbs_resume_0_0, &_set_callback_cbs_resume_0_0);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QAbstractAudioInput::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QAbstractAudioInput::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("setBufferSize", "@brief Virtual method void QAbstractAudioInput::setBufferSize(int value)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setBufferSize_767_0, &_call_cbs_setBufferSize_767_0);
  methods += new qt_gsi::GenericMethod ("setBufferSize", "@hide", false, &_init_cbs_setBufferSize_767_0, &_call_cbs_setBufferSize_767_0, &_set_callback_cbs_setBufferSize_767_0);
  methods += new qt_gsi::GenericMethod ("setFormat", "@brief Virtual method void QAbstractAudioInput::setFormat(const QAudioFormat &fmt)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setFormat_2509_0, &_call_cbs_setFormat_2509_0);
  methods += new qt_gsi::GenericMethod ("setFormat", "@hide", false, &_init_cbs_setFormat_2509_0, &_call_cbs_setFormat_2509_0, &_set_callback_cbs_setFormat_2509_0);
  methods += new qt_gsi::GenericMethod ("setNotifyInterval", "@brief Virtual method void QAbstractAudioInput::setNotifyInterval(int milliSeconds)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setNotifyInterval_767_0, &_call_cbs_setNotifyInterval_767_0);
  methods += new qt_gsi::GenericMethod ("setNotifyInterval", "@hide", false, &_init_cbs_setNotifyInterval_767_0, &_call_cbs_setNotifyInterval_767_0, &_set_callback_cbs_setNotifyInterval_767_0);
  methods += new qt_gsi::GenericMethod ("setVolume", "@brief Virtual method void QAbstractAudioInput::setVolume(double)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setVolume_1071_0, &_call_cbs_setVolume_1071_0);
  methods += new qt_gsi::GenericMethod ("setVolume", "@hide", false, &_init_cbs_setVolume_1071_0, &_call_cbs_setVolume_1071_0, &_set_callback_cbs_setVolume_1071_0);
  methods += new qt_gsi::GenericMethod ("start", "@brief Virtual method void QAbstractAudioInput::start(QIODevice *device)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_start_1447_0, &_call_cbs_start_1447_0);
  methods += new qt_gsi::GenericMethod ("start", "@hide", false, &_init_cbs_start_1447_0, &_call_cbs_start_1447_0, &_set_callback_cbs_start_1447_0);
  methods += new qt_gsi::GenericMethod ("start", "@brief Virtual method QIODevice *QAbstractAudioInput::start()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_start_0_0, &_call_cbs_start_0_0);
  methods += new qt_gsi::GenericMethod ("start", "@hide", false, &_init_cbs_start_0_0, &_call_cbs_start_0_0, &_set_callback_cbs_start_0_0);
  methods += new qt_gsi::GenericMethod ("state", "@brief Virtual method QAudio::State QAbstractAudioInput::state()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_state_c0_0, &_call_cbs_state_c0_0);
  methods += new qt_gsi::GenericMethod ("state", "@hide", true, &_init_cbs_state_c0_0, &_call_cbs_state_c0_0, &_set_callback_cbs_state_c0_0);
  methods += new qt_gsi::GenericMethod ("stop", "@brief Virtual method void QAbstractAudioInput::stop()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_stop_0_0, &_call_cbs_stop_0_0);
  methods += new qt_gsi::GenericMethod ("stop", "@hide", false, &_init_cbs_stop_0_0, &_call_cbs_stop_0_0, &_set_callback_cbs_stop_0_0);
  methods += new qt_gsi::GenericMethod ("suspend", "@brief Virtual method void QAbstractAudioInput::suspend()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_suspend_0_0, &_call_cbs_suspend_0_0);
  methods += new qt_gsi::GenericMethod ("suspend", "@hide", false, &_init_cbs_suspend_0_0, &_call_cbs_suspend_0_0, &_set_callback_cbs_suspend_0_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QAbstractAudioInput::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("volume", "@brief Virtual method double QAbstractAudioInput::volume()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_volume_c0_0, &_call_cbs_volume_c0_0);
  methods += new qt_gsi::GenericMethod ("volume", "@hide", true, &_init_cbs_volume_c0_0, &_call_cbs_volume_c0_0, &_set_callback_cbs_volume_c0_0);
  return methods;
}

gsi::Class<QAbstractAudioInput_Adaptor> decl_QAbstractAudioInput_Adaptor (qtdecl_QAbstractAudioInput (), "QtMultimedia", "QAbstractAudioInput",
  methods_QAbstractAudioInput_Adaptor (),
  "@qt\n@brief Binding of QAbstractAudioInput");

}

