/*
 * Kylin-video
 *
 * Copyright (C) 2021, Tianjin KYLIN Information Technology Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * Authors: Liu Cong <liucong1@kylinos.cn>
 *
 */

#include "global.h"

#include <QSettings>
#include <QGSettings>
#include <QApplication>
#include <QFile>
#include <QDebug>
#include "translator.h"
#include "paths.h"

QSettings       *Global::g_settings     = nullptr;
Translator      *Global::translator     = nullptr;
KVSqlite        *Global::g_sqlite       = nullptr;
GlobalSetup     *Global::gsetup         = nullptr;
QGSettings      *Global::g_gsettings    = nullptr;
ShortCutSetting *Global::gshortCut      = nullptr;
bool Global::isWayland = false;
//KPlayControl *Global::k_playcontrol = KPlayControl::getInstanece();

using namespace Global;

void Global::global_init() {

	// Translator
    translator = new Translator();

    // g_settings
    QString filename = Paths::iniPath() + "/kylin-video3.ini";
    QString dbname = Paths::iniPath() + "/kylin-video3.db";

    g_settings = new QSettings(filename, QSettings::IniFormat);
    g_settings->setIniCodec("UTF-8");
    // 运行环境
    if(!g_settings->contains("General/display_env"))
    {
        if((QString(qgetenv("XDG_SESSION_TYPE")) == "wayland"))
            g_settings->setValue("General/display_env", "wayland");
        else
            g_settings->setValue("General/display_env", "x11");
    }
    isWayland   = (g_settings->value("General/display_env").toString() == "wayland");

    g_gsettings = new QGSettings(ORG_UKUI_STYLE);

    gshortCut   = ShortCutSetting::getInstance(g_settings);
    g_sqlite    = KVSqlite::getInstance(dbname);
    gsetup      = GlobalSetup::getInstance();
}

void Global::global_end() {
    delete g_gsettings;
    delete g_settings;
    delete translator;
}
