
/*******************************  LICENSE  *******************************

 * (C) Copyright 1996-2016 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \fileTableDecoderAttributes.h
    \brief Definition of TableDecoder Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 
*/
   

#ifndef TableDecoderAttributes_H
#define TableDecoderAttributes_H

#include "magics.h"
#include "BinningObject.h"
namespace magics {

class XmlNode;
class TableDecoderAttributes 
{
public:
//  --  constructor
    TableDecoderAttributes();
    
//  --  destructor
    virtual ~TableDecoderAttributes();
    
    virtual void set(const std::map<std::string, std::string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const TableDecoderAttributes&);
    virtual bool accept(const std::string&);

    void setTag(const std::string& tag) { tag_ = tag; }

public:
	//  --  method
	virtual void print(std::ostream&) const;
	virtual void toxml(std::ostream& out) const;
	//  --  members:
	string tag_;
	string path_;
	string delimiter_;
	bool combine_delimiters_;
	int header_row_;
	int data_row_offset_;
	intarray meta_data_rows_;
	string x_type_;
	string y_type_;
	string name_mode_;
	string x_;
	string y_;
	string values_;
	string lat_;
	string lon_;
	string x_component_;
	string y_component_;
	double x_missing_;
	double y_missing_;
	unique_ptr<BinningObject> table_binning_;
	 

private:
	friend ostream& operator<<(ostream& s,const TableDecoderAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif

