
/*******************************  LICENSE  *******************************

 * (C) Copyright 1996-2016 ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0. 
 * In applying this licence, ECMWF does not waive the privileges and immunities 
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \fileTaylorGridAttributes.h
    \brief Definition of TaylorGrid Attributes class.

    This file is automatically generated.
    Do Not Edit!

    Generated: 
*/
   

#ifndef TaylorGridAttributes_H
#define TaylorGridAttributes_H

#include "magics.h"
#include "Colour.h"
namespace magics {

class XmlNode;
class TaylorGridAttributes 
{
public:
//  --  constructor
    TaylorGridAttributes();
    
//  --  destructor
    virtual ~TaylorGridAttributes();
    
    virtual void set(const std::map<std::string, std::string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const TaylorGridAttributes&);
    virtual bool accept(const std::string&);

    void setTag(const std::string& tag) { tag_ = tag; }

public:
	//  --  method
	virtual void print(std::ostream&) const;
	virtual void toxml(std::ostream& out) const;
	//  --  members:
	string tag_;
	string label_;
	double label_height_;
	double primary_increment_;
	int primary_thickness_;
	double primary_reference_;
	int reference_thickness_;
	bool primary_label_;
	double primary_label_height_;
	bool secondary_grid_;
	double secondary_reference_;
	double secondary_increment_;
	int secondary_thickness_;
	bool secondary_label_;
	double secondary_label_height_;
	unique_ptr<Colour> label_colour_;
	unique_ptr<Colour> primary_colour_;
	LineStyle primary_style_;
	unique_ptr<Colour> reference_colour_;
	LineStyle reference_style_;
	unique_ptr<Colour> primary_label_colour_;
	unique_ptr<Colour> secondary_colour_;
	LineStyle secondary_style_;
	unique_ptr<Colour> secondary_label_colour_;
	 

private:
	friend ostream& operator<<(ostream& s,const TaylorGridAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif

