#include <catch2/catch.hpp>

#include <QDebug>

#include <IsoSpecEntity.hpp>


using namespace msxps::minexpert;


TEST_CASE("Constructing IsoSpecEntity objects.",
          "[IsoSpecEntity][constructors]")
{

  SECTION("Construct a IsoSpecEntity", "[IsoSpecEntity]")
  {
    int id = 12;
    QString element = "carbon";
    QString symbol = "C";
    int atomic_no = 6;
    double mass = 12.0000;
    double mass_no = 12;
    int extra_neutrons = 0;
    double prob =  0.989211941850466902614869013632414862513542175292968750000000;
    double log_prob = -0.010846671177187771836769591971005866071209311485290527343750;
    bool radioactive = false;

    IsoSpecEntity iso_spec_entity(id, element, symbol, atomic_no, mass, mass_no, extra_neutrons, prob, log_prob, radioactive);

    REQUIRE(iso_spec_entity.getId() == 12);
    REQUIRE(iso_spec_entity.getElement() == "carbon");
    REQUIRE(iso_spec_entity.getSymbol() == "C");
    REQUIRE(iso_spec_entity.getAtomicNo() == 6);
    REQUIRE(iso_spec_entity.getMass() == 12.0000);
    REQUIRE(iso_spec_entity.getMassNo() == 12);
    REQUIRE(iso_spec_entity.getExtraNeutrons() == 0);
    REQUIRE(iso_spec_entity.getProbability() == 0.989211941850466902614869013632414862513542175292968750000000);
    REQUIRE(iso_spec_entity.getLogProbability() == -0.010846671177187771836769591971005866071209311485290527343750);
    REQUIRE(iso_spec_entity.getRadioactive() == false);

    qDebug().noquote() << "to string:" << iso_spec_entity.toString();

    QString to_string = "12, carbon, C, 6, 12.000000000000000000000000000000000000000000000000000000000000, 12, 0, 0.989211941850466902614869013632414862513542175292968750000000, -0.010846671177187771836769591971005866071209311485290527343750, 0";

    REQUIRE(iso_spec_entity.toString() == to_string);
  }

  SECTION("Test in/equality of two IsoSpecEntity", "[IsoSpecEntity]")
  {
     int id_1 = 12;
     int id_2 = 13;
    QString element = "carbon";
    QString symbol = "C";
    int atomic_no = 6;
    double mass = 12.0000;
    double mass_no = 12;
    int extra_neutrons = 0;
    double prob =  0.989211941850466902614869013632414862513542175292968750000000;
    double log_prob = -0.010846671177187771836769591971005866071209311485290527343750;
    bool radioactive = false;

    IsoSpecEntity iso_spec_entity_1(id_1, element, symbol, atomic_no, mass, mass_no, extra_neutrons, prob, log_prob, radioactive);
    IsoSpecEntity iso_spec_entity_2(id_1, element, symbol, atomic_no, mass, mass_no, extra_neutrons, prob, log_prob, radioactive);

    REQUIRE(iso_spec_entity_1 == iso_spec_entity_2);

    IsoSpecEntity iso_spec_entity_3(iso_spec_entity_2);
 
    REQUIRE(iso_spec_entity_3 == iso_spec_entity_2);

    IsoSpecEntity iso_spec_entity_4 = iso_spec_entity_3;

    REQUIRE(iso_spec_entity_4 == iso_spec_entity_3);

    // Change the m_id value.
    IsoSpecEntity iso_spec_entity_5(id_2, element, symbol, atomic_no, mass, mass_no, extra_neutrons, prob, log_prob, radioactive);

    REQUIRE(iso_spec_entity_5 != iso_spec_entity_4);
}

}
