//------------------------------------------------------------------------------
// <auto-generated>
//     This code was generated by a tool.
//
//     Changes to this file may cause incorrect behavior and will be lost if
//     the code is regenerated.
// </auto-generated>
//------------------------------------------------------------------------------

namespace System.Runtime
{
    using System.Runtime.Diagnostics;
    using System.Security;
    
    
    internal partial class TraceCore
    {
        
        static System.Resources.ResourceManager resourceManager;
        
        static System.Globalization.CultureInfo resourceCulture;
        
        [System.Security.SecurityCriticalAttribute()]
        static System.Runtime.Diagnostics.EventDescriptor[] eventDescriptors;
        
        static object syncLock = new object();
        
        // Double-checked locking pattern requires volatile for read/write synchronization
        static volatile bool eventDescriptorsCreated;
        
        private TraceCore()
        {
        }
        
        [System.Diagnostics.CodeAnalysis.SuppressMessageAttribute("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Justification="This is an auto-generated code, some ETW/TraceSource mixed code would use it.")]
        static System.Resources.ResourceManager ResourceManager
        {
            get
            {
                if (object.ReferenceEquals(resourceManager, null))
                {
                    resourceManager = new System.Resources.ResourceManager("System.Runtime.TraceCore", typeof(TraceCore).Assembly);
                }
                return resourceManager;
            }
        }
        
        [System.Diagnostics.CodeAnalysis.SuppressMessageAttribute("Microsoft.Performance", "CA1811:AvoidUncalledPrivateCode", Justification="This template is shared across all assemblies, some of which use this accessor.")]
        internal static System.Globalization.CultureInfo Culture
        {
            get
            {
                return resourceCulture;
            }
            set
            {
                resourceCulture = value;
            }
        }
        
        /// <summary>
        /// Check if trace definition is enabled
        /// Event description ID=57393, Level=informational, Channel=Debug
        /// </summary>
        /// <param name="trace">The trace provider</param>
        internal static bool AppDomainUnloadIsEnabled(EtwDiagnosticTrace trace)
        {
            return (trace.ShouldTrace(TraceEventLevel.Informational) || TraceCore.IsEtwEventEnabled(trace, 0));
        }
        
        /// <summary>
        /// Gets trace definition like: AppDomain unloading. AppDomain.FriendlyName {0}, ProcessName {1}, ProcessId {2}.
        /// Event description ID=57393, Level=informational, Channel=Debug
        /// </summary>
        /// <param name="trace">The trace provider</param>
        /// <param name="appdomainName">Parameter 0 for event: AppDomain unloading. AppDomain.FriendlyName {0}, ProcessName {1}, ProcessId {2}.</param>
        /// <param name="processName">Parameter 1 for event: AppDomain unloading. AppDomain.FriendlyName {0}, ProcessName {1}, ProcessId {2}.</param>
        /// <param name="processId">Parameter 2 for event: AppDomain unloading. AppDomain.FriendlyName {0}, ProcessName {1}, ProcessId {2}.</param>
        internal static void AppDomainUnload(EtwDiagnosticTrace trace, string appdomainName, string processName, string processId)
        {
            TracePayload payload = trace.GetSerializedPayload(null, null, null);
            if (TraceCore.IsEtwEventEnabled(trace, 0))
            {
                TraceCore.WriteEtwEvent(trace, 0, null, appdomainName, processName, processId, payload.AppDomainFriendlyName);
            }
            if (trace.ShouldTraceToTraceSource(TraceEventLevel.Informational))
            {
                string description = string.Format(Culture, ResourceManager.GetString("AppDomainUnload", Culture), appdomainName, processName, processId);
                TraceCore.WriteTraceSource(trace, 0, description, payload);
            }
        }
        
        /// <summary>
        /// Check if trace definition is enabled
        /// Event description ID=57394, Level=informational, Channel=Analytic
        /// </summary>
        /// <param name="trace">The trace provider</param>
        internal static bool HandledExceptionIsEnabled(EtwDiagnosticTrace trace)
        {
            return (trace.ShouldTrace(TraceEventLevel.Informational) || TraceCore.IsEtwEventEnabled(trace, 1));
        }
        
        /// <summary>
        /// Gets trace definition like: Handling an exception.  Exception details: {0}
        /// Event description ID=57394, Level=informational, Channel=Analytic
        /// </summary>
        /// <param name="trace">The trace provider</param>
        /// <param name="param0">Parameter 0 for event: Handling an exception.  Exception details: {0}</param>
        /// <param name="exception">Exception associated with the event</param>
        internal static void HandledException(EtwDiagnosticTrace trace, string param0, System.Exception exception)
        {
            TracePayload payload = trace.GetSerializedPayload(null, null, exception);
            if (TraceCore.IsEtwEventEnabled(trace, 1))
            {
                TraceCore.WriteEtwEvent(trace, 1, null, param0, payload.SerializedException, payload.AppDomainFriendlyName);
            }
            if (trace.ShouldTraceToTraceSource(TraceEventLevel.Informational))
            {
                string description = string.Format(Culture, ResourceManager.GetString("HandledException", Culture), param0);
                TraceCore.WriteTraceSource(trace, 1, description, payload);
            }
        }
        
        /// <summary>
        /// Check if trace definition is enabled
        /// Event description ID=57395, Level=error, Channel=Analytic
        /// </summary>
        /// <param name="trace">The trace provider</param>
        internal static bool ShipAssertExceptionMessageIsEnabled(EtwDiagnosticTrace trace)
        {
            return (trace.ShouldTrace(TraceEventLevel.Error) || TraceCore.IsEtwEventEnabled(trace, 2));
        }
        
        /// <summary>
        /// Gets trace definition like: An unexpected failure occurred. Applications should not attempt to handle this error. For diagnostic purposes, this English message is associated with the failure: {0}.
        /// Event description ID=57395, Level=error, Channel=Analytic
        /// </summary>
        /// <param name="trace">The trace provider</param>
        /// <param name="param0">Parameter 0 for event: An unexpected failure occurred. Applications should not attempt to handle this error. For diagnostic purposes, this English message is associated with the failure: {0}.</param>
        internal static void ShipAssertExceptionMessage(EtwDiagnosticTrace trace, string param0)
        {
            TracePayload payload = trace.GetSerializedPayload(null, null, null);
            if (TraceCore.IsEtwEventEnabled(trace, 2))
            {
                TraceCore.WriteEtwEvent(trace, 2, null, param0, payload.AppDomainFriendlyName);
            }
            if (trace.ShouldTraceToTraceSource(TraceEventLevel.Error))
            {
                string description = string.Format(Culture, ResourceManager.GetString("ShipAssertExceptionMessage", Culture), param0);
                TraceCore.WriteTraceSource(trace, 2, description, payload);
            }
        }
        
        /// <summary>
        /// Check if trace definition is enabled
        /// Event description ID=57396, Level=warning, Channel=Analytic
        /// </summary>
        /// <param name="trace">The trace provider</param>
        internal static bool ThrowingExceptionIsEnabled(EtwDiagnosticTrace trace)
        {
            return (trace.ShouldTrace(TraceEventLevel.Warning) || TraceCore.IsEtwEventEnabled(trace, 3));
        }
        
        /// <summary>
        /// Gets trace definition like: Throwing an exception. Source: {0}. Exception details: {1}
        /// Event description ID=57396, Level=warning, Channel=Analytic
        /// </summary>
        /// <param name="trace">The trace provider</param>
        /// <param name="param0">Parameter 0 for event: Throwing an exception. Source: {0}. Exception details: {1}</param>
        /// <param name="param1">Parameter 1 for event: Throwing an exception. Source: {0}. Exception details: {1}</param>
        /// <param name="exception">Exception associated with the event</param>
        internal static void ThrowingException(EtwDiagnosticTrace trace, string param0, string param1, System.Exception exception)
        {
            TracePayload payload = trace.GetSerializedPayload(null, null, exception);
            if (TraceCore.IsEtwEventEnabled(trace, 3))
            {
                TraceCore.WriteEtwEvent(trace, 3, null, param0, param1, payload.SerializedException, payload.AppDomainFriendlyName);
            }
            if (trace.ShouldTraceToTraceSource(TraceEventLevel.Warning))
            {
                string description = string.Format(Culture, ResourceManager.GetString("ThrowingException", Culture), param0, param1);
                TraceCore.WriteTraceSource(trace, 3, description, payload);
            }
        }
        
        /// <summary>
        /// Check if trace definition is enabled
        /// Event description ID=57397, Level=critical, Channel=Operational
        /// </summary>
        /// <param name="trace">The trace provider</param>
        internal static bool UnhandledExceptionIsEnabled(EtwDiagnosticTrace trace)
        {
            return (trace.ShouldTrace(TraceEventLevel.Critical) || TraceCore.IsEtwEventEnabled(trace, 4));
        }
        
        /// <summary>
        /// Gets trace definition like: Unhandled exception.  Exception details: {0}
        /// Event description ID=57397, Level=critical, Channel=Operational
        /// </summary>
        /// <param name="trace">The trace provider</param>
        /// <param name="param0">Parameter 0 for event: Unhandled exception.  Exception details: {0}</param>
        /// <param name="exception">Exception associated with the event</param>
        internal static void UnhandledException(EtwDiagnosticTrace trace, string param0, System.Exception exception)
        {
            TracePayload payload = trace.GetSerializedPayload(null, null, exception);
            if (TraceCore.IsEtwEventEnabled(trace, 4))
            {
                TraceCore.WriteEtwEvent(trace, 4, null, param0, payload.SerializedException, payload.AppDomainFriendlyName);
            }
            if (trace.ShouldTraceToTraceSource(TraceEventLevel.Critical))
            {
                string description = string.Format(Culture, ResourceManager.GetString("UnhandledException", Culture), param0);
                TraceCore.WriteTraceSource(trace, 4, description, payload);
            }
        }
        
        /// <summary>
        /// Check if trace definition is enabled
        /// Event description ID=57399, Level=critical, Channel=Debug
        /// </summary>
        /// <param name="trace">The trace provider</param>
        internal static bool TraceCodeEventLogCriticalIsEnabled(EtwDiagnosticTrace trace)
        {
            return (trace.ShouldTrace(TraceEventLevel.Critical) || TraceCore.IsEtwEventEnabled(trace, 5));
        }
        
        /// <summary>
        /// Gets trace definition like: Wrote to the EventLog.
        /// Event description ID=57399, Level=critical, Channel=Debug
        /// </summary>
        /// <param name="trace">The trace provider</param>
        /// <param name="traceRecord">Extended data (TraceRecord) for the event</param>
        internal static void TraceCodeEventLogCritical(EtwDiagnosticTrace trace, TraceRecord traceRecord)
        {
            TracePayload payload = trace.GetSerializedPayload(null, traceRecord, null);
            if (TraceCore.IsEtwEventEnabled(trace, 5))
            {
                TraceCore.WriteEtwEvent(trace, 5, null, payload.ExtendedData, payload.AppDomainFriendlyName);
            }
            if (trace.ShouldTraceToTraceSource(TraceEventLevel.Critical))
            {
                string description = string.Format(Culture, ResourceManager.GetString("TraceCodeEventLogCritical", Culture));
                TraceCore.WriteTraceSource(trace, 5, description, payload);
            }
        }
        
        /// <summary>
        /// Check if trace definition is enabled
        /// Event description ID=57400, Level=error, Channel=Debug
        /// </summary>
        /// <param name="trace">The trace provider</param>
        internal static bool TraceCodeEventLogErrorIsEnabled(EtwDiagnosticTrace trace)
        {
            return (trace.ShouldTrace(TraceEventLevel.Error) || TraceCore.IsEtwEventEnabled(trace, 6));
        }
        
        /// <summary>
        /// Gets trace definition like: Wrote to the EventLog.
        /// Event description ID=57400, Level=error, Channel=Debug
        /// </summary>
        /// <param name="trace">The trace provider</param>
        /// <param name="traceRecord">Extended data (TraceRecord) for the event</param>
        internal static void TraceCodeEventLogError(EtwDiagnosticTrace trace, TraceRecord traceRecord)
        {
            TracePayload payload = trace.GetSerializedPayload(null, traceRecord, null);
            if (TraceCore.IsEtwEventEnabled(trace, 6))
            {
                TraceCore.WriteEtwEvent(trace, 6, null, payload.ExtendedData, payload.AppDomainFriendlyName);
            }
            if (trace.ShouldTraceToTraceSource(TraceEventLevel.Error))
            {
                string description = string.Format(Culture, ResourceManager.GetString("TraceCodeEventLogError", Culture));
                TraceCore.WriteTraceSource(trace, 6, description, payload);
            }
        }
        
        /// <summary>
        /// Check if trace definition is enabled
        /// Event description ID=57401, Level=informational, Channel=Debug
        /// </summary>
        /// <param name="trace">The trace provider</param>
        internal static bool TraceCodeEventLogInfoIsEnabled(EtwDiagnosticTrace trace)
        {
            return (trace.ShouldTrace(TraceEventLevel.Informational) || TraceCore.IsEtwEventEnabled(trace, 7));
        }
        
        /// <summary>
        /// Gets trace definition like: Wrote to the EventLog.
        /// Event description ID=57401, Level=informational, Channel=Debug
        /// </summary>
        /// <param name="trace">The trace provider</param>
        /// <param name="traceRecord">Extended data (TraceRecord) for the event</param>
        internal static void TraceCodeEventLogInfo(EtwDiagnosticTrace trace, TraceRecord traceRecord)
        {
            TracePayload payload = trace.GetSerializedPayload(null, traceRecord, null);
            if (TraceCore.IsEtwEventEnabled(trace, 7))
            {
                TraceCore.WriteEtwEvent(trace, 7, null, payload.ExtendedData, payload.AppDomainFriendlyName);
            }
            if (trace.ShouldTraceToTraceSource(TraceEventLevel.Informational))
            {
                string description = string.Format(Culture, ResourceManager.GetString("TraceCodeEventLogInfo", Culture));
                TraceCore.WriteTraceSource(trace, 7, description, payload);
            }
        }
        
        /// <summary>
        /// Check if trace definition is enabled
        /// Event description ID=57402, Level=verbose, Channel=Debug
        /// </summary>
        /// <param name="trace">The trace provider</param>
        internal static bool TraceCodeEventLogVerboseIsEnabled(EtwDiagnosticTrace trace)
        {
            return (trace.ShouldTrace(TraceEventLevel.Verbose) || TraceCore.IsEtwEventEnabled(trace, 8));
        }
        
        /// <summary>
        /// Gets trace definition like: Wrote to the EventLog.
        /// Event description ID=57402, Level=verbose, Channel=Debug
        /// </summary>
        /// <param name="trace">The trace provider</param>
        /// <param name="traceRecord">Extended data (TraceRecord) for the event</param>
        internal static void TraceCodeEventLogVerbose(EtwDiagnosticTrace trace, TraceRecord traceRecord)
        {
            TracePayload payload = trace.GetSerializedPayload(null, traceRecord, null);
            if (TraceCore.IsEtwEventEnabled(trace, 8))
            {
                TraceCore.WriteEtwEvent(trace, 8, null, payload.ExtendedData, payload.AppDomainFriendlyName);
            }
            if (trace.ShouldTraceToTraceSource(TraceEventLevel.Verbose))
            {
                string description = string.Format(Culture, ResourceManager.GetString("TraceCodeEventLogVerbose", Culture));
                TraceCore.WriteTraceSource(trace, 8, description, payload);
            }
        }
        
        /// <summary>
        /// Check if trace definition is enabled
        /// Event description ID=57403, Level=warning, Channel=Debug
        /// </summary>
        /// <param name="trace">The trace provider</param>
        internal static bool TraceCodeEventLogWarningIsEnabled(EtwDiagnosticTrace trace)
        {
            return (trace.ShouldTrace(TraceEventLevel.Warning) || TraceCore.IsEtwEventEnabled(trace, 9));
        }
        
        /// <summary>
        /// Gets trace definition like: Wrote to the EventLog.
        /// Event description ID=57403, Level=warning, Channel=Debug
        /// </summary>
        /// <param name="trace">The trace provider</param>
        /// <param name="traceRecord">Extended data (TraceRecord) for the event</param>
        internal static void TraceCodeEventLogWarning(EtwDiagnosticTrace trace, TraceRecord traceRecord)
        {
            TracePayload payload = trace.GetSerializedPayload(null, traceRecord, null);
            if (TraceCore.IsEtwEventEnabled(trace, 9))
            {
                TraceCore.WriteEtwEvent(trace, 9, null, payload.ExtendedData, payload.AppDomainFriendlyName);
            }
            if (trace.ShouldTraceToTraceSource(TraceEventLevel.Warning))
            {
                string description = string.Format(Culture, ResourceManager.GetString("TraceCodeEventLogWarning", Culture));
                TraceCore.WriteTraceSource(trace, 9, description, payload);
            }
        }
        
        /// <summary>
        /// Check if trace definition is enabled
        /// Event description ID=57404, Level=warning, Channel=Analytic
        /// </summary>
        /// <param name="trace">The trace provider</param>
        internal static bool HandledExceptionWarningIsEnabled(EtwDiagnosticTrace trace)
        {
            return (trace.ShouldTrace(TraceEventLevel.Warning) || TraceCore.IsEtwEventEnabled(trace, 10));
        }
        
        /// <summary>
        /// Gets trace definition like: Handling an exception. Exception details: {0}
        /// Event description ID=57404, Level=warning, Channel=Analytic
        /// </summary>
        /// <param name="trace">The trace provider</param>
        /// <param name="param0">Parameter 0 for event: Handling an exception. Exception details: {0}</param>
        /// <param name="exception">Exception associated with the event</param>
        internal static void HandledExceptionWarning(EtwDiagnosticTrace trace, string param0, System.Exception exception)
        {
            TracePayload payload = trace.GetSerializedPayload(null, null, exception);
            if (TraceCore.IsEtwEventEnabled(trace, 10))
            {
                TraceCore.WriteEtwEvent(trace, 10, null, param0, payload.SerializedException, payload.AppDomainFriendlyName);
            }
            if (trace.ShouldTraceToTraceSource(TraceEventLevel.Warning))
            {
                string description = string.Format(Culture, ResourceManager.GetString("HandledExceptionWarning", Culture), param0);
                TraceCore.WriteTraceSource(trace, 10, description, payload);
            }
        }
        
        /// <summary>
        /// Check if trace definition is enabled
        /// Event description ID=131, Level=verbose, Channel=Debug
        /// </summary>
        /// <param name="trace">The trace provider</param>
        internal static bool BufferPoolAllocationIsEnabled(EtwDiagnosticTrace trace)
        {
            return TraceCore.IsEtwEventEnabled(trace, 11);
        }
        
        /// <summary>
        /// Gets trace definition like: Pool allocating {0} Bytes.
        /// Event description ID=131, Level=verbose, Channel=Debug
        /// </summary>
        /// <param name="trace">The trace provider</param>
        /// <param name="Size">Parameter 0 for event: Pool allocating {0} Bytes.</param>
        internal static void BufferPoolAllocation(EtwDiagnosticTrace trace, int Size)
        {
            TracePayload payload = trace.GetSerializedPayload(null, null, null);
            if (TraceCore.IsEtwEventEnabled(trace, 11))
            {
                TraceCore.WriteEtwEvent(trace, 11, null, Size, payload.AppDomainFriendlyName);
            }
        }
        
        /// <summary>
        /// Check if trace definition is enabled
        /// Event description ID=132, Level=verbose, Channel=Debug
        /// </summary>
        /// <param name="trace">The trace provider</param>
        internal static bool BufferPoolChangeQuotaIsEnabled(EtwDiagnosticTrace trace)
        {
            return TraceCore.IsEtwEventEnabled(trace, 12);
        }
        
        /// <summary>
        /// Gets trace definition like: BufferPool of size {0}, changing quota by {1}.
        /// Event description ID=132, Level=verbose, Channel=Debug
        /// </summary>
        /// <param name="trace">The trace provider</param>
        /// <param name="PoolSize">Parameter 0 for event: BufferPool of size {0}, changing quota by {1}.</param>
        /// <param name="Delta">Parameter 1 for event: BufferPool of size {0}, changing quota by {1}.</param>
        internal static void BufferPoolChangeQuota(EtwDiagnosticTrace trace, int PoolSize, int Delta)
        {
            TracePayload payload = trace.GetSerializedPayload(null, null, null);
            if (TraceCore.IsEtwEventEnabled(trace, 12))
            {
                TraceCore.WriteEtwEvent(trace, 12, null, PoolSize, Delta, payload.AppDomainFriendlyName);
            }
        }
        
        /// <summary>
        /// Check if trace definition is enabled
        /// Event description ID=133, Level=verbose, Channel=Debug
        /// </summary>
        /// <param name="trace">The trace provider</param>
        internal static bool ActionItemScheduledIsEnabled(EtwDiagnosticTrace trace)
        {
            return TraceCore.IsEtwEventEnabled(trace, 13);
        }
        
        /// <summary>
        /// Gets trace definition like: IO Thread scheduler callback invoked.
        /// Event description ID=133, Level=verbose, Channel=Debug
        /// </summary>
        /// <param name="trace">The trace provider</param>
        /// <param name="eventTraceActivity">The event trace activity</param>
        internal static void ActionItemScheduled(EtwDiagnosticTrace trace, System.Runtime.Diagnostics.EventTraceActivity eventTraceActivity)
        {
            TracePayload payload = trace.GetSerializedPayload(null, null, null);
            if (TraceCore.IsEtwEventEnabled(trace, 13))
            {
                TraceCore.WriteEtwEvent(trace, 13, eventTraceActivity, payload.AppDomainFriendlyName);
            }
        }
        
        /// <summary>
        /// Check if trace definition is enabled
        /// Event description ID=134, Level=verbose, Channel=Debug
        /// </summary>
        /// <param name="trace">The trace provider</param>
        internal static bool ActionItemCallbackInvokedIsEnabled(EtwDiagnosticTrace trace)
        {
            return TraceCore.IsEtwEventEnabled(trace, 14);
        }
        
        /// <summary>
        /// Gets trace definition like: IO Thread scheduler callback invoked.
        /// Event description ID=134, Level=verbose, Channel=Debug
        /// </summary>
        /// <param name="trace">The trace provider</param>
        /// <param name="eventTraceActivity">The event trace activity</param>
        internal static void ActionItemCallbackInvoked(EtwDiagnosticTrace trace, System.Runtime.Diagnostics.EventTraceActivity eventTraceActivity)
        {
            TracePayload payload = trace.GetSerializedPayload(null, null, null);
            if (TraceCore.IsEtwEventEnabled(trace, 14))
            {
                TraceCore.WriteEtwEvent(trace, 14, eventTraceActivity, payload.AppDomainFriendlyName);
            }
        }
        
        /// <summary>
        /// Check if trace definition is enabled
        /// Event description ID=57405, Level=error, Channel=Operational
        /// </summary>
        /// <param name="trace">The trace provider</param>
        internal static bool HandledExceptionErrorIsEnabled(EtwDiagnosticTrace trace)
        {
            return (trace.ShouldTrace(TraceEventLevel.Error) || TraceCore.IsEtwEventEnabled(trace, 15));
        }
        
        /// <summary>
        /// Gets trace definition like: Handling an exception. Exception details: {0}
        /// Event description ID=57405, Level=error, Channel=Operational
        /// </summary>
        /// <param name="trace">The trace provider</param>
        /// <param name="param0">Parameter 0 for event: Handling an exception. Exception details: {0}</param>
        /// <param name="exception">Exception associated with the event</param>
        internal static void HandledExceptionError(EtwDiagnosticTrace trace, string param0, System.Exception exception)
        {
            TracePayload payload = trace.GetSerializedPayload(null, null, exception);
            if (TraceCore.IsEtwEventEnabled(trace, 15))
            {
                TraceCore.WriteEtwEvent(trace, 15, null, param0, payload.SerializedException, payload.AppDomainFriendlyName);
            }
            if (trace.ShouldTraceToTraceSource(TraceEventLevel.Error))
            {
                string description = string.Format(Culture, ResourceManager.GetString("HandledExceptionError", Culture), param0);
                TraceCore.WriteTraceSource(trace, 15, description, payload);
            }
        }
        
        /// <summary>
        /// Check if trace definition is enabled
        /// Event description ID=57406, Level=verbose, Channel=Analytic
        /// </summary>
        /// <param name="trace">The trace provider</param>
        internal static bool HandledExceptionVerboseIsEnabled(EtwDiagnosticTrace trace)
        {
            return (trace.ShouldTrace(TraceEventLevel.Verbose) || TraceCore.IsEtwEventEnabled(trace, 16));
        }
        
        /// <summary>
        /// Gets trace definition like: Handling an exception  Exception details: {0}
        /// Event description ID=57406, Level=verbose, Channel=Analytic
        /// </summary>
        /// <param name="trace">The trace provider</param>
        /// <param name="param0">Parameter 0 for event: Handling an exception  Exception details: {0}</param>
        /// <param name="exception">Exception associated with the event</param>
        internal static void HandledExceptionVerbose(EtwDiagnosticTrace trace, string param0, System.Exception exception)
        {
            TracePayload payload = trace.GetSerializedPayload(null, null, exception);
            if (TraceCore.IsEtwEventEnabled(trace, 16))
            {
                TraceCore.WriteEtwEvent(trace, 16, null, param0, payload.SerializedException, payload.AppDomainFriendlyName);
            }
            if (trace.ShouldTraceToTraceSource(TraceEventLevel.Verbose))
            {
                string description = string.Format(Culture, ResourceManager.GetString("HandledExceptionVerbose", Culture), param0);
                TraceCore.WriteTraceSource(trace, 16, description, payload);
            }
        }
        
        /// <summary>
        /// Check if trace definition is enabled
        /// Event description ID=57408, Level=critical, Channel=Operational
        /// </summary>
        /// <param name="trace">The trace provider</param>
        internal static bool EtwUnhandledExceptionIsEnabled(EtwDiagnosticTrace trace)
        {
            return TraceCore.IsEtwEventEnabled(trace, 17);
        }
        
        /// <summary>
        /// Gets trace definition like: Unhandled exception. Exception details: {0}
        /// Event description ID=57408, Level=critical, Channel=Operational
        /// </summary>
        /// <param name="trace">The trace provider</param>
        /// <param name="param0">Parameter 0 for event: Unhandled exception. Exception details: {0}</param>
        /// <param name="exception">Exception associated with the event</param>
        internal static void EtwUnhandledException(EtwDiagnosticTrace trace, string param0, System.Exception exception)
        {
            TracePayload payload = trace.GetSerializedPayload(null, null, exception);
            if (TraceCore.IsEtwEventEnabled(trace, 17))
            {
                TraceCore.WriteEtwEvent(trace, 17, null, param0, payload.SerializedException, payload.AppDomainFriendlyName);
            }
        }
        
        /// <summary>
        /// Check if trace definition is enabled
        /// Event description ID=57410, Level=warning, Channel=Analytic
        /// </summary>
        /// <param name="trace">The trace provider</param>
        internal static bool ThrowingEtwExceptionIsEnabled(EtwDiagnosticTrace trace)
        {
            return TraceCore.IsEtwEventEnabled(trace, 18);
        }
        
        /// <summary>
        /// Gets trace definition like: Throwing an exception. Source: {0}. Exception details: {1}
        /// Event description ID=57410, Level=warning, Channel=Analytic
        /// </summary>
        /// <param name="trace">The trace provider</param>
        /// <param name="param0">Parameter 0 for event: Throwing an exception. Source: {0}. Exception details: {1}</param>
        /// <param name="param1">Parameter 1 for event: Throwing an exception. Source: {0}. Exception details: {1}</param>
        /// <param name="exception">Exception associated with the event</param>
        internal static void ThrowingEtwException(EtwDiagnosticTrace trace, string param0, string param1, System.Exception exception)
        {
            TracePayload payload = trace.GetSerializedPayload(null, null, exception);
            if (TraceCore.IsEtwEventEnabled(trace, 18))
            {
                TraceCore.WriteEtwEvent(trace, 18, null, param0, param1, payload.SerializedException, payload.AppDomainFriendlyName);
            }
        }
        
        /// <summary>
        /// Check if trace definition is enabled
        /// Event description ID=57409, Level=verbose, Channel=Analytic
        /// </summary>
        /// <param name="trace">The trace provider</param>
        internal static bool ThrowingEtwExceptionVerboseIsEnabled(EtwDiagnosticTrace trace)
        {
            return TraceCore.IsEtwEventEnabled(trace, 19);
        }
        
        /// <summary>
        /// Gets trace definition like: Throwing an exception. Source: {0}. Exception details: {1}
        /// Event description ID=57409, Level=verbose, Channel=Analytic
        /// </summary>
        /// <param name="trace">The trace provider</param>
        /// <param name="param0">Parameter 0 for event: Throwing an exception. Source: {0}. Exception details: {1}</param>
        /// <param name="param1">Parameter 1 for event: Throwing an exception. Source: {0}. Exception details: {1}</param>
        /// <param name="exception">Exception associated with the event</param>
        internal static void ThrowingEtwExceptionVerbose(EtwDiagnosticTrace trace, string param0, string param1, System.Exception exception)
        {
            TracePayload payload = trace.GetSerializedPayload(null, null, exception);
            if (TraceCore.IsEtwEventEnabled(trace, 19))
            {
                TraceCore.WriteEtwEvent(trace, 19, null, param0, param1, payload.SerializedException, payload.AppDomainFriendlyName);
            }
        }
        
        /// <summary>
        /// Check if trace definition is enabled
        /// Event description ID=57407, Level=verbose, Channel=Analytic
        /// </summary>
        /// <param name="trace">The trace provider</param>
        internal static bool ThrowingExceptionVerboseIsEnabled(EtwDiagnosticTrace trace)
        {
            return (trace.ShouldTrace(TraceEventLevel.Verbose) || TraceCore.IsEtwEventEnabled(trace, 20));
        }
        
        /// <summary>
        /// Gets trace definition like: Throwing an exception. Source: {0}. Exception details: {1}
        /// Event description ID=57407, Level=verbose, Channel=Analytic
        /// </summary>
        /// <param name="trace">The trace provider</param>
        /// <param name="param0">Parameter 0 for event: Throwing an exception. Source: {0}. Exception details: {1}</param>
        /// <param name="param1">Parameter 1 for event: Throwing an exception. Source: {0}. Exception details: {1}</param>
        /// <param name="exception">Exception associated with the event</param>
        internal static void ThrowingExceptionVerbose(EtwDiagnosticTrace trace, string param0, string param1, System.Exception exception)
        {
            TracePayload payload = trace.GetSerializedPayload(null, null, exception);
            if (TraceCore.IsEtwEventEnabled(trace, 20))
            {
                TraceCore.WriteEtwEvent(trace, 20, null, param0, param1, payload.SerializedException, payload.AppDomainFriendlyName);
            }
            if (trace.ShouldTraceToTraceSource(TraceEventLevel.Verbose))
            {
                string description = string.Format(Culture, ResourceManager.GetString("ThrowingExceptionVerbose", Culture), param0, param1);
                TraceCore.WriteTraceSource(trace, 20, description, payload);
            }
        }
        
        /// <summary>
        /// Creates the event descriptors array
        /// </summary>
        // Critical = Sets the SecurityCritical member eventDescriptors
        // Safe = We control what the event descriptors contain
        [System.Security.SecuritySafeCriticalAttribute()]
        static void CreateEventDescriptors()
        {
            eventDescriptors = new System.Runtime.Diagnostics.EventDescriptor[] {
                    new System.Runtime.Diagnostics.EventDescriptor(57393, 0, (byte)TraceChannel.Debug, (byte)TraceEventLevel.Informational, (byte)TraceEventOpcode.Info, 0x0, 0x1000000000010000),
                    new System.Runtime.Diagnostics.EventDescriptor(57394, 0, (byte)TraceChannel.Analytic, (byte)TraceEventLevel.Informational, (byte)TraceEventOpcode.Info, 0x0, 0x2000000000010000),
                    new System.Runtime.Diagnostics.EventDescriptor(57395, 0, (byte)TraceChannel.Analytic, (byte)TraceEventLevel.Error, (byte)TraceEventOpcode.Info, 0x0, 0x2000000000010000),
                    new System.Runtime.Diagnostics.EventDescriptor(57396, 0, (byte)TraceChannel.Analytic, (byte)TraceEventLevel.Warning, (byte)TraceEventOpcode.Info, 0x0, 0x2000000000010000),
                    new System.Runtime.Diagnostics.EventDescriptor(57397, 0, (byte)TraceChannel.Operational, (byte)TraceEventLevel.Critical, (byte)TraceEventOpcode.Info, 0x0, 0x4000000000010000),
                    new System.Runtime.Diagnostics.EventDescriptor(57399, 0, (byte)TraceChannel.Debug, (byte)TraceEventLevel.Critical, (byte)TraceEventOpcode.Info, 0x0, 0x1000000000010000),
                    new System.Runtime.Diagnostics.EventDescriptor(57400, 0, (byte)TraceChannel.Debug, (byte)TraceEventLevel.Error, (byte)TraceEventOpcode.Info, 0x0, 0x1000000000010000),
                    new System.Runtime.Diagnostics.EventDescriptor(57401, 0, (byte)TraceChannel.Debug, (byte)TraceEventLevel.Informational, (byte)TraceEventOpcode.Info, 0x0, 0x1000000000010000),
                    new System.Runtime.Diagnostics.EventDescriptor(57402, 0, (byte)TraceChannel.Debug, (byte)TraceEventLevel.Verbose, (byte)TraceEventOpcode.Info, 0x0, 0x1000000000010000),
                    new System.Runtime.Diagnostics.EventDescriptor(57403, 0, (byte)TraceChannel.Debug, (byte)TraceEventLevel.Warning, (byte)TraceEventOpcode.Info, 0x0, 0x1000000000010000),
                    new System.Runtime.Diagnostics.EventDescriptor(57404, 0, (byte)TraceChannel.Analytic, (byte)TraceEventLevel.Warning, (byte)TraceEventOpcode.Info, 0x0, 0x2000000000010000),
                    new System.Runtime.Diagnostics.EventDescriptor(131, 0, (byte)TraceChannel.Debug, (byte)TraceEventLevel.Verbose, (byte)12, 0x9cd, 0x1000000000010000),
                    new System.Runtime.Diagnostics.EventDescriptor(132, 0, (byte)TraceChannel.Debug, (byte)TraceEventLevel.Verbose, (byte)13, 0x9cd, 0x1000000000010000),
                    new System.Runtime.Diagnostics.EventDescriptor(133, 0, (byte)TraceChannel.Debug, (byte)TraceEventLevel.Verbose, (byte)TraceEventOpcode.Start, 0xa21, 0x1000000000200000),
                    new System.Runtime.Diagnostics.EventDescriptor(134, 0, (byte)TraceChannel.Debug, (byte)TraceEventLevel.Verbose, (byte)TraceEventOpcode.Stop, 0xa21, 0x1000000000200000),
                    new System.Runtime.Diagnostics.EventDescriptor(57405, 0, (byte)TraceChannel.Operational, (byte)TraceEventLevel.Error, (byte)TraceEventOpcode.Info, 0x0, 0x4000000000010000),
                    new System.Runtime.Diagnostics.EventDescriptor(57406, 0, (byte)TraceChannel.Analytic, (byte)TraceEventLevel.Verbose, (byte)TraceEventOpcode.Info, 0x0, 0x2000000000010000),
                    new System.Runtime.Diagnostics.EventDescriptor(57408, 0, (byte)TraceChannel.Operational, (byte)TraceEventLevel.Critical, (byte)TraceEventOpcode.Info, 0x0, 0x4000000000010000),
                    new System.Runtime.Diagnostics.EventDescriptor(57410, 0, (byte)TraceChannel.Analytic, (byte)TraceEventLevel.Warning, (byte)TraceEventOpcode.Info, 0x0, 0x2000000000010000),
                    new System.Runtime.Diagnostics.EventDescriptor(57409, 0, (byte)TraceChannel.Analytic, (byte)TraceEventLevel.Verbose, (byte)TraceEventOpcode.Info, 0x0, 0x2000000000010000),
                    new System.Runtime.Diagnostics.EventDescriptor(57407, 0, (byte)TraceChannel.Analytic, (byte)TraceEventLevel.Verbose, (byte)TraceEventOpcode.Info, 0x0, 0x2000000000010000)};
        }
        
        /// <summary>
        /// Ensures that the event descriptors array is initialized
        /// </summary>
        static void EnsureEventDescriptors()
        {
            if (eventDescriptorsCreated)
            {
                return;
            }
            System.Threading.Monitor.Enter(syncLock);
            try
            {
                if (eventDescriptorsCreated)
                {
                    return;
                }
                CreateEventDescriptors();
                eventDescriptorsCreated = true;
            }
            finally
            {
                System.Threading.Monitor.Exit(syncLock);
            }
        }
        
        /// <summary>
        /// Check if ETW tracing is enabled for the particular event
        /// </summary>
        /// <param name="trace">The trace provider</param>
        /// <param name="eventIndex">The index of the event descriptor</param>
        // Critical = Accesses SecurityCritical member eventDescriptors
        // Safe = eventDescriptors is not changed
        [System.Security.SecuritySafeCriticalAttribute()]
        static bool IsEtwEventEnabled(EtwDiagnosticTrace trace, int eventIndex)
        {
            if (trace.IsEtwProviderEnabled)
            {
                EnsureEventDescriptors();
                return trace.IsEtwEventEnabled(ref eventDescriptors[eventIndex], false);
            }
            return false;
        }
        
        /// <summary>
        /// Writes ETW trace event
        ///</summary>
        /// <param name="trace">The trace provider</param>
        /// <param name="eventIndex">The index of the event descriptor</param>>
        /// <param name="eventParam0">A parameter of the ETW event</param>>
        /// <param name="eventParam1">A parameter of the ETW event</param>>
        /// <param name="eventParam2">A parameter of the ETW event</param>>
        /// <param name="eventParam3">A parameter of the ETW event</param>>
        /// <param name="eventParam4">A parameter of the ETW event</param>>
        // Critical = Calls SecurityCritical method EtwProvider.WriteEvent
        // Safe = We only allow setting of provider id from SecurityCritical code, access to EventDescriptors is SecurityCritical, and ETW limits buffer sizes.
        [System.Security.SecuritySafeCriticalAttribute()]
        static bool WriteEtwEvent(EtwDiagnosticTrace trace, int eventIndex, System.Runtime.Diagnostics.EventTraceActivity eventParam0, string eventParam1, string eventParam2, string eventParam3, string eventParam4)
        {
            EnsureEventDescriptors();
            return trace.EtwProvider.WriteEvent(ref eventDescriptors[eventIndex], eventParam0, eventParam1, eventParam2, eventParam3, eventParam4);
        }
        
        /// <summary>
        /// Writes ETW trace event
        ///</summary>
        /// <param name="trace">The trace provider</param>
        /// <param name="eventIndex">The index of the event descriptor</param>>
        /// <param name="eventParam0">A parameter of the ETW event</param>>
        /// <param name="eventParam1">A parameter of the ETW event</param>>
        /// <param name="eventParam2">A parameter of the ETW event</param>>
        /// <param name="eventParam3">A parameter of the ETW event</param>>
        // Critical = Calls SecurityCritical method EtwProvider.WriteEvent
        // Safe = We only allow setting of provider id from SecurityCritical code, access to EventDescriptors is SecurityCritical, and ETW limits buffer sizes.
        [System.Security.SecuritySafeCriticalAttribute()]
        static bool WriteEtwEvent(EtwDiagnosticTrace trace, int eventIndex, System.Runtime.Diagnostics.EventTraceActivity eventParam0, string eventParam1, string eventParam2, string eventParam3)
        {
            EnsureEventDescriptors();
            return trace.EtwProvider.WriteEvent(ref eventDescriptors[eventIndex], eventParam0, eventParam1, eventParam2, eventParam3);
        }
        
        /// <summary>
        /// Writes ETW trace event
        ///</summary>
        /// <param name="trace">The trace provider</param>
        /// <param name="eventIndex">The index of the event descriptor</param>>
        /// <param name="eventParam0">A parameter of the ETW event</param>>
        /// <param name="eventParam1">A parameter of the ETW event</param>>
        /// <param name="eventParam2">A parameter of the ETW event</param>>
        // Critical = Calls SecurityCritical method EtwProvider.WriteEvent
        // Safe = We only allow setting of provider id from SecurityCritical code, access to EventDescriptors is SecurityCritical, and ETW limits buffer sizes.
        [System.Security.SecuritySafeCriticalAttribute()]
        static bool WriteEtwEvent(EtwDiagnosticTrace trace, int eventIndex, System.Runtime.Diagnostics.EventTraceActivity eventParam0, string eventParam1, string eventParam2)
        {
            EnsureEventDescriptors();
            return trace.EtwProvider.WriteEvent(ref eventDescriptors[eventIndex], eventParam0, eventParam1, eventParam2);
        }
        
        /// <summary>
        /// Writes ETW trace event
        ///</summary>
        /// <param name="trace">The trace provider</param>
        /// <param name="eventIndex">The index of the event descriptor</param>>
        /// <param name="eventParam0">A parameter of the ETW event</param>>
        /// <param name="eventParam1">A parameter of the ETW event</param>>
        /// <param name="eventParam2">A parameter of the ETW event</param>>
        // Critical = Calls SecurityCritical method EtwProvider.WriteEvent
        // Safe = We only allow setting of provider id from SecurityCritical code, access to EventDescriptors is SecurityCritical, and ETW limits buffer sizes.
        [System.Security.SecuritySafeCriticalAttribute()]
        static bool WriteEtwEvent(EtwDiagnosticTrace trace, int eventIndex, System.Runtime.Diagnostics.EventTraceActivity eventParam0, int eventParam1, string eventParam2)
        {
            EnsureEventDescriptors();
            return trace.EtwProvider.WriteEvent(ref eventDescriptors[eventIndex], eventParam0, eventParam1, eventParam2);
        }
        
        /// <summary>
        /// Writes ETW trace event
        ///</summary>
        /// <param name="trace">The trace provider</param>
        /// <param name="eventIndex">The index of the event descriptor</param>>
        /// <param name="eventParam0">A parameter of the ETW event</param>>
        /// <param name="eventParam1">A parameter of the ETW event</param>>
        /// <param name="eventParam2">A parameter of the ETW event</param>>
        /// <param name="eventParam3">A parameter of the ETW event</param>>
        // Critical = Calls SecurityCritical method EtwProvider.WriteEvent
        // Safe = We only allow setting of provider id from SecurityCritical code, access to EventDescriptors is SecurityCritical, and ETW limits buffer sizes.
        [System.Security.SecuritySafeCriticalAttribute()]
        static bool WriteEtwEvent(EtwDiagnosticTrace trace, int eventIndex, System.Runtime.Diagnostics.EventTraceActivity eventParam0, int eventParam1, int eventParam2, string eventParam3)
        {
            EnsureEventDescriptors();
            return trace.EtwProvider.WriteEvent(ref eventDescriptors[eventIndex], eventParam0, eventParam1, eventParam2, eventParam3);
        }
        
        /// <summary>
        /// Writes ETW trace event
        ///</summary>
        /// <param name="trace">The trace provider</param>
        /// <param name="eventIndex">The index of the event descriptor</param>>
        /// <param name="eventParam0">A parameter of the ETW event</param>>
        /// <param name="eventParam1">A parameter of the ETW event</param>>
        // Critical = Calls SecurityCritical method EtwProvider.WriteEvent
        // Safe = We only allow setting of provider id from SecurityCritical code, access to EventDescriptors is SecurityCritical, and ETW limits buffer sizes.
        [System.Security.SecuritySafeCriticalAttribute()]
        static bool WriteEtwEvent(EtwDiagnosticTrace trace, int eventIndex, System.Runtime.Diagnostics.EventTraceActivity eventParam0, string eventParam1)
        {
            EnsureEventDescriptors();
            return trace.EtwProvider.WriteEvent(ref eventDescriptors[eventIndex], eventParam0, eventParam1);
        }
        
        /// <summary>
        /// write a trace source into the diagnostic trace
        /// </summary>
        /// <param name="trace">The trace provider</param>
        /// <param name="eventIndex">The index of the event descriptor</param>
        /// <param name="description">The description to write</param>
        /// <param name="payload">The trace payload</param>
        // Critical = Calls SecurityCritical method EtwDiagnosticTrace.WriteTraceSource
        // Safe = We only allow setting of provider id from SecurityCritical code
        [System.Security.SecuritySafeCriticalAttribute()]
        static void WriteTraceSource(EtwDiagnosticTrace trace, int eventIndex, string description, TracePayload payload)
        {
            EnsureEventDescriptors();
            trace.WriteTraceSource(ref eventDescriptors[eventIndex], description, payload);
        }
    }
}

