/*
 * Copyright (C) by Argonne National Laboratory
 *     See COPYRIGHT in top-level directory
 */

/* -- THIS FILE IS AUTO-GENERATED -- */

#include "mpiimpl.h"
#include "mpii_fortlogical.h"

/* -- Begin Profiling Symbol Block for routine MPI_Abi_get_fortran_booleans */
#if defined(HAVE_PRAGMA_WEAK)
#pragma weak MPI_Abi_get_fortran_booleans = PMPI_Abi_get_fortran_booleans
#elif defined(HAVE_PRAGMA_HP_SEC_DEF)
#pragma _HP_SECONDARY_DEF PMPI_Abi_get_fortran_booleans  MPI_Abi_get_fortran_booleans
#elif defined(HAVE_PRAGMA_CRI_DUP)
#pragma _CRI duplicate MPI_Abi_get_fortran_booleans as PMPI_Abi_get_fortran_booleans
#elif defined(HAVE_WEAK_ATTRIBUTE)
int MPI_Abi_get_fortran_booleans(int logical_size, void *logical_true, void *logical_false,
                                 int *is_set)
                                  __attribute__ ((weak, alias("PMPI_Abi_get_fortran_booleans")));
#endif
/* -- End Profiling Symbol Block */

/* Define MPICH_MPI_FROM_PMPI if weak symbols are not supported to build
   the MPI routines */
#ifndef MPICH_MPI_FROM_PMPI
#undef MPI_Abi_get_fortran_booleans
#define MPI_Abi_get_fortran_booleans PMPI_Abi_get_fortran_booleans
#endif /* MPICH_MPI_FROM_PMPI */

static int internal_Abi_get_fortran_booleans(int logical_size, void *logical_true,
                                             void *logical_false, int *is_set)
{
    int mpi_errno = MPI_SUCCESS;

    MPIR_ERRTEST_INITIALIZED_ORDIE();

    MPID_THREAD_CS_ENTER(GLOBAL, MPIR_THREAD_GLOBAL_ALLFUNC_MUTEX);
    MPIR_FUNC_TERSE_ENTER;

#ifdef HAVE_ERROR_CHECKING
    {
        MPID_BEGIN_ERROR_CHECKS;
        {
            MPIR_ERRTEST_ARGNONPOS(logical_size, "logical_size", mpi_errno, MPI_ERR_ARG);
            MPIR_ERRTEST_ARGNULL(logical_true, "logical_true", mpi_errno);
            MPIR_ERRTEST_ARGNULL(logical_false, "logical_false", mpi_errno);
            MPIR_ERRTEST_ARGNULL(is_set, "is_set", mpi_errno);
        }
        MPID_END_ERROR_CHECKS;
    }
#endif /* HAVE_ERROR_CHECKING */

    /* ... body of routine ... */
    MPI_Datatype type = MPI_LOGICAL;
    MPIR_DATATYPE_REPLACE_BUILTIN(type);
    if (type == MPI_DATATYPE_NULL) {
        *is_set = 0;
        /* do we leave other outputs unset? */
    } else {
        *is_set = 1;
        int exp_logical_size = MPIR_Datatype_get_basic_size(type);
        if (logical_size != exp_logical_size) {
            MPIR_ERR_SETANDJUMP1(mpi_errno, MPI_ERR_ABI, "**logical_size_wrong", "**logical_size_wrong %d", exp_logical_size);
        }
        switch(logical_size) {
            case 1:
                *(int8_t *) logical_true = MPIR_fortran_true;
                *(int8_t *) logical_false = MPIR_fortran_false;
                break;
            case 2:
                *(int16_t *) logical_true = MPIR_fortran_true;
                *(int16_t *) logical_false = MPIR_fortran_false;
                break;
            case 4:
                *(int32_t *) logical_true = MPIR_fortran_true;
                *(int32_t *) logical_false = MPIR_fortran_false;
                break;
            case 8:
                *(int64_t *) logical_true = MPIR_fortran_true;
                *(int64_t *) logical_false = MPIR_fortran_false;
                break;
            default:
                MPIR_ERR_SETANDJUMP1(mpi_errno, MPI_ERR_ABI, "**logical_size_unexp", "**logical_size_unexp %d", logical_size);
        }
    }
    /* ... end of body of routine ... */

  fn_exit:
    MPIR_FUNC_TERSE_EXIT;

    MPID_THREAD_CS_EXIT(GLOBAL, MPIR_THREAD_GLOBAL_ALLFUNC_MUTEX);
    return mpi_errno;

  fn_fail:
    /* --BEGIN ERROR HANDLINE-- */
#ifdef HAVE_ERROR_CHECKING
    mpi_errno = MPIR_Err_create_code(mpi_errno, MPIR_ERR_RECOVERABLE, __func__, __LINE__, MPI_ERR_OTHER,
                                     "**mpi_abi_get_fortran_booleans",
                                     "**mpi_abi_get_fortran_booleans %d %p %p %p", logical_size,
                                     logical_true, logical_false, is_set);
#endif
    mpi_errno = MPIR_Err_return_comm(0, __func__, mpi_errno);
    /* --END ERROR HANDLING-- */
    goto fn_exit;
}

#ifdef ENABLE_QMPI
#ifndef MPICH_MPI_FROM_PMPI
int QMPI_Abi_get_fortran_booleans(QMPI_Context context, int tool_id, int logical_size,
                                  void *logical_true, void *logical_false, int *is_set)
{
    return internal_Abi_get_fortran_booleans(logical_size, logical_true, logical_false, is_set);
}
#endif /* MPICH_MPI_FROM_PMPI */
int MPI_Abi_get_fortran_booleans(int logical_size, void *logical_true, void *logical_false,
                                 int *is_set)
{
    QMPI_Context context;
    QMPI_Abi_get_fortran_booleans_t *fn_ptr;

    context.storage_stack = NULL;

    if (MPIR_QMPI_num_tools == 0)
        return QMPI_Abi_get_fortran_booleans(context, 0, logical_size, logical_true, logical_false,
                                             is_set);

    fn_ptr = (QMPI_Abi_get_fortran_booleans_t *) MPIR_QMPI_first_fn_ptrs[MPI_ABI_GET_FORTRAN_BOOLEANS_T];

    return (*fn_ptr) (context, MPIR_QMPI_first_tool_ids[MPI_ABI_GET_FORTRAN_BOOLEANS_T],
            logical_size, logical_true, logical_false, is_set);
}
#else /* ENABLE_QMPI */
int MPI_Abi_get_fortran_booleans(int logical_size, void *logical_true, void *logical_false,
                                 int *is_set)
{
    return internal_Abi_get_fortran_booleans(logical_size, logical_true, logical_false, is_set);
}

#endif /* ENABLE_QMPI */
