<?
#==========================================================

# ===========================================================
#

function corrigeRNE($rne)
{
    return $rne;
}

/*
    if (file_exists("utils/compte_inspecteur.csv")) {
        if (($handle = fopen("utils/compte_inspecteur.csv", "r")) !== FALSE) {
            while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {
                //$rne = corrigeRNE(strtoupper($data[0]));
                $rne = corrigeRNE($data[0]);
                $ETABS[$rne]["inspecteur"]=true;
            }
            fclose($handle);
        }
    }
*/

$fichier_etabs_ini = "utils/etabs.ini";
if (file_exists($fichier_etabs_ini)) {
    // INI_SCANNER_RAW : pour eviter les interpretations des quotes
    $ETABS = parse_ini_file($fichier_etabs_ini,true,INI_SCANNER_RAW);
    if (!$ETABS){
        echo("<br/><table>".DisplayAppli("Fichier utils/etabs.ini invalide !", "", "ERREUR")."</table><br/>");
    }
} else {
    $ETABS = array();
}


function GetInfo($key)
{
    //if (!is_array ($_SESSION["CASATTRIBUTE"])) return "";
    return $_SESSION["CASATTRIBUTE"][$key][0];
}

function HasFederationKey()     { return isset($_SESSION["CASATTRIBUTE"]["FederationKey"]);}

function BAD_SESSION()
{
    echo "
          <body>
            Vous êtes un personnel de l'Education Nationale,<br>
             veuillez donc utiliser vos identifiants académiques pour vous connecter.
            <br>
            <a href='logout.php?url=".$_SERVER[SCRIPT_NAME]."'>Cliquer ici pour vous reconnecter</a>
          </body>
    ";
    die();
}


/* On va vérifier que l'utilisateur est dans l'annuaire consolidé */
function GetRneEntryInScribeForAcadUser($mail)
{
    $ds=ldap_connect("localhost");
    $infos=array("dn");
    $sr=ldap_search($ds,"ou=education,o=gouv,c=fr", "FederationKey=".strtolower($mail),$infos);
    $infos = ldap_get_entries($ds, $sr);

    $rnes=array();

    $count= $infos['count'];
    for ($i=0;$i<$count;$i++)
    {
        if (ereg("(.*),ou=(.*),ou=.*,ou=education,o=gouv,c=fr",$infos[$i]['dn'],$regs))
        {
            $r=strtoupper($regs[2]);
            $rnes[]=strtoupper($r);
        }
    }

    return $rnes;
}

function GetRne()
{
    $s=strtoupper(GetInfo("rne"));
    $arr=array_unique(explode("|",$s));
    $s=implode(",",$arr);

    return $s;
}

function PIWIK($service,$etab,$profil)
{
    ?>
        <!-- Piwik -->
        <script type="text/javascript">
        try {
          var piwikTracker = Piwik.getTracker(pkBaseURL + "piwik.php", 5);
          piwikTracker.setDocumentTitle("<? echo($service); ?>");
          piwikTracker.setCustomUrl("<? echo($etab); ?>");
          piwikTracker.setReferrerUrl("<? echo($profil); ?>");
          piwikTracker.trackPageView();
          piwikTracker.enableLinkTracking();
        } catch( err ) {}
        </script>
        <!-- End Piwik Code -->
    <?
}


/* =========================================================*/
/* Librairie permettant d'affihcer les Applications la mode Arenb*/
function DisplayTitre($TITRE,$ICON=false)
{
    $ICON=false;
    if (!$ICON)
    {
        $ICON="option".TID().".gif";
    }

    echo "<tr>
        <TD width='10%'><IMG ALT=\"\" height=35 src=\"images/spacer.gif\" width=20>
        </TD>
            <TD align='left' vAlign=Bottom width=90% background='" . "images/" . $ICON .  "' STYLE=\"background-repeat: no-repeat\">
                    <font class='titreAren'>$TITRE</font>
        </TD>
            <TD><IMG ALT=\"\" border=0 height=35 src=\"images/spacer.gif\" width=1>
            </TD>
              </tr>";


}

function DisplayAppli($TITRE,$URL,$flag="",$TARGET=false)
{
    echo "<TR><TD width='10%'><IMG ALT=\"\" height=1 src=\"images/spacer.gif\" width=20></TD><TD align='left' vAlign=Bottom width=90% class='lienAren'>&#160;&#160;";
    $s="";
    switch ($flag)
    {
        case "ERREUR":
            $s="cross.png";$color="#F99";break;
        case "WARNING":
            $s="warning.png";$color="#ecc14e";break;

    }
    if ($s != "" )
    {
        $TITRE= "<font color='$color'><img ALIGN='ABSMIDDLE' src='images/$s'>&nbsp;&nbsp;&nbsp;" . $TITRE . "</font>";
    }

    if ( $TARGET === false ) {
        $TARGET="target=_blank";
        if (!isset($_GET["ent"]))   $TARGET="";
    }

    if ($URL != "") echo "<A class='lienAren' $TARGET title=\"$TITRE\" href='$URL'>$TITRE</A>";
    else echo "$TITRE";
    echo "</TD><TD><IMG ALT=\"\" border=0 height=1 src=\"images/spacer.gif\" width=1></TD></TR>";
}


function http_file_exists($url)
{
    $f=@fopen($url,"r");
    if($f)
    {
        $output = stream_get_contents($f);
        fclose($f);
        if ( strpos($output,"username") !== False )
        {
            //die ($output);
            return true;
        }
    }
    return false;
}

function BuildListOfENT($AutoRedirectIfOneEntry = False)
{
    $rne=GetRne();
    $arr=explode(",",$rne);

    $errorlevel=error_reporting();
    error_reporting(0);

    $RneScribe=$arr;

    // Si c'est une authentification académique, on va récupérer les RNE où est présent
    // l'adresse mail académqiue de la personne
    // Cas ou un enseignant a un FrEduRne d'un établissement, mais n'y enseigne pas, il ne faut donc pas
    // lui présenter le lien de connexion à l'ENT de cet établissement
    if (  IsAuthAcad() )
    {
        $RneScribe=GetRneEntryInScribeForAcadUser(GetInId());
        if (count($RneScribe)==0) $RneScribe=explode(",",GetRne());
    }

    $count=0;$url="";$AuMoinsUnEtabEnt=false;
    foreach ( $arr as $rne)
    {

        if (!in_array($rne,$RneScribe)) continue;

        $portail=GetPortailFromRne($rne);
        if ( $portail === False )
        {
            continue;
        } elseif (  $portail == "" )
        {
            // si pas d'ent installé, sentinelle renvoie une adresse de portail vide
            DisplayAppli("#100: [".$rne . "] " .GetLibelleEtabFromRne($rne) . " ne dispose pas encore d'un ENT", "","WARNING");
            PIWIK("Accès/" . "Pas d'ENT/" . $rne ,"/Accès" ,"");
        } else
        {
            $AuMoinsUnEtabEnt=true;

            $test=0;
            $url=_URL_SESHAT.":"._SERVEUR_SSO_PORT."/saml?sp_ident=".$rne."&RelayState=https://".GetPortailFromRne($rne);

            $test = fsockopen($portail, 8443, $errno, $errstr, 5);

            if ($test !== false)
            {
                if ($test!=0) fclose($test);
                if (http_file_exists("https://$portail:8443"))
                {
                    DisplayAppli(" [".$rne . "] " .GetLibelleEtabFromRne($rne),$url);
                    PIWIK("Accès/" . "OK/" . $rne ,"/Accès" ,"");
                    $count++;
                } else
                {
                    DisplayAppli("#200: [".$rne . "] " .GetLibelleEtabFromRne($rne). " semble indisponible pour le moment (Scribe injoignable)","","ERREUR");
                    DisplayAppli("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;=> Cliquez ici pour essayer l'accès à " .GetLibelleEtabFromRne($rne),$url);
                    PIWIK("Accès/" . "Scribe HS/" . $rne ,"/Accès" ,"");
                }
            } else
            {
                DisplayAppli("#201 [".$rne . "] " .GetLibelleEtabFromRne($rne). " semble indisponible pour le moment (Accès impossible)","","ERREUR");
                DisplayAppli("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;=> Cliquez ici pour essayer l'accès à " .GetLibelleEtabFromRne($rne),$url);
                PIWIK("Accès/" . "Injoignable/" . $rne ,"/Accès" ,"");
            }
        }
    }

    // Si un seul établissement et autoredirect
    if ( ($AutoRedirectIfOneEntry) && ($count == 1) )
    {
        echo '<SCRIPT LANGUAGE="JavaScript">';
        echo ' document.location.href="' . $url .'"';
        echo '</SCRIPT>';
    }

    if ( ( $count == 0 ) && ($AuMoinsUnEtabEnt))
    {
        $CODE="($rne)";
        if (  IsAuthAcad() ){
            $CODE="ACAD=[$rne] ENT=[". implode(",",$RneScribe) ."]";
        }

        echo "<tr height='20px'></tr>";
        DisplayAppli("&nbsp;&nbsp;&nbsp; <b> >>#300: Aucun ENT n'est disponible pour vos affectations $CODE<< </b>", "");
        echo "<tr height='20px'></tr>";

        DisplayTitre("Vous pouvez cependant");
        DisplayAppli("Accéder au site internet dédié à l'ENT", _URL_PORTAIL_DEFAUT);
        #DisplayAppli("Accéder au portail Académique (Iprof, Webmail,...)", "https://seshat.ac-reunion.fr/dispatcher/apps.php?ent=1");
    }

    // Aucun établissement ENT pour cet utilisateur, on redirige donc vers les services académiques
    if (  !$AuMoinsUnEtabEnt )
    {
        DisplayAppli("Si vous n'êtes pas redirigé automatiquement, cliquer ici pour accéder aux applications académiques", _URL_PORTAIL_ACA);
        echo '<SCRIPT LANGUAGE="JavaScript">';
        echo ' document.location.href="' . _URL_PORTAIL_ACA .'"';
        echo '</SCRIPT>';

    }

    error_reporting($errorlevel);

}

/* =========================================================*/

function input_validation ($data, $charset = 'UTF-8') {
    if (is_array ($data)) {
        foreach ($data as $key => $value) {
            $data[$key] = input_validation ($value);
        }
    }
    else {
        $data = htmlentities (trim ($data), ENT_QUOTES, $charset);
    }
    return $data;
}



function GetUid()       {return GetInfo("user");}
function GetInId()      {return GetInfo("uid");}
function IsAuthAcad()       {return GetInfo("source")=="ACADEMIQUE";}
function GetFederationKey()     {return GetInfo("FederationKey");}
function GetDisplayName()   {return GetInfo("displayName");}
function GetTicket()        {return $_SESSION["id"];}
function GetPortail()
{
    return GetPortailFromRne(GetRne());
}

function GetPortailFromRne($rne)
{
    global $ETABS;

    $pos = strpos($rne,",");
    if ( $pos !== false )
    {
        return "Plusieurs établissements : $rne";
    }


    if (isset($ETABS[$rne])) {
        if (isset($ETABS[$rne]["portail"])) {
            return parse_url($ETABS[$rne]["portail"], PHP_URL_HOST);
        }
    }

    return false;
}

function GetLibelleEtabFromRne($rne)
{
    global $ETABS;
    $pos = strpos($rne,",");
    if ( $pos !== false )
    {
        return "Plusieurs établissements : $rne";
    }

    if (!isset($ETABS[$rne])) {
        return "$rne";
    }

    if (!isset($ETABS[$rne]["libelle"])) {
        return "$rne";
    }

    return $ETABS[$rne]["libelle"];
}

function GetLibelleEtab()
{
    return GetLibelleEtabFromRne(GetRne());
}


# Nomenclature nationale des profils utilisateurs
#    National_1 : Élève
#    National_2 : Responsable d'un élève (parent, tuteur légal)
#    National_3 : Enseignant
#    National_4 : Personnel de direction de l'établissement
#    National_5 : Personnel de vie scolaire travaillant dans l'établissement
#    National_6 : Personnel administratif, technique ou d'encadrement
#                  travaillant dans l'établissement
#    National_7 : Personnel de rectorat, de DRAF, de collectivité locale,
#                 d'inspection académique
function GetProfil()        {return GetInfo("profils");}
function GetProfilLibelle()
{
    switch (GetProfil())
    {
        case "National_1":return "Élève";
        case "National_2":return "Responsable";
        case "National_3":return "Enseignant" . GetLibelleOTP();
        case "National_4":return "Direction" . GetLibelleOTP();
        case "National_5":return "Vie scolaire" . GetLibelleOTP() ;
        case "National_6":return "Administratif" . GetLibelleOTP() ;
        case "National_7":return "Académique" . GetLibelleOTP();
    }
    return GetProfil();
}
function IsEnseignant() {return GetProfil()=="National_3";}
function IsEleve()  {return GetProfil()=="National_1";}
function IsParent() {return GetProfil()=="National_2";}
function IsRectorat()   {return GetProfil()=="RECTORAT";}
function IsInspecteur() {return GetProfil()=="INSPECTEUR";}
function IsOTP()    {return GetInfo("auth") == "OTP";}


function GetLibelleOTP()
{
    if (IsOTP()) return " OTP";
    else "";
}

function TID()
{
    if (IsEnseignant())         return "";
    else if (IsEleve())         return "2";
    else if (IsParent())        return "3";
}

function PIWIK_LIB()
{
    echo '<script type="text/javascript">';
    echo 'var pkBaseURL = '._PIWIK_BASE_URL.';';
    echo 'document.write(unescape("%3Cscript src=\'" + pkBaseURL + "piwik.js\' type=\'text/javascript\'%3E%3C/script%3E"));';
    echo '</script>';
}

# ==========================================================
#


?>
