<?php
# Chargement de la partie CAS + lib
include_once("include/inc.php");
if (isset($_SESSION["bad"])){BAD_SESSION();}

include_once("arena/arena_inc.php");

// Récupération des favoris CT
$favCT=array();
try  {
    $client = WS();
    $result=$client->getFavoris(GetUid());
    $items=objectToArray($result);
    foreach ($items["item"] as $f)  {$favCT[]=$f["urlCT"];}
} catch (Exception $e) {}

ini_set('error_reporting', E_ALL);
ini_set( "display_errors", 1);

define("BOOKMARK_ADD","BOOKMARK_ADD");
define("BOOKMARK_DEL","BOOKMARK_DEL");

function sendMessage($message,$success)
{
      echo "<html><body>";
      echo "<form id='form2submit' name='form2submit' method='POST' action='".$_GET["callback"]."'>";
      echo "<input name='action'  id='action'  type='hidden' value='".$_GET["action"]."' />";
      echo "<input name='message' id='message' type='hidden' value='".htmlentities($message,ENT_QUOTES,"UTF-8")."' />";
      echo "<input name='success' id='success' type='hidden' value='".$success."' />";
      echo "<input name='id'      id='id'      type='hidden' value='".$_GET["id"]."' />";
      echo "<input name='callbackid'      id='callbackid'      type='hidden' value='".$_GET["callbackid"]."' />";
      echo "</form>";
      echo "<script>";
      echo "document.form2submit.submit();";
      echo "</script>";
      echo "</body></html>";
      die();
}


function success($m) {sendMessage($m,1);}
function error($m)   {sendMessage($m,0);}

$uid=GetUid();


if ($_GET['action']==BOOKMARK_ADD) {
    $libelle            =$_GET['libelle'];
    $url                =$_GET['favurl'];
    $icon               =$_GET['icon'];
    $categorie          ="";


    // Cas où il s'agit d'une URL CT
    if (strpos($url,SEP_SIGAT)!==false)
    {
        $favoris = null;
        try {
            $favoris  = \R::findOne( 'arenafavoris','user = ? ',[$uid]);
        } catch (\Exception $e) {
            $favoris = null ;
        }

        if (!$favoris) {
            $client = new SoapClient(__ARENA_WSIDENTITE);

            // ref  #16870 : Vérification du nombre de favrois Arena
            $result = $client->getFavoris(GetUid());
            $items = objectToArray($result);
            if (isset($items["item"]) && count($items["item"]) >= __ARENA_FAVORIS_MAX) {
                error("Le nombre de favoris Arena est limité, vous ne pouvez donc plus ajouter de favoris Arena");
            }

            // ref #16870 : on recréé le tableau des favoris, avant de l'envoyer au WS
            $favCT = [];
            // ref #20184 : Un hash de favoris pour s'assurer de ne pas ajouter deux fois le favoris
            $hashFav = [];
            // Y a t'il des favoris déja ?
            if (isset($items["item"])) {
                $favorisArena = $items["item"];
                // ref #16870 : Si $items["item"]["uid"] existe, ( => un seul favori ), dans ce cas  $items["item"] n'est pas un tableau de favoris
                if (isset($items["item"]["uid"])) {
                    $favorisArena = array($items["item"]);
                }
                foreach ($favorisArena as $item) {
                    if (strlen($item["urlCT"]) < 5) continue; // Une url de favoris doit avoir au moins 5 caractères
                    // fixes #20184 : Verifions si le favoris n'existe pas encore
                    if (array_key_exists($item["urlCT"], $hashFav)) continue;

                    $hashFav[$item["urlCT"]] = true;
                    $favCT[] = $item["urlCT"];
                }
            }

            // Ajout du favori si pas encore existant
            if (!array_key_exists($url, $hashFav)) {
                $favCT[] = $url;
            }

            // appel du WS
            $result = $client->setFavoris(GetUid(), $favCT);
        } else  {
            $ressources  = json_decode($favoris->ressources,true);
            $resarena    = arenaRessource($url);
            if (!in_array($resarena,$ressources)) {
                $ressources[] = $resarena ;
            }
            $now = new \DateTime("now");
            $favoris->updatedAt = $now;
            $favoris->ressources = json_encode($ressources);
            R::store($favoris);

        }

        success($libelle . " a été ajouté à vos favoris");
    } else
    {
        $favori=R::findOne( 'favoris', ' uid = ? and url  = ? ', array($uid,$url));
        if (!$favori) {
          $favori = R::dispense('favoris');
          $favori->uid=$uid;
          $favori->url=$url;
        }
        $favori->icon=$icon;
        $favori->libelle=$libelle;
        R::store($favori);

        success($libelle . " a été ajouté à vos favoris");
    }

    error($libelle . " n'a pu être ajouté à vos favoris");

}

if ($_GET['action']==BOOKMARK_DEL) {
    $url                  =$_GET['favurl'];
    $libelle              =$_GET['libelle'];

    // Cas où il s'agit d'une URL CT
    if (strpos($url,SEP_SIGAT)!==false)
    {
        $favoris = null;
        try {
            $favoris  = \R::findOne( 'arenafavoris','user = ? ',[$uid]);
        } catch (\Exception $e) {
            $favoris = null ;
        }

        if (!$favoris) {
            $newArr=array();

            $ress=arenaRessource($url);

            foreach ($favCT as $f)
            {
                $r=arenaRessource($f);
                if ($f != $url && $r!=$ress) $newArr[]=$f;
            }
            $result=$client->setFavoris($uid,$newArr);
        } else  {
            $ressources  = json_decode($favoris->ressources,true);
            $resarena=arenaRessource($url);


            $nouvellesRessources = [];
            foreach ($ressources as $ress) {
                // Ca correspond : ON ne l'ajoute pas
                if ($url == $ress) {
                    continue;
                }

                if ($resarena == $ress) {
                    continue;
                }

                $nouvellesRessources[] = $ress;
            }
            $now = new \DateTime("now");
            $favoris->updatedAt = $now;
            $favoris->ressources = json_encode($nouvellesRessources);
            R::store($favoris);

        }

        success($libelle . " a été supprimé à vos favoris");
    } else
    {
        $favori=R::findOne( 'favoris', ' uid = ? and url  = ? ', array($uid,$url));
        if ($favori) {
          R::trash( $favori );
          success($libelle . " a été supprimé à vos favoris");
        }
    }

    error($libelle . " n'a pu être supprimé de vos favoris url=[$url] uid=[$uid] ");
}


?>
