<?php

namespace Edispatcher\Controllers;
use \Psr\Http\Message\ServerRequestInterface as Request;
use \Psr\Http\Message\ResponseInterface as Response;
use Slim\Container;

use Prometheus\CollectorRegistry;
use Prometheus\RenderTextFormat;

use Edispatcher\Entity\Application;

function objectToArray($d)
{
    if (is_object($d)){$d = get_object_vars($d);}
    if (is_array($d)){return array_map(__FUNCTION__, $d);} else{return $d;}
}


class ArenaController extends BaseController {

  public function refreshAction(Request $request, Response $response, $args) {



    $this->requireCacheManager();

    $uid = $args["uid"];
    if (!$uid) {die("uid manquant");}

    $caches=\R::find( 'arenacache', 'uid = ?', [$uid]);
    $client = new \SoapClient(__ARENA_WSIDENTITE);

    foreach ($caches as $cache) {
        $result=$client->getRessourcesPortail($cache->uid,$cache->zone);
        $items=objectToArray($result);
        if (!is_array($items) || count($items)==0) {
          continue;
        }
        $cache->setCache($items); // setCache met aussi a jour la date de l'update
    }
    \R::storeAll( $caches );


    if (count($caches)){
      $token=\R::findOne( 'hubtoken','user = ?',[$uid]);
      if ($token) {

          $caches=\R::find( 'cache', 'hubtoken_id = ? ', array($token->id));
          \R::trashAll($caches);

          $token->refresh = true;
          \R::store($token);
      }
    }


    $loc=$this->ci->get('router')->pathFor('arena_cache',["uid"=>$uid]);
    return $response->withRedirect($loc);

 }

 public function getData(Request $request, Response $response, $args) {
        $queryParams=$request->getQueryParams();
        if ($args["uid"]) {
            $state = "userok";
        $uid = $args["uid"];
        $cachesArena=\R::find( 'arenacache', 'uid = ?', [$uid]);
        foreach ($cachesArena as $cacheArena) {

            $cache = unserialize($cacheArena->content);
            $items = $cache["item"];
            $cacheArena->items=[];
            foreach($items as $item) {
                $sousDomaines=$item["sousDomaines"];
                if (!isset($sousDomaines["0"])) {$sousDomaines=array(0=>$sousDomaines);}
                foreach($sousDomaines as $sousDomaine)
                    {
                    $ressources=$sousDomaine["ressources"];
                    if (!isset($ressources["0"])) {$ressources=array(0=>$ressources);}
                        foreach($ressources as $ressource)
                            {
                            $libelle=$ressource["libelleRessource"];
                            $url=$ressource["urlComplete"];
                            $cacheArena->items[]=["libelle"=>$libelle, "url" => $url];
                            }
                    }
            }
        }
        $token = null;$caches=[];
        if (count($cachesArena)){
        $token=\R::findOne( 'hubtoken','user = ?',[$uid]);
        $caches=\R::find( 'cache', 'hubtoken_id = ?', array($token->id));
        }

    }
    elseif (array_key_exists("uid2find", $queryParams)) {
        $uid = $queryParams['uid2find'];
    if (strlen($uid) < 3) {
        $state = "nouid";
    }
    else { // uid ok
        $users=\R::getAll( "SELECT DISTINCT(uid) FROM arenacache WHERE uid LIKE '%" .$uid. "%'" );
        switch (count($users)) {
        case 0:
            $state = "nouserfound";
            break;
        case 1:
            $state = "userok";
            $uid = $users[0]['uid'];
            $loc=$this->ci->get('router')->pathFor('arena_cache',["uid"=>$uid]);
            return $response->withRedirect($loc);
        break;
        default:
            $usersfound=array();
            $state="severalusers";
            foreach($users as $user) {
                $usersfound[] = $user['uid'];
            }
        }
    } //fin du else (uid ok)
    }

     $ressourcesEnFavoris = [];
     try {
         $favoris  = \R::findOne( 'arenafavoris','user = ? ',[$uid]);
         $ressourcesEnFavoris = json_decode($favoris->ressources,true);
     } catch (\Exception $e) {
         $ressourcesEnFavoris = [] ;
     }
    
    return [ "token" => $token,
    "favoris" =>     $ressourcesEnFavoris,
    "cachesArena"=>$cachesArena,
    "caches" => $caches,
    "uid" => $uid,"__CACHE_DURATION"=>__CACHE_DURATION, "state"=>$state,"usersfound"=>$usersfound];// fin du elseif
 }


  public function cacheAction(Request $request, Response $response, $args) {
        //print_r($this->getProfil()->getGroupes());die();
    $this->requireCacheManager();
      
    $data = $this->getData($request,$response,$args);

    return $this->ci["view"]->render($response, 'arena/show.html.twig',$this->genParams($data));
   }
}
