<?php

namespace Edispatcher\Controllers;
use \Psr\Http\Message\ServerRequestInterface as Request;
use \Psr\Http\Message\ResponseInterface as Response;
use Slim\Container;

use Prometheus\CollectorRegistry;
use Prometheus\RenderTextFormat;

use Edispatcher\Entity\Application;


class DelegController extends BaseController {

    //Constructor
    /*public function __construct() {
      $this->ci = null;
  }*/

  public function delegAction(Request $request, Response $response, $args) {
    $this->requireManager();

    $delegs=\R::find( 'deleg', 'ORDER by value');
    $roles=\R::find( 'role', 'ORDER by libelle');
    return $this->ci["view"]->render($response, 'app/deleg.html.twig', $this->genParams(["delegs"=>$delegs,"roles"=>$roles]));
  }

  public function deleteAction(Request $request, Response $response,$args){
    $this->requireManager();

    $deleg = \R::findOne("deleg" , "id = ? ", [$args["id"]]);
    if (!$deleg) {
        $this->notFound("id incorrect");
    }
    \R::trash($deleg);

    $url = $this->ci->get('router')->pathFor('deleg');
    return $response->withRedirect($url);
  }

  public function createAction(Request $request, Response $response, $args) {
    $this->requireManager();

    $data=$request->getParsedBody();


    $value = $data["value"];
    $role = \R::findOne("role" , "id = ? ", [$data["role"]]);
    if (!$role) {
        $this->notFound("role incorrect");
    }

    if (isset($data["id"]) and $data["id"]) {
      $deleg = \R::findOne("deleg" , "id = ? ", [$data["id"]]);
      if (!$deleg) {
          $this->notFound("id incorrect");
      }
    } else {
      $deleg = \R::findOne("deleg" , "value = ? ", [$value]);
      if (!$deleg) {
          $deleg = \R::dispense("deleg");
      }
    }

    $deleg->value = $value;
    $deleg->role  = $role;
    \R::store($deleg);

    $url = $this->ci->get('router')->pathFor('deleg');
    return $response->withRedirect($url);

  }

}
