<?php

namespace Edispatcher\Controllers;
use \Psr\Http\Message\ServerRequestInterface as Request;
use \Psr\Http\Message\ResponseInterface as Response;
use Slim\Container;

use Edispatcher\Entity\Application;


class DocController {

  protected $ci;

  //Constructor
  public function __construct(Container $ci) {
    $this->ci = $ci;
  }

  public function indexAction(Request $request, Response $response, $args) {

    $params["profilClass"]="edispatcher-ng";
    $params["profil"]=$this->ci["profil"];
    return $this->ci["view"]->render($response, 'doc/index.html.twig',$params);
  }

  public function accueilAction(Request $request, Response $response, $args) {

    return $this->ci["view"]->render($response, 'doc/accueil.html.twig');
  }

  public function pageAction(Request $request, Response $response, $args) {
    return $this->ci["view"]->render($response, 'doc/'.$args['name'].'.html.twig',$params);
  }


  public function componentAction(Request $request, Response $response, $args) {
    $params["profil"]=$this->ci["profil"];
    return $this->ci["view"]->render($response, 'doc/'.$args['name'].'.html.twig',$params);
  }

}
