<?php

namespace Edispatcher\Entity;


class Arenacache extends \RedBeanPHP\SimpleModel {

  public function dispense() {
      $this->created=new \DateTime();
      $this->setCache(null);
  }

  public function update() {
      $cache=$this->getCache();
      $this->content=serialize($cache);
  }

  public function open() {
    $cache=unserialize($this->content);
    if ($cache) {
      $this->bean->setMeta("cache",$cache);
    } else {
      $this->bean->setMeta("cache",null);
    }
  }

  public function getCache() {
    return $this->bean->getMeta("cache");
  }

  public function setCache($cache) {
    $this->updated=new \DateTime();
    $this->locked=false;
    $this->bean->setMeta("cache",$cache);
  }

  public function access() {
    $this->acceded=new DateTime();
  }

  public function getLastAccess() {
    return $this->acceded;
  }

  public function clear() {
    $this->setCache(null);
  }

  public function isRecent() {
    if ($this->getCache()==null) return false;

    $t1=new DateTime($this->updated);
    $interval=$t1->diff(new DateTime());
    return $interval->days*24+$interval->h < __CACHE_DURATION;
  }

}
