<?php

namespace Edispatcher\Entity;

class Url extends \RedBeanPHP\SimpleModel {

  public function update() {
    $this->updatedAt = new \DateTime("now");
  }


  public function getApp()
  {
    return $this->app;
  }

  public function getCategory()
  {
    return $this->category;
  }
  
  public function getIcon()
  {
    return $this->icon;
  }

  public function getHoster()
  {
    return $this->hoster;
  }

  public function json() {
    $a=[];
    if ($this->app) {
      $a["app"]   = $this->app->json();
      $a["color"] = $this->app->color;
    }

    if (!$this->category) {
      $a["category"] = $this->app?$this->app->getCategory()->json():null;
    } else {
      $a["category"] = $this->category->json();
    }

    $a["id"]           = $this->id ;
    $a["libelle"]      = ($this->libelle != $this->app->libelle)?$this->app->libelle." ".$this->libelle:$this->libelle ;
    $a["hoster"]       = ($this->hoster)?$this->hoster->libelle:($this->app->getHoster()?$this->app->getHoster()->libelle:"n/a") ;
    $a["editor"]       = ($this->editor)?$this->editor->libelle:($this->app->getEditor()?$this->app->getEditor()->libelle:"n/a") ;
    $a["description"]  = $this->description ;

    return $a;
  }

    public function __toString() {
      return $this->libelle."";
    }

}
