<?php

namespace Edispatcher\plugins\avis;
use \Psr\Http\Message\ServerRequestInterface as Request;
use \Psr\Http\Message\ResponseInterface as Response;
use Slim\Container;
use Edispatcher\Controllers\BaseController;




class Controller extends BaseController
{

    public function __construct(Container $ci)
    {
        $this->ci = $ci;
        $this->AVIS_INSTRUCTIONS = [
            "synthese-de-vos-retours" => [
                "description" => "Laissez nous votre avis",
                "fields" => [
                    "utile" => [
                        "question" => "Avez-vous trouvé cette page utile ?",
                        "type" => "radio",
                        "values"=> [
                            "oui" => "oui, cela a été utile",
                            "non" => "non, pas du tout"
                        ]
                    ],
                    "commentaire" => [
                        "type" => "textarea",
                        "label" => "Laisser un commentaire"
                    ]
                ]
            ]

        ];

    }

    public function loginAction(Request $request, Response $response, $args)
    {
        $redirectTo = "/books/metice-nouveau-bureau-des-applications/page/synthese-de-vos-retours";
        $params = ["redirect" => $redirectTo];

        return $this->ci["view"]->render($response, '@avis/avis-login.html.twig',$params);
    }

    public function avisPostAction(Request $request, Response $response, $args)
    {

        $profil = $this->ci["profil"];
        if (!$profil->isPersAcad()) {
            die("");
        }

        $code = $args["code"];
        if (!isset( $this->AVIS_INSTRUCTIONS[$code])) {
            echo("[$code] !!!");
            die();
        }
        $params = ["code" => $code];

        \R::freeze(false);

        $avis  = \R::findOne( 'avis','user = ? AND intid = ? AND code = ?',[$profil->getUser(),$profil->getIntid(),$code]);
        if ($avis) {
            return $this->ci["view"]->render($response, '@avis/avis-ok.html.twig',$params);
        }

        /**
         * Represents an individual entry in a dataset or collection.
         *
         * This variable can be used to store or process details of a single data entry.
         * It may contain various attributes or properties depending on the context.
         */
        $entry = \R::dispense('avis');
        $now   = new \DateTime("now");
        $entry->createdAt= $now;
        $entry->user     = $profil->getUser();
        $entry->intid    = $profil->getIntid();
        $entry->code     = $code;

        $body = $request->getParsedBody();
        $entry->content = json_encode($body);

        \R::store($entry);
        return $this->ci["view"]->render($response, '@avis/avis-thanks.html.twig',$params);


    }

    public function avisDetailsAction(Request $request, Response $response, $args) {



        $profil = $this->ci["profil"];
        if (!$profil->isPersAcad()) {
            die("");
        }

        $code = $args["code"];
        if (!isset( $this->AVIS_INSTRUCTIONS[$code])) {
            echo("[$code] !!!");
            die();
        }

        $this->requireManager();

        $avis  = \R::findAll( 'avis','code = ?',[$code]);

        $lesAvis = [];
        foreach ($avis as $un_avis)  {
            try  {
                $responses = json_decode($un_avis->content,true);
                $lesAvis[] =  ["avis"=> $un_avis,"responses"=>$responses];
            } catch (\Exception $e) {
                continue;
            }


        }



        $fields = $this->AVIS_INSTRUCTIONS[$code]["fields"];


        $params["lesAvis"] = $lesAvis;
        $params["fields"] = array_keys($fields);
       // print_r($params["fields"]);die();

        return $this->ci["view"]->render($response, '@avis/avis-details.html.twig',$params);

    }

    public function avisAction(Request $request, Response $response, $args)
    {

        $profil = $this->ci["profil"];
        if (!$profil->isPersAcad()) {
            die("");
        }

        $code = $args["code"];
        if (!isset( $this->AVIS_INSTRUCTIONS[$code])) {
            echo("[$code] !!!");
            die();
        }

        $params = ["code" => $code];

        \R::freeze(false);
        $avis  = \R::findOne( 'avis','user = ? AND intid = ? AND code = ?',[$profil->getUser(),$profil->getIntid(),$code]);
        if ($avis) {
            return $this->ci["view"]->render($response, '@avis/avis-ok.html.twig',$params);
        }

        $params["formData"] = $this->AVIS_INSTRUCTIONS[$code];

        return $this->ci["view"]->render($response, '@avis/avis.html.twig',$params);
    }

}

