<?php

namespace Edispatcher\plugins\esettings;
use \Psr\Http\Message\ServerRequestInterface as Request;
use \Psr\Http\Message\ResponseInterface as Response;
use Slim\Container;
use Edispatcher\Controllers\BaseController;

use Edispatcher\Entity\Profil;

require_once dirname(__FILE__).'/utils/Spyc.php';

class Controller extends BaseController  {

    protected $ci;
  
    //Constructor
    public function __construct(Container $ci) {
      $this->ci = $ci;

    }

    // Parse les settings possibles
    private static function getSettings() {

      // Config par defaut
      $filename = ROOT_DIR . '/ng/settings.yaml';

      // Verification si un autre fichier de config est déclaré
      global $__PLUGINS;
      if (isset($__PLUGINS['esettings']) && isset($__PLUGINS['esettings']['config']) )  {
        $filename = $__PLUGINS['esettings']['config'];
      }
      
      // Fichier n'existe pas => pas de settings
      if (!file_exists($filename)) {
        return [];
      }
      
      // On essaie de charger la conf
      try {
        $data = \Spyc::YAMLLoad($filename);
      } catch(\Exception $e) {
        $data = [];
        echo $e;
      }

      return $data;

    }

    // Parse la config et retourne tous les parametres 
    // possibles avec la valeur par défaut
    public static function getDefaultSettings() {
      $settings = self::getSettings();

      $KEYS=[];
      foreach($settings as $key=>$values) {
        foreach($values as $settings){
          foreach($settings as $key=>$category) {
            if (is_array($category)) {
              foreach($category as $setting => $value) {
                $KEYS[$setting] = isset($value["default"])?$value["default"]:false;
              }
            }
          }
        }
      }

      return $KEYS;

    }

    // settings du profil actuellement connecté
    private function getSettingsForProfil($profil) {
      $hubtoken = $profil->getHubToken();

      $settings=[];
      if ($hubtoken->settings) {
        $settings = json_decode($hubtoken->settings,true);
      }

      return $settings;
    }

    // Enregistrement des parametres
    public function postAction(Request $request, Response $response, $args) {
      $data=$request->getParsedBody();


      $settingsForUser=[];

      $settings = $this->getSettings();
      foreach($settings["global"] as $settings){
        foreach($settings as $key=>$category) {
          foreach($category as $setting => $value) {

            if (isset($data[$setting]) && $data[$setting]=="_not_available_") {
              continue;
            }

            // Cas particulier du boolean qui 
            // s'il est a false n'est pas envoyé dans la form
            if ($value["type"]=="boolean") {
              if (!isset($data[$setting])) {
                $settingsForUser[$setting]="off";
              }
            }

            if ($value["type"]=="multiple") {
              if (!isset($data[$setting])) {
                $settingsForUser[$setting]=["-/-"];
              }
            }

            if (isset($data[$setting])) {
              if ($value["type"]=="multiple") {
                $settingsForUser[$setting][]=$data[$setting];
              }
              $settingsForUser[$setting]=$data[$setting];
            }

          
          }
        }
      }

      $profil   = $this->ci["profil"];
      $hubtoken = $profil->getHubToken();
      $hubtoken->settings=json_encode($settingsForUser);
      \R::store($hubtoken);

      return $response->withJson($settingsForUser);
      
    }

    public function indexAction(Request $request, Response $response, $args) {

      $profil = $this->ci["profil"];
      $params["profil"] = $profil;

      // Url pour page changement du mdp
      $mdpUrl = "";
      if ($profil->isPersAcad()) {
        $mdpUrl = "http://aca.re/mdp/changement";
      }elseif($profil->getProfil()=="national_2") {
        $mdpUrl = "";
      }
    
      $params["mdpUrl"] = $mdpUrl;

      // Settings 
      $params["userSettings"] = $this->getSettingsForProfil($profil);
      $params["settings"]     = $this->getSettings();


      return $this->ci["view"]->render($response, '@esettings/index.html.twig',$params);

    }

}
