<?php

namespace Edispatcher\plugins\external;
use \Psr\Http\Message\ServerRequestInterface as Request;
use \Psr\Http\Message\ResponseInterface as Response;
use Slim\Container;
use Edispatcher\Controllers\BaseController;


class Controller extends BaseController {

  private function check() {
      global $__PLUGINS;
      // On verifie que la conf existe
      if (!isset($__PLUGINS['external']))                {die("NOT CONFIGURED");}
      if (!isset($__PLUGINS['external']["branches"]))    {die("branches NON DEFINIE");}

  }

  private function getBranchLdap($dn) {
      global $__PLUGINS;

      foreach ($__PLUGINS['external']["branches"] as $key => $branch) {
          if (preg_match('/'.$key."/", $dn)) {
              return $branch;
          }
      }
      return "default";
  }

  public function apiLogoutAction(Request $request, Response $response, $args) {
    session_destroy();
    \logout();
  }

  //  construction de la liste des applications avec postMessage
  public function buildAppsAction(Request $request, Response $response, $args) {
    $params = [];

    return $this->ci["view"]->render($response, '@external/buildapps.html.twig',$params);
  }

  // reprend le fichier messages.php
  public function apiArenaMessagesAction(Request $request, Response $response, $args) {
    $this->check();
    include_once(INC_DIR.'/dispatcher.config.php');
    include_once(INC_DIR.'/fonctions.php');

    // Uniquemement le personnel avec une auth académique
    if (  IsEleve() || IsParent()   ) {
        header('Content-Type: text/javascript');
        die("/*Profil non autorié*/ console.log('Message Arena: profil non autorisé')");
    }

    // include arena
    include_once(INC_DIR."/../arena/arena_inc.php");

    // Inclusion d'une configuration locale si elle existe
    if (file_exists(INC_DIR."/../arena/ressources.config.local.php")) {include_once(INC_DIR."/../arena/ressources.config.local.php"); }

    // Récupération des messages de Arena
    try {
        $client = WS();
        $result=$client->__call('getMessages',array("dateDuJour" => date('c')));
        $message=objectToArray($result);

        $messageArena=$message["item"]["corpsMessage"];
        $messageArena=nl2br($messageArena);
        $messageArena=preg_replace('/[\x00-\x1F\x7F]/', '', $messageArena);
        $messages[]=array("id"=>time(),"message"=>$messageArena);
    } catch (Exception $e) {
    }

    // Messages applicatifs
    try  {
        $client = WS();
        $result=$client->getMessagesAppli(date('c'));
        $items=objectToArray($result);
        $items=$items["item"];

        // Cas d'un seul item, attention $items["0"] n'existe pas
        if (!isset($items["0"])) {$items=array("0"=>$items);}

        foreach ($items as $f)
        {
            $arr=explode(SEP_SIGAT,$f["domSousdomUrlCT"]);
            $message=$f["corpsMessageAppli"];

            // Pour flaguer le message
            $flag="";
            $lastChar=substr(trim($message), -1);
            $last2Chars=substr(trim($message), -2);
            if ($lastChar=="!") $flag="attention";
            if ($last2Chars=="!!") $flag="important";

            $messages[]=array("id"=>md5($message),"message"=>$message,"url"=>$arr[2],"flag"=>$flag);
        }
    } catch (Exception $e) {

    }

    //Retour de la réponse
    $json=json_encode(array("messages"=>$messages));
    if (isset($_GET["api"])) {
        $id=$_GET["id"];
        $api=$_GET["api"];
        header('Content-Type: text/javascript');
        echo "var data=$json;";
        echo "$api('$id',data);";

        callHandler('ArenaMessageJs');
    } else {
        header('Content-Type: application/json');
        echo $json;
    }

  }

  public function importAction(Request $request, Response $response, $args) {
    $this->check();
    if (!isset($_SESSION["GUID"])) {
      $now=new \DateTime("now");
      $data=openssl_random_pseudo_bytes(16);
      $data[6] = chr(ord($data[6]) & 0x0f | 0x40); // set version to 0100
      $data[8] = chr(ord($data[8]) & 0x3f | 0x80); // set bits 6-7 to 10
      $guid=vsprintf('%s%s-%s-%s-%s-%s%s%s', str_split(bin2hex($data), 4));
      $_SESSION["GUID"]=$guid;
      $_SESSION["GUID_TIME"]=$now;
      $token = \R::dispense('token');
      $token->guid=$guid;
      $token->createdAt=$now;
      $token->attribues=serialize($_SESSION["CASATTRIBUTE"]);
      \R::store($token);
    }

    $profil = $this->ci["profil"];
    $params["portails"]             =   $profil->getPortails();
    $params['ARENA_ZONE_DEFAUT']    =   __ARENA_ZONE_DEFAUT;
    $params['GUID']                 =   $_SESSION["GUID"];
    $params["_EDISPATCHER"]         =   _URL_DISPATCHER;
    return $this->ci["view"]->render($response, '@external/import.js.twig',$params);
  }

  public function apiMeAction(Request $request, Response $response, $args) {

    $this->check();

    $profil = $this->ci["profil"];
    $params['profil'] =  $profil;
    $params['device'] =  [];

    $infos = $args["infos"];
    $user  = $args["user"];

    $auth = \R::findOne("authtoken","hash = ? and hubtoken_id = ?",[$user,$profil->getHubtoken()->getId()]);
    if ($auth) {
      $device = json_decode(base64_decode($infos),true);
      foreach ($device as $key => $value) {
        $auth->{"device_".$key} = $value;
      }
      $params['device'] = $device;
      $auth->modifiedAt = new \DateTime("now");
      \R::store($auth);

    }

    return $this->ci["view"]->render($response, '@external/me.html.twig',$params);
  }

  public function profilAction(Request $request, Response $response, $args) {

    $this->check();

    $profil = $this->ci["profil"];
    

  }


  public function authAction(Request $request, Response $response, $args) {

    $this->check();

    $profil = $this->ci["profil"];
    $params['profil'] =   $profil;

    $queryParams= $request->getQueryParams();
    $data = $queryParams["data"];
    $data=json_decode(base64_decode($data),true);
    $params["device"]  = $data;

    return $this->ci["view"]->render($response, '@external/auth.html.twig',$params);
  }

  public function authPostAction(Request $request, Response $response, $args) {

    $this->check();

    $profil = $this->ci["profil"];
    $params['profil'] =   $profil;


    $data = openssl_random_pseudo_bytes(16);
    $uuid = vsprintf('%s%s-%s-%s-%s-%s%s%s', str_split(bin2hex($data), 4));

    $data = openssl_random_pseudo_bytes(16);
    $uuid2 = vsprintf('%s_%s.%s;%s%sx%s%s%s', str_split(bin2hex($data), 4));

    $post = $request->getParsedBody();

    $authToken= \R::dispense("authtoken");
    $authToken->hubtoken = $profil->getHubtoken();
    $authToken->auth     = ($post["pin"]?"PIN":($post["secret"]?"SECRET":"NONE") );
    $authToken->dn       = $profil->getAttribute("dn");
    $authToken->profil   = $profil->getProfil();
    $authToken->uuid     = $uuid.$uuid2;
    $authToken->uid      = $profil->getUser();
    $authToken->mail     = $profil->getMail();
    $authToken->hash     = md5($profil->getHubtoken()->getUser().time());
    $authToken->branch   = $this->getBranchLdap($profil->getAttribute("dn"));
    \R::store($authToken);

    $params['uuid'] =   $authToken->uuid;
    $params['hash'] =   $authToken->hash;
    $params['auth'] =   $post;

    return $this->ci["view"]->render($response, '@external/pass.html.twig',$params);
  }

}
