<?php

namespace Edispatcher\plugins\feedback;
use \Psr\Http\Message\ServerRequestInterface as Request;
use \Psr\Http\Message\ResponseInterface as Response;
use Slim\Container;
use Edispatcher\Controllers\BaseController;


class Controller extends BaseController {


  public function meticeAction(Request $request, Response $response, $args) {
    return $this->ci["view"]->render($response, '@feedback/metice.twig.html');
  }

  public function listAction(Request $request, Response $response, $args) {

     $params=$request->getQueryParams();

     $profil = $this->ci["profil"];
     $filtre = "profil != 'national_1'";

     $params['feedbacks']          = \R::find("feedback",$filtre);
     $t1=0;$t2=0;
     foreach ($params['feedbacks']  as $feedback) {
       $t1+=$feedback->mire;
       $t2+=$feedback->app;
       $feedback->user=$feedback->hubtoken->user;
       $feedback->tmpl=$feedback->hubtoken->hub_tmpl;
     }

     $params["mire"] = ceil(($t1/count($params['feedbacks']))*10);
     $params["app"] = ceil(($t2/count($params['feedbacks'])*10));

     return $this->ci["view"]->render($response, '@feedback/list.twig.html',$params);
  }


 public function pageAction(Request $request, Response $response, $args) {

    $this->requireManager();
    
    $params=$request->getQueryParams();

    $profil = $this->ci["profil"];

    $params['groupes']          = $profil->getGroupes();

    return $this->ci["view"]->render($response, '@feedback/view.twig.html',$params);
 }

 public function checkAction(Request $request, Response $response, $args) {
     $ret=["success"=>false];
     $profil = $this->ci["profil"];
     $token = $profil->getHubToken();
     if (!$token) {
         return  $response->withJson($ret);
     }

     $ret["success"] = false;

     $feedback = \R::findOne("feedback","hubtoken_id = ?",[$token->id]) ;
     if ($feedback) {
         $ret["id"]         = $feedback->id;
         $ret["response"]   = $feedback->response;
     }

     return $response->withJson($ret);
 }

 public function postAction(Request $request, Response $response, $args) {

    $data=$request->getParsedBody();

    $profil = $this->ci["profil"];
    $token = $profil->getHubToken();
    if (!$token) {
        return $this->ci["view"]->render($response, '@feedback/ok.twig.html',[]);
    }

    if (trim( $data["comment"])=="" ||
        $data["mire"] == "-1" ||
        $data["app"] == "-1"
    )  {
        return $this->ci["view"]->render($response, '@feedback/ko.twig.html',[]);
    }

    $comment = str_replace("|", "",$data["comment"]);

    $feedback = \R::findOne("feedback","hubtoken_id = ?",[$token->id]) ;
    if (!$feedback) {
        $feedback = \R::dispense("feedback");
        $feedback->hubtoken = $token;
        $feedback->comment  = str_replace("|", "",$data["comment"]);
        $feedback->profil   = $profil->getProfil();
        $feedback->createdAt     = new \DateTime("now");
    } else
    {
        $feedback->comment  = $feedback->comment."<br> => mire:  ".$feedback->mire." app:".$feedback->app.
                              "<br>=========================<br>".
                              $comment;

        $feedback->modifiedAt     = new \DateTime("now");
    }

    $feedback->mire     = intval($data["mire"]);
    $feedback->app      = intval($data["app"]);
    $feedback->loadtime = $data["time"];
    $feedback->browser  = $data["browser"];
    $feedback->response = "";

    $redis = $this->ci["metrics"]->getRedis();
    if ($redis) {
        $redis->rpush("feedback",$comment."|".$feedback->mire."|".$feedback->app."|".$feedback->profil."|".$data["time"]."|".$data["browser"]);
    }

    \R::store($feedback);

    return $this->ci["view"]->render($response, '@feedback/ok.twig.html',[]);
}

}
