function EStorage() {
    this.id=_USERID +  ((typeof __TEMPLATE != "undefined") ?  __TEMPLATE : "")
    edispatcher_loadScript(_EDISPATCHER_GET_CACHE_URL)
}

EStorage.SECONDS    = 1000;
EStorage.MINUTES    = EStorage.SECONDS*60;
EStorage.HOURS      = EStorage.MINUTES*60;
EStorage.DAYS       = EStorage.HOURS*24;

EStorage.timestampNotify = null;

EStorage.prototype.set=function(key,data,withRemote) {

    var json={timestamp:(new Date()).getTime(),data:data}
    var item=JSON.stringify(json);
    try {
        localStorage.setItem(this.id+key,item);
    } catch (e) {
        // Sous FF il peut y avoir le message NS_ERROR_DOM_QUOTA_REACHED: Persitent storage maximum size reached
        console.error("Impossible de mettre dans le cache local");
        console.error(e);
    }


    if (!withRemote) return
    if (typeof _EDISPATCHER_SET_CACHE_URL == "undefined") return;

    $.ajax({ url:_EDISPATCHER_SET_CACHE_URL.replace("KEY",key),
             method: "POST",
             type: "json",
             timeout: 2000, // Max 2s
             data: {value: item, key:key, version: _VERSION }
           })

}

EStorage.prototype.get=function(key,maxAge,triggerEvent) {

    maxAge = maxAge || ( _CACHE_DEFAULT_DELAY_IN_DAYS || 5)*EStorage.DAYS
    if (triggerEvent==undefined) triggerEvent = true

    var bRemoteUsed = false

    var item=null;

    try {
        item = localStorage.getItem(this.id+key);
    } catch (e) {
        console.log("Impossible d'accéder au cache local")
    }
    // Pas de cache local et le fag isWithoutRemote n'est pas posititioné
    // => on regarde si le cache remote peut nous aider
    if (!item && key!='withoutRemote' && !this.isWithoutRemote()) {
      try {
        bRemoteUsed = true
        item = atob(_REMOTE_CACHE[key]);
      } catch (e) {
        return null;
      }
    }

    if (!item) {
      return null;
    }

    var now=(new Date()).getTime();
    var json;
    try {
      json = JSON.parse(item)
    } catch (err) {
      return null;
    }

    // Old cache ?
    if (json.timestamp+maxAge <= now ) {
        this.remove(key);
        return null;
    }

    // Notify que le cache est utilisé
    if (triggerEvent) {
        if (!EStorage.timestampNotify) {
          EStorage.timestampNotify=setTimeout(function() {
            $("edispatcher-toolbar").trigger("edispatcher_cache_used",{age: now - json.timestamp  });
            EStorage.timestampNotify = null;
          },5000);
        }
    }

    if (bRemoteUsed) console.log("[CACHE REMOTE] remote cache used for "+ key)

    return json.data

}

EStorage.prototype.isReload = function() {
    return this.get("reload",1*EStorage.MINUTES,false)=="yes"
}

EStorage.prototype.isForceReload = function() {
    return this.get("reload",1*EStorage.MINUTES,false)=="force"
}

EStorage.prototype.isWithoutRemote = function() {
    return this.get("withoutRemote",1*EStorage.MINUTES,false)=="yes"
}

EStorage.prototype.remove = function(key) {
    try {
        localStorage.removeItem(this.id+key);
    } catch (e) {
        console.log("Erreur dans la suppression du cache "+(this.id+key))
        console.error(e)
    }

    if (_EDISPATCHER_SET_CACHE_URL && (_REMOTE_CACHE[key] || Object.keys(__ZONES).join(",") ==  key) /* cache zones Arena */) {
        _REMOTE_CACHE[key] = null;
        $.ajax({ url:_EDISPATCHER_SET_CACHE_URL.replace("KEY",key),
                 method: "DELETE",
                 timeout: 2000, // Max 2s
               })
    }


}

EStorage.prototype.setConfig = function(key,value,template=__TEMPLATE) {

  $.ajax({ url:_EDISPATCHER_SET_CONFIG_URL,
           method: "POST",
           type: "json",
           timeout: 2000, // Max 2s
           data: {tmpl: template , key: key, value: JSON.stringify(value)},
           headers: { "guid": _EDISPATCHER_GUID }
         })
}

EStorage.prototype.getConfig = function(key,value,template=__TEMPLATE) {
  var conf = _CONFIG[template];
  if (! conf) return null;
  if (! conf[key]) return null;
  return conf[key];
}

EStorage.prototype.getConfigGlobal = function(key,value) {
    return this.getConfig(key,value,"GOLBAL");
}

EStorage.prototype.setConfigGlobal = function(key,value) {
    return this.setConfig(key,value,"GOLBAL");
}

EStorage.prototype.empty = function(shiftKey,withoutRemote) {
    
        var self=this
        $.each(localStorage, function(key, value){
            try {
                if (key.indexOf(self.id)==0) {
                    self.remove(key.replace(self.id,""));
                }
            } catch (e) {}
        })
    

    _REMOTE_CACHE = {}

    self.set("reload",shiftKey?"force":"yes")
    self.set("withoutRemote",withoutRemote?"yes":"no")

    console.log("Reload demandé reload="+self.get("reload")+" withoutRemote="+self.get("withoutRemote"));

}

EStorage.prototype.cancelForceReload = function() {
    this.remove("reload")
}

EStorage.prototype.clear = function(shiftKey) {
    var self=this
    $.each(localStorage, function(key, value){
        if (key.indexOf(self.id)==0) {
            localStorage.removeItem(key);
        }
    })

    self.set("reload",shiftKey?"force":"yes")

}
