// Extraction d'un noeud dans un flux xml
function xmlText(node,item) {return $(node).find(item).text()}
function xmlHtml(node,item) {return $(node).find(item).html()}

const baseUrl = window.location.protocol + '//' + window.location.host + window.location.pathname

xdesktop={

categories_mapping: {
    "Outils" : "Ressources et outils",
    "Applications" : "Ressources et outils",
    "Administration financière et comptable" : "Structure et personnels",
    "Examens et concours" : "Élèves",
    "Gestion des personnels" : "Structure et personnels",
    "Enqutes et Pilotage" : "Enquêtes et signalements",
    "Enquêtes et Pilotage" : "Enquêtes et signalements",
    "Formation et Ressources" : "Espace personnel",
    "Médicales et Secours"  : "Élèves",
    "Apps": "Apps education.fr",
    "Espace Mutualisé des personnels Académiques": "Espace Mutualisé Académique",
    "DRAJES - Jeunesse, Engagement et Sports" : "DRAJES - Jeunesse, Engagement et Sports",
},

categories_icones: {
    "Élèves" : baseUrl+"/../public/images/categorie-eleves.svg",
    "Espace personnel" : baseUrl+"/../public/images/categorie-personnel.svg",
    "Ressources et outils" : baseUrl+"/../public/images/categorie-search.svg",
    "Structure et personnels" : baseUrl+"/../public/images/categorie-city-hall.svg",
    "Enquêtes et signalements" : baseUrl+"/../public/images/categorie-community.svg",
    "Au quotidien" : baseUrl+"/../public/images/categorie-quotidien2.png",
    "Mes Ressources" : baseUrl+"/../public/images/categorie-custom.png",
    "Espace Mutualisé des personnels Académiques": baseUrl+"/../public/images/categorie-academie.png",
    "Espace Mutualisé Académique": baseUrl+"/../public/images/categorie-academie.png",
    "Support et Assistance" : baseUrl+"/../public/images/categorie-support.png",
    "Autres" : baseUrl+"/../public/images/categorie-autres.png",
    "Favoris" : baseUrl+"/../public/images/categorie-favoris2.png",
    "DRAJES - Jeunesse, Engagement et Sports" : baseUrl+"/../public/images/categorie-drajes.png",
    "Apps education.fr": baseUrl+"/../public/images/categorie-apps5.png",
},

categories_indices: {
        "Au quotidien" : 1,
        "Espace personnel" : 100,
        "Élèves" : 101,
        "Enquêtes et signalements" : 102,
        "Ressources et outils" : 103,
        "Structure et personnels" : 104,
        "Espace Mutualisé des personnels Académiques": 200,
        "Espace Mutualisé Académique": 200,
        "Qualification Magmatic 2": 201,
        "Autres" : 1001,
        "DRAJES - Jeunesse, Engagement et Sports" : 101,
        "Apps education.fr" : 1000,
},

createApp: function(attributs) {

    // Si pas de libelle ou pas de nom on ne va pas créer d'application
    attributs.libelle = attributs.libelle || attributs.nom

    if ( !attributs.libelle || !attributs.icon) return null;


   // Si url commence par / on préfix par l'url de l'établissement
   var urlBase=attributs.url
   if (attributs.url.indexOf("/")==0 && !attributs.source && attributs.etab ) {
       attributs.url="https://"+attributs.etab.url+attributs.url
   }

    // Si url commence par / on préfix par l'url de la source si elle existe
   if (attributs.url && attributs.url.indexOf("/")==0 && attributs.source && attributs.source.baseurl != undefined) {
        urlBase=attributs.url;
        attributs.url=attributs.source.baseurl+attributs.url;
   }

   if (!attributs.categorie) {
       attributs.categorie = ""
   }
   if (__TEMPLATE.indexOf("x25") !== -1) {
       attributs.categorie = xdesktop.categories_mapping[attributs.categorie] || attributs.categorie
       if ( !xdesktop.categories_icones[attributs.categorie]) {
           attributs.categorie = "Autres"
       }
   }

   attributs.categorie=attributs.categorie.normalize()

   if (!attributs.piwik_marker) {attributs.piwik_marker = "SANSCATEGORIE/"+attributs.libelle}

   app= new App({libelle:attributs.libelle,
           libellecours:attributs.libellecours || attributs.libelle,
           icon:attributs.icon,
           etab: attributs.etab,
           url:attributs.url,
           urlBase:urlBase,
           favurl:attributs.favurl || attributs.url,
           resarena:attributs.resarena,
           listesDesUrl:[],
           source:attributs.source,
           nom:attributs.nom,
           server:attributs.server,
           infos:attributs.infos,
           piwik_marker: attributs.piwik_marker,
           infosChecked:[],
           favoris:false,
           ssdomaine: attributs.ssdomaine,

           visible: true,
           hasBadge: false,
           external:attributs.external || false,
           categorie:attributs.categorie})
   return app;
},


extractAppFromXml: function(xml) {

    // Récupération des infos
    infos={url:xmlText(xml,'infos_url'),
           type:xmlText(xml,'infos_type'),
           message:xmlHtml(xml,'infos_message')}

     // Les balises & sont transformés en &amp; , on fait donc l'inverse
     if (infos.message!=undefined) infos.message=infos.message.replace( /\&amp;/g, '&' );
     if (infos.url!=undefined) infos.url=infos.url.replace( /\&amp;/g, '&' );

     categorie=xmlText(xml,'categoriename');
     nom=xmlText(xml,'nom')
     libelle=xmlText(xml,'libelle')
     piwik_marker=xmlText(xml,'piwik_marker')
     url=xmlText(xml,'url')
     favurl=xmlText(xml,'favurl') || url // Url pour stocker dans favoris
     resarena=xmlText(xml,'resarena')
     libellecours=xmlText(xml,'libellecours') || libelle;

    ssdomaine = xmlText(xml,'ssdomaine') || '';



     if (url == 'nonAccessible' ) {
         return null;
     }

     nom=nom || libelle
     if (nom==undefined) nom="Aucun nom";

     // Determine la categorie a partir du nom (cf ancienne nomenclature)
     if ((categorie==undefined || categorie=="") && nom.indexOf("/")!=-1) {
                categorie=nom.split("/")[0];
                libelle=nom.split("/")[1];
                if (libelle=="") libelle=categorie
     }

     if (libelle.indexOf(" - ") !== -1 ) {
        let parts = libelle.split(" - ")
        if (parts.length>1) {
            let urlLibelle= parts[1].trim()
            if (urlLibelle=="Accès") {
                urlLibelle = ""
            }
            libelle=`<span class="app-libelle">${parts[0]}</span>  <span class="url-libelle">${urlLibelle}</span> `;
        }
     }

     return  {
                 libelle:libelle,
                 libellecours:libellecours,
                 icon:xmlText(xml,'icon'),
                 server:xmlText(xml,'server'),
                 baseurl:xmlText(xml,'baseurl'),
                 url:url,
                 hidden:xmlText(xml,'hidden'),
                 external:xmlText(xml,'external')=="true",
                 nom:nom,
                 ssdomaine:ssdomaine,
                 piwik_marker:piwik_marker,
                 favurl:favurl,resarena:resarena,
                 infos:infos,
                 infosChecked:[],
                 favoris:false,
                 categorie: (-1 !== __TEMPLATE.indexOf("x25")) ? categorie : categorie.normalize()}
     }


}
