<?php
# Chargement de la partie CAS + lib
include_once("include/inc.php");
if (isset($_SESSION["bad"])){BAD_SESSION();}

require 'vendor/autoload.php';

include_once("arena/arena_inc.php");

// =========================================================================================================
// Toutes ces variables sont surchargeables dans arena/ressources.config.local.php (a créer si inexistant)

$__ICONE=_URL_SESHAT."/edispatcher/images/EN.png";      // Icone des services académiques
$__URL_DE_FEDERATION_ARENA="";                          // Url de fédération pour l'accès au portail Arena
$__APP_ICONE_DEFAULT="default-icon.png" ;               // Icone par défaut des appli Arena
$__APP_ICONE_URL=_URL_SESHAT."/edispatcher/icones/";    // Url pour les icones
$__APP_ICONE_FOLDER="icones/";                          // dossier correspondant a l'url (relative au dossier courant)
$__NOM="Ressources ENT-Réunion";
$__DEFAULt_CATEGORIE="Autres applications";             // Nom de la catégorie par défaut,
                                                        // mettre a "" si vous souhaitez utilisez les catégories Scibe aussi

$__MAX_RNE=2;                                           // Nombre max de RNE a renvoyer
$__USE_CACHE=__USE_CACHE;                               // Si true utilise un systeme de cache pour les données provenant du WSArena

// Liste des handles disponibles
/*
    handle_beforeStart  : Avant le début des opérations
    handle_afterStop    : Après la fin des opérations

    handle_beforeArenaWs : Avant l'utilisation du WebService Itentite
    handle_afterArenaWs  : Après l'utilisation du WebService Itentite

    handle_NoArena       : Appelé dans le cas d'une non utilisation du WebService Identité (Parents, Eleves...)

    getSource(rne)       : Permet de redéfinir les informations pour un rne

*/
// =========================================================================================================

$ws=__ARENA_WSIDENTITE;           // __ARENA_WSIDENTITE  : est défini dans dispatcher.config.php correspond a l'url du webservice Arena
$zones=__ARENA_ZONE_DEFAUT;       // __ARENA_ZONE_DEFAUT : Zone Arena par défaut

// On va chercher la zone Arena la plus appropriée =======
$zones_ip=getZones();
$zones=$zones_ip["zones"];
$ip=$zones_ip["ip"];
// =============================================================

// Récupération des zones passées en paramètres
if (isset($_GET["zones"]) && $_GET["zones"]) {
    $zones=$_GET["zones"];
    $_SESSION["ZONES"]=$zones;
}

$categories=array();
$reorgs=array();
$LISTE_ICONES_ARENA=array();
$APPS_SUPLEMENTAIRES=array();   // Pour les applis supplémentaires : dans arena/apps.local.php

# =====================================================

// Inclusion d'une configuration locale si elle existe
if (file_exists("arena/ressources.config.local.php")) {include_once("arena/ressources.config.local.php"); }



// AJOUT NICE : RECUPERATION DES CATEGORIES DEFINIES DANS LE APP MANAGER JUSTE APRES L'INCLUSION DE ressources.config.local

$categories_ng = R::findAll('category');
foreach ($categories_ng as $cat) {
    $categories[] = new Categorie($cat->libelle, $cat->color, $cat->indice, $cat->fa,$cat->icon_id);
}

$withGenXml = false;
if (file_exists("include/genxml2.csv") ) {
    $withGenXml = true;
    include_once("arena/genxml.config.php");
    getGenXmlFromCsv();
    $categories = updateCategories();
}

// Récupération des applis Arena depuis arena/arena_apps.csv
getArenaApps();

// Inclusion d'une liste d'applications locales
if (file_exists("arena/apps.local.php"))              {include_once("arena/apps.local.php"); }

//Si la fonction handle_beforeStart existe on va l'utiliser
callHandler('beforeStart');

// Gestion des infos du profil ==============
$infos=$_SESSION["CASATTRIBUTE"];
$arr=array();
$arr["profil"]=$infos["profils"][0];
$arr["rne"]=_RNE_PORTAIL_ACA;
$user_infos=json_encode($arr);
// ==========================================


// Si c'est une authentification académique
// on va récupérer les ressources sur Arena
if ( IsAuthAcad() )
{
    $__NOM="Services Académiques";

    $metrics = \Edispatcher\Entity\Metrics::instance();

    callHandler('beforeArenaWs');

    $arrDesZones=explode(",",$zones);
    usort($arrDesZones, "orderZones");

    $arrDesItemsArena=array();
    $uid=GetUid();
    $client = WS();
    $time_start = microtime(true);
    foreach($arrDesZones as $zone) {

        // La zone doit être déclarée dans la configuration
        if (!isset($__ARENA_ZONES[$zone])) continue;
        // Doit avoir un portail
        if (!$__ARENA_ZONES[$zone]["portail"]) continue;

        $time_start_load = microtime(true);
        
        
    //!!!!!!!!!!!!NOUVELLE GESTION CACHE NICE  !!!!!!!!!!!!!!!!!!!!!!!

        $cache = null;
        if ($__USE_CACHE) {
            $cache  = R::findOne( 'arenacache', ' uid = ? and zone  = ? ', array($uid,$zone));
            //Si un cache est trouve dans la base pour ce user et cette zone,
            //on vérifie s'il est récent ou si un reload n'est pas demandé
            if ($cache && ((isset($_GET["reload"]) &&  ($_GET["reload"]=="true" )) || (!($cache->isRecent())))) {
                //si un cache est trouvé mais qu'il est ancien ou qu'un reolad a été demandé, on le supprime
                        $cache->clear();
                        \R::trash($cache);
                        $cache = null;
            }
            if ($cache) { //si après ces vérifications, un cache existe encore, on l'utilise
                $time = microtime(true) - $time_start_load;
                echo "/* $zone: utilisation du cache ". $cache->updated. " in $time seconds */\n";
                // Oui on va l'utiliser
                $items = $cache->getCache();
                $cache->access();
                $sQuery = "UPDATE arenacache SET acceded='".$cache->acceded."' WHERE id=".$cache->getId();
                R::exec( $sQuery );

                // Log le temps de chargement depuis le cache
                $metrics->arenaFromCache($zone,$time);

                $arrDesItemsArena[]=$items;
            }
            else { // si au final il n'y a pas de cache (soit pas au début, soit détruit apres les verifs), on en crée un

                $cache = R::dispense('arenacache');
                $cache->uid=$uid;
                $cache->zone=$zone;
                // On le sauvegarde de suite,
                // car si mode cluster il peut ne pas y avoir d'unicité, vue le temps pris par le chargement des WS
                try {
                    R::store( $cache );
                } catch (\Exception $e) {

                }
                $time_start_load = microtime(true);
                
                // récupérartion des items Arena via le web service
                $result=$client->getRessourcesPortail($uid,$zone);
                $items=objectToArray($result);

                $time = microtime(true) - $time_start_load;
                $cache->timetoload = $time;
                echo "/* $zone: getFromArenaWebService in $time seconds */\n";

    //            $metrics->arenaFromWebService($zone,$time);

                // Création du cache, uniquement si des données sont remontées
                if ($cache && is_array($items) && count($items)!=0) {

                  $time = microtime(true);

                  $cache->setCache($items);
                  $cache->access();
                  try {
                      R::store( $cache );
                  } catch (\Exception $e) {

                  }

                  $metrics->arenaToCache($zone,microtime(true) - $time);
                } // FIN du if ($cache && is_array($items) && count($items)!=0)

            } //FIN du else (pas de $cache)

        } // FIN if (__USE_CACHE)

        else { // on ne veut pas de cache, cas très rare vu la lenteur du WS
                //$uid="vgasser";
                $result=$client->getRessourcesPortail($uid,$zone);
                $items=objectToArray($result);
        }

        $arrDesItemsArena[]=$items;
    } // FIN DU foreach sur les zones

    //!!!!!!!!!!!! FIN NOUVELLE GESTION CACHE NICE !!!!!!!!!!!!!!!!!!!!!!!


    $time_end = microtime(true);
    $time = $time_end - $time_start;
    echo "/* $time seconds arena loading */\n";

    $favoris = null;
    try {
        $favoris  = \R::findOne( 'arenafavoris','user = ? ',[$uid]);
    } catch (\Exception $e) {
        $favoris = null ;
    }

    // Récupération des favoris de Arena =======================
    $favCT=array();
    $favURLCT=array();

    // Pas de favoris encore en base ?
    if (!$favoris) {
        $ressources = [];
        try  {
            $time_start = microtime(true);
            $client = WS();
            $result=$client->getFavoris($uid);
            $items=objectToArray($result);

            if (isset($items["item"])) {
                // fixes #22343 : Pb favoris ARENA lorsqu'il n'en reste plus qu'un
                if (isset($items["item"]["urlCT"])) {
                    $ress=arenaRessource($items["item"]["urlCT"]);
                    debug("FAVORIS : $uid ".$ress);
                    $ressources[]=  $ress ;

                    if ($withGenXml) {
                        $parts=explode(SEP_SIGAT,$ress);
                        $url=$parts[2];
                        debug($url);
                        $domaine = renameDomaineFromUrl($url,$parts[0]);
                        $data = getDataFromGenXML2($url);
                        $ssdomaine = $parts[1];
                        if ($data) {
                            $ssdomaine = $data["Sous-domaine"];
                        }
                        $ress = $domaine . SEP_SIGAT . $ssdomaine . SEP_SIGAT . $url;
                        $favURLCT[$url] = true;
                    }
                    $favCT[$ress]=true;
                } else {
                    foreach ($items["item"] as $f)
                    {

                        // ref #20196 :  Gérer les favoris 'identiques' de plusieurs zones avec des urlCT différentes
                        $ress=arenaRessource($f["urlCT"]);
                        $ressources[]=  $ress ;
                        if ($withGenXml) {
                            $parts=explode(SEP_SIGAT,$ress);
                            $url=$parts[2];
                            debug($url);
                            $domaine = renameDomaineFromUrl($url,$parts[0]);
                            $data = getDataFromGenXML2($url);
                            $ssdomaine = $parts[1];
                            if ($data) {
                                $ssdomaine = $data["Sous-domaine"];
                            }
                            $ress = $domaine . SEP_SIGAT . $ssdomaine . SEP_SIGAT . $url;
                            $favURLCT[$url] = true;
                        }
                        $favCT[$ress]=true;
                    }
                }
            }

            $now = new \DateTime("now");
            $favoris = \R::dispense('arenafavoris');
            $favoris->createdAt = $now;
            $favoris->user = $uid;
            $favoris->ressources = json_encode($ressources);
            $favoris->updatedAt = $now;
            \R::store($favoris);

            $time_end = microtime(true);
            $time = $time_end - $time_start;
            echo "/* $time seconds favoris loading */\n";
        } catch (Exception $e) {

        }
    } else {

        $time_start = microtime(true);
        $ressources  = json_decode($favoris->ressources,true);
        foreach ($ressources as $urlCT) {
            $ress=arenaRessource($urlCT);
            $parts=explode(SEP_SIGAT,$ress);
            $url=$parts[2];
            $domaine = renameDomaineFromUrl($url,$parts[0]);
            $data = getDataFromGenXML2($url);
            $ssdomaine = $parts[1];
            if ($data) {
                $ssdomaine = $data["Sous-domaine"];
            }
            $ress = $domaine . SEP_SIGAT . $ssdomaine . SEP_SIGAT . $url;
            $favURLCT[$url] = true;
            $favCT[$ress]=true;
        }
        $time_end = microtime(true);
        $time = $time_end - $time_start;
        echo "/* $time seconds favoris loading from database */\n";

    }

    // ===========================================================

    callHandler('afterArenaWs');
} else
{
    $arrDesItemsArena=Array();
    $__URL_DE_FEDERATION_ARENA="";
    callHandler('NoArena');
}

$ret_str="<main>";

// Définition de la source de données
$ret_str=$ret_str."<description>";
$ret_str=$ret_str."<nom>". $__NOM ."</nom>";
$ret_str=$ret_str."<icon>". $__ICONE ."</icon>";
$ret_str=$ret_str."<zones>". $zones ."</zones>";
$ret_str=$ret_str."<type>COMMUNE</type>";
$ret_str=$ret_str."<ip>". $ip ."</ip>";
$ret_str=$ret_str."<ipclient>". (isset($_SESSION["IP_CLIENT"])?$_SESSION["IP_CLIENT"]:"") ."</ipclient>";
$ret_str=$ret_str."<services_url>".urlencode(_URL_SESHAT."/edispatcher/mxServices.php")."</services_url>";
if ($__DEFAULt_CATEGORIE !=  "")
{
    $ret_str=$ret_str."<defaultCategorie>". $__DEFAULt_CATEGORIE ."</defaultCategorie>";
}
$ret_str=$ret_str."<federationBefore>". $__URL_DE_FEDERATION_ARENA ."</federationBefore>";
$ret_str=$ret_str."</description>";

if (file_exists("utils/zones.ini")) {
    $les_zones=parse_ini_file("utils/zones.ini",true,INI_SCANNER_RAW);
    if ($les_zones) {
        $ret_str=$ret_str."<servers>";
        foreach ($les_zones as $zone => $une_zone) {
            $ret_str=$ret_str."<server>";
            $ret_str=$ret_str."<id>". $zone ."</id>";
            $ret_str=$ret_str."<nom>". $une_zone["nom"] ."</nom>";
            $ret_str=$ret_str."<icone>". $une_zone["icone"] ."</icone>";
            $ret_str=$ret_str."</server>";
        }
        $ret_str=$ret_str."</servers>";
    }
}

// ref: #9350 : Les messages arena sont envoyé par la page messages.php
//$ret_str=$ret_str."<message>".nl2br($messageArena)."</message>";

// Ajout des url externe (Portail Envole) ==================================
$ret_str=$ret_str."<sources>";
$arr=GetRne();


//if (isDebug()) { print_r($arr);die();}

// Vérification du nombre de RNE a renvoyer
// car sinon une personne disposant de 10 rne (CoPsy par exemple)
// se verrait proposer 10 sources
if (count($arr)>$__MAX_RNE)
{
    if (isset($_GET["rne"])) $arr=array($_GET["rne"]);
    else $arr=array();
}

# fixes: #7890 : Ajout d'un handle handle_beforeOthers
callHandler('beforeOthers');
foreach ( $arr as $rne)
{
    $rne=strtoupper($rne);
    $portail=GetPortailFromRne($rne);


    $federationBefore="";
    $nom=GetLibelleEtabFromRne($rne);
    $desktopitem_url="/xdesktop/controllers/desktopitem.php";
    $services_url="/xdesktop/controllers/mxServices.php";

    // Couleur aléatoire
    if (isset($ETABS[$rne]["couleur"])) {
        $couleur=$ETABS[$rne]["couleur"];
    } else
    {
        $couleur=sprintf( "%06X", mt_rand( 0x8888AA , 0xAAAAAA ));
    }

    // Si la fonction getSource existe on va l'executer pour
    // avoir des informations sur la source (rne)
    if (function_exists('getSource'))
    {
        $arr=getSource($rne);
        if ($arr) {
            if (isset($arr["portail"]))          $portail=$arr["portail"];
            if (isset($arr["federationBefore"])) $federationBefore=$arr["federationBefore"];
	          if (isset($arr["rne"]))              $rne=$arr["rne"]; // ref: #11306, pouvoir changer le rne de la source
            if (isset($arr["nom"]))              $nom=$arr["nom"];
            if (isset($arr["couleur"]))          $couleur=$arr["couleur"];
            if (isset($arr["desktopitem_url"]))  $desktopitem_url=$arr["desktopitem_url"];
            if (isset($arr["services_url"]))     $services_url=$arr["services_url"];
        }
    }

    if ($portail=="") continue;

    // Construction de la source
    $service=_URL_SESHAT.":"._SERVEUR_SSO_PORT."/saml?sp_ident=".$rne."&RelayState=https://".$portail;
    $url=$service.$desktopitem_url;
    $ret_str=$ret_str."<others>";
    $ret_str=$ret_str."<uaj>".$rne."</uaj>";
    $ret_str=$ret_str."<nom>".$nom."</nom>";
    $ret_str=$ret_str."<url>"."https://".$portail."</url>";
    $ret_str=$ret_str."<services_url>".urlencode("https://".$portail.$services_url)."</services_url>";
    $ret_str=$ret_str."<couleur>#".$couleur."</couleur>";
    $ret_str=$ret_str."<ressource>".urlencode($url)."</ressource>";
    $ret_str=$ret_str."<federationBefore>".urlencode($federationBefore)."</federationBefore>";
    if (isset($_GET["js"])) {
        $ret_str=$ret_str."<federer>".urlencode($service."/xdesktop/api/session")."</federer>";
        $ret_str=$ret_str."<data>".urlencode("https://".$portail."/xdesktop/controllers/desktopitem.php")."</data>";
	      $ret_str=$ret_str."<baseurl>https://$portail</baseurl>";
    }
    $ret_str=$ret_str."</others>";
}

if (_XDESKTOP) {
  $portail            = _HOST;
  $services_url       = "https://".$portail."/xdesktop/controllers/mxServices.php";
  $desktopitem_url    = "/xdesktop/controllers/desktopitem.php";
  $url                = "https://".$portail.$desktopitem_url;

  $ret_str=$ret_str."<others>";
  $ret_str=$ret_str."<nom>"._XDESKTOP_LIBELLE."</nom>";
  $ret_str=$ret_str."<type>COMMUNE</type>";
  $ret_str=$ret_str."<url>"."https://"._HOST."</url>";
  $ret_str=$ret_str."<services_url>".urlencode("https://".$portail.$services_url)."</services_url>";
  $ret_str=$ret_str."<couleur>#".$couleur."</couleur>";
  $ret_str=$ret_str."<ressource>".urlencode($url)."</ressource>";
  if (isset($_GET["js"])) {
      $ret_str=$ret_str."<data>".urlencode("https://".$portail."/xdesktop/controllers/desktopitem.php")."</data>";
      $ret_str=$ret_str."<baseurl>https://$portail</baseurl>";
  }
  $ret_str=$ret_str."</others>";

}

$ret_str=$ret_str."</sources>";
//=================================================================================

// Construction des catégories ====================================================
$path = explode("/",$_SERVER['REQUEST_URI']);array_pop($path);
$path=implode("/",$path);
$ret_str=$ret_str."<categories>";
foreach ($categories as $categorie) {
    $ret_str=$ret_str."<categorie>";
    $ret_str=$ret_str."<nom>".$categorie->nom."</nom>";
    $ret_str=$ret_str."<couleur>".$categorie->couleur."</couleur>";
    $ret_str=$ret_str."<indice>".$categorie->indice."</indice>";
    if ($categorie->fa) {
       $ret_str=$ret_str."<icone>".$categorie->fa."</icone>";
    } elseif ($categorie->icon_id) {
       $ret_str=$ret_str."<icone>"._URL_DISPATCHER . $path . '/ng/public/api/icon/' . $categorie->icon_id . '/view'."</icone>";
    } elseif ($categorie->icon) {
        $ret_str=$ret_str."<icone>". $categorie->icon ."</icone>";
    } 
    else {
        $ret_str=$ret_str."<icone>fa-square</icone>";
    }
    
    $ret_str=$ret_str."</categorie>";
}
$ret_str=$ret_str."</categories>";
//=================================================================================

// Re-catégorisations ====================================================
$ret_str=$ret_str."<reorgs>";
foreach ($reorgs as $reorg) {
    $ret_str=$ret_str."<reorg>";
    $ret_str=$ret_str."<app>";
    foreach ($reorg->app as $key=>$value) {
        $ret_str=$ret_str."<$key>".$value."</$key>";
    }
    $ret_str=$ret_str."</app>";
    $ret_str=$ret_str."<condition>".$reorg->condition."</condition>";
    $ret_str=$ret_str."</reorg>";
}
$ret_str=$ret_str."</reorgs>";
//=================================================================================

// Construction de la liste des boutons
$ret_str=$ret_str."<buttondatas>";

//$CR="\n";
$CR="";

// Pour chaque zone Arena
$arrDesUrlCT=array(); // Afin de ne pas retourner 2 fois la même url on va utiliser ce tableau pour les stocker
$arrDesFavoris=array();
foreach($arrDesItemsArena as $items)
{
    $listeitems = $items['item'];
    if(!isset($listeitems["0"])) {$listeitems=array(0=>$items['item']);}

    // Chaque domaines
    foreach($listeitems as $item) {
        $domaine=$item["libelleDomaine"];
        if (function_exists('renameDomaine')) $domaine=renameDomaine($domaine);

        debug("domaine:".$domaine);

        $sousDomaines=$item["sousDomaines"];
        if (!isset($sousDomaines["0"])) {$sousDomaines=array(0=>$sousDomaines);}

        // chaque sous-domaine
        foreach($sousDomaines as $sousDomaine)
        {
            $ssdomaine=$sousDomaine["libelleDomaine"];
            if (function_exists('renameSousDomaine')) $ssdomaine=renameSousDomaine($ssdomaine);

            $ressources=$sousDomaine["ressources"];
            if (!isset($ressources["0"])) {$ressources=array(0=>$ressources);}

            debug("  ss:".$ssdomaine. " " .sizeof($ressources) ." ressources");

            // chaque ressource
            foreach($ressources as $ressource)
            {
                $libelle=$ressource["libelleRessource"];
                $url=$ressource["urlComplete"];
                $urlCT=strtolower($ressource["urlCT"]);
                $favurl=$item["libelleDomaine"].SEP_SIGAT.$sousDomaine["libelleDomaine"].SEP_SIGAT.$ressource["urlCT"];

		            // Si pas d'url ou pas de libelle on passe au suivant
                if ($url=="" || $libelle=="") {
                    continue;
                }

                //NICE : ligne suivante aupravant placée plus bas : on affecte plus tôt l'icône par défaut
                $icon=$__APP_ICONE_URL . $__APP_ICONE_DEFAULT;
		        // Cas des appli en fédération ( ref: #9115 )
		        if (strpos($urlCT,"redirectionhub/redirect.jsp?applicationname=")!==false) {
                    $arrUrl=explode("=",$urlCT);
                    //NICE : certains liens en fédération contiennent un - au lieu d'un _
                   $app=strtr($arrUrl[1],array("_in"=>"", "-in"=>"", "_etab"=>"", "-etab"=>""));
                    if (array_key_exists($app,$arrDesUrlCT)) continue;
                    $arrDesUrlCT[$app]=true;
                }
                //NICE : on poursuit la logique des applis en fédération : pour les applis locales, on recupere la chaine qui suit le premier /
                //Cela permet de déposer une icone de type appli.png dans le dossier icones (ex : sconetbe.png) qui sera prise automatiquement
                else {
                         $urlarray = explode( '/', $urlCT);
                         $app = $urlarray[1];
                }
                if (file_exists($__APP_ICONE_FOLDER . $app . ".png")) {
                         $icon=$__APP_ICONE_URL .  $app . ".png";
                }

                // L'url a déja été traitée, on passe au suivant
                if (array_key_exists($urlCT,$arrDesUrlCT)) {
                    continue;
                }

                $arrDesUrlCT[$urlCT]=true;

                $a=explode("/",$url);
                $piwik_tag=(count($a)>=4)?$a[3]:""; // Cas de url=nonAccessible pas de piwikTag
                if (strpos($url,"applicationname=")!==false)
                {
                    $a=explode("applicationname=",$url);
                    $piwik_tag=$a[1];
                }

                debug("      ressource:".$libelle. "($url)");

                $libelleSousDomaine = "";
                if ($withGenXml) {

                    if (hideUrl($url)) {
                        continue;
                    }

                    $newDomaine = renameDomaineFromUrl($ressource["urlCT"],$domaine);
                    if ($newDomaine!=$domaine) {
                        debug($ressource["urlCT"] . " : $domaine => " . $newDomaine);
                        $domaine = $newDomaine;
                    }

                    $data = getDataFromGenXML2($ressource["urlCT"]);
                    if ($data) {
                        $libelleSousDomaine = $data["Sous-domaine"];
                        $parts              = explode(":",$data["Libellé"]);
                        $libelle            = $parts[0];
                        if (count($parts)>1) {
                            $nom                = $parts[1];
                            $libelle = trim($parts[0])." - ".trim($parts[1]);
                        }

                    }


                }

                $nom=$ssdomaine;
                $categorie=$domaine;
                $flag="";
            // NICE : traitement CSV modifié, on prend comme entrée soit l'urlCT, soit la chaine $app récupérée avant, ce qui permet d'alléger le CSV
            if (array_key_exists($urlCT,$LISTE_ICONES_ARENA) || (array_key_exists($app,$LISTE_ICONES_ARENA)))
                {
                    if (isset($LISTE_ICONES_ARENA[$urlCT])) {$data=$LISTE_ICONES_ARENA[$urlCT];}
                    if (isset($LISTE_ICONES_ARENA[$app])) {$data=$LISTE_ICONES_ARENA[$app];}
                    if ($data["icone"]!="")     {$icon= $__APP_ICONE_URL . $data["icone"] . ".png"; }
                    if ($data["nom"]!="")       {$nom=$data["nom"];}
                    if ($data["libelle"]!="")   {$libelle=$data["libelle"];}
                    if ($data["categorie"]!="" && !$withGenXml) {$categorie=$data["categorie"];}
                    if ($data["flag"]!="")      {$flag=$data["flag"];}
                }
                // Flag h:hidden -> skip
                if (strpos($flag,"h")!==false) continue;

		            // Ref: #9350 : Prise en compte du mode fenêtre externe (arena v1.1.1)
		            // ajout du flag e si fenetreCourante == 0
                if (isset($ressource["fenetreCourante"]) &&  $ressource["fenetreCourante"]==0) $flag=$flag."e";

                $ret_str=$ret_str."<buttondata>$CR";
		            $ret_str=$ret_str."<nom>".$nom."</nom>$CR";
		            $ret_str=$ret_str."<libelle>".$libelle."</libelle>$CR";

                // Si il y a un libelle avec entre parenthèse, on récupère le nom entre parenthèse
                if (strpos($ssdomaine,"(")) {
                    preg_match_all('/.*\((.*)\).*/', $ssdomaine, $matches);
                    $cours=$matches[1][0];
                    $ret_str=$ret_str."<libellecours>".$cours."</libellecours>";
                //NICE : pour supprimer l'apostrophe du libelle cours de imag'in
                   $c=str_replace("'", "", strtolower($cours));
                    if (file_exists($__APP_ICONE_FOLDER . $c . ".png")) { $icon=$__APP_ICONE_URL .  $c . ".png";}
                }

                // Badge pour les messages CT
                if (isset($messagesCT[$favurl])) {
		                $msg=preg_replace('/[\x00-\x1F\x7F,*]/', '', $messagesCT[$favurl]);
                    $ret_str=$ret_str."<infos_type>"."infos"."</infos_type>$CR";
                    $ret_str=$ret_str."<infos_message>".$msg."</infos_message>$CR";
                }

                // traitement des flags
                if (strpos($flag,"e")!==false) $ret_str=$ret_str."<external>"."true"."</external>$CR"; // App externe

                // ref #20196 :  Gérer les favoris 'identiques' de plusieurs zones avec des urlCT différentes
                $ress=arenaRessource($favurl);

                $ret_str=$ret_str."<icon>".$icon."</icon>$CR";
                $ret_str=$ret_str."<url>".$url."</url>$CR";
		        $ret_str=$ret_str."<server>".$ressource['serveur']."</server>$CR";
                $ret_str=$ret_str."<piwik_tag>".$piwik_tag."</piwik_tag>$CR";
		        $ret_str=$ret_str."<categoriename>".$categorie."</categoriename>$CR";
		        $ret_str=$ret_str."<categorieid>"."0"."</categorieid>$CR";
                $ret_str=$ret_str."<ssdomaine>".$libelleSousDomaine."</ssdomaine>$CR";
                $ret_str=$ret_str."<favurl>".$favurl."</favurl>$CR";
                $ret_str=$ret_str."<resarena>".$ress."</resarena>$CR";
                $ret_str=$ret_str."<infos_url></infos_url>$CR";
		        $ret_str=$ret_str."</buttondata>$CR";

                if (isset($favCT[$ress])) {
                    $arrDesFavoris[]=array("url"=>$url,"resarena"=>$ress);
                }
                if (isset($favURLCT[$ressource["urlCT"]])) {
                    $arrDesFavoris[]=array("url"=>$url,"resarena"=>$ress);
                }

                $finUrl=explode(SEP_SIGAT,$ress);
                if (count($finUrl) >= 2 && isset($favURLCT[$finUrl[2]])) {
                    $arrDesFavoris[]=array("url"=>$url,"resarena"=>$ress);
                }

            }
            // Fin ressources
       } // Fin sous-domaines
    }// Fin domaines
}

// Appli locales ========================================================================

// Favoris locaux ----------------------------------------------------------------------
$favoris  = R::find( 'favoris', ' uid = ?', array($uid));
foreach ($favoris as $favori) {
  $arrDesFavoris[]=$favori->toArray();
}
// ---------------------------------------------------------------------------------------

foreach($APPS_SUPLEMENTAIRES as $appli)
{
    $ret_str=$ret_str."<buttondata>$CR";
    $ret_str=$ret_str."<nom>".          $appli[_N]."</nom>$CR";
    $ret_str=$ret_str."<libelle>".      $appli[_L]."</libelle>$CR";
    $ret_str=$ret_str."<categoriename>".$appli[_C]."</categoriename>$CR";
    $ret_str=$ret_str."<icon>".         $appli[_I]."</icon>$CR";
    $ret_str=$ret_str."<url>".          $appli[_U]."</url>$CR";
    $ret_str=$ret_str."<external>".     $appli[_E]."</external>$CR";
    $ret_str=$ret_str."<piwik_tag>".    $appli[_PT]."</piwik_tag>$CR";
    $ret_str=$ret_str."<infos_url>".    $appli[_IU]."</infos_url>$CR";
    $ret_str=$ret_str."<infos_type>".   $appli[_IT]."</infos_type>$CR";
    $ret_str=$ret_str."<server>edispatcher</server>$CR";
    $ret_str=$ret_str."<infos_message>".$appli[_IM]."</infos_message>$CR";
    $ret_str=$ret_str."</buttondata>$CR";
}
//===================================================================================

// Et si on fermait toutes les balises
$ret_str=$ret_str."</buttondatas>";
$ret_str=$ret_str."</main>";

if (isDebug()) {
    $s=$ret_str;
    echo $s;
    print_r($arrDesFavoris);
    die();
}

$favoris= json_encode($arrDesFavoris);

callHandler('afterStop');

// Si callback utilisation du callback
if (isset($_GET["callback"])) {postData($ret_str,$favoris,"",$user_infos);return;}

// Si js
if (isset($_GET["js"])) {
    $id=isset($_GET["id"])?$_GET["id"]:"";
    header("Content-type: text/javascript");

    $data=json_encode(array("xml"=>(htmlentities($ret_str,ENT_QUOTES,"UTF-8")),
                            "favoris"=>(htmlentities($favoris,ENT_QUOTES,"UTF-8")),
                            "userinfos"=>(htmlentities(str_replace("'",'"',$user_infos),ENT_QUOTES,"UTF-8")),
                            "nom"=>$__NOM,"id"=>$id,
                            "referer"=>(isset($_SERVER['HTTPS']) ? "https" : "http") . "://{$_SERVER['HTTP_HOST']}{$_SERVER['REQUEST_URI']}"
                    ));

    echo <<<EOL
/* DATA_FOR_MXDESKTOP: Ne pas supprimer cette ligne */
var source=MX.getSource('$id');
if (!source) {
    console.log("Source $id introuvable");
} else {
    source.setData('$data');
}
EOL
;
    return;
}


//header('Content-Type: text/xml; charset=utf-8');
//echo chr(60).chr(63).'xml version="1.0" encoding="utf-8" '.chr(63).chr(62);
echo $ret_str;
echo "\n\n";
echo "favoris:$favoris";
print_r($favCT);
echo "\n";
print_r($messagesCT);


?>
