<?php

include_once "uinc.php";

define("AAF_FOLDER","/tmp/aaf");
define("DBID",7);

// Correspondance des profils avec AAF
$PROFILS= ["ENS"=>"national_3","DOC"=>"national_3",
           "EDU"=>"national_5","DIR"=>"national_4",
           "INS"=>"national_7",
           "ADM"=>"national_6","ADF"=>"national_6","ASH"=>"national_6","TEC"=>"national_6"];

// Check si redis est configuré
if (!is_array($__METRICS) && $__METRICS["mode"] != "redis")  {
  die("METRICS REDIS NOT DEFINED");
}

// Connection Redis
$redis = new \Redis();
if (!$redis->connect($__METRICS["redis"]["host"],$__METRICS["redis"]["port"])) {
    die("IMPOSSIBLE TO CONNECT AT REDIS ${$__METRICS["redis"]["host"]}:${$__METRICS["redis"]["port"]}");
};

if (!$redis->select(DBID)) {
  die("IMPOSSIBLE TO SELECT DATABASE ".DBID);
}

// Pour ajouter les stats a prometheus
$metrics = \Edispatcher\Entity\Metrics::instance();



// Fonctions ==================================================
function Add($values,$targets){
  global $redis;
  foreach ($targets as $target) {
    foreach ($values as $value) {
      $redis->sAdd($target, $value);
    }
  }
}

function getProfil($value){
 global $PROFILS;
 $a=explode("$",$value);
 $p = "national_6";
 if (array_key_exists($a[1],$PROFILS)) {
   $p = $PROFILS[$a[1]];
 }
 return $p;
}
// =============================================================

// Reset profils
for($i=1;$i<8;$i++) {
  $redis->delete("national_".$i);
}

$etabs=\R::findAll( 'etab' );
foreach ($etabs as $etab) {
  $uaj = $etab->uaj;
  $uaj = str_replace("974","",$uaj);

  // reset key before
  $redis->delete($etab->uaj);

  $bHasComptes = false;

  // Eleves
  foreach (glob(AAF_FOLDER."/ENT_${uaj}_Complet_*_Eleve_*.xml") as $filename) {
    $file = file_get_contents ($filename);
    preg_match_all ('/<identifier><id>([0-9]*)<\/id><\/identifier>/', $file, $matches);
    if ($matches) {
      echo $etab->uaj. " ".$etab->nom. " ";
      Add($matches[1],[$etab->uaj,'national_1']);
      $bHasComptes = true;
      echo " national_1".":".count($matches[1]);
    }
  }

  // Responsables
  foreach (glob(AAF_FOLDER."/ENT_${uaj}_Complet_*_PersRelEleve_*.xml") as $filename) {
    $file = file_get_contents ($filename);
    preg_match_all ('/<identifier><id>([0-9]*)<\/id><\/identifier>/', $file, $matches);
    if ($matches) {
      Add($matches[1],[$etab->uaj,'national_2']);
      $bHasComptes = true;
      echo " national_2".":".count($matches[1]);
    }
  }

  // Academiques
  foreach (glob(AAF_FOLDER."/ENT_${uaj}_Complet_*_PersEducNat_*.xml") as $filename) {
    $file = file_get_contents ($filename);
    preg_match_all ('/<identifier><id>([0-9]{1,10})<\/id><\/identifier>/', $file, $matches1);
    preg_match_all ('/<attr name="ENTPersonFonctions"><value>(.*)<\/value><\/attr>/', $file, $matches2);
    if ($matches1) {
      $l1=count($matches1[1]);
      $l2=count($matches2[1]);
      // Fiche sans ENTPersonFonctions
      if ($l1>$l2) {
        print_r($matches1[1]);print_r($matches2[1]);
        $redis->close();
        die($filename." ERROR ${l1} != ${l2}");
      }

      $bHasComptes = true;
      foreach ($matches1[1] as $key=>$value) {
        Add([$value],[$etab->uaj,getProfil($matches2[1][$key])]);
      }

      echo " national_3-7".":".count($matches1[1]);
      echo "\n";
    }
  }

  // Comptabilise sur prometheus
  if ($bHasComptes) {
    for($i=1;$i<8;$i++) {
      $x=$redis->sInter($etab->uaj,'national_'.$i);
      if (count($x)) {
        $metrics->accountsAvailable(count($x),'national_'.$i,$etab->uaj,$etab->type);
      }
    }
  }

}




$redis->close();
