<?php

if(php_sapi_name() != "cli") {
  die("mode cli requis");
}

define("ROOT_DIR",dirname(__FILE__)."/..");
define("INC_DIR",ROOT_DIR."/include");
include_once(INC_DIR.'/dispatcher.config.php');
include_once(INC_DIR.'/db.config.php');
include_once(ROOT_DIR.'/arena/arena_inc.php');


require ROOT_DIR. '/vendor/autoload.php';

// fixes #22791 , Erreur à l'execution du cron
// __ARENA_WSIDENTITE , non renseigné on ne fait rien
if (!__ARENA_WSIDENTITE) {
  die();
}

// On attend entre 2s et 10s, avant de lancer la tâche
// Tâche concurrante si serveur en HA
$d = rand ( 2, 10);
echo "\nwaiting for ${d}s...\n";
sleep ( $d );

echo "START ==>" . date("Y-m-d H:i:s") . "\n";

$metrics = \Edispatcher\Entity\Metrics::instance();

// Les tokens trop anciens
$date = new DateTime();
$date->sub(new DateInterval('P5D'));
$oldTokens=R::find( 'token', ' created_at  < ? LIMIT 10000' , array($date->format('Y-m-d H:i:s')));
echo "suppression des " . count($oldTokens) . " old tokens\n";
R::trashAll( $oldTokens );

// __CACHE_DURATIONh /2 avant expiration du cache
$date = new DateTime();
$date->sub(new DateInterval('PT'.max(ceil(__CACHE_DURATION/2),1).'H'));

// WebServices Init
$client = WS();

$LIMIT=1000;

$time_start = microtime(true);
echo "Maj du cache < ".$date->format('Y-m-d H:i:s')." ($LIMIT plus anciens)\n";

$caches=R::find( 'arenacache', ' updated  < ? and ( locked is false ) ORDER BY updated ASC,uid ASC ' . "LIMIT $LIMIT", array($date->format('Y-m-d H:i:s')));

if (count($caches)==0) {
  // Rien a mettre a jour on va tout de même en faire 10 :)
  $count = rand ( 10, 100) ;
  $caches=R::find( 'arenacache', ' ORDER BY updated ASC LIMIT ' . $count);
  echo "rien a mettre a jour on va tout de même en faire $count :)\n";
}

echo count($caches) . " enregistrements seront mis à jour\n";

// Lock record
echo "Verouillage des enregistrements : ";
foreach ($caches as $cache) {
    $cache->locked=true;
    //R::store( $cache );
}
R::storeAll( $caches );
$time_end = microtime(true);
$time = $time_end - $time_start;
echo "$time seconds\n";

$timeToLoad=[];




echo "Récupération du cache : ";
$total = count($caches);
$time_start = microtime(true);
foreach ($caches as $cache) {
  $time_start_load = microtime(true);

  echo "\n ($total) [".$cache->id."] ".$cache->updated." (".$cache->uid.") :".$cache->zone;
  $total = $total - 1;

  $result=$client->getRessourcesPortail($cache->uid,$cache->zone);
  $time = microtime(true) - $time_start_load;

  if (!isset($timeToLoad[$cache->zone])) $timeToLoad[$cache->zone]=[];
  $timeToLoad[$cache->zone][] = $time;

  $items=objectToArray($result);
  if (!is_array($items) || count($items)==0) {
    continue;
  }
  $cache->setCache($items);
  $cache->updated=new DateTime();
  $cache->timetoload = $time;
  echo ":OK --- DUREE : ".$time;
}
R::storeAll( $caches );
$time_end = microtime(true);
$time = $time_end - $time_start;
echo "\n$time seconds\n";

echo "Temps moyen de chargement par zone\n";
foreach ($timeToLoad as $key => $times) {
  $avg = array_sum($times) / count($times);
  echo " $key :" . $avg;
  $metrics->arenaFromWebService($key,$avg);
}

echo "\n";

// Nombre total de cache obsolete
// cache trop vieux ( >  __CACHE_DURATION -1 et locked)
$date = new DateTime();
$date->sub(new DateInterval('PT'.max((__CACHE_DURATION - 1),1).'H'));
$reste=R::find( 'arenacache', ' updated  < ? and ( locked is true )' , array($date->format('Y-m-d H:i:s')));
if (count($reste) != 0) {
    echo "Suppression de ". count($reste) ." trop ancien\n";
    R::trashAll( $reste );
}


$date = new DateTime();
$date->sub(new DateInterval('PT'.max(__CACHE_DURATION ,1).'H'));
$reste=R::find( 'arenacache', ' updated  < ? ' , array($date->format('Y-m-d H:i:s')));

$metrics->arenaCacheObsolete(count($reste));
echo "Il reste : " . count($reste) . "\n";

// Durée moyenne du cache arena
$data=R::getAll("SELECT AVG(TIMESTAMPDIFF(SECOND,updated,CURRENT_TIMESTAMP())) as moyenne FROM arenacache");

$moy=$data[0]["moyenne"];
$metrics->arenaCacheAveragDuration($moy);
echo "Durée moyenne d'obscelelance : " . $moy . " secondes\n";

R::close();
echo "END ==>" . date("Y-m-d H:i:s") . "\n";
echo "---\n";
