#!/bin/bash

#1 : app to reconf = default all
#2 : lanch template = default yes
#3 : lanch bdd = default yes
#4 : lanch theme = default yes
#5 : RAZ = default no

activer_adminer=$(CreoleGet activer_adminer non)
activer_balado=$(CreoleGet activer_balado non)
activer_dokuwiki=$(CreoleGet activer_dokuwiki non)
activer_econnect=$(CreoleGet activer_econnect non)
activer_edispatcher=$(CreoleGet activer_edispatcher non)
activer_eportail=$(CreoleGet activer_eportail non)
activer_etherhome=$(CreoleGet activer_etherhome non)
activer_etherpad=$(CreoleGet activer_etherpad non)
activer_ethercalc=$(CreoleGet activer_ethercalc non)
activer_fluxbb=$(CreoleGet activer_fluxbb non)
activer_gepi=$(CreoleGet activer_gepi non)
activer_glpi=$(CreoleGet activer_glpi non)
activer_grr=$(CreoleGet activer_grr non)
activer_janus=$(CreoleGet activer_janus non)
activer_kanboard=$(CreoleGet activer_kanboard non)
activer_limesurvey=$(CreoleGet activer_limesurvey non)
activer_mahara=$(CreoleGet activer_mahara non)
activer_mindmaps=$(CreoleGet activer_mindmaps non)
activer_moodle=$(CreoleGet activer_moodle non)
activer_opensondage=$(CreoleGet activer_opensondage non)
activer_owncloud=$(CreoleGet activer_owncloud non)
activer_piwigo=$(CreoleGet activer_piwigo non)
activer_piwik=$(CreoleGet activer_piwik non)
activer_poshprofil=$(CreoleGet activer_poshprofil non)

activer_ninebadge=$(CreoleGet activer_ninebadge non)
activer_nineboard=$(CreoleGet activer_nineboard non)
activer_ninegate=$(CreoleGet activer_ninegate non)
activer_ninegitea=$(CreoleGet activer_ninegitea non)
activer_nineskeletor=$(CreoleGet activer_nineskeletor non)
activer_ninesurvey=$(CreoleGet activer_ninesurvey non)
activer_nineschool=$(CreoleGet activer_nineschool non)

activer_scrumblr=$(CreoleGet activer_scrumblr non)

container_path_web=$(CreoleGet container_path_web)
container_path_bdd=$(CreoleGet container_path_bdd "")
eole_release=$(CreoleGet eole_release "0.0.0")


#===========================================================================================================================================
#== ENVOLE =================================================================================================================================
#===========================================================================================================================================
#1 = activation oui/non
#2 = application

apache(){

    rm -rf ${container_path_web}/etc/apache2/sites-enabled/$2
    if [[ "$1" == "oui" ]]
    then
        ln -s ${container_path_web}/etc/apache2/sites-available/$2 ${container_path_web}/etc/apache2/sites-enabled/$2
    fi
}

#===========================================================================================================================================
#== MAIN ===================================================================================================================================
#===========================================================================================================================================

. /usr/lib/envole-tools/e-ihm.sh

clear
BigTitle "RECONFIGURE ENVOLE $1"
service creoled restart

# Refresh
if [[ $5 == "yes" ]]
then
    if [[ $1 == "" || $1 == "all" ]]
    then
        EchoRouge "Merci de précisez l'application que vous souhaitez réintaller totalement"
        exit
    fi

    # Si RAZ template et bdd obligatoire
    if [[ $2 == "no" ]]
    then
        EchoRouge "Execution des templates obligatoires si RAZ d'une application"
        exit
    fi

    if [[ $3 == "no" ]]
    then
        EchoRouge "Execution des templates obligatoires si RAZ d'une application"
        exit
    fi

    BigTitle "SUPPRESSION"
    e-purgeapp $1 1

    BigTitle "INSTALLATION"
    if [[ $1 == "glpi" ]]
    then
        apt-get install eole-glpi
        if [[ "$container_path_web" == "" ]]
        then
            yes | apt-get install glpi
            yes | apt-get install glpi-plugin-ocsinventoryng
        else
            yes | apt-eole -c reseau install glpi
            yes | apt-eole -c reseau install glpi-plugin-ocsinventoryng
        fi        
    else
        if [[ $1 == "moodle" ]]
        then
            apppkg="moodle-update"
        elif [[ $1 == "econnect" ]]
        then
            apppkg="envole-connecteur"
        elif [[ $1 == "edispatcher" ]]
        then
            apppkg="dispatcher"
        else
            apppkg=$1
        fi

        apt-get install eole-$apppkg
        apt-get install $apppkg-sso
        if [[ "$container_path_web" == "" ]]
        then
            yes | apt-get install $apppkg-apps
        else
            yes | apt-eole -c reseau install $apppkg-apps
        fi
    fi
fi

# Pretemplate
BigTitle "PRETEMPLATE"

if [[ -f "/usr/share/eole/pretemplate/25-balado" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "balado" ]]
    then
        Title "BALADO"
        /usr/share/eole/pretemplate/25-balado
    fi
fi
if [[ -f "/usr/share/eole/pretemplate/25-etherpad" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "etherpad" ]]
    then
        Title "ETHERPAD"
        /usr/share/eole/pretemplate/25-etherpad
    fi
fi
if [[ -f "/usr/share/eole/pretemplate/25-janus" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "janus" ]]
    then
        Title "JANUS"
        /usr/share/eole/pretemplate/25-janus
    fi
fi
if [[ -f "/usr/share/eole/pretemplate/25-ninebadge" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "ninebadge" ]]
    then
        Title "NINEBADGE"
        /usr/share/eole/pretemplate/25-ninebadge
    fi
fi
if [[ -f "/usr/share/eole/pretemplate/25-nineboard" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "nineboard" ]]
    then
        Title "NINEBOARD"
        /usr/share/eole/pretemplate/25-nineboard
    fi
fi
if [[ -f "/usr/share/eole/pretemplate/25-ninegitea" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "ninegitea" ]]
    then
        Title "NINEGITEA"
        /usr/share/eole/pretemplate/25-ninegitea
    fi
fi
if [[ -f "/usr/share/eole/pretemplate/25-nineschool" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "nineschool" ]]
    then
        Title "NINESCHOOL"
        /usr/share/eole/pretemplate/25-nineschool
    fi
fi
if [[ -f "/usr/share/eole/pretemplate/25-ninesurvey" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "ninesurvey" ]]
    then
        Title "NINESURVEY"
        /usr/share/eole/pretemplate/25-ninesurvey
    fi
fi
if [[ -f "/usr/share/eole/pretemplate/25-nineskeletor" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "nineskeletor" ]]
    then
        Title "NINESKELETOR"
        /usr/share/eole/pretemplate/25-nineskeletor
    fi
fi
if [[ -f "/usr/share/eole/pretemplate/25-ninegate" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "ninegate" ]]
    then
        Title "NINEGATE"
        /usr/share/eole/pretemplate/25-ninegate
    fi
fi
if [[ -f "/usr/share/eole/pretemplate/25-schedule" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "schedule" ]]
    then
        Title "SCHEDULE"
        /usr/share/eole/pretemplate/25-schedule
    fi
fi


# Génération des Templates
if [[ $2 == "" || $2 == "yes" ]]
then
    if [[ "${eole_release}" > "2.7.2" ]]
    then
        BigTitle "GENERATION DES TEMPLATES ${eole_release}"
        python3 -c "from creole.reconfigure import templates;templates()"
    else
        BigTitle "GENERATION DES TEMPLATES ${eole_release}"
        python -c "from creole.reconfigure import templates;templates()"
    fi
fi


# Generation des BDD
if [[ $3 == "" || $3 == "yes" ]]
then
    BigTitle "EOLEDB"
    /usr/share/eole/posttemplate/00-mysql
    /usr/share/eole/posttemplate/01-eoledb

    RunCmd=CreoleRun
    if [[ "$container_path_bdd" == "" ]]
    then
        service mysql restart
    else
        $RunCmd "service mysql restart" bdd    
    fi    
fi


# Posttemplate
BigTitle "POSTTEMPLATE"
if [[ -f "/usr/share/eole/posttemplate/06-adminer" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "adminer" ]]
    then
        Title "ADMINER"
        /usr/share/eole/posttemplate/06-adminer
    fi
fi

if [[ -f "/usr/share/eole/posttemplate/10-envole-dependances" ]]
then
    Title "ENVOLE DEPENDANCES"
    /usr/share/eole/posttemplate/10-envole-dependances
fi

if [[ -f "/usr/share/eole/posttemplate/10-nodejspkg" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "etherpad" || $1 == "ethercalc" || $1 == "scrumblr" ]]
    then
        Title "NODEJS"
        /usr/share/eole/posttemplate/10-nodejspkg
    fi
fi

if [[ -f "/usr/share/eole/posttemplate/15-nodepm2" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "etherpad" || $1 == "ethercalc" || $1 == "scrumblr" ]]
    then
        Title "PM2"
        /usr/share/eole/posttemplate/15-nodepm2
    fi
fi

if [[ -f "/usr/share/eole/posttemplate/20-etherpad" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "etherpad" ]]
    then
        Title "ETHERPAD"
        /usr/share/eole/posttemplate/20-etherpad
    fi
fi

if [[ -f "/usr/share/eole/posttemplate/30_dispatcher" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "edispatcher" ]]
    then
        Title "EDISPATCHER"
        /usr/share/eole/posttemplate/30_dispatcher
    fi
fi
    

# Activation apache
BigTitle "APACHE"
apache $activer_balado "balado"
apache $activer_dokuwiki "dokuwiki"
apache $activer_econnect "econnect"
apache $activer_edispatcher "edispatcher"
apache $activer_eportail "eportail"
apache $activer_etherhome "etherhome"
apache $activer_etherpad "etherpad"
apache $activer_ethercalc "ethercalc"
apache $activer_fluxbb "fluxbb"
apache $activer_gepi "gepi"
apache $activer_glpi "glpi"
apache $activer_grr "grr"
apache $activer_janus "janus"
apache $activer_kanboard "kanboard"
apache $activer_limesurvey "limesurvey"
apache $activer_mahara "mahara"
apache $activer_mindmaps "mindmaps"
apache $activer_moodle "moodle"
apache $activer_opensondage "opensondage"
apache $activer_owncloud "owncloud"
apache $activer_piwigo "piwigo"
apache $activer_piwik "piwik"
apache $activer_poshprofil "posh-profil"

apache $activer_ninegate "ninegate"
apache $activer_ninebadge "ninebadge"
apache $activer_nineboard "nineboard"
apache $activer_nineskeletor "nineskeletor"
apache $activer_ninesurvey "ninesurvey"
apache $activer_nineschool "nineschool"

apache $activer_scrumblr "scrumblr"

RunCmd=CreoleRun
$RunCmd "service apache2 restart" web




# Domaine
if [[ -f "/usr/share/eole/postservice/05-eolead-join-and-sync-ldap" ]]
then
    BigTitle "DOMAINE"
    /usr/share/eole/postservice/05-eolead-join-and-sync-ldap reconfigure
fi


# Service
BigTitle "SERVICE"
if [[ $1 == "" || $1 == "all" || $1 == "etherpad" ]]
then
    if [[ -f /lib/systemd/system/etherpad.service ]]
    then
        Title "SERVICE ETHERPAD"
        service etherpad restart
        pm2 restart etherpad
    fi
fi

if [[ $1 == "" || $1 == "all" || $1 == "ethercalc" ]]
then
    if [[ -f /lib/systemd/system/ethercalc.service ]]
    then
        Title "SERVICE ETHERCALC"
        service ethercalc restart
        pm2 restart ethercalc
    fi
fi

if [[ $1 == "" || $1 == "all" || $1 == "scrumblr" ]]
then
    if [[ -f /lib/systemd/system/scrumblr.service ]]
    then
        Title "SERVICE SCRUMBLR"
        service scrumblr restart
    fi
fi

if [[ $1 == "" || $1 == "all" || $1 == "nineboard" ]]
then
    if [[ -f /lib/systemd/system/wssnineboard.service ]]
    then
        Title "SERVICE NINEBOARD"
        service wssnineboard restart
    fi
fi


if [[ $1 == "" || $1 == "all" || $1 == "nineskeletor" ]]
then
    if [[ -f /lib/systemd/system/wssnineskeletor.service ]]
    then
        Title "SERVICE NINESKELETOR"
        service wssninegate restart
    fi 
fi

if [[ $1 == "" || $1 == "all" || $1 == "ninegate" ]]
then
    if [[ -f /lib/systemd/system/wssninegate.service ]]
    then
        Title "SERVICE NINEGATE"
        service wssninegate restart
    fi

    if [[ -f /lib/systemd/system/msgninegate.service ]]
    then
        service msgninegate restart
    fi    
fi

# Postservice
BigTitle "POSTSERVICE"

if [[ -f "/usr/share/eole/postservice/00-cdt" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "cdt" ]]
    then
        Title "CDT"
        /usr/share/eole/postservice/00-cdt
        echo
    fi
fi

if [[ -f "/usr/share/eole/postservice/00-piwik" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "piwik" ]]
    then
        Title "PIWIK"
        /usr/share/eole/postservice/00-piwik
        echo
    fi
fi

if [[ -f "/usr/share/eole/postservice/01-update-glpi" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "glpi" ]]
    then
        Title "GLPI"
        /usr/share/eole/postservice/01-update-glpi
        echo
    fi
fi

if [[ -f "/usr/share/eole/postservice/10-gepi" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "gepi" ]]
    then
        Title "GEPI"
        /usr/share/eole/postservice/10-gepi
        echo
    fi
fi

if [[ -f "/usr/share/eole/postservice/10-xdesktop" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "xdesktop" ]]
    then
        Title "XDESKTOP"
        /usr/share/eole/postservice/10-xdesktop
        echo
    fi
fi

if [[ -f "/usr/share/eole/postservice/20-dokuwiki" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "dokuwiki" ]]
    then
        Title "DOKUWIKI"
        /usr/share/eole/postservice/20-dokuwiki
        echo
    fi
fi

if [[ -f "/usr/share/eole/postservice/20-eportail" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "eportail" ]]
    then
        Title "EPORTAIL"
        /usr/share/eole/postservice/20-eportail
        echo
    fi
fi

if [[ -f "/usr/share/eole/postservice/20-kanboard" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "kanboard" ]]
    then
        Title "KANBOARD"
        /usr/share/eole/postservice/20-kanboard
        echo
    fi
fi

if [[ -f "/usr/share/eole/postservice/20-limesurvey" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "limesurvey" ]]
    then
        Title "LIMESURVEY"
        /usr/share/eole/postservice/20-limesurvey
        echo
    fi
fi

if [[ -f "/usr/share/eole/postservice/20-moodle" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "moodle" ]]
    then
        Title "MOODLE"
        /usr/share/eole/postservice/20-moodle
        echo
    fi
fi

if [[ -f "/usr/share/eole/postservice/20-piwigo" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "piwigo" ]]
    then
        Title "PIWIGO"
        /usr/share/eole/postservice/20-piwigo
        echo
    fi
fi

if [[ -f "/usr/share/eole/postservice/25-sacoche" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "sacoche" ]]
    then
        Title "SACOCHE"
        /usr/share/eole/postservice/25-sacoche
        echo
    fi
fi

if [[ -f "/usr/share/eole/postservice/25-schedule" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "schedule" ]]
    then
        Title "SCHEDULE"
        /usr/share/eole/postservice/25-schedule
        echo
    fi
fi

if [[ -f "/usr/share/eole/postservice/30_dispatcher" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "edispatcher" ]]
    then
        Title "DISPATCHER"
        /usr/share/eole/postservice/30_dispatcher
        echo
    fi
fi

if [[ -f "/usr/share/eole/postservice/30_econnect" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "econnect" ]]
    then
        Title "ECONNECT"
        /usr/share/eole/postservice/30_econnect
        /usr/share/eole/postservice/31_econnect_sso
        echo
    fi
fi

if [[ -f "/usr/share/eole/postservice/50-balado" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "balado" ]]
    then
        Title "BALADO"
        /usr/share/eole/postservice/50-balado
        echo
    fi
fi

if [[ -f "/usr/share/eole/postservice/50-grr" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "grr" ]]
    then
        Title "GRR"
        /usr/share/eole/postservice/50-grr
        echo
    fi
fi

if [[ -f "/usr/share/eole/postservice/50-nextcloud" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "nextcloud" ]]
    then
        Title "NEXTCLOUD"
        /usr/share/eole/postservice/50-nextcloud
        echo
    fi
fi

if [[ -f "/usr/share/eole/postservice/51-pydio" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "pydio" ]]
    then
        Title "PYDIO"
        /usr/share/eole/postservice/51-pydio
        echo
    fi
fi

if [[ -f "/usr/share/eole/postservice/51-wordpress" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "wordpress" ]]
    then
        Title "WORDPRESS"
        /usr/share/eole/postservice/51-wordpress
        echo
    fi
fi

if [[ -f "/usr/share/eole/postservice/60-ethercalc" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "ethercalc" ]]
    then
        Title "ETHERCALC"
        /usr/share/eole/postservice/60-ethercalc
        echo
    fi
fi

if [[ -f "/usr/share/eole/postservice/60-zephir-racvision" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "zephir-racvision" ]]
    then
        Title "ZEPHIR RACVISION"
        /usr/share/eole/postservice/60-zephir-racvision
        echo
    fi
fi

if [[ -f "/usr/share/eole/postservice/62-etherhome" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "etherhome" ]]
    then
        Title "ETHERHOME"
        /usr/share/eole/postservice/62-etherhome
        echo
    fi
fi

if [[ -f "/usr/share/eole/postservice/90-janus" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "janus" ]]
    then
        Title "JANUS"
        /usr/share/eole/postservice/90-janus
    fi
fi

if [[ -f "/usr/share/eole/postservice/90-ninebadge" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "ninebadge" ]]
    then
        Title "NINEBADGE"
        /usr/share/eole/postservice/90-ninebadge
    fi
fi

if [[ -f "/usr/share/eole/postservice/90-nineboard" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "nineboard" ]]
    then
        Title "NINEBOARD"
        /usr/share/eole/postservice/90-nineboard
        systemctl restart wssnineboard
    fi
fi

if [[ -f "/usr/share/eole/postservice/90-ninegitea" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "ninegitea" ]]
    then
        Title "NINEGITEA"
        /usr/share/eole/postservice/90-ninegitea
    fi
fi

if [[ -f "/usr/share/eole/postservice/90-nineschool" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "nineschool" ]]
    then
        Title "NINESCHOOL"
        /usr/share/eole/postservice/90-nineschool
    fi
fi

if [[ -f "/usr/share/eole/postservice/90-ninesurvey" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "ninesurvey" ]]
    then
        Title "NINESURVEY"
        /usr/share/eole/postservice/90-ninesurvey
    fi
fi

if [[ -f "/usr/share/eole/postservice/90-nineskeletor" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "nineskeletor" ]]
    then
        Title "NINESKELETOR"
        /usr/share/eole/postservice/90-nineskeletor
        systemctl restart wssnineskeletor
    fi
fi

if [[ -f "/usr/share/eole/postservice/91-ninegate" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "ninegate" ]]
    then
        Title "NINEGATE"
        /usr/share/eole/postservice/91-ninegate
        systemctl restart wssninegate
    fi
fi

if [[ -f "/usr/share/eole/postservice/95-envole-themes" ]]
then
    if [[ $4 == "" || $4 == "yes" ]]
    then
        Title "THEME"
        /usr/share/eole/postservice/95-envole-themes
    fi
fi



