#!/bin/bash

#1 : app to purge
#2 : purge package




#===========================================================================================================================================
#== MAIN ===================================================================================================================================
#===========================================================================================================================================

. /usr/lib/envole-tools/e-ihm.sh

container_path_web=$(CreoleGet container_path_web)
adresse_ip_mysql=$(CreoleGet adresse_ip_mysql)
RunMysql=${container_path_web}/usr/bin/mysql
RunCmd=CreoleRun
BigTitle "PURGE APP ENVOLE"

if [[ $1 == "" ]]
then
    Question "Nom de l'application à purger"
    app=$retval
    echo ""
else
    app=$1
fi

if [[ $2 == "" ]]
then
    Question_ouinon "Souhaitez-vous purger les paquets correspondant ?" oui
    echo $retval
    purge=$retval
else
    purge=$2
fi

EchoRouge "Suppression des anciennes sources"
rm -rf $container_path_web/var/www/html/$app
rm -rf $container_path_web/home/www-data/var/www/html/$app
rm -rf $container_path_web/etc/apache2/sites-enabled/$app.conf
rm -rf $container_path_web/etc/apache2/sites-available/$app
rm -rf /etc/eole/eole-db.d/$app-db.yml

echo
EchoRouge "Suppression de la BDD"
mysql_pwd.py 123456 >/dev/null
export MYSQL_PWD=123456
echo "DROP DATABASE IF EXISTS $app;" | $RunMysql -uroot -p123456 -h $adresse_ip_mysql


if [[ $purge = 1 ]]
then
    echo
    EchoRouge "Suppression des paquets"
    if [[ $app == "glpi" ]]
    then
        yes | apt-get remove eole-glpi --purge
        if [[ "$container_path_web" == "" ]]
        then
            yes | apt-get remove glpi --purge
        else
            yes | apt-eole -c reseau remove glpi
        fi        
    else
        if [[ $app == "moodle" ]]
        then
            apppkg="moodle-update"
        elif [[ $app == "econnect" ]]
        then
            apppkg="envole-connecteur"
        elif [[ $app == "edispatcher" ]]
        then
            apppkg="dispatcher"
        else
            apppkg=$app
        fi
        
        yes | apt-get remove eole-$apppkg --purge
        yes | apt-get remove $apppkg-sso --purge
        
        if [[ "$container_path_web" == "" ]]
        then
            yes | apt-get remove $apppkg-apps --purge
        else
            yes | apt-eole -c reseau remove $apppkg-apps
        fi
    fi
fi

# EoleDB
if [[ -f "/etc/eole/eole-db.d/schedule-db.yml" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "schedule" ]]
    then
        Title "SCHEDULE"
        rm -rf /etc/eole/eole-db.d/schedule-db.yml
    fi
fi

if [[ -f "/etc/eole/eole-db.d/janus-db.yml" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "janus" ]]
    then
        Title "JANUS"
        rm -rf /etc/eole/eole-db.d/janus-db.yml
    fi
fi

if [[ -f "/etc/eole/eole-db.d/ninebadge-db.yml" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "ninebadge" ]]
    then
        Title "NINEBADGE"
        rm -rf /etc/eole/eole-db.d/ninebadge-db.yml
    fi
fi

if [[ -f "/etc/eole/eole-db.d/nineboard-db.yml" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "nineboard" ]]
    then
        Title "NINEBOARD"
        rm -rf /etc/eole/eole-db.d/nineboard-db.yml
    fi
fi

if [[ -f "/etc/eole/eole-db.d/ninegitea-db.yml" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "ninegitea" ]]
    then
        Title "NINEGITEA"
        rm -rf /etc/eole/eole-db.d/ninegitea-db.yml
    fi
fi

if [[ -f "/etc/eole/eole-db.d/nineschool-db.yml" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "nineschool" ]]
    then
        Title "NINESCHOOL"
        rm -rf /etc/eole/eole-db.d/nineschool-db.yml
    fi
fi

if [[ -f "/etc/eole/eole-db.d/nineskeletor-db.yml" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "nineskeletor" ]]
    then
        Title "NINESKELETOR"
        rm -rf /etc/eole/eole-db.d/nineskeletor-db.yml
    fi
fi

if [[ -f "/etc/eole/eole-db.d/ninesurvey-db.yml" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "ninesurvey" ]]
    then
        Title "NINESURVEY"
        rm -rf /etc/eole/eole-db.d/ninesurvey-db.yml
    fi
fi

if [[ -f "//etc/eole/eole-db.d/ninegate-db.yml" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "ninegate" ]]
    then
        Title "NINEGATE"
        rm -rf /etc/eole/eole-db.d/ninegate-db.yml
    fi
fi

# Dicos
if [[ -f "/usr/share/eole/creole/dicos/25_schedule-db.yml" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "schedule" ]]
    then
        Title "SCHEDULE"
        rm -rf /usr/share/eole/creole/dicos/25_schedule.xml
    fi
fi

if [[ -f "/usr/share/eole/creole/dicos/90_janus.xml" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "janus" ]]
    then
        Title "JANUS"
        rm -rf /usr/share/eole/creole/dicos/90_janus.xml
    fi
fi

if [[ -f "/usr/share/eole/creole/dicos/90_ninebadge.xml" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "ninebadge" ]]
    then
        Title "NINEBADGE"
        rm -rf /usr/share/eole/creole/dicos/90_ninebadge.xml
    fi
fi

if [[ -f "/usr/share/eole/creole/dicos/90_nineboard.xml" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "nineboard" ]]
    then
        Title "NINEBOARD"
        rm -rf /usr/share/eole/creole/dicos/90_nineboard.xml
    fi
fi

if [[ -f "/usr/share/eole/creole/dicos/90_ninegitea.xml" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "ninegitea" ]]
    then
        Title "NINEGITEA"
        rm -rf /usr/share/eole/creole/dicos/90_ninegitea.xml
    fi
fi

if [[ -f "/usr/share/eole/creole/dicos/90_nineschool.xml" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "nineschool" ]]
    then
        Title "NINESCHOOL"
        rm -rf /usr/share/eole/creole/dicos/90_nineschool.xml
    fi
fi

if [[ -f "/usr/share/eole/creole/dicos/90_nineskeletor.xml" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "nineskeletor" ]]
    then
        Title "NINESKELETOR"
        rm -rf /usr/share/eole/creole/dicos/90_nineskeletor.xml
    fi
fi

if [[ -f "/usr/share/eole/creole/dicos/90_ninesurvey.xml" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "ninesurvey" ]]
    then
        Title "NINESURVEY"
        rm -rf /usr/share/eole/creole/dicos/90_ninesurvey.xml
    fi
fi

if [[ -f "/usr/share/eole/creole/dicos/91_ninegate.xml" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "ninegate" ]]
    then
        Title "NINEGATE"
        rm -rf /usr/share/eole/creole/dicos/91_ninegate.xml
        rm -rf /usr/share/eole/creole/dicos/91_ninegate_annuaire.xml
    fi
fi

# Service
BigTitle "SERVICE"

if [[ -f "$container_path_web/usr/lib/systemd/system/wssninegate.service" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "ninegate" ]]
    then
        Title "NINEGATE"
        rm -rf $container_path_web/usr/lib/systemd/system/wssninegate.service
        rm -rf $container_path_web/usr/lib/systemd/system/msgninegate.service
    fi
fi

if [[ -f "$container_path_web/usr/lib/systemd/system/wssnineboard.service" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "nineboard" ]]
    then
        Title "NINEBOARD"
        rm -rf $container_path_web/usr/lib/systemd/system/wssnineboard.service
    fi
fi

if [[ -f "$container_path_web/usr/lib/systemd/system/wssnineskeletor.service" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "nineskeletor" ]]
    then
        Title "NINESKELETOR"
        rm -rf $container_path_web/usr/lib/systemd/system/wssnineskeletor.service
    fi
fi

# Pretemplate
BigTitle "PRETEMPLATE"

if [[ -f "/usr/share/eole/pretemplate/25-schedule" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "schedule" ]]
    then
        Title "SCHEDULE"
        rm -rf /usr/share/eole/pretemplate/25-schedule
    fi
fi


if [[ -f "/usr/share/eole/pretemplate/25-nineboard" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "nineboard" ]]
    then
        Title "NINEBOARD"
        rm -rf /usr/share/eole/pretemplate/25-nineboard
    fi
fi

if [[ -f "/usr/share/eole/pretemplate/25-nineschool" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "nineschool" ]]
    then
        Title "NINESCHOOL"
        rm -rf /usr/share/eole/pretemplate/25-nineschool
    fi
fi

if [[ -f "/usr/share/eole/pretemplate/25-nineskeletor" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "nineskeletor" ]]
    then
        Title "NINESKELETOR"
        rm -rf /usr/share/eole/pretemplate/25-nineskeletor
    fi
fi

if [[ -f "/usr/share/eole/pretemplate/25-ninesurvey" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "ninesurvey" ]]
    then
        Title "NINESURVEY"
        rm -rf /usr/share/eole/pretemplate/25-ninesurvey
    fi
fi

if [[ -f "/usr/share/eole/pretemplate/25-ninebadge" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "ninebadge" ]]
    then
        Title "NINEBADGE"
        rm -rf /usr/share/eole/pretemplate/25-ninebadge
    fi
fi

if [[ -f "/usr/share/eole/pretemplate/25-ninegitea" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "ninegitea" ]]
    then
        Title "NINEGITEA"
        rm -rf /usr/share/eole/pretemplate/25-ninegitea
    fi
fi

if [[ -f "/usr/share/eole/pretemplate/25-ninegate" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "ninegate" ]]
    then
        Title "NINEGATE"
        rm -rf /usr/share/eole/pretemplate/25-ninegate
    fi
fi

if [[ -f "/usr/share/eole/pretemplate/25-janus" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "janus" ]]
    then
        Title "JANUS"
        rm -rf /usr/share/eole/pretemplate/25-janus
    fi
fi

# Postservice
BigTitle "POSTSERVICE"

if [[ -f "/usr/share/eole/postservice/00-cdt" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "cdt" ]]
    then
        Title "CDT"
        rm -rf /usr/share/eole/postservice/00-cdt
        echo
    fi
fi

if [[ -f "/usr/share/eole/postservice/00-piwik" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "piwik" ]]
    then
        Title "PIWIK"
        rm -rf /usr/share/eole/postservice/00-piwik
        echo
    fi
fi

if [[ -f "/usr/share/eole/postservice/10-gepi" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "gepi" ]]
    then
        Title "GEPI"
        rm -rf /usr/share/eole/postservice/10-gepi
        echo
    fi
fi

if [[ -f "/usr/share/eole/postservice/10-xdesktop" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "xdesktop" ]]
    then
        Title "XDESKTOP"
        rm -rf /usr/share/eole/postservice/10-xdesktop
        echo
    fi
fi

if [[ -f "/usr/share/eole/postservice/20-dokuwiki" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "dokuwiki" ]]
    then
        Title "DOKUWIKI"
        rm -rf /usr/share/eole/postservice/20-dokuwiki
        echo
    fi
fi

if [[ -f "/usr/share/eole/postservice/20-eportail" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "eportail" ]]
    then
        Title "EPORTAIL"
        rm -rf /usr/share/eole/postservice/20-eportail
        echo
    fi
fi

if [[ -f "/usr/share/eole/postservice/20-limesurvey" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "limesurvey" ]]
    then
        Title "LIMESURVEY"
        rm -rf /usr/share/eole/postservice/20-limesurvey
        echo
    fi
fi

if [[ -f "/usr/share/eole/postservice/20-moodle" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "moodle" ]]
    then
        Title "MOODLE"
        rm -rf /usr/share/eole/postservice/20-moodle
        echo
    fi
fi

if [[ -f "/usr/share/eole/postservice/20-piwigo" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "piwigo" ]]
    then
        Title "PIWIGO"
        rm -rf /usr/share/eole/postservice/20-piwigo
        echo
    fi
fi

if [[ -f "/usr/share/eole/postservice/25-sacoche" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "sacoche" ]]
    then
        Title "SACOCHE"
        rm -rf /usr/share/eole/postservice/25-sacoche
        echo
    fi
fi

if [[ -f "/usr/share/eole/postservice/25-schedule" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "schedule" ]]
    then
        Title "SCHEDULE"
        rm -rf /usr/share/eole/postservice/25-schedule
        echo
    fi
fi

if [[ -f "/usr/share/eole/postservice/30_dispatcher" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "dispatcher" ]]
    then
        Title "DISPATCHER"
        rm -rf /usr/share/eole/postservice/30_dispatcher
        echo
    fi
fi

if [[ -f "/usr/share/eole/postservice/30_econnect" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "econnect" ]]
    then
        Title "ECONNECT"
        rm -rf /usr/share/eole/postservice/30_econnect
        rm -rf /usr/share/eole/postservice/31_econnect_sso
        echo
    fi
fi

if [[ -f "/usr/share/eole/postservice/50-balado" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "balado" ]]
    then
        Title "BALADO"
        rm -rf /usr/share/eole/postservice/50-balado
        echo
    fi
fi

if [[ -f "/usr/share/eole/postservice/50-grr" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "grr" ]]
    then
        Title "GRR"
        rm -rf /usr/share/eole/postservice/50-grr
        echo
    fi
fi

if [[ -f "/usr/share/eole/postservice/50-nextcloud" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "nextcloud" ]]
    then
        Title "NEXTCLOUD"
        rm -rf /usr/share/eole/postservice/50-nextcloud
        echo
    fi
fi

if [[ -f "/usr/share/eole/postservice/51-pydio" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "pydio" ]]
    then
        Title "PYDIO"
        rm -rf /usr/share/eole/postservice/51-pydio
        echo
    fi
fi

if [[ -f "/usr/share/eole/postservice/51-wordpress" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "wordpress" ]]
    then
        Title "WORDPRESS"
        rm -rf /usr/share/eole/postservice/51-wordpress
        echo
    fi
fi

if [[ -f "/usr/share/eole/postservice/60-ethercalc" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "ethercalc" ]]
    then
        Title "ETHERCALC"
        rm -rf /usr/share/eole/postservice/60-ethercalc
        echo
    fi
fi

if [[ -f "/usr/share/eole/postservice/60-zephir-racvision" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "zephir-racvision" ]]
    then
        Title "ZEPHIR RACVISION"
        rm -rf /usr/share/eole/postservice/60-zephir-racvision
        echo
    fi
fi

if [[ -f "/usr/share/eole/postservice/62-etherhome" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "etherhome" ]]
    then
        Title "ETHERHOME"
        rm -rf /usr/share/eole/postservice/62-etherhome
        echo
    fi
fi

if [[ -f "/usr/share/eole/postservice/90-nineboard" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "nineboard" ]]
    then
        Title "NINEBOARD"
        rm -rf /usr/share/eole/postservice/90-nineboard
    fi
fi

if [[ -f "/usr/share/eole/postservice/90-nineschool" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "nineschool" ]]
    then
        Title "NINESCHOOL"
        rm -rf /usr/share/eole/postservice/90-nineschool
    fi
fi

if [[ -f "/usr/share/eole/postservice/90-nineskeletor" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "nineskeletor" ]]
    then
        Title "NINESKELETOR"
        rm -rf /usr/share/eole/postservice/90-nineskeletor
    fi
fi

if [[ -f "/usr/share/eole/postservice/90-ninesurvey" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "ninesurvey" ]]
    then
        Title "NINESURVEY"
        rm -rf /usr/share/eole/postservice/90-ninesurvey
    fi
fi


if [[ -f "/usr/share/eole/postservice/90-janus" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "janus" ]]
    then
        Title "JANUS"
        rm -rf /usr/share/eole/postservice/90-janus
    fi
fi

if [[ -f "/usr/share/eole/postservice/91-ninegate" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "ninegate" ]]
    then
        Title "NINEGATE"
        rm -rf /usr/share/eole/postservice/91-ninegate
    fi
fi

if [[ -f "/usr/share/eole/postservice/95-envole-themes" ]]
then
    if [[ $1 == "" || $1 == "all" || $1 == "envole-themes" ]]
    then
        Title "THEME"
        rm -rf /usr/share/eole/postservice/95-envole-themes
    fi
fi



