#!/bin/bash

###################################################################
# Script de migration vers Envole 4 & Envole 5 & Envole 6         #
###################################################################

#1 : repertoire de stockage de la sauvegarde
#2 : application à restaurer ou all pour restaurer l'ensemble des applications sans question
#3 : lancer le reconfigure en fin de script : yes / no


# Version
# 20160101 = Script de base
# 20160213 = Mise en place de script preRestaure et postRestaure
# 20160323 = Ne pas récupérer les anciennes sources de piwik + se placer dans le repertoire courrant avant rsync de Moodle
# 20200602 = Passage à envole-tools et envole-migrations pour envole 6
# 20251120 = Passage à envole-tools pour envole 9

VERSION="20251120"

#===========================================================================================================================================
#== FONCTION ===============================================================================================================================
#===========================================================================================================================================

. /usr/lib/envole-tools/e-ihm.sh

export MYSQL_PWD="123456"

testcmd(){
    if [ "$1" -ne 0 ];then
        msg="$2"
        [ -z "$msg" ] && msg="Erreur, Abandon."
        EchoRouge "$msg"
        echo
        [ -z "$3" ] && exit 1
    fi
}

testf(){
    if [ ! -e $1 ];    then
        EchoRouge "$1 introuvable, Abandon."
        echo
        exit 1
    fi
}

Alerte01(){
	EchoRouge "Pensez à faire à faire un Maj-Auto avant exécution"	
    echo
    Question_ouinon "Exécution du script de migration d'envole, voulez-vous continuer ?" $interactive "non" "warn"
    testcmd $? "Abandon"
}

trim () { read -r line; echo "$line"; }

#===========================================================================================================================================
#== MONTAGE ================================================================================================================================
#===========================================================================================================================================

montage(){
    # $1 : point de montage
    # $2 : point de montage par défaut
    
    /bin/mkdir -p "$1"
    /bin/umount "$1" 2>/dev/null
    if [ "$2" == "" ] 
    then
        echo
        echo "Quel est le support de sauvegarde ?"
        echo "* support distant  => ex : //machine/partage"
        echo "* disque USB       => ex : /dev/sd.."
        echo "* répertoire local => ex : /root/sauvegarde"
        read peri
    else
        peri=$2
    fi
    
    echo $peri
    if [ "${peri:0:2}" = "//" ]
    then
        echo -n "Entrez un nom d'utilisateur (sinon rien) : "
        read user
        echo Montage de $peri
        [ "$user" != "" ] && mount -t smbfs $peri "$1" -o username=$user || mount -t smbfs $peri "$1" -o password=''
    elif [ "${peri:0:4}" = "/dev" ]
    then
        echo Disque local
        echo Montage de $peri
        /bin/mount $peri "$1"
    elif [ "${peri:0:1}" = "/" ]
    then
    testf $peri
    [ -L "$1" ] && rm -f "$1"
    if [ -d "$1" ];then
        rmdir "$1"
        testcmd $?
    fi
        ln -ns $peri "$1"
    else
        testcmd 1 "Le chemin doit être complet !"
    fi
    testcmd $? "Montage $peri impossible, Abandon."
}



#===========================================================================================================================================
#== DEMONTAGE ==============================================================================================================================
#===========================================================================================================================================

demontage(){
    # $1 : point de montage
    # $2 : point de montage par défaut
    
    Title "Démontage du support"
    if [ "$2" != "" ] 
    then
        /bin/umount "$2"
        [ -L "$2" ] && rm -f "$2"
    else
        /bin/umount "$1"
        [ -L "$1" ] && rm -f "$1"
    fi
    
    echo
}



#===========================================================================================================================================
#== USERBDD ================================================================================================================================
#===========================================================================================================================================

UserBdd(){
    adresse_ip_web=$(CreoleGet adresse_ip_web)
    adresse_ip_br0=$(CreoleGet adresse_ip_br0)
    container_ip_bdd=$(CreoleGet container_ip_bdd)
    
    # Utilisateur bdd
    echo "Génération de l'utilisateur de la bdd"

    echo "grant all privileges on $2.* to $2@$adresse_ip_web identified by '123aze'"  > "$1/temp.sql"
    mysql -h $container_ip_bdd -uroot < "$1/temp.sql"

    echo "grant all privileges on $2.* to $2@$adresse_ip_br0 identified by '123aze'"  > "$1/temp.sql"
    mysql -h $container_ip_bdd -uroot < "$1/temp.sql"
}

#===========================================================================================================================================
#== RESTOAPPLICATION =======================================================================================================================
#===========================================================================================================================================

restoapplication(){
    # $1 : poser la question pour installer
    # $2 : répertoire de sauvegarde
    # $3 : répertoire de l'application
	# $4 : nom du paquet 
	# $5 : nom de la bdd

	SourceO="$2/html"
	SourceD="$container_path_web/var/www/html"

	# Cas particulier Paquet
	Paquet=$3
	if [ "$4" != "" ]
	then
	    Paquet=$4
	fi
	
	# Cas particulier BDD
	Bdd=$3
	if [ "$5" != "" ]
	then
	    Bdd=$5
	fi

    if [[ "$1" == "install" || "$1" == "yes" ]]
    then    
        
        BigTitle "RESTAURATION $3"

        if [ "$1" == "yes" ]
        then
    	    Question_ouinon "Souhaitez-vous restaurer l'application = $3" $interactive "oui" "warn"
	    fi
	    
        if [[ "$?" = 0 || "$1" == "install" ]]
        then
		    # Supprimer le repertoire de l'application s'il existe déjà
		    if [ -d "$SourceD/$3" ]
		    then
		        EchoVert "Suppression du repertoire html existant de l'application avant restauration"
			    rm -rf "$SourceD/$3"
		    fi
		
		    # Recopier le repertoire de l'application
            if [ -d "$SourceO/$3" ]
            then
                EchoVert "Restaurer le repertoire html de l'application"
                cp -rp "$SourceO/$3" "$SourceD/$3"
            fi

            # Restauration www-data
            if [ -d "$2/www-data/var/www/html/$3" ]
            then
		        # Supprimer le repertoire de l'application s'il existe déjà
		        if [ -d "/home/www-data/var/www/html/$3" ]
		        then
		            EchoVert "Suppression du www-data existant de l'application avant restauration"
			        rm -rf "/home/www-data/var/www/html/$3"
		        fi
		        
		        # Recopier le repertoire de l'application
		        EchoVert "Restaurer le repertoire www-data de l'application"
		        cp -rp "$2/www-data/var/www/html/$3" "/home/www-data/var/www/html/$3"
            fi

		    # Restauration BDD
		    if [ -f "$2/mysql/$Bdd.sql" ]
		    then
		        # Suppression de la base de donnée
		        EchoVert "Suppression de la base de données"
		        echo "DROP DATABASE IF EXISTS $Bdd" > "$2/temp.sql"
		        mysql -h $container_ip_bdd -uroot < "$2/temp.sql"

		        # Import de la base de donnée v2
                EchoVert "Génération de la base de données"
                mysql -h $container_ip_bdd -u root < "$2/mysql/$Bdd.sql" > /root/log.log 2>&1
            fi

            # Cas particulier Ethercalc
            if [ "$3" == "ethercalc" ]
            then
                # On écrase la base redis
                if [ -f "$2/redis/dump.rdb" ]
		        then
                    EchoVert "Restauration base redis"
                    service redis-server stop 
                    yes | cp -r -f $2/redis/dump.rdb /var/lib/redis/dump.rdb
                    chown redis:redis /var/lib/redis/dump.rdb
                    service redis-server start
                fi
            fi
                       
		    # Réappliquer les paquets
		    if [ "$Paquet" != "" ]
		    then
                EchoVert "Installation eole-$Paquet"
			    apt-get -y -qq install --reinstall eole-$Paquet >/dev/null 2>&1
                EchoVert "Installation $Paquet-apps"
	            apt-get -y -qq install --reinstall $Paquet-apps >/dev/null 2>&1
		    fi
        fi
    fi
}



#===========================================================================================================================================
#== ENVOLE =================================================================================================================================
#===========================================================================================================================================
#1 = application à restaurer ou all
#2 = eole version
envole(){
    DDS="$DD/scribe-$numero_etab"
    HTMLDIR="$DDS/html"

    Title "Test existance répertoire de sauvegarde"
    testf "$DDS"
    EchoVert "OK"
    
    Title "Arret des services"
    CreoleService smbd stop
    CreoleService nmbd stop

    # On force le mot de passe root
    Title "Modification password root apache"
	mysql_pwd.py 123456 root
	
	# Création du /home/www-data
	if [ ! -d "/home/www-data/var/www/html/" ]
	then
		mkdir -p "/home/www-data/var/www/html/"
		chown www-data:root "/home/www-data" -R
	fi
	
	
	# Patch preRestaure.sh
	if [ -f /usr/lib/envole-tools/preRestaure.sh ]
	then
	    BigTitle "Script preRestaure"
	    /usr/lib/envole-tools/preRestaure.sh
	fi 
	
	# Pour l'ensemble des applications sauvegardées
    for dirname in `ls -1 $HTMLDIR/`
    do
	    # Verifier si on demande la restauration de l'appli
	    if [ "$1" == "allwithquestion" ]
	    then
	        question="yes"
        elif [ "$1" == "all" ]
        then
	        question="install"
        elif [ "$1" == "${dirname}" ]
        then
            question="install"
        else
            question="no"
        fi
        
        # application non maintenu
        torestaure="yes"
        if [ "${question}" != "no" ]
        then
            if [ "${dirname}" = "xdesktop" ] ||
               [ "${dirname}" = "sacoche" ] ||
               [ "${dirname}" = "piwigo" ] ||
               [ "${dirname}" = "mindmaps" ] ||
               [ "${dirname}" = "mahara" ] ||
               [ "${dirname}" = "gepi" ] ||
               [ "${dirname}" = "fluxbb" ] ||
               [ "${dirname}" = "etherhome" ] ||
               [ "${dirname}" = "eportail" ] ||
               [ "${dirname}" = "econnect" ] ||
               [ "${dirname}" = "dokuwiki" ] ||
               [ "${dirname}" = "calendrier" ] ||
               [ "${dirname}" = "balado" ] ||
               [ "${dirname}" = "owncloud" ] ||
               [ "${dirname}" = "bergamote" ] ||
               [ "${dirname}" = "cdc" ] ||
               [ "${dirname}" = "envolemobile" ] ||
               [ "${dirname}" = "fengoffice" ] ||
               [ "${dirname}" = "iconito" ] ||
               [ "${dirname}" = "posh" ] ||
               [ "${dirname}" = "pydio" ] ||
               [ "${dirname}" = "sap" ] ||
               [ "${dirname}" = "spip" ] ||
               [ "${dirname}" = "taskfreak" ] ||
               [ "${dirname}" = "webcalendar" ]
            then
                BigTitle "RESTAURATION $dirname"
                EchoRouge "${dirname^^} non maintenu = il ne sera pas réinstaller"
                torestaure="no"
            fi
        fi

        # restoration des applications
        if [ "$torestaure" = "yes" ]
        then
            if [ "${dirname}" = "edispatcher" ]
            then
                restoapplication $question "$DDS" "$dirname" "dispatcher"
            fi

            if [ "${dirname}" = "grr" ]
            then
                restoapplication $question "$DDS" "$dirname"
            fi

            if [ "${dirname}" = "kanboard" ]
            then
                restoapplication $question "$DDS" "$dirname"
            fi

            if [ "${dirname}" = "limesurvey" ]
            then
                restoapplication $question "$DDS" "$dirname"
            fi

            if [ "${dirname}" = "moodle" ]
            then
                restoapplication $question "$DDS" "$dirname" "moodle-update"
            fi

            if [ "${dirname}" = "nextcloud" ]
            then
                restoapplication $question "$DDS" "$dirname"
            fi

            if [ "${dirname}" = "nineboard" ]
            then
                restoapplication $question "$DDS" "$dirname"
            fi

            if [ "${dirname}" = "ninegate" ]
            then
                restoapplication $question "$DDS" "$dirname"
            fi

            if [ "${dirname}" = "nineschool" ]
            then
                restoapplication $question "$DDS" "$dirname"
            fi

            if [ "${dirname}" = "ninesurvey" ]
            then
                restoapplication $question "$DDS" "$dirname"
            fi

            if [ "${dirname}" = "opensondage" ]
            then
                restoapplication $question "$DDS" "$dirname"
            fi

            if [ "${dirname}" = "piwik" ]
            then
                restoapplication $question "$DDS" "$dirname"
            fi      

            if [ "${dirname}" = "posh-profil" ]
            then
                restoapplication $question "$DDS" "$dirname" "posh-profil" "poshprofile"
            fi  

            if [ "${dirname}" = "roundcube" ]
            then
                restoapplication $question "$DDS" "$dirname"
            fi  

            if [ "${dirname}" = "wordpress" ]
            then
                restoapplication $question "$DDS" "$dirname"
            fi
        fi
    done

    # Cas particulier etherpad = Verifier si on demande la restauration de l'appli
    haveetherpad="no"
    if [ -f "$DDS/mysql/etherpad.sql" ]
    then 
        haveetherpad="yes"
    fi

    if [ "$1" == "allwithquestion" ] || [ "$1" == "all" ] || [ "$1" == "etherpad" ]
    then
        if [ "$1" == "allwithquestion" ]
        then
            question="yes"
        else
            question="install"
        fi

        if [ "$haveetherpad" == "yes" ]
        then
            restoapplication $question "$DDS" "etherpad"
        fi
    fi

    # Cas particulier ethercalc = Verifier si on demande la restauration de l'appli
    haveethercalc="no"
    if [ -f "$DDS/redis/dump.rdb" ]
    then 
        haveethercalc="yes"
    fi

    if [ "$1" == "allwithquestion" ] || [ "$1" == "all" ] || [ "$1" == "ethercalc" ]
    then
        if [ "$1" == "allwithquestion" ]
        then
            question="yes"
        else
            question="install"
        fi

        if [ "$haveethercalc" == "yes" ]
        then
            restoapplication $question "$DDS" "ethercalc"
        fi
    fi


	# Patch preRestaure.sh
	if [ -f /usr/lib/envole-tools/postRestaure.sh ]
	then
	    BigTitle "Script postRestaure"
	    /usr/lib/envole-tools/postRestaure.sh
	fi 
}



#===========================================================================================================================================
#== MAIN ===================================================================================================================================
#===========================================================================================================================================

DD=/media/migration
container_ip_bdd=$(CreoleGet adresse_ip_mysql)

# version 2.4/2.5
if [ -f /usr/lib/eole/ihm.sh ];then
    . /usr/lib/eole/ihm.sh
    numero_etab=$(CreoleGet numero_etab)
    interactive='True'
else
    EchoRouge "Script executable depuis EOLE 2.4 et 2.5 uniquement"
    exit 1        
fi

if [ -z "$numero_etab" ]
then
    EchoRouge "Récupération du numéro d'établissement impossible !"
    exit 1
fi

# Vérifier sur quelle version d'eole 
if [ -f /etc/eole/release ]
then
    . /etc/eole/release
    version="$EOLE_MODULE-$EOLE_VERSION"

    if [ "$EOLE_MODULE" = "scribe" ];then
        BigTitle "RESTAUTRATION ENVOLE $EOLE_VERSION"

        # Demander la location de la sauvegarde
        if [ "$1" == "" ]
        then
            Alerte01
        fi
        montage $DD $1

        # Si aucune application on restaure toutes les applications
        apps=$2
        if [ "$apps" == "" ]
        then
            apps="allwithquestion"
        fi

        # Restauration envole
        envole $apps $EOLE_VERSION

        # Redemarrage des service
        BigTitle "Redemarrage Services"
        demontage $DD $1
        CreoleService smbd start
        CreoleService nmbd start

        BigTitle "Restauration Envole terminée"
        EchoVert  "Restauration Envole terminée"


        if [[ "$3" == "" ]]
        then
            BigTitle "Reconfigure"
            Question_ouinon "Souhaitez-vous exécuter un reconfigure" $interactive "oui" "warn"
            if [ "$?" = 0 ]
            then
                reconfigure
            fi     
        elif [ "$3" == "yes" ]
        then
            BigTitle "Reconfigure"
            reconfigure
        else
            EchoRouge "Pensez à faire un reconfigure"
        fi
    else
        EchoRouge "Module EOLE incompatible"
        exit 1
    fi
else
    EchoRouge "Détection du module impossible !"
    exit 1
fi




echo
exit 0
