// Generated by CoffeeScript 1.6.3
(function() {
  var codename, coffee_css, coffeecup_adapter, coffeescript_helpers, copy_data_to, express, express_partials, flatten, fs, jquery, jquery_minified, jsdom, log, methods, minify, native_array, native_exists, native_existsSync, native_name, native_readFile, native_readFileSync, path, sammy, sammy_minified, socketio, socketio_key, socketjs, uglify, uuid, vendor, zappa, zappa_fs, _ref, _ref1,
    __slice = [].slice,
    __indexOf = [].indexOf || function(item) { for (var i = 0, l = this.length; i < l; i++) { if (i in this && this[i] === item) return i; } return -1; };

  zappa = {
    version: '0.4.22'
  };

  codename = 'You can\'t do that on stage anymore';

  log = console.log;

  fs = require('fs');

  path = require('path');

  uuid = require('node-uuid');

  uglify = require('uglify-js');

  methods = require('methods');

  vendor = function(name) {
    return fs.readFileSync(path.join(__dirname, '..', 'vendor', name)).toString();
  };

  jquery = vendor('jquery.js');

  jquery_minified = vendor('jquery.min.js');

  sammy = vendor('sammy.js');

  sammy_minified = vendor('sammy.min.js');

  socketjs = vendor('socket.io.js');

  socketio_key = '__session';

  jsdom = null;

  express_partials = null;

  coffee_css = null;

  coffeescript_helpers = "var __slice = Array.prototype.slice;\nvar __hasProp = Object.prototype.hasOwnProperty;\nvar __bind = function(fn, me){\n  return function(){ return fn.apply(me, arguments); };\n};\nvar __extends = function(child, parent) {\n  for (var key in parent) {\n    if (__hasProp.call(parent, key)) child[key] = parent[key];\n  }\n  function ctor() { this.constructor = child; }\n  ctor.prototype = parent.prototype;\n  child.prototype = new ctor;\n  child.__super__ = parent.prototype;\n  return child;\n};\nvar __indexOf = Array.prototype.indexOf || function(item) {\n  for (var i = 0, l = this.length; i < l; i++) {\n    if (this[i] === item) return i;\n  } return -1; };".replace(/\n/g, '');

  minify = function(js) {
    var result;
    result = uglify.minify(js, {
      fromString: true
    });
    return result.code;
  };

  copy_data_to = function(recipient, sources) {
    var k, obj, v, _i, _len;
    for (_i = 0, _len = sources.length; _i < _len; _i++) {
      obj = sources[_i];
      for (k in obj) {
        v = obj[k];
        if (!recipient[k]) {
          recipient[k] = v;
        }
      }
    }
  };

  flatten = function(arr, ret) {
    var o, _i, _len;
    if (ret == null) {
      ret = [];
    }
    for (_i = 0, _len = arr.length; _i < _len; _i++) {
      o = arr[_i];
      if (Array.isArray(o)) {
        flatten(o, ret);
      } else {
        ret.push(o);
      }
    }
    return ret;
  };

  zappa_fs = {};

  native_name = function(p) {
    return p.replace(/\/\.zappa-[^\/]+/, '');
  };

  native_readFileSync = fs.readFileSync;

  native_readFile = fs.readFile;

  native_array = function() {
    var args;
    args = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
    args[0] = native_name(args[0]);
    return args;
  };

  fs.readFileSync = function(p, encoding) {
    var _ref;
    return (_ref = zappa_fs[p]) != null ? _ref : native_readFileSync.apply(fs, native_array.apply(null, arguments));
  };

  fs.readFile = function(p, encoding, callback) {
    var view;
    view = zappa_fs[p];
    if (view) {
      if (typeof encoding === 'function' && (callback == null)) {
        callback = encoding;
      }
      return callback(null, view);
    } else {
      return native_readFile.apply(fs, native_array.apply(null, arguments));
    }
  };

  native_existsSync = (_ref = fs.existsSync) != null ? _ref : path.existsSync;

  native_exists = (_ref1 = fs.exists) != null ? _ref1 : path.exists;

  path.existsSync = fs.existsSync = function(p) {
    return (zappa_fs[p] != null) || native_existsSync.apply(fs, native_array.apply(null, arguments));
  };

  path.exists = fs.exists = function(p, callback) {
    if (zappa_fs[p] != null) {
      return callback(true);
    } else {
      return native_exists.apply(fs, native_array.apply(null, arguments));
    }
  };

  express = require('express');

  socketio = require('socket.io');

  zappa.app = function() {
    var a, app, apply_helpers, client, client_bundle_simple, client_bundled, context, func, helpers, io, options, partials, postrenders, real_root, request_socket, root, route, socket_session, use_middleware, verb, wrap_middleware, ws_handlers, zappa_prefix, zappa_used, _fn, _i, _j, _len, _len1, _ref2, _ref3;
    for (_i = 0, _len = arguments.length; _i < _len; _i++) {
      a = arguments[_i];
      switch (typeof a) {
        case 'function':
          func = a;
          break;
        case 'object':
          options = a;
      }
    }
    if (options == null) {
      options = {};
    }
    context = {
      id: uuid.v4(),
      zappa: zappa,
      express: express
    };
    real_root = path.dirname(module.parent.filename);
    root = path.join(real_root, ".zappa-" + context.id);
    ws_handlers = {};
    helpers = {};
    postrenders = {};
    partials = {};
    app = context.app = express();
    if (options.https != null) {
      context.server = require('https').createServer(options.https, app);
    } else {
      context.server = require('http').createServer(app);
    }
    if (options.disable_io) {
      io = null;
    } else {
      io = context.io = socketio.listen(context.server, (_ref2 = options.io) != null ? _ref2 : {});
    }
    client = null;
    client_bundled = null;
    client_bundle_simple = null;
    zappa_used = false;
    app.set('view engine', 'coffee');
    app.engine('coffee', coffeecup_adapter);
    app.set('views', path.join(root, '/views'));
    app.set('zappa_prefix', '/zappa');
    _ref3 = __slice.call(methods).concat(['del'], ['all']);
    _fn = function(verb) {
      return context[verb] = function() {
        var args, arity, k, v, _ref4;
        args = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
        arity = args.length;
        if (arity > 1) {
          route({
            verb: verb,
            path: args[0],
            middleware: flatten(args.slice(1, arity - 1)),
            handler: args[arity - 1]
          });
        } else {
          _ref4 = arguments[0];
          for (k in _ref4) {
            v = _ref4[k];
            route({
              verb: verb,
              path: k,
              handler: v
            });
          }
        }
      };
    };
    for (_j = 0, _len1 = _ref3.length; _j < _len1; _j++) {
      verb = _ref3[_j];
      _fn(verb);
    }
    context.client = function(obj) {
      var js, k, v;
      if (!zappa_used) {
        context.use('zappa');
      }
      for (k in obj) {
        v = obj[k];
        js = ";zappa.run(" + v + ");";
        if (app.settings['minify']) {
          js = minify(js);
        }
        route({
          verb: 'get',
          path: k,
          handler: js,
          contentType: 'js'
        });
      }
    };
    context.coffee = function(obj) {
      var js, k, v;
      for (k in obj) {
        v = obj[k];
        js = ";" + coffeescript_helpers + "(" + v + ")();";
        if (app.settings['minify']) {
          js = minify(js);
        }
        route({
          verb: 'get',
          path: k,
          handler: js,
          contentType: 'js'
        });
      }
    };
    context.js = function(obj) {
      var js, k, v;
      for (k in obj) {
        v = obj[k];
        js = String(v);
        if (app.settings['minify']) {
          js = minify(js);
        }
        route({
          verb: 'get',
          path: k,
          handler: js,
          contentType: 'js'
        });
      }
    };
    context.css = function(obj) {
      var css, k, v;
      for (k in obj) {
        v = obj[k];
        if (typeof v === 'object') {
          if (coffee_css == null) {
            coffee_css = require('coffee-css');
          }
          css = coffee_css.compile(v);
        } else {
          css = String(v);
        }
        route({
          verb: 'get',
          path: k,
          handler: css,
          contentType: 'css'
        });
      }
    };
    context["with"] = function(obj) {
      var k, v, zappa_with, _results;
      zappa_with = {
        css: function(modules) {
          var module, name, _k, _len2;
          if (typeof modules === 'string') {
            modules = [modules];
          }
          for (_k = 0, _len2 = modules.length; _k < _len2; _k++) {
            name = modules[_k];
            module = require(name);
            context[name] = function(obj) {
              var k, v;
              for (k in obj) {
                v = obj[k];
                module.render(v, {
                  filename: k
                }, function(err, css) {
                  if (err) {
                    throw err;
                  }
                  return route({
                    verb: 'get',
                    path: k,
                    handler: css,
                    contentType: 'css'
                  });
                });
              }
            };
          }
        }
      };
      _results = [];
      for (k in obj) {
        v = obj[k];
        if (zappa_with[k]) {
          _results.push(zappa_with[k](v));
        } else {
          _results.push(void 0);
        }
      }
      return _results;
    };
    context.helper = function(obj) {
      var k, v;
      for (k in obj) {
        v = obj[k];
        helpers[k] = v;
      }
    };
    context.postrender = function(obj) {
      var k, v;
      jsdom = require('jsdom');
      for (k in obj) {
        v = obj[k];
        postrenders[k] = v;
      }
    };
    context.on = function(obj) {
      var k, v;
      for (k in obj) {
        v = obj[k];
        ws_handlers[k] = v;
      }
    };
    context.view = function(obj) {
      var ext, k, p, v;
      for (k in obj) {
        v = obj[k];
        ext = path.extname(k);
        p = path.join(app.get('views'), k);
        zappa_fs[p] = v;
        if (!ext) {
          ext = '.' + app.get('view engine');
          zappa_fs[p + ext] = v;
        }
      }
    };
    context.engine = function(obj) {
      var k, v;
      for (k in obj) {
        v = obj[k];
        app.engine(k, v);
      }
    };
    context.set = function(obj) {
      var k, v;
      for (k in obj) {
        v = obj[k];
        app.set(k, v);
      }
    };
    context.enable = function() {
      var i, _k, _len2;
      for (_k = 0, _len2 = arguments.length; _k < _len2; _k++) {
        i = arguments[_k];
        app.enable(i);
      }
    };
    context.disable = function() {
      var i, _k, _len2;
      for (_k = 0, _len2 = arguments.length; _k < _len2; _k++) {
        i = arguments[_k];
        app.disable(i);
      }
    };
    wrap_middleware = function(f) {
      return function(req, res, next) {
        var ctx;
        ctx = {
          app: app,
          settings: app.settings,
          locals: res.locals,
          request: req,
          req: req,
          query: req.query,
          params: req.params,
          body: req.body,
          session: req.session,
          response: res,
          res: res,
          next: next
        };
        apply_helpers(ctx);
        if (app.settings['databag']) {
          ctx.data = {};
          copy_data_to(ctx.data, [req.query, req.params, req.body]);
        }
        return f.call(ctx, req, res, next);
      };
    };
    context.middleware = function(f) {
      if (app.settings['magic middleware']) {
        return f;
      } else {
        return wrap_middleware(f);
      }
    };
    use_middleware = function(f) {
      if (app.settings['magic middleware']) {
        return wrap_middleware(f);
      } else {
        return f;
      }
    };
    context.use = function() {
      var k, use, v, zappa_middleware, _k, _len2;
      zappa_middleware = {
        "static": function(options) {
          var p, _ref4;
          if (typeof options === 'string') {
            options = {
              path: options
            };
          }
          if (options == null) {
            options = {};
          }
          p = (_ref4 = options.path) != null ? _ref4 : path.join(real_root, '/public');
          delete options.path;
          return express["static"](p, options);
        },
        zappa: function() {
          zappa_used = true;
          return function(req, res, next) {
            var send, zappa_prefix;
            send = function(code) {
              res.contentType('js');
              return res.send(code);
            };
            if (req.method.toUpperCase() !== 'GET') {
              next();
            } else {
              zappa_prefix = app.settings['zappa_prefix'];
              switch (req.url) {
                case zappa_prefix + '/Zappa.js':
                  send(client_bundled);
                  break;
                case zappa_prefix + '/Zappa-simple.js':
                  send(client_bundle_simple);
                  break;
                case zappa_prefix + '/zappa.js':
                  send(client);
                  break;
                case zappa_prefix + '/jquery.js':
                  send(jquery_minified);
                  break;
                case zappa_prefix + '/sammy.js':
                  send(sammy_minified);
                  break;
                default:
                  next();
              }
            }
          };
        },
        partials: function(maps) {
          var k, v;
          if (maps == null) {
            maps = {};
          }
          if (express_partials == null) {
            express_partials = require('zappajs-partials');
          }
          partials = express_partials();
          partials.register('coffee', coffeecup_adapter.render);
          for (k in maps) {
            v = maps[k];
            partials.register(k, v);
          }
          return partials;
        },
        session: function(options) {
          context.session_store = options.store;
          return express.session(options);
        }
      };
      use = function(name, arg) {
        if (arg == null) {
          arg = null;
        }
        if (zappa_middleware[name]) {
          return app.use(zappa_middleware[name](arg));
        } else if (typeof express[name] === 'function') {
          return app.use(use_middleware(express[name](arg)));
        } else {
          throw "Unknown middleware " + name;
        }
      };
      for (_k = 0, _len2 = arguments.length; _k < _len2; _k++) {
        a = arguments[_k];
        switch (typeof a) {
          case 'function':
            app.use(use_middleware(a));
            break;
          case 'string':
            use(a);
            break;
          case 'object':
            if ((a.stack != null) || (a.route != null) || (a.handle != null)) {
              app.use(a);
            } else {
              for (k in a) {
                v = a[k];
                use(k, v);
              }
            }
        }
      }
    };
    context.configure = function(p) {
      var k, v;
      if (typeof p === 'function') {
        app.configure(p);
      } else {
        for (k in p) {
          v = p[k];
          app.configure(k, v);
        }
      }
    };
    context.settings = app.settings;
    context.locals = app.locals;
    context.shared = function(obj) {
      var js, k, v;
      if (!zappa_used) {
        context.use('zappa');
      }
      for (k in obj) {
        v = obj[k];
        js = ";zappa.run(" + v + ");";
        if (app.settings['minify']) {
          js = minify(js);
        }
        route({
          verb: 'get',
          path: k,
          handler: js,
          contentType: 'js'
        });
        v.apply(context);
      }
    };
    context.include = function(p) {
      var sub;
      sub = typeof p === 'string' ? require(path.join(real_root, p)) : p;
      return sub.include.apply(context);
    };
    apply_helpers = function(ctx) {
      var helper, name, _fn1;
      _fn1 = function(name, helper) {
        if (typeof helper === 'function') {
          ctx[name] = function() {
            return helper.apply(ctx, arguments);
          };
        } else {
          ctx[name] = helper;
        }
      };
      for (name in helpers) {
        helper = helpers[name];
        _fn1(name, helper);
      }
      return ctx;
    };
    request_socket = function(req) {
      var socket_id, _ref4, _ref5, _ref6;
      socket_id = (_ref4 = req.session) != null ? (_ref5 = _ref4.__socket) != null ? (_ref6 = _ref5['__local']) != null ? _ref6.id : void 0 : void 0 : void 0;
      return socket_id && (io != null ? io.sockets.socket(socket_id, true) : void 0);
    };
    socket_session = function(socket, cb) {
      return socket.get(socketio_key, function(err, data) {
        if (err) {
          return cb(err);
        }
        data = JSON.parse(data);
        if (data.id != null) {
          return context.session_store.get(data.id, cb);
        } else {
          return cb(err);
        }
      });
    };
    context.param = function(obj) {
      var build, k, v;
      build = function(callback) {
        return function(req, res, next, p) {
          var ctx;
          ctx = {
            app: app,
            settings: app.settings,
            locals: res.locals,
            request: req,
            req: req,
            query: req.query,
            params: req.params,
            body: req.body,
            session: req.session,
            response: res,
            res: res,
            next: next,
            param: p
          };
          apply_helpers(ctx);
          return callback.call(ctx, req, res, next, p);
        };
      };
      for (k in obj) {
        v = obj[k];
        this.app.param(k, build(v));
      }
    };
    route = function(r) {
      if (r.middleware == null) {
        r.middleware = [];
      }
      r.middleware = r.middleware.map(wrap_middleware);
      if (typeof r.handler === 'string') {
        return app[r.verb](r.path, r.middleware, function(req, res) {
          if (r.contentType != null) {
            res.contentType(r.contentType);
          }
          res.send(r.handler);
        });
      } else {
        return app[r.verb](r.path, r.middleware, function(req, res, next) {
          var ctx, render, result;
          ctx = {
            app: app,
            settings: app.settings,
            locals: res.locals,
            request: req,
            req: req,
            query: req.query,
            params: req.params,
            body: req.body,
            session: req.session,
            response: res,
            res: res,
            next: next,
            send: function() {
              return res.send.apply(res, arguments);
            },
            json: function() {
              return res.json.apply(res, arguments);
            },
            jsonp: function() {
              return res.jsonp.apply(res, arguments);
            },
            redirect: function() {
              return res.redirect.apply(res, arguments);
            },
            format: function() {
              return res.format.apply(res, arguments);
            },
            render: function() {
              var k, v, _ref4;
              if (typeof arguments[0] !== 'object') {
                render.apply(this, arguments);
              } else {
                _ref4 = arguments[0];
                for (k in _ref4) {
                  v = _ref4[k];
                  render.apply(this, [k, v]);
                }
              }
            },
            emit: function() {
              var k, socket, v, _ref4;
              socket = request_socket(req);
              if (socket != null) {
                if (typeof arguments[0] !== 'object') {
                  socket.emit.apply(socket, arguments);
                } else {
                  _ref4 = arguments[0];
                  for (k in _ref4) {
                    v = _ref4[k];
                    socket.emit.apply(socket, [k, v]);
                  }
                }
              }
            }
          };
          render = function(name, opts, fn) {
            var postrender, report;
            if (opts == null) {
              opts = {};
            }
            report = fn != null ? fn : function(err, html) {
              if (err) {
                return next(err);
              } else {
                return res.send(html);
              }
            };
            if (typeof opts === 'function') {
              fn = opts;
              opts = {};
            }
            if (app.settings['databag']) {
              opts.params = ctx.data;
            }
            if (opts.postrender == null) {
              postrender = report;
            } else {
              postrender = function(err, str) {
                if (err) {
                  return report(err);
                }
                jsdom.env({
                  html: str,
                  src: [jquery],
                  done: function(err, window) {
                    var doctype, html, rendered;
                    if (err) {
                      return report(err);
                    }
                    ctx.window = window;
                    rendered = postrenders[opts.postrender].apply(ctx, [window.$]);
                    doctype = (window.document.doctype || '') + "\n";
                    html = doctype + window.document.documentElement.outerHTML;
                    return report(null, html);
                  }
                });
              };
            }
            return res.render.call(res, name, opts, postrender);
          };
          apply_helpers(ctx);
          if (app.settings['databag']) {
            ctx.data = {};
            copy_data_to(ctx.data, [req.query, req.params, req.body]);
          }
          if (app.settings['x-powered-by']) {
            res.setHeader('X-Powered-By', "Zappa " + zappa.version);
          }
          result = r.handler.call(ctx, req, res, next);
          if (r.contentType != null) {
            res.contentType(r.contentType);
          }
          if (typeof result === 'string') {
            return res.send(result);
          } else {
            return result;
          }
        });
      }
    };
    if (io != null) {
      io.sockets.on('connection', function(socket) {
        var build_ctx, c, ctx, h, name, _fn1;
        c = {};
        build_ctx = function() {
          var ctx;
          ctx = {
            app: app,
            io: io,
            settings: app.settings,
            locals: app.locals,
            socket: socket,
            id: socket.id,
            client: c,
            join: function(room) {
              return socket.join(room);
            },
            leave: function(room) {
              return socket.leave(room);
            },
            emit: function() {
              var k, v, _ref4;
              if (typeof arguments[0] !== 'object') {
                socket.emit.apply(socket, arguments);
              } else {
                _ref4 = arguments[0];
                for (k in _ref4) {
                  v = _ref4[k];
                  socket.emit.apply(socket, [k, v]);
                }
              }
            },
            broadcast: function() {
              var broadcast, k, v, _ref4;
              broadcast = socket.broadcast;
              if (typeof arguments[0] !== 'object') {
                broadcast.emit.apply(broadcast, arguments);
              } else {
                _ref4 = arguments[0];
                for (k in _ref4) {
                  v = _ref4[k];
                  broadcast.emit.apply(broadcast, [k, v]);
                }
              }
            },
            broadcast_to: function() {
              var args, k, room, v, _ref4;
              room = arguments[0], args = 2 <= arguments.length ? __slice.call(arguments, 1) : [];
              room = io.sockets["in"](room);
              if (typeof args[0] !== 'object') {
                room.emit.apply(room, args);
              } else {
                _ref4 = args[0];
                for (k in _ref4) {
                  v = _ref4[k];
                  room.emit.apply(room, [k, v]);
                }
              }
            },
            session: function() {
              return socket_session.apply(null, [socket].concat(__slice.call(arguments)));
            }
          };
          apply_helpers(ctx);
          return ctx;
        };
        ctx = build_ctx();
        if (ws_handlers.connection != null) {
          ws_handlers.connection.apply(ctx);
        }
        socket.on('disconnect', function() {
          ctx = build_ctx();
          if (ws_handlers.disconnect != null) {
            return ws_handlers.disconnect.apply(ctx);
          }
        });
        _fn1 = function(name, h) {
          if (name !== 'connection' && name !== 'disconnect') {
            socket.on(name, function(data, ack) {
              ctx = build_ctx();
              ctx.data = data;
              ctx.ack = ack;
              return h.call(ctx, data, ack);
            });
          }
        };
        for (name in ws_handlers) {
          h = ws_handlers[name];
          _fn1(name, h);
        }
      });
    }
    func.apply(context);
    client = require('./client').build(zappa.version, app.settings);
    client = ";" + coffeescript_helpers + "(" + client + ")();";
    client_bundle_simple = io != null ? jquery + socketjs + client : jquery + client;
    client_bundled = io != null ? jquery + socketjs + sammy + client : jquery + sammy + client;
    if (app.settings['minify']) {
      client = minify(client);
      client_bundle_simple = minify(client_bundle_simple);
      client_bundled = minify(client_bundled);
    }
    if (app.settings['default layout']) {
      context.view({
        layout: function() {
          var extension;
          extension = function(path, ext) {
            if (path.substr(-ext.length).toLowerCase() === ext.toLowerCase()) {
              return path;
            } else {
              return path + ext;
            }
          };
          doctype(5);
          return html(function() {
            head(function() {
              var s, _k, _l, _len2, _len3, _ref4, _ref5;
              if (this.title) {
                title(this.title);
              }
              if (this.scripts) {
                _ref4 = this.scripts;
                for (_k = 0, _len2 = _ref4.length; _k < _len2; _k++) {
                  s = _ref4[_k];
                  script({
                    src: extension(s, '.js')
                  });
                }
              }
              if (this.script) {
                script({
                  src: extension(this.script, '.js')
                });
              }
              if (this.stylesheets) {
                _ref5 = this.stylesheets;
                for (_l = 0, _len3 = _ref5.length; _l < _len3; _l++) {
                  s = _ref5[_l];
                  link({
                    rel: 'stylesheet',
                    href: extension(s, '.css')
                  });
                }
              }
              if (this.stylesheet) {
                link({
                  rel: 'stylesheet',
                  href: extension(this.stylesheet, '.css')
                });
              }
              if (this.style) {
                return style(this.style);
              }
            });
            return body(this.body);
          });
        }
      });
    }
    if (io != null) {
      zappa_prefix = app.settings['zappa_prefix'];
      context.get(zappa_prefix + '/socket/:channel_name/:socket_id', function() {
        var channel_name, io_client, io_data, key, socket_id, _base;
        if (this.session != null) {
          channel_name = this.params.channel_name;
          socket_id = this.params.socket_id;
          if ((_base = this.session).__socket == null) {
            _base.__socket = {};
          }
          if (this.session.__socket[channel_name] != null) {
            this.send({
              error: 'Channel already assigned',
              channel_name: channel_name
            });
          } else {
            key = uuid.v4();
            this.session.__socket[channel_name] = {
              id: socket_id,
              key: key
            };
            io_client = io.sockets.store.client(socket_id);
            io_data = JSON.stringify({
              id: this.req.sessionID,
              key: key
            });
            io_client.set(socketio_key, io_data);
            this.send({
              channel_name: channel_name,
              key: key
            });
          }
        } else {
          this.send({
            error: 'No session'
          });
        }
      });
    }
    return context;
  };

  zappa.run = function() {
    var a, app, express_ready, host, k, options, port, root_function, v, zapp, _i, _len;
    host = null;
    port = 3000;
    root_function = null;
    options = {
      disable_io: false
    };
    for (_i = 0, _len = arguments.length; _i < _len; _i++) {
      a = arguments[_i];
      switch (typeof a) {
        case 'string':
          if (isNaN(Number(a))) {
            host = a;
          } else {
            port = Number(a);
          }
          break;
        case 'number':
          port = a;
          break;
        case 'function':
          root_function = a;
          break;
        case 'object':
          for (k in a) {
            v = a[k];
            switch (k) {
              case 'host':
                host = v;
                break;
              case 'port':
                port = v;
                break;
              case 'disable_io':
                options.disable_io = v;
                break;
              case 'https':
                options.https = v;
            }
          }
      }
    }
    zapp = zappa.app(root_function, options);
    app = zapp.app;
    express_ready = function() {
      var _ref2;
      log('Express server listening on port %d in %s mode', (_ref2 = zapp.server.address()) != null ? _ref2.port : void 0, app.settings.env);
      return log("Zappa " + zappa.version + " \"" + codename + "\" orchestrating the show");
    };
    if (host) {
      zapp.server.listen(port, host, express_ready);
    } else {
      zapp.server.listen(port, express_ready);
    }
    return zapp;
  };

  zappa.adapter = function(engine, options) {
    var compile, render, renderFile;
    if (options == null) {
      options = {};
    }
    if (options.blacklist == null) {
      options.blacklist = [];
    }
    if (typeof engine === 'string') {
      engine = require(engine);
    }
    compile = function(template, data) {
      template = engine.compile(template, data);
      return function(data) {
        var k, v, _ref2;
        _ref2 = data.params;
        for (k in _ref2) {
          v = _ref2[k];
          if (typeof data[k] === 'undefined' && __indexOf.call(options.blacklist, k) < 0) {
            data[k] = v;
          }
        }
        return template(data);
      };
    };
    render = function(template, data) {
      template = compile(template, data);
      return template(data);
    };
    renderFile = function(name, data, fn) {
      var err, template;
      try {
        template = fs.readFileSync(name, 'utf8');
        template = compile(template, data);
      } catch (_error) {
        err = _error;
        return fn(err);
      }
      return fn(null, template(data));
    };
    renderFile.compile = compile;
    renderFile.render = render;
    return renderFile;
  };

  coffeecup_adapter = zappa.adapter('coffeecup', {
    blacklist: ['format', 'autoescape', 'locals', 'hardcode', 'cache']
  });

  module.exports = zappa.run;

  module.exports.run = zappa.run;

  module.exports.app = zappa.app;

  module.exports.adapter = zappa.adapter;

  module.exports.version = zappa.version;

}).call(this);
