<?php

namespace Kanboard\Plugin\PhpcasAuth;

use Kanboard\Core\Plugin\Base;
use Kanboard\Core\Security\Role;
use Kanboard\Plugin\PhpcasAuth\Auth\PhpcasAuthProvider;


class Plugin extends Base
{
    public function initialize()
    {
        // Provider d'identité
        $this->authenticationManager->register(new PhpcasAuthProvider($this->container));

        // Controler 
        $this->applicationAccessMap->add('PhpcasController', 'login', Role::APP_PUBLIC);
        
        // Hook sur la page de login
        $this->template->hook->attach('template:auth:login-form:before', 'PhpcasAuth:login');
        $this->template->hook->attach('template:header:dropdown', 'PhpcasAuth:logout');
        //$this->template->hook->attach('template:dashboard:sidebar', 'PhpcasAuth:login');
    }

    public function getPluginName()
    {
        return 'PhpCAS Authentication';
    }

    public function getPluginDescription()
    {
        return t('Use PhpCAS connecteur');
    }

    public function getPluginAuthor()
    {
        return 'Projet Envole';
    }

    public function getPluginVersion()
    {
        return '1.0.0';
    }

    public function getPluginHomepage()
    {
        return 'https://dev-eole.ac-dijon.fr/projects/envole?jump=welcome';
    }

    public function getCompatibleVersion()
    {
        return '>=1.0.37';
    }
}
