<?php

require_once 'CAS-1.3.1/eoleCAS.php';
require_once 'configCAS/cas.inc.php';

if (method_exists("eolephpCAS", "EoleTestphpCAS")){
    if(!eolephpCAS::EoleTestphpCAS()) {
        eolephpCAS::client(__CAS_VERSION, __CAS_SERVER, __CAS_PORT, __CAS_FOLDER, false);
    }
}


class AuthCAS extends AuthPluginBase
{
    
    
    protected $storage = 'DbStorage';

    static protected $description = 'CAS authentication';
    static protected $name = 'AuthCAS';

    protected $settings = array(
        'autoCreate' => array(
            'type' => 'checkbox',
            'label' => 'Auto Create',
            'default' => '1',
        ),
        'errorMessage' => array(
            'type' => 'string',
            'label' => 'Message d\'erreur quand erreur sur autocreate',
            'default' => 'Une erreur s\'est produite, merci de contacter la personne en charge de Limesurvey.',
        ),
        'autocreateMessage' => array(
            'type' => 'string',
            'label' => 'Message d\'erreur quand utilisateur non autorisé',
            'default' => 'Vous devez demander une création de compte avant de pouvoir utiliser Limesurvey.',
        )
    );

    public function init()
    {
        /**
         * Here you should handle subscribing to the events your plugin will handle
         */
        if($_SERVER["SCRIPT_URL"]!="/limesurvey/index.php/admin/remotecontrol") {
            $this->subscribe('beforeLogin');
            $this->subscribe('newUserSession');
            $this->subscribe('afterLogout');
        }
    }


    public function beforeLogin()
    {
        if($_SESSION["user"]!="restuser") {
            if (__CAS_VALIDER_CA) {
                EolephpCAS::setCasServerCACert(__CAS_CA_LOCATION); // v?rification par rapport ? la CA
            } else {
                if (method_exists("EolephpCAS", "setNoCasServerValidation")){
                    EolephpCAS::setNoCasServerValidation();
                }
            }

            eolephpCAS::setNoClearTicketsFromUrl();
            //forcer à redemander les infos auprès du serveur CAS (au lieu de les lire en session alors que ce serait les infos d'une autre appli...)
            if(isset($_SESSION["phpCAS"])) unset($_SESSION["phpCAS"]);
            //authentification
            eolephpCAS::forceAuthentication();

            $user = eolephpCAS::getUser();
            $this->setUsername($user);
            //To bypass the login form
            $this->setAuthPlugin();
        }
        
    }

    public function newUserSession()
    {
        $sUser = $this->getUserName();
        $oUser = $this->api->getUserByName($sUser);
        
        // Get user details du SSO filter
        $userinfos = eolephpCAS::getDetails();
		if(!isset($userinfos["utilisateur"])&&isset($userinfos["attributes"])) {
			$userinfos["utilisateur"]=$userinfos["attributes"];
        }
                
        // get settings
        $pluginsettings = $this->getPluginSettings(true);
        
        // Sonde piwik
        $_SESSION['profil_piwik'] = $userinfos['infos']['ENTPersonProfils'][0];
        if (!is_null($oUser))
        {
            /* Ne plus réinitialiser les permissions
            $permission=new Permission;
            $permission->setPermissions($oUser->uid, 0, 'global', Array('surveys' => array('create'=>true,'read'=>false,'update'=>false,'delete'=>false)), true);
            */

            $this->setAuthSuccess($oUser);
            return;
        } else {
            // autocreate user
            if ($pluginsettings['autoCreate']['current'] == 1) {
                $usermail = $userinfos['utilisateur']['email'][0];
                $userfirstname = $userinfos['utilisateur']['firstname'][0];
                $userlastname = $userinfos['utilisateur']['lastname'][0];
                //Si adresse non renseigné dans le LDAP (ce qui ne devrait pas arriver..) on crée une fausse adresse pour éviter les erreurs
                if($usermail=="")$usermail=$userfirstname.".".$userlastname."@".$_SERVER['HTTP_HOST'];
                // Rempli l'objet user
                $oUser=new User;
                $oUser->users_name=$sUser;
                $oUser->password=hash('sha256', createPassword());
                $oUser->full_name=$userfirstname." ".$userlastname;
                $oUser->parent_id=1;
                $oUser->lang="fr";
                $oUser->email=$usermail;
                // On ajoute en bdd et on définit les permissions
                if ($oUser->save()) {
                    $permission=new Permission;
                    $permission->setPermissions($oUser->uid, 0, 'global', Array('surveys' => array('create'=>true,'read'=>false,'update'=>false,'delete'=>false)), true);
                    // on peut maintenant authentifier l'user nouvellement créé
                    $this->setAuthSuccess($oUser);
                    return;
                } else {
                    echo $pluginsettings['errorMessage']['current'];
                    die();
                }
            } else {
                echo $pluginsettings['autocreateMessage']['current'];
                die();
            }
        }
    }

    public function afterLogout()
    {
        session_destroy();
        //eolephpCAS::logoutWithUrl($_SERVER['HTTP_REFERER']);
        eolephpCAS::logout(array("service"=>$_SERVER['HTTP_REFERER']));
    }


    public function beforeSurveySettings()
    {
        $event = $this->event;
        $event->set("surveysettings.{$this->id}", array(
            'name' => get_class($this),
            'settings' => array(
                'message' => array(
                    'type' => 'string',
                    'label' => 'Message to show to users:',
                    'current' => $this->get('message', 'Survey', $event->get('survey'))
                )
            )
         ));
    }

    public function newSurveySettings()
    {
        $event = $this->event;
        foreach ($event->get('settings') as $name => $value)
        {
            $this->set($name, $value, 'Survey', $event->get('survey'));
        }
    }
}

?>
