<?php
    class AddUserCommand extends CConsoleCommand
    {
        public $connection;

        public function run($sArgument)
        {
            # 0 = username
            # 1 = email
            if (isset($sArgument) && isset($sArgument[0]) && isset($sArgument[1])) {
                Yii::import('application.helpers.common_helper', true);
                Yii::import('application.helpers.sanitize_helper', true);

                $userlogin=$this->frmshell($sArgument[0]);
                $usermail = $this->frmshell($sArgument[1]);
                $userfirstname = $this->frmshell($sArgument[2]);
                $userlastname = $this->frmshell($sArgument[3]);

                $oUser = User::findByUsername($userlogin);
                if (is_null($oUser)) {
                    echo "$userlogin = CREATION";

                    //Si adresse non renseigné dans le LDAP (ce qui ne devrait pas arriver..) on crée une fausse adresse pour éviter les erreurs
                    if($usermail=="")$usermail=$userfirstname.".".$userlastname."@".$_SERVER['HTTP_HOST'];
                    
                    // Rempli l'objet user
                    $oUser=new User;
                    $oUser->users_name=$userlogin;
                    $oUser->password=hash('sha256', createPassword());
                    $oUser->full_name=$userfirstname." ".$userlastname;
                    $oUser->parent_id=1;
                    $oUser->lang="fr";
                    $oUser->email=$usermail;

                    // On ajoute en bdd et on définit les permissions
                    if ($oUser->save()) {
                        $permission=new Permission;
                        $permission->setPermissions($oUser->uid, 0, 'global', [
                            'participantpanel' => [
                                'create'=>true ,
                                'read'=>true,
                                'update'=>true ,
                                'delete'=>false,
                                'import'=>true,
                                'export'=>true],
                            'usergroups' => [
                                'create'=>true ,
                                'read'=>true,
                                'update'=>true ,
                                'delete'=>false],
                            'labelsets' => [
                                'create'=>true ,
                                'read'=>true,
                                'update'=>true ,
                                'delete'=>false,
                                'import'=>true,
                                'export'=>true],
                            'templates' => [
                                'create'=>true ,
                                'read'=>true,
                                'update'=>true ,
                                'delete'=>false,
                                'import'=>true,
                                'export'=>true], 
                            'settings' => [
                                'read'=>true,
                                'update'=>false ,
                                'import'=>false],                             
                            'surveys' => [
                                'create'=>true,
                                'read'=>false,
                                'update'=>false,
                                'delete'=>false,
                                'import'=>false,
                                'export'=>true],
                            'users' => [
                                'create'=>false,
                                'read'=>true,
                                'update'=>false,
                                'delete'=>false],                        
                        ], true);
                    }
    
                }
            } 
        }    

        private function frmshell($string) {
            return str_replace("___"," ",$string);
        }          
    }
