<?php if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}
/*
 * LimeSurvey
 * Copyright (C) 2007-2011 The LimeSurvey Project Team / Carsten Schmitz
 * All rights reserved.
 * License: GNU/GPL License v2 or later, see LICENSE.php
 * LimeSurvey is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 * See COPYRIGHT.php for copyright notices and details.
 *
 */

class LSYii_EmailIDNAValidator extends CValidator
{

    public $allowEmpty = false;
    public $allowMultiple = false;


    public function validateAttribute($object, $attribute)
    {

        if ($object->$attribute == '' && $this->allowEmpty) {
            return;
        }

        if ($this->allowMultiple) {
            $aEmailAdresses = preg_split("/(,|;)/", $object->$attribute);
        } else {
            $aEmailAdresses = array($object->$attribute);
        }

        foreach ($aEmailAdresses as $sEmailAddress) {
            if (!validateEmailAddress($sEmailAddress)) {
                $this->addError($object, $attribute, gT('Invalid email address.'));
                return;
            }

        }
        return;
    }

}
