<?php if (!defined('BASEPATH')) exit('No direct script access allowed');
/*
| -------------------------------------------------------------------
| DATABASE CONNECTIVITY SETTINGS
| -------------------------------------------------------------------
| This file will contain the settings needed to access your database.
|
| For complete instructions please consult the 'Database Connection'
| page of the User Guide.
|
| -------------------------------------------------------------------
| EXPLANATION OF VARIABLES
| -------------------------------------------------------------------
|
|    'connectionString' Hostname, database, port and database type for
|     the connection. Driver example: mysql. Currently supported:
|                 mysql, pgsql, mssql, sqlite, oci
|    'username' The username used to connect to the database
|    'password' The password used to connect to the database
|    'tablePrefix' You can add an optional prefix, which will be added
|                 to the table name when using the Active Record class
|
*/
// ne pas toucher au formatage de la ligne suivante pour que le packaging modifie le pwd
/* Database */
$dbpassword="changeme";
$config['dbpassword']					= $dbpassword;
$config['dbport']                       ="3306";
$config['dblogin']						= "limesurvey";
$config['dbname'] 						= "limesurvey";

%if %%getVar("limesurvey_db_mode", 'non') == "externe"
$config['dbhost']                       ="%%limesurvey_dbserver";
    %if %%getVar('limesurvey_dbport', 'non') != "non"
$config['dbport']                       ="%%limesurvey_dbport";
    %end if
%else if %%getVar("limesurvey_db_mode", 'non') == "default"
   %set dbhost = %%getVar('edb_host', 'non')
   %if %%dbhost == 'non' and %%mode_conteneur_actif == 'oui':
$config['dbhost']                       ="%%adresse_ip_mysql";
   %else
       %if %%dbhost == 'non'
$config['dbhost']                       ="localhost";
       %else
$config['dbhost']                       ="%%edb_host";
       %end if
   %end if

   %if %%getVar('edb_dbport', 'non') != "non"
$config['dbport']                       ="%%edb_port";
    %end if
%else
$config['dbhost']                       ="%%adresse_ip_mysql";
%end if;

return array(
	'components' => array(
		'db' => array(
			'connectionString' => 'mysql:host='.$config['dbhost'].';port='.$config['dbport'].';dbname='.$config['dbname'].';',
			'emulatePrepare' => true,
			'username' => $config['dblogin'],
			'password' => $config['dbpassword'],
			'charset' => 'utf8',
			'tablePrefix' => 'lime_',
		),

		// Uncomment the following line if you need table-based sessions
		// 'session' => array (
			// 'class' => 'system.web.CDbHttpSession',
			// 'connectionID' => 'db',
			// 'sessionTableName' => '{{sessions}}',
		// ),

		'urlManager' => array(
			'urlFormat' => 'path',
			'rules' => require('routes.php'),
			'showScriptName' => true,
		),

	),
	// Use the following config variable to set modified optional settings copied from config-defaults.php
	'config'=>array(
	// debug: Set this to 1 if you are looking for errors. If you still get no errors after enabling this
	// then please check your error-logs - either in your hosting provider admin panel or in some /logs directory
	// on your webspace.
	// LimeSurvey developers: Set this to 2 to additionally display STRICT PHP error messages and get full access to standard templates
		'debug'=>0,
		'debugsql'=>0, // Set this to 1 to enanble sql logging, only active when debug = 2
		'enableLdap'=>true,
		'updatable' => false,	// Pas de confortupdate : évite les interminables attentes

		%if %%is_defined('proxy_client_adresse')
		'proxy_host_name'=>'%%proxy_client_adresse',
		'proxy_host_port'=>%%proxy_client_port,		
		%end if
	)
);
/* End of file config.php */
/* Location: ./application/config/config.php */
