<?php
/*
 * LimeSurvey
 * Copyright (C) 2007-2011 The LimeSurvey Project Team / Carsten Schmitz
 * All rights reserved.
 * License: GNU/GPL License v2 or later, see LICENSE.php
 * LimeSurvey is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 * See COPYRIGHT.php for copyright notices and details.
 *
 */

/*********** LDAP Parameters and Functions ***********************
 *
 *  - First define your ldap servers and remember the serverId
 *  - Then define your ldap_query and 'attach' it to the serverId
 ******************************************************************/

/*********************************************/
/* LDAP servers                              */
/*********************************************/


%if %%is_defined("ldap_reader_passfile")
// Adresse du Serveur LDAP 2.4
$config["LDAPserver"] 		= "%%adresse_ip_ldap";
$config["LDAPport"] 		= "%%ldap_port";
$config['LDAPreaderdn'] 	= "%%ldap_reader";
$config['LDAPreaderpw'] 	= "%%pwdreader("",%%ldap_reader_passfile)";
$config["LDAPracine"] 		= "%%ldap_base_dn";
$config["LDAPorganisation"] = "education";
$config["nom_academie"]		= "%%nom_academie";
$config["numero_etab"] 		= "%%numero_etab";
%else
// Adresse du Serveur LDAP 2.3
%if(%%eolesso_ldap[0] in ("localhost","127.0.0.1"))
$config['LDAPserver']       = "%%adresse_ip_ldap";
%else
$config['LDAPserver']		= "%%eolesso_ldap[0]";
%end if
$config['LDAPport']         = "%%eolesso_ldap[0].eolesso_port_ldap";
$config['LDAPreaderdn'] 	= "%%eolesso_ldap[0].eolesso_ldap_reader";
$config['LDAPreaderpw']     = "%%pwdreader("",%%eolesso_ldap[0].eolesso_ldap_reader_passfile)";
$config["LDAPracine"] 		= "%%eolesso_ldap[0].eolesso_base_ldap";
$config["LDAPorganisation"] = "education";
$config["nom_academie"]		= "%%nom_academie";
$config["numero_etab"] 		= "%%numero_etab";
%end if


$serverId=0;
// Define the server DNS name or IP Address
// If encryption is enabled, make sure the name given here
// corresponds to the certificate's identity
$ldap_server[$serverId]['server'] = $config["LDAPserver"];

// Define the TCP port on which the LDAP server is listenning
// This should be 389 for standard LDAP servers
// or 636 for standard LDAPS connections
$ldap_server[$serverId]['port'] = $config["LDAPport"];

// Define the ldap protocol to use
// 'ldapv2' and 'ldapv3' are supported
$ldap_server[$serverId]['protoversion'] = "ldapv3";

// Define the encryption method to use
// 'ldaps' is supported for 'ldapv2' servers
// 'start-tls' is supproted for 'ldapv3' servers
// 'none' is supproted for no encryption at all
// Don't forget to setup your CA's certificate in
// the openldap ldap.conf file
$ldap_server[$serverId]['encrypt'] = "none";

// Define the referral option
// 'false' is recommended for ActiveDirectory servers
$ldap_server[$serverId]['referrals'] = false;

// Define the encoding used by the Ldap directory
// You may omit this parameter (let it commented out)
// as the default value, 'utf-8', should work for most installations.
// However, Active Directory in West Europe may use 'cp850'.
// $ldap_server[$serverId]['encoding'] = 'utf-8';

// Define the authentication used to bind to the directory
// We currently support simple authentication
// If anonymous bind must be performed, comment the following two lines
// Note that Active Directory (AD) usually requires authentication before
// you are authorized to read its content. Remeber as well that user's DN
// in AD are in the form of CN=username,CN=Users,DC=WindowsDomainName,DC=mycompany,DC=org
//
$ldap_server[$serverId]['binddn']	=	$config['LDAPreaderdn'];
$ldap_server[$serverId]['bindpw']	=	$config['LDAPreaderpw'];

/********* Copy for more definitions *****
 $serverId++;
 $ldap_server[$serverId]['server'] = "ldap.mycompany.org";
 $ldap_server[$serverId]['port'] = "389";
 $ldap_server[$serverId]['protoversion'] = "ldapv3";
 $ldap_server[$serverId]['encrypt'] = "start-tls";
 $ldap_server[$serverId]['referrals'] = false;
 $ldap_server[$serverId]['binddn']	=	"uid=mybinduser,dc=mycompany,dc=org";
 $ldap_server[$serverId]['bindpw']	=	"AsecretPassword";
 *****************************************/

/**********************************************************************/
/* Predefined Queries for Token Imports                               */
/*                                                                    */
/* This sample query definition is just an fake template: do not      */
/* expect it to do something intelligent on your directory            */
/* Instead have a look at the online documentation:                   */
/* - Section Installation, paragraph LDAP_Settings                     */
/* And for Active Directory tips:                                     */
/* - Section Installation FAQ, paragraph                               */
/*   How_do_I_configure_LDAP_settings_to_work_with_Active_Directory_  */
/**********************************************************************/

/************************************************************************/
/* Gestion des groupes d'invitations globaux à l'annuaire Envole	*/
/************************************************************************/
%if %%is_defined('poshprofil_typesynchro') and %%poshprofil_typesynchro == 'ENT' 
$query_id=0;
$ldap_queries[$query_id]['ldapServerId'] = 0;
$ldap_queries[$query_id]['name'] = "Tous les élèves";
$ldap_queries[$query_id]['userbase'] = $config["LDAPracine"];
$ldap_queries[$query_id]['userfilter'] = '(ENTPersonProfils=eleve)';
$ldap_queries[$query_id]['userscope'] = 'sub';
$ldap_queries[$query_id]['firstname_attr'] = 'givenname';
$ldap_queries[$query_id]['lastname_attr'] = 'sn';
$ldap_queries[$query_id]['email_attr'] = 'mail';
$ldap_queries[$query_id]['token_attr'] = ''; 
$ldap_queries[$query_id]['language'] = '';
$ldap_queries[$query_id]['attr1'] = 'divcod';
$ldap_queries[$query_id]['attr2'] = '';
$query_id++;

$ldap_queries[$query_id]['ldapServerId'] = 0;
$ldap_queries[$query_id]['name'] = "Tous les professeurs";
$ldap_queries[$query_id]['userbase'] = $config["LDAPracine"];
$ldap_queries[$query_id]['userfilter'] = '(ENTPersonProfils=enseignant)';
$ldap_queries[$query_id]['userscope'] = 'sub';
$ldap_queries[$query_id]['firstname_attr'] = 'givenname';
$ldap_queries[$query_id]['lastname_attr'] = 'sn';
$ldap_queries[$query_id]['email_attr'] = 'mail';
$ldap_queries[$query_id]['token_attr'] = ''; 
$ldap_queries[$query_id]['language'] = '';
$ldap_queries[$query_id]['attr1'] = 'divcod';
$ldap_queries[$query_id]['attr2'] = '';
$query_id++;

$ldap_queries[$query_id]['ldapServerId'] = 0;
$ldap_queries[$query_id]['name'] = "Tous les responsables";
$ldap_queries[$query_id]['userbase'] = $config["LDAPracine"];
$ldap_queries[$query_id]['userfilter'] = '(ENTPersonProfils=responsable)';
$ldap_queries[$query_id]['userscope'] = 'sub';
$ldap_queries[$query_id]['firstname_attr'] = 'givenname';
$ldap_queries[$query_id]['lastname_attr'] = 'sn';
$ldap_queries[$query_id]['email_attr'] = 'mail';
$ldap_queries[$query_id]['token_attr'] = ''; 
$ldap_queries[$query_id]['language'] = '';
$ldap_queries[$query_id]['attr1'] = 'divcod';
$ldap_queries[$query_id]['attr2'] = '';
$query_id++;

$ldap_queries[$query_id]['ldapServerId'] = 0;
$ldap_queries[$query_id]['name'] = "Tous les administratifs";
$ldap_queries[$query_id]['userbase'] = $config["LDAPracine"];
$ldap_queries[$query_id]['userfilter'] = '(ENTPersonProfils=administratif)';
$ldap_queries[$query_id]['userscope'] = 'sub';
$ldap_queries[$query_id]['firstname_attr'] = 'givenname';
$ldap_queries[$query_id]['lastname_attr'] = 'sn';
$ldap_queries[$query_id]['email_attr'] = 'mail';
$ldap_queries[$query_id]['token_attr'] = ''; 
$ldap_queries[$query_id]['language'] = '';
$ldap_queries[$query_id]['attr1'] = 'divcod';
$ldap_queries[$query_id]['attr2'] = '';
$query_id++;

%end if

/************************************************************************/
/* Gestion des groupes d'invitations par posh-profil (par classes)	*/
/************************************************************************/
// Inclure le script de maj
$fic = "/var/www/html/limesurvey/application/config/ldap-invitations-posh-profil.php";
if (is_file($fic)) include $fic;


return array('ldap_server' => $ldap_server, 'ldap_queries' => $ldap_queries);
?>
