\r limesurvey
SET character_set_client = utf8;

%if %%is_defined('activer_limesurvey') and %%activer_limesurvey == 'oui'

ALTER TABLE `lime_user_groups` CHANGE `name` `name` varchar(250) COLLATE 'utf8mb4_unicode_ci' NOT NULL AFTER `ugid`;

-- Réinitialisation de l'activation du plugin CAS
DELETE FROM lime_plugins WHERE name='AuthCAS';
INSERT IGNORE INTO `lime_plugins` (`id`, `name`, `active`) VALUES (7,'AuthCAS',1);

DELETE FROM lime_settings_global WHERE stg_name='RPCInterface' OR stg_name='rpc_publish_api';
INSERT IGNORE INTO lime_settings_global (`stg_name`, `stg_value`) VALUES
('RPCInterface',	'json'),
('rpc_publish_api',	'1');

DELETE FROM lime_settings_global WHERE stg_name='shownoanswer';
INSERT IGNORE INTO lime_settings_global (`stg_name`, `stg_value`) VALUES
('shownoanswer',	'2');

DELETE FROM lime_settings_global WHERE stg_name='force_ssl';
INSERT IGNORE INTO lime_settings_global (`stg_name`, `stg_value`) VALUES
('force_ssl',	'on');

-- Création de superadmin
DROP PROCEDURE IF EXISTS AddAdminLimesurvey;
delimiter |
CREATE PROCEDURE AddAdminLimesurvey(_adminuser VARCHAR( 32 ), _password VARCHAR( 255 ), _mail VARCHAR( 255 ))
BEGIN
    DECLARE ad_id INT DEFAULT 0;
 
    SELECT uid INTO ad_id FROM lime_users WHERE users_name=_adminuser;
    IF ad_id = 0 THEN
        INSERT IGNORE INTO `lime_users` (`users_name`, `password`, `full_name`, `parent_id`, `lang`, `email`, `htmleditormode`, `templateeditormode`, `questionselectormode`, `one_time_pw`, `dateformat`, `created`, `modified`)
					VALUES 
        				( _adminuser, _password, 'Administrateur Envole', 1, 'fr', _mail, 'default', 'default', 'default', NULL, 1, NULL, NULL);
        SET ad_id = LAST_INSERT_ID();
    END IF;

    INSERT INTO `lime_permissions` (`entity`, `entity_id`, `uid`, `permission`, `create_p`, `read_p`, `update_p`, `delete_p`, `import_p`, `export_p`) 
	VALUES ('global', 0, ad_id, 'superadmin', 0, 1, 0, 0, 0, 0) 
	ON DUPLICATE KEY UPDATE `permission` = 'superadmin', `entity`='global', `entity_id`=0, `uid` = ad_id, `create_p`=0, `read_p`=1, `update_p`=0, `delete_p`=0, `import_p`=0, `export_p`=0;

END|
DELIMITER ;

-- 2 admin
%if %%is_defined('activer_addadmin') and %%activer_addadmin == 'oui'
CALL AddAdminLimesurvey('%%uid_addadmin','','');
%end if

-- restuser password = apikeyenvole
CALL AddAdminLimesurvey('restuser','7ef23abec45648986dd9635f7b87238e81814692ba4cc94f0f1cb913b60ffa99','restuser@noreplay.fr');

%end if
