/*
 * Decompiled with CFR 0.152.
 */
package gong.audio;

import gong.audio.AudioDataException;
import gong.audio.data.BlockAudioData;
import gong.audio.data.ImaADPCMData;
import gong.audio.data.SpeexData;
import gong.event.AudioDataListener;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.util.Date;
import javax.sound.sampled.AudioFormat;

public abstract class AudioData
implements Cloneable {
    public static final String FILE_EXTENSION = ".raw";
    protected static final int STREAM_TIMEOUT = 60000;
    protected static final int UPDATE_INTERVAL = 500;
    public static final String FEATURE_SENT_PROGRESS = "sent-progress";
    public static final String FEATURE_RECEIVED_PROGRESS = "received-progress";
    protected AudioFormat format = null;
    protected int position = 0;
    protected TransferThread transferThread = null;
    protected AudioDataListener listener = null;
    protected File cache = null;
    protected CacheInputStream cacheInputStream = new CacheInputStream();

    public AudioData() {
    }

    public AudioData(AudioFormat audioFormat) {
        this.format = audioFormat;
    }

    public AudioFormat getFormat() {
        return this.format;
    }

    public abstract String getFileExtension();

    public synchronized void setListener(AudioDataListener audioDataListener) {
        this.listener = audioDataListener;
        if (audioDataListener != null) {
            if (this.isTransferInProgress()) {
                audioDataListener.received(this, this.getAvailable());
            } else {
                audioDataListener.finish(this, this.getAvailable());
            }
        }
    }

    public void setCache(File file) {
        this.cache = file;
    }

    public File getCache() {
        return this.cache;
    }

    public void clearCache() {
        if (this.isTransferInProgress()) {
            this.stopTransfer();
        }
        if (this.cache != null) {
            try {
                this.cacheInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.cache.delete();
        }
    }

    public abstract int read() throws IOException, AudioDataException;

    public synchronized int read(int[] nArray, int n, int n2) throws IOException, AudioDataException {
        int n3 = 0;
        for (int i = n; i < n + n2; ++i) {
            try {
                nArray[i] = this.read();
                ++n3;
                continue;
            }
            catch (Throwable throwable) {
                break;
            }
        }
        return n3;
    }

    public abstract void write(int var1) throws IOException, AudioDataException;

    public abstract int seek(int var1) throws IOException, AudioDataException;

    public synchronized int seekAndRead(int n) throws IOException, AudioDataException {
        int n2 = this.position;
        this.seek(n);
        int n3 = this.read();
        this.seek(n2);
        return n3;
    }

    public synchronized int seekAndRead(int n, int[] nArray, int n2, int n3) throws IOException, AudioDataException {
        int n4 = this.position;
        this.seek(n);
        int n5 = this.read(nArray, n2, n3);
        this.seek(n4);
        return n5;
    }

    public synchronized int skip(int n) throws IOException, AudioDataException {
        return this.seek(this.position + n);
    }

    public synchronized void reset() {
        this.position = 0;
    }

    public synchronized int getPosition() {
        return this.position;
    }

    public abstract boolean isAvailable();

    public abstract boolean isSupported(String var1);

    public synchronized void setTime(long l) throws IOException, AudioDataException {
        int n = (int)((double)l / 1000.0 * (double)this.format.getSampleRate());
        if (n < 0) {
            n = 0;
        }
        if (n > this.getLength()) {
            n = this.getLength();
        }
        this.seek(n);
    }

    public synchronized long getTime() {
        long l = (long)((double)this.position / (double)this.format.getSampleRate() * 1000.0);
        if (l < 0L) {
            l = 0L;
        }
        if (l > this.getDuration()) {
            l = this.getDuration();
        }
        return l;
    }

    public synchronized long getDuration() {
        return (long)((double)this.getLength() / (double)this.format.getSampleRate() * 1000.0);
    }

    public abstract long getAvailable();

    public abstract int getLength();

    public abstract long getMemoryUsage();

    public Object clone() {
        return this;
    }

    public void close() throws IOException, AudioDataException {
    }

    public abstract void sendToStream(OutputStream var1) throws IOException, AudioDataException;

    public abstract void receiveFromStream(InputStream var1, boolean var2) throws IOException, AudioDataException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receiveByteArrayFromStream(InputStream inputStream, byte[] byArray, int n, int n2) throws IOException, EOFException, ConnectException {
        StreamReader streamReader;
        StreamReader streamReader2 = streamReader = new StreamReader(inputStream, byArray, n, n2);
        synchronized (streamReader2) {
            streamReader.start();
            while (streamReader.getBytesRemaining() > 0) {
                try {
                    streamReader.wait(60000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (streamReader.getBytesRemaining() <= 0) continue;
                streamReader.close();
                if (streamReader.isEOF()) {
                    throw new EOFException("Unexpected end of file reached.");
                }
                throw new ConnectException("Connection timeout.");
            }
        }
    }

    public static AudioData createFromStream(InputStream inputStream) {
        BlockAudioData blockAudioData;
        try {
            blockAudioData = new ImaADPCMData();
            inputStream.mark(0);
            try {
                ((ImaADPCMData)blockAudioData).receiveHeaderFromStream(inputStream, null);
                inputStream.reset();
                return blockAudioData;
            }
            catch (Exception exception) {
                inputStream.reset();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            blockAudioData = new SpeexData();
            inputStream.mark(0);
            try {
                ((SpeexData)blockAudioData).receiveHeaderFromStream(inputStream);
                inputStream.reset();
                return blockAudioData;
            }
            catch (Exception exception) {
                inputStream.reset();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected TransferThread getTransferThread() {
        return new TransferThread();
    }

    public synchronized boolean isTransferBuffered(float f) {
        if (!this.isAvailable()) {
            return false;
        }
        if (!this.isTransferInProgress()) {
            return true;
        }
        if (this.getDuration() <= 60000L) {
            long l = this.transferThread.getTime();
            long l2 = this.getDuration() - this.getAvailable();
            return (double)l2 * ((double)l + 1000.0) / (double)this.getAvailable() * (double)f * 1.1 <= (double)(this.getDuration() - this.getTime());
        }
        return (float)(this.getAvailable() - this.getTime()) * f >= 30000.0f || this.getAvailable() == this.getDuration();
    }

    public synchronized boolean isTransferInProgress() {
        return this.transferThread != null;
    }

    public synchronized void stopTransfer() {
        if (this.isTransferInProgress()) {
            this.transferThread.kill();
            this.transferThread = null;
        }
    }

    public static long swapLong(long l) {
        long l2 = l & 0xFFL;
        long l3 = l >> 8 & 0xFFL;
        long l4 = l >> 16 & 0xFFL;
        long l5 = l >> 24 & 0xFFL;
        long l6 = l >> 32 & 0xFFL;
        long l7 = l >> 40 & 0xFFL;
        long l8 = l >> 48 & 0xFFL;
        long l9 = l >> 56 & 0xFFL;
        return l2 << 56 | l3 << 48 | l4 << 40 | l5 << 32 | l6 << 24 | l7 << 16 | l8 << 8 | l9;
    }

    public static int swapInt(int n) {
        int n2 = n & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n >> 16 & 0xFF;
        int n5 = n >> 24 & 0xFF;
        return n2 << 24 | n3 << 16 | n4 << 8 | n5;
    }

    public static short swapShort(short s) {
        int n = s & 0xFF;
        int n2 = s >> 8 & 0xFF;
        return (short)(n << 8 | n2);
    }

    protected class CacheInputStream {
        private FileInputStream stream = null;
        private long position = -1L;
        private byte data;

        public void read(byte[] byArray, long l) throws IOException {
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = this.read((long)i + l);
            }
        }

        public byte read(long l) throws IOException {
            if (l == this.position) {
                return this.data;
            }
            if (this.stream == null || l < this.position) {
                if (this.stream != null) {
                    this.stream.close();
                }
                this.stream = new FileInputStream(AudioData.this.cache);
            }
            if (this.position == -1L || l < this.position) {
                this.stream.skip(l);
            } else if (l - this.position > 1L) {
                this.stream.skip(l - this.position - 1L);
            }
            this.data = (byte)this.stream.read();
            this.position = l;
            return this.data;
        }

        public void close() throws IOException {
            if (this.stream != null) {
                this.stream.close();
            }
        }
    }

    protected class TransferThread
    extends Thread {
        protected InputStream in = null;
        protected OutputStream out = null;
        private long startTime;
        protected boolean inProgress = true;

        protected TransferThread() {
        }

        public void start(InputStream inputStream, OutputStream outputStream) {
            this.in = inputStream;
            this.out = outputStream;
            this.start();
        }

        protected void recordStartTime() {
            this.startTime = new Date().getTime();
        }

        public long getTime() {
            return new Date().getTime() - this.startTime;
        }

        public void run() {
            this.recordStartTime();
        }

        public void kill() {
            try {
                this.in.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.out.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.inProgress = false;
        }
    }

    protected class StreamReader
    extends Thread {
        private InputStream stream;
        private byte[] buffer;
        private int offset;
        private int length;
        private int bytesRead;
        private boolean eof;
        private boolean closed;

        public StreamReader(InputStream inputStream, byte[] byArray, int n, int n2) {
            this.stream = inputStream;
            this.buffer = byArray;
            this.offset = n;
            this.length = n2;
            this.bytesRead = 0;
            this.eof = false;
            this.closed = false;
        }

        public synchronized void run() {
            try {
                while (!this.closed && this.bytesRead < this.length) {
                    int n = this.stream.read(this.buffer, this.offset + this.bytesRead, this.length - this.bytesRead);
                    if (n < 0) {
                        this.eof = true;
                        break;
                    }
                    this.bytesRead += n;
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            this.notifyAll();
        }

        public void close() {
            this.closed = true;
        }

        public int getBytesRemaining() {
            return this.length - this.bytesRead;
        }

        public boolean isEOF() {
            return this.eof;
        }
    }
}

