<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'forum', language 'en', branch 'MOODLE_20_STABLE'
 *
 * @package   mod_forum
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

$string['activitydate:due'] = 'Due:';
$string['activityoverview'] = 'There are new forum posts';
$string['actionsforgraderinterface'] = 'Actions for the grader interface';
$string['actionsforpost'] = 'Actions for post';
$string['addanewdiscussion'] = 'Add discussion topic';
$string['addanewquestion'] = 'Add a new question';
$string['addanewtopic'] = 'Add a new topic';
$string['addreply'] = 'Add reply';
$string['addtofavourites'] = 'Star this discussion';
$string['advancedsearch'] = 'Advanced search';
$string['alldiscussions'] = 'All discussions';
$string['allforums'] = 'All forums';
$string['allowdiscussions'] = 'Can a {$a} post to this forum?';
$string['allowsallsubscribe'] = 'This forum allows everyone to choose whether to subscribe or not';
$string['allowsdiscussions'] = 'This forum allows each person to start one discussion topic.';
$string['allsubscribe'] = 'Subscribe to all forums';
$string['allunsubscribe'] = 'Unsubscribe from all forums';
$string['allusers'] = 'All users';
$string['alreadyfirstpost'] = 'This is already the first post in the discussion';
$string['anyfile'] = 'Any file';
$string['areaattachment'] = 'Attachments';
$string['areapost'] = 'Messages';
$string['attachment'] = 'Attachment';
$string['attachmentname'] = 'Attachment {$a}';
$string['attachmentnameandfilesize'] = '{$a->name} ({$a->size})';
$string['attachment_help'] = 'You can optionally attach one or more files to a forum post. If you attach an image, it will be displayed after the message.';
$string['attachmentnopost'] = 'You cannot export attachments without a post id';
$string['attachments'] = 'Attachments';
$string['attachmentswordcount'] = 'Attachments and word count';
$string['authorreplyingprivatelytoauthor'] = '{$a->respondant} replying privately to {$a->author}';
$string['authorreplyingtoauthor'] = '{$a->respondant} replying to {$a->author}';
$string['availability'] = 'Availability';
$string['blockafter'] = 'Post threshold for blocking';
$string['blockafter_help'] = 'This setting specifies the maximum number of posts which a user can post in the given time period. Users with the capability mod/forum:postwithoutthrottling are exempt from post limits.';
$string['blockperiod'] = 'Time period for blocking';
$string['blockperiod_help'] = 'Students can be blocked from posting more than a given number of posts in a given time period. Users with the capability mod/forum:postwithoutthrottling are exempt from post limits.';
$string['blockperioddisabled'] = 'Don\'t block';
$string['blogforum'] = 'Standard forum displayed in a blog-like format';
$string['bynameondate'] = 'by {$a->name} - {$a->date}';
$string['cachedef_forum_is_tracked'] = 'Forum tracking status for user';
$string['calendardue'] = '{$a} is due';
$string['cancelreply'] = 'Cancel reply';
$string['cannotadd'] = 'Could not add the discussion for this forum';
$string['cannotadddiscussion'] = 'Adding discussions to this forum requires group membership.';
$string['cannotadddiscussionall'] = 'You do not have permission to add a new discussion topic for all participants.';
$string['cannotadddiscussiongroup'] = 'You are not able to create a discussion because you are not a member of any group.';
$string['cannotaddsubscriber'] = 'Could not add subscriber with id {$a} to this forum!';
$string['cannotaddteacherforumto'] = 'Could not add converted teacher forum instance to section 0 in the course';
$string['cannotcreatediscussion'] = 'Could not create new discussion';
$string['cannotcreateinstanceforteacher'] = 'Could not create new course module instance for the teacher forum';
$string['cannotdeletepost'] = 'You can\'t delete this post!';
$string['cannoteditposts'] = 'You can\'t edit other people\'s posts!';
$string['cannotexportforum'] = 'You cannot export this forum';
$string['cannotfinddiscussion'] = 'Could not find the discussion in this forum';
$string['cannotfindfirstpost'] = 'Could not find the first post in this forum';
$string['cannotfindorcreateforum'] = 'Could not find or create a main announcements forum for the site';
$string['cannotfindparentpost'] = 'Could not find top parent of post {$a}';
$string['cannotmovefromsingleforum'] = 'Cannot move discussion from a simple single discussion forum';
$string['cannotmovenotvisible'] = 'Forum not visible';
$string['cannotmovetonotexist'] = 'You can\'t move to that forum - it doesn\'t exist!';
$string['cannotmovetonotfound'] = 'Target forum not found in this course.';
$string['cannotmovetosingleforum'] = 'Cannot move discussion to a simple single discussion forum';
$string['cannotpindiscussions'] = 'Sorry, you do not have permission to pin discussions.';
$string['cannotpurgecachedrss'] = 'Could not purge the cached RSS feeds for the source and/or destination forum(s) - check your file permissionsforums';
$string['cannotremovesubscriber'] = 'Could not remove subscriber with id {$a} from this forum!';
$string['cannotreply'] = 'You cannot reply to this post';
$string['cannotsplit'] = 'Discussions from this forum cannot be split';
$string['cannotsubscribe'] = 'Sorry, but you must be a group member to subscribe.';
$string['cannotfavourite'] = 'Sorry, but you do not have the permission to star discussions.';
$string['cannottrack'] = 'Could not stop tracking that forum';
$string['cannotunsubscribe'] = 'Could not unsubscribe you from that forum';
$string['cannotupdatepost'] = 'You can not update this post';
$string['cannotuseseperategroupsandsingletopic'] = 'Separate groups can\'t be used with a single simple discussion.';
$string['cannotusesingletopicandseperategroups'] = 'A single simple discussion can\'t be used with separate groups.';
$string['cannotviewpostyet'] = 'You can\'t read other students\' posts in this discussion yet because you haven\'t posted.';
$string['cannotviewusersposts'] = 'There are no posts made by this user that you are able to view.';
$string['cleanreadtime'] = 'Mark old posts as read hour';
$string['clicktolockdiscussion'] = 'Click to lock this discussion';
$string['clicktounlockdiscussion'] = 'Click to unlock this discussion';
$string['clicktounsubscribe'] = 'You are subscribed to this discussion. Click to unsubscribe.';
$string['clicktosubscribe'] = 'You are not subscribed to this discussion. Click to subscribe.';
$string['clicktounfavourite'] = 'You have starred this discussion. Click to unstar.';
$string['clicktofavourite'] = 'You have not starred this discussion. Click to star.';
$string['close'] = 'Close';
$string['closegrader'] = 'Close grader';
$string['completiondetail:discussions'] = 'Start discussions: {$a}';
$string['completiondetail:replies'] = 'Post replies: {$a}';
$string['completiondetail:posts'] = 'Make forum posts: {$a}';
$string['completiondiscussions'] = 'Student must create discussions:';
$string['completiondiscussionsdesc'] = 'Student must create at least {$a} discussion(s)';
$string['completiondiscussionsgroup'] = 'Require discussions';
$string['completiondiscussionshelp'] = 'requiring discussions to complete';
$string['completionposts'] = 'Student must post discussions or replies:';
$string['completionpostsdesc'] = 'Student must post at least {$a} discussion(s) or reply/replies';
$string['completionpostsgroup'] = 'Require posts';
$string['completionpostshelp'] = 'requiring discussions or replies to complete';
$string['completionreplies'] = 'Student must post replies:';
$string['completionrepliesdesc'] = 'Student must post at least {$a} reply/replies';
$string['completionrepliesgroup'] = 'Require replies';
$string['completionreplieshelp'] = 'requiring replies to complete';
$string['configcleanreadtime'] = 'The hour of the day to clean old posts from the \'read\' table.';
$string['configdigestmailtime'] = 'People who choose to have emails sent to them in digest form will be emailed the digest daily. This setting controls which time of day the daily mail will be sent (the next cron that runs after this hour will send it).';
$string['configdisplaymode'] = 'The default display mode for discussions if one isn\'t set.';
$string['configenablerssfeeds'] = 'This switch will enable the possibility of RSS feeds for all forums.  You will still need to turn feeds on manually in the settings for each forum.';
$string['configenabletimedposts'] = 'Set to \'yes\' if you want to allow setting of display periods when posting a new forum discussion.';
$string['configlongpost'] = 'Any post over this length (in characters not including HTML) is considered long. Posts displayed on the site home, social format course pages, or user profiles are shortened to a natural break somewhere between the forum_shortpost and forum_longpost values.';
$string['configmanydiscussions'] = 'Maximum number of discussions shown in a forum per page';
$string['configmaxattachments'] = 'Default maximum number of attachments allowed per post.';
$string['configmaxbytes'] = 'Default maximum size for all forum attachments on the site (subject to course limits and other local settings)';
$string['configoldpostdays'] = 'Number of days old any post is considered read.';
$string['configreplytouser'] = 'When a forum post is mailed out, should it contain the user\'s email address so that recipients can reply personally rather than via the forum? Even if set to \'Yes\' users can choose in their profile to keep their email address secret.';
$string['configrsstypedefault'] = 'If RSS feeds are enabled, sets the default activity type.';
$string['configrssarticlesdefault'] = 'If RSS feeds are enabled, sets the default number of articles (either discussions or posts).';
$string['configsubscriptiontype'] = 'Default setting for subscription mode.';
$string['configshortpost'] = 'Any post under this length (in characters not including HTML) is considered short (see below).';
$string['configtrackingtype'] = 'Default setting for read tracking.';
$string['configtrackreadposts'] = 'Set to \'yes\' if you want to track read/unread for each user.';
$string['configusermarksread'] = 'If \'yes\', the user must manually mark a post as read. If \'no\', when the post is viewed it is marked as read.';
$string['confirmsubscribediscussion'] = 'Do you really want to subscribe to discussion \'{$a->discussion}\' in forum \'{$a->forum}\'?';
$string['confirmunsubscribediscussion'] = 'Do you really want to unsubscribe from discussion \'{$a->discussion}\' in forum \'{$a->forum}\'?';
$string['confirmsubscribe'] = 'Do you really want to subscribe to forum \'{$a}\'?';
$string['confirmunsubscribe'] = 'Do you really want to unsubscribe from forum \'{$a}\'?';
$string['couldnotadd'] = 'Could not add your post due to an unknown error';
$string['couldnotdeletereplies'] = 'Sorry, that cannot be deleted as people have already responded to it';
$string['couldnotupdate'] = 'Could not update your post due to an unknown error';
$string['created'] = 'Created';
$string['crontask'] = 'Forum mailings and maintenance jobs';
$string['cutoffdate'] = 'Cut-off date';
$string['cutoffdate_help'] = 'If set, the forum will not accept posts after this date.';
$string['cutoffdatereached'] = 'The cut-off date for posting to this forum is reached so you can no longer post to it.';
$string['cutoffdatevalidation'] = 'The cut-off date cannot be earlier than the due date.';
$string['delete'] = 'Delete';
$string['deleteddiscussion'] = 'The discussion topic has been deleted';
$string['deletedpost'] = 'The post has been deleted';
$string['deletedposts'] = 'Those posts have been deleted';
$string['deleteduser'] = 'Deleted user';
$string['deletesure'] = 'Are you sure you want to delete this post?';
$string['deletesureplural'] = 'Are you sure you want to delete this post and all replies? ({$a} posts)';
$string['digestmailheader'] = 'This is your daily digest of new posts from the {$a->sitename} forums. To change your default forum email preferences, go to {$a->userprefs}.';
$string['digestmailpost'] = 'Change your forum digest preferences';
$string['digestmailpostlink'] = 'Change your forum digest preferences: {$a}';
$string['digestmailprefs'] = 'your user profile';
$string['digestmailsubject'] = '{$a}: forum digest';
$string['digestmailtime'] = 'Hour to send digest emails';
$string['digestsentusers'] = 'Email digests successfully sent to {$a} users.';
$string['disallowsubscribe'] = 'Subscriptions not allowed';
$string['disallowsubscription'] = 'Subscription';
$string['disallowsubscription_help'] = 'This forum has been configured so that you cannot subscribe to discussions.';
$string['disallowsubscribeteacher'] = 'Subscriptions not allowed (except for teachers)';
$string['discussion'] = 'Discussion';
$string['discussionlistsortbycreatedasc'] = 'Sort by creation date in ascending order';
$string['discussionlistsortbycreateddesc'] = 'Sort by creation date in descending order';
$string['discussionlistsortbydiscussionasc'] = 'Sort by discussion name in ascending order';
$string['discussionlistsortbydiscussiondesc'] = 'Sort by discussion name in descending order';
$string['discussionlistsortbygroupasc'] = 'Sort by group in ascending order';
$string['discussionlistsortbygroupdesc'] = 'Sort by group in descending order';
$string['discussionlistsortbylastpostdesc'] = 'Sort by last post creation date in descending order';
$string['discussionlistsortbylastpostasc'] = 'Sort by last post creation date in ascending order';
$string['discussionlistsortbyrepliesasc'] = 'Sort by number of replies in ascending order';
$string['discussionlistsortbyrepliesdesc'] = 'Sort by number of replies in descending order';
$string['discussionlistsortbystarterasc'] = 'Sort by discussion starter name in ascending order';
$string['discussionlistsortbystarterdesc'] = 'Sort by discussion starter name in descending order';
$string['discussionlocked'] = 'This discussion has been locked so you can no longer reply to it.';
$string['discussionlockingheader'] = 'Discussion locking';
$string['discussionlockingdisabled'] = 'Do not lock discussions';
$string['discussionmoved'] = 'This discussion has been moved to \'{$a}\'.';
$string['discussionmovedpost'] = 'This discussion has been moved to <a href="{$a->discusshref}">here</a> in the forum <a href="{$a->forumhref}">{$a->forumname}</a>';
$string['discussionname'] = 'Discussion name';
$string['discussionnownotsubscribed'] = '{$a->name} will NOT be notified of new posts in \'{$a->discussion}\' of \'{$a->forum}\'';
$string['discussionnowsubscribed'] = 'You will be notified of new posts in \'{$a->discussion}\' in the forum \'{$a->forum}\'.';
$string['discussionpin'] = 'Pin';
$string['discussionpinned'] = 'Pinned';
$string['discussionpinned_help'] = 'Pinned discussions will appear at the top of a forum.';
$string['discussionsplit'] = 'Discussion has been split';
$string['discussionsubscribed'] = 'You are now subscribed to this discussion.';
$string['discussionsubscribestop'] = 'I don\'t want to be notified of new posts in this discussion';
$string['discussionsubscribestart'] = 'Send me notifications of new posts in this discussion';
$string['discussionsubscription'] = 'Discussion subscription';
$string['discussionsubscription_help'] = 'Subscribing to a discussion means you will receive notifications of new posts to that discussion.';
$string['discussions'] = 'Discussions';
$string['discussionsstartedby'] = 'Discussions started by {$a}';
$string['discussionstartedby'] = 'Discussion started by {$a}';
$string['discussionsstartedbyrecent'] = 'Discussions recently started by {$a}';
$string['discussionsstartedbyuserincourse'] = 'Discussions started by {$a->fullname} in {$a->coursename}';
$string['discussionsstartedincourse'] = 'Discussions started in {$a}';
$string['discussionunpin'] = 'Unpin';
$string['discussionunsubscribed'] = 'You are now unsubscribed from this discussion.';
$string['discussthistopic'] = 'Discuss this topic';
$string['discusstopicname'] = 'Discuss the topic: {$a}';
$string['displayend'] = 'Display end';
$string['displayend_help'] = 'This setting specifies whether a forum post should be hidden after a certain date. Note that administrators can always view forum posts.';
$string['displayenddate'] = 'Display end: {$a}.';
$string['displaymode'] = 'Display mode';
$string['displayperiod'] = 'Display period';
$string['displaystart'] = 'Display start';
$string['displaystart_help'] = 'This setting specifies whether a forum post should be displayed from a certain date. Note that administrators can always view forum posts.';
$string['displaystartdate'] = 'Display start: {$a}.';
$string['displaywordcount'] = 'Display word count';
$string['displaywordcount_help'] = 'This setting specifies whether the word count of each post should be displayed or not.';
$string['duedate'] = 'Due date';
$string['duedate_help'] = 'This is when posting in the forum is due. Although this date is displayed in the calendar as the due date for the forum, posting will still be allowed after this date. Set a forum cut-off date to prevent posting to the forum after a certain date.';
$string['duedatetodisplayincalendar'] = 'Due date to display in calendar';
$string['eachuserforum'] = 'Each person posts one discussion';
$string['edit'] = 'Edit';
$string['editdiscussion'] = 'Edit discussion';
$string['editdiscussiontopic'] = 'Edit discussion topic';
$string['editedby'] = 'Edited by {$a->name} - original submission {$a->date}';
$string['editedpostupdated'] = '{$a}\'s post was updated';
$string['editing'] = 'Editing';
$string['eventcoursesearched'] = 'Course searched';
$string['eventdiscussioncreated'] = 'Discussion created';
$string['eventdiscussionupdated'] = 'Discussion updated';
$string['eventdiscussiondeleted'] = 'Discussion deleted';
$string['eventdiscussionmoved'] = 'Discussion moved';
$string['eventdiscussionviewed'] = 'Discussion viewed';
$string['eventdiscussionsubscriptioncreated'] = 'Discussion subscription created';
$string['eventdiscussionsubscriptiondeleted'] = 'Discussion subscription deleted';
$string['eventdiscussionpinned'] = 'Discussion pinned';
$string['eventdiscussionunpinned'] = 'Discussion unpinned';
$string['eventuserreportviewed'] = 'User report viewed';
$string['eventpostcreated'] = 'Post created';
$string['eventpostdeleted'] = 'Post deleted';
$string['eventpostupdated'] = 'Post updated';
$string['eventreadtrackingdisabled'] = 'Read tracking disabled';
$string['eventreadtrackingenabled'] = 'Read tracking enabled';
$string['eventsubscribersviewed'] = 'Subscribers viewed';
$string['eventsubscriptioncreated'] = 'Subscription created';
$string['eventsubscriptiondeleted'] = 'Subscription deleted';
$string['emaildigestcompleteshort'] = 'Complete posts';
$string['emaildigestdefault'] = 'Default ({$a})';
$string['emaildigestoffshort'] = 'No digest';
$string['emaildigestsubjectsshort'] = 'Subjects only';
$string['emaildigesttype'] = 'Email digest options';
$string['emaildigesttype_help'] = 'The type of notification that you will receive for each forum.

* Default - follow the digest setting found in your user profile. If you update your profile, then that change will be reflected here too;
* No digest - you will receive one e-mail per forum post;
* Digest - complete posts - you will receive one digest e-mail per day containing the complete contents of each forum post;
* Digest - subjects only - you will receive one digest e-mail per day containing just the subject of each forum post.
';
$string['emptymessage'] = 'Something was wrong with your post. Perhaps you left it blank, or the attachment was too big. Your changes have NOT been saved.';
$string['errorcannotlock'] = 'You do not have the permission to lock discussions.';
$string['errordiscussionnotfound'] = 'The discussion was not found';
$string['erroremptymessage'] = 'Post message cannot be empty';
$string['erroremptysubject'] = 'Post subject cannot be empty.';
$string['errorenrolmentrequired'] = 'You must be enrolled in this course to access this content';
$string['errorforumnotfound'] = 'The forum that this discussion belongs to was not found';
$string['errorwhiledelete'] = 'An error occurred while deleting record.';
$string['eventassessableuploaded'] = 'Some content has been posted.';
$string['everyonecanchoose'] = 'Everyone can choose to be subscribed';
$string['everyonecannowchoose'] = 'Everyone can now choose to be subscribed';
$string['everyoneisnowsubscribed'] = 'Everyone is now subscribed to this forum';
$string['everyoneissubscribed'] = 'Everyone is subscribed to this forum';
$string['existingsubscribers'] = 'Existing subscribers';
$string['export'] = 'Export';
$string['exportattachmentname'] = 'Export attachment {$a} to portfolio';
$string['exportdiscussion'] = 'Export whole discussion to portfolio';
$string['exportstriphtml'] = 'Remove HTML';
$string['exportstriphtml_help'] = 'Whether HTML tags such as p and br should be removed from the forum post message.';
$string['exportoptions'] = 'Export options';
$string['exporthumandates'] = 'Human-readable dates';
$string['exporthumandates_help'] = 'Whether dates should be exported in a human-readable format or as a timestamp (sequence of numbers).';
$string['firstpost'] = 'First post';
$string['favourites'] = 'Starred';
$string['favouriteupdated'] = 'Your star option has been updated.';
$string['forcedreadtracking'] = 'Allow forced read tracking';
$string['forcedreadtracking_desc'] = 'Allows forums to be set to forced read tracking. Will result in decreased performance for some users, particularly on courses with many forums and posts. When off, any forums previously set to Forced are treated as optional.';
$string['forcesubscribed_help'] = 'This forum has been configured so that you cannot unsubscribe from discussions.';
$string['forcesubscribed'] = 'This forum forces everyone to be subscribed';
$string['forum'] = 'Forum';
$string['forum:addinstance'] = 'Add a new forum';
$string['forum:addnews'] = 'Add announcements';
$string['forum:addquestion'] = 'Add question';
$string['forum:allowforcesubscribe'] = 'Allow force subscribe';
$string['forum:canoverridecutoff'] = 'Post to forums after their cut-off date';
$string['forum:canoverridediscussionlock'] = 'Reply to locked discussions';
$string['forum:cantogglefavourite'] = 'Star discussions';
$string['forum:grade'] = 'Grade forum';
$string['forumauthorhidden'] = 'Author (hidden)';
$string['forumblockingalmosttoomanyposts'] = 'You are approaching the posting threshold. You have posted {$a->numposts} times in the last {$a->blockperiod} and the limit is {$a->blockafter} posts.';
$string['forumbodyhidden'] = 'This post is currently hidden, most likely because you need to post in the discussion first and forum post notifications must be sent. Another possibility is that the current time is not within the display period set for the post.';
$string['forum:canposttomygroups'] = 'Post to all groups you have access to';
$string['forum:createattachment'] = 'Create attachments';
$string['forum:deleteanypost'] = 'Delete any posts (anytime)';
$string['forum:deleteownpost'] = 'Delete own posts (within deadline)';
$string['forum:editanypost'] = 'Edit any post';
$string['forum:exportdiscussion'] = 'Export whole discussion';
$string['forum:exportforum'] = 'Export forum';
$string['forum:exportownpost'] = 'Export own post';
$string['forum:exportpost'] = 'Export post';
$string['forumgradingnavigation'] = 'Forum grading navigation';
$string['forumgradingpanel'] = 'Forum grading panel';
$string['forumintro'] = 'Description';
$string['forum:managesubscriptions'] = 'Manage subscribers';
$string['forum:movediscussions'] = 'Move discussions';
$string['forum:pindiscussions'] = 'Pin discussions';
$string['forum:postwithoutthrottling'] = 'Exempt from post threshold';
$string['forumname'] = 'Forum name';
$string['forumposts'] = 'Forum posts';
$string['forum:rate'] = 'Rate posts';
$string['forum:replynews'] = 'Reply to announcements';
$string['forum:replypost'] = 'Reply to posts';
$string['replypostdiscussion'] = 'Reply to discussion';
$string['forum:postprivatereply'] = 'Reply privately to posts';
$string['forum:readprivatereplies'] = 'View private replies';
$string['forums'] = 'Forums';
$string['forum:splitdiscussions'] = 'Split discussions';
$string['forum:startdiscussion'] = 'Start new discussions';
$string['forumsubjecthidden'] = 'Subject (hidden)';
$string['forumtracked'] = 'Unread posts are being tracked';
$string['forumtrackednot'] = 'Unread posts are not being tracked';
$string['forumtype'] = 'Forum type';
$string['forumtype_help'] = 'There are 5 forum types:

* A single simple discussion - A single discussion topic which everyone can reply to (cannot be used with separate groups)
* Each person posts one discussion - Each student can post exactly one new discussion topic, which everyone can then reply to
* Q and A forum - A student must first post their reply to a question posted by the teacher, before viewing other students\' posts
* Standard forum displayed in a blog-like format - An open forum where anyone can start a new discussion at any time, and in which discussion topics are displayed on one page with "Discuss this topic" links
* Standard forum for general use - An open forum where anyone can start a new discussion at any time';
$string['forum:viewallratings'] = 'View all raw ratings given by individuals';
$string['forum:viewanyrating'] = 'View total ratings that anyone received';
$string['forum:viewdiscussion'] = 'View discussions';
$string['forum:viewhiddentimedposts'] = 'View hidden timed posts';
$string['forum:viewqandawithoutposting'] = 'Always see Q and A posts';
$string['forum:viewrating'] = 'View the total rating you received';
$string['forum:viewsubscribers'] = 'View subscribers';
$string['generalforum'] = 'Standard forum for general use';
$string['generalforums'] = 'General forums';
$string['gradeitem:forum'] = 'Forum';
$string['hiddenforumpost'] = 'Hidden forum post';
$string['hidegraderpanel'] = 'Hide grader panel';
$string['hidepreviousrepliescount'] = 'Hide previous replies ({$a})';
$string['hideusersearch'] = 'Hide user search';
$string['indicator:cognitivedepth'] = 'Forum cognitive';
$string['indicator:cognitivedepth_help'] = 'This indicator is based on the cognitive depth reached by the student in a Forum activity.';
$string['indicator:cognitivedepthdef'] = 'Forum cognitive';
$string['indicator:cognitivedepthdef_help'] = 'The participant has reached this percentage of the cognitive engagement offered by the Forum activities during this analysis interval (Levels = No view, View, Submit, View feedback, Comment on feedback, Resubmit after viewing feedback)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Forum social';
$string['indicator:socialbreadth_help'] = 'This indicator is based on the social breadth reached by the student in a Forum activity.';
$string['indicator:socialbreadthdef'] = 'Forum social';
$string['indicator:socialbreadthdef_help'] = 'The participant has reached this percentage of the social engagement offered by the Forum activities during this analysis interval (Levels = No participation, Participant alone, Participant with others)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['starredonly'] = 'Search starred discussions only';
$string['indexoutoftotal'] = '{$a->index} out of {$a->total}';
$string['inforum'] = 'in {$a}';
$string['inreplyto'] = 'In reply to {$a}';
$string['introblog'] = 'The posts in this forum were copied here automatically from blogs of users in this course because those blog entries are no longer available';
$string['intronews'] = 'General news and announcements';
$string['introsocial'] = 'An open forum for chatting about anything you want to';
$string['introteacher'] = 'A forum for teacher-only notes and discussion';
$string['invalidaccess'] = 'This page was not accessed correctly';
$string['invaliddiscussionid'] = 'Discussion ID was incorrect or no longer exists';
$string['invaliddigestsetting'] = 'An invalid mail digest setting was provided';
$string['invalidforcesubscribe'] = 'Invalid force subscription mode';
$string['invalidforumid'] = 'Forum ID was incorrect';
$string['invalidparentpostid'] = 'Parent post ID was incorrect';
$string['invalidpostid'] = 'Invalid post ID - {$a}';
$string['lastpost'] = 'Last post';
$string['learningforums'] = 'Learning forums';
$string['lockdiscussionafter'] = 'Lock discussions after period of inactivity';
$string['lockdiscussionafter_help'] = 'Discussions may be automatically locked after a specified time has elapsed since the last reply.

Users with the capability to reply to locked discussions can unlock a discussion by replying to it.';
$string['longpost'] = 'Long post';
$string['locked'] = 'Locked';
$string['lockdiscussion'] = 'Lock this discussion';
$string['lockupdated'] = 'The lock option has been updated.';
$string['mailnow'] = 'Send forum post notifications with no editing-time delay';
$string['manydiscussions'] = 'Discussions per page';
$string['managesubscriptionsoff'] = 'Finish managing subscriptions';
$string['managesubscriptionson'] = 'Manage subscribers';
$string['markasread'] = 'Mark as read';
$string['markalldread'] = 'Mark all posts in this discussion read.';
$string['markallread'] = 'Mark all posts in this forum read.';
$string['markasreadonnotification'] = 'When sending forum post notifications';
$string['markasreadonnotificationno'] = 'Do not mark the post as read';
$string['markasreadonnotificationyes'] = 'Mark the post as read';
$string['markasreadonnotification_help'] = 'When you are notified of a forum post, you can choose whether this should mark the post as read for the purpose of forum tracking.';
$string['markread'] = 'Mark read';
$string['markreadbutton'] = 'Mark<br />read';
$string['markunread'] = 'Mark unread';
$string['markunreadbutton'] = 'Mark<br />unread';
$string['maxattachments'] = 'Maximum number of attachments';
$string['maxattachments_help'] = 'This setting specifies the maximum number of files that can be attached to a forum post.';
$string['maxattachmentsize'] = 'Maximum attachment size';
$string['maxattachmentsize_help'] = 'This setting specifies the largest size of file that can be attached to a forum post.';
$string['maxtimehaspassed'] = 'Sorry, but the maximum time for editing this post ({$a}) has passed!';
$string['message'] = 'Message';
$string['messageinboundattachmentdisallowed'] = 'Unable to post your reply, since it includes an attachment and the forum doesn\'t allow attachments.';
$string['messageinboundfilecountexceeded'] = 'Unable to post your reply, since it includes more than the maximum number of attachments allowed for the forum ({$a->forum->maxattachments}).';
$string['messageinboundfilesizeexceeded'] = 'Unable to post your reply, since the total attachment size ({$a->filesize}) is greater than the maximum size allowed for the forum ({$a->maxbytes}).';
$string['messageinboundforumhidden'] = 'Unable to post your reply, since the forum is currently unavailable.';
$string['messageinboundnopostforum'] = 'Unable to post your reply, since you do not have permission to post in the {$a->forum->name} forum.';
$string['messageinboundthresholdhit'] = 'Unable to post your reply.  You have exceeded the posting threshold set for this forum';
$string['messageprovider:digests'] = 'Subscribed forum digests';
$string['messageprovider:posts'] = 'Subscribed forum posts';
$string['missingsearchterms'] = 'The following search terms occur only in the HTML markup of this message:';
$string['modeflatnewestfirst'] = 'Display replies flat, with newest first';
$string['modeflatoldestfirst'] = 'Display replies flat, with oldest first';
$string['modenested'] = 'Display replies in nested form';
$string['modenestedv2'] = 'Display replies in experimental nested form';
$string['modethreaded'] = 'Display replies in threaded form';
$string['modulename'] = 'Forum';
$string['modulename_help'] = 'The forum activity module enables participants to have asynchronous discussions i.e. discussions that take place over an extended period of time.

There are several forum types to choose from, such as a standard forum where anyone can start a new discussion at any time; a forum where each student can post exactly one discussion; or a question and answer forum where students must first post before being able to view other students\' posts. A teacher can allow files to be attached to forum posts. Attached images are displayed in the forum post.

Participants can subscribe to a forum to receive notifications of new forum posts. A teacher can set the subscription mode to optional, forced or auto, or prevent subscription completely. If required, students can be blocked from posting more than a given number of posts in a given time period; this can prevent individuals from dominating discussions.

Forum posts can be rated by teachers or students (peer evaluation). Ratings can be aggregated to form a final grade which is recorded in the gradebook.

Forums have many uses, such as

* A social space for students to get to know each other
* For course announcements (using a news forum with forced subscription)
* For discussing course content or reading materials
* For continuing online an issue raised previously in a face-to-face session
* For teacher-only discussions (using a hidden forum)
* A help centre where tutors and students can give advice
* A one-on-one support area for private student-teacher communications (using a forum with separate groups and with one student per group)
* For extension activities, for example ‘brain teasers’ for students to ponder and suggest solutions to';
$string['modulename_link'] = 'mod/forum/view';
$string['modulenameplural'] = 'Forums';
$string['more'] = 'more';
$string['movedmarker'] = '(Moved)';
$string['movethisdiscussionlabel'] = 'Move the current discussion to the specified forum';
$string['movethisdiscussionto'] = 'Move this discussion to ...';
$string['mustprovidediscussionorpost'] = 'You must provide either a discussion ID or post ID to export.';
$string['myprofileownpost'] = 'My forum posts';
$string['myprofileowndis'] = 'My forum discussions';
$string['myprofileotherdis'] = 'Forum discussions';
$string['namenews'] = 'Announcements';
$string['namenews_help'] = 'The course announcements forum is a special forum for announcements and is automatically created when a course is created. A course can have only one announcements forum. Only teachers and administrators can post announcements. The "Latest announcements" block will display recent announcements.';
$string['namesocial'] = 'Social forum';
$string['nameteacher'] = 'Teacher forum';
$string['nextdiscussiona'] = 'Next discussion: {$a}';
$string['nextuser'] = 'Save changes and proceed to the next user';
$string['newforumposts'] = 'New forum posts';
$string['noattachments'] = 'There are no attachments to this post';
$string['nodiscussions'] = 'There are no discussion topics yet in this forum';
$string['nodiscussionsstartedby'] = '{$a} has not started any discussions';
$string['nodiscussionsstartedbyyou'] = 'You haven\'t started any discussions yet';
$string['noguestpost'] = 'Sorry, guests are not allowed to post.';
$string['noguestsubscribe'] = 'Sorry, guests are not allowed to subscribe.';
$string['noguesttracking'] = 'Sorry, guests are not allowed to set tracking options.';
$string['nomorepostscontaining'] = 'No more posts containing \'{$a}\' were found';
$string['nonews'] = 'No announcements have been posted yet.';
$string['noonecansubscribenow'] = 'Subscriptions are now disallowed';
$string['nopermissiontosubscribe'] = 'You do not have the permission to view forum subscribers';
$string['nopermissiontoview'] = 'You do not have permissions to view this post';
$string['nopostforum'] = 'Sorry, you are not allowed to post to this forum';
$string['noposts'] = 'No posts';
$string['nopostsmadebyuser'] = '{$a} has made no posts';
$string['nopostsmadebyyou'] = 'You haven\'t made any posts';
$string['noquestions'] = 'There are no questions yet in this forum';
$string['nosubscribers'] = 'There are no subscribers yet for this forum';
$string['notsubscribed'] = 'Subscribe';
$string['notexists'] = 'Discussion no longer exists';
$string['nothingnew'] = 'Nothing new for {$a}';
$string['notingroup'] = 'Sorry, but you need to be part of a group to see this forum.';
$string['notinstalled'] = 'The forum module is not installed';
$string['notlocked'] = 'Lock';
$string['notpartofdiscussion'] = 'This post is not part of a discussion!';
$string['notrackforum'] = 'Don\'t track unread posts';
$string['noviewdiscussionspermission'] = 'You do not have the permission to view discussions in this forum';
$string['nowallsubscribed'] = 'You are now subscribed to all forums in {$a}.';
$string['nowallunsubscribed'] = 'You are now unsubscribed from all forums in {$a}.';
$string['nownotsubscribed'] = '{$a->name} will NOT be notified of new posts in \'{$a->forum}\'';
$string['nownottracking'] = '{$a->name} is no longer tracking \'{$a->forum}\'.';
$string['nowsubscribed'] = 'You will be notified of new posts in the forum \'{$a->forum}\'.';
$string['nowtracking'] = '{$a->name} is now tracking \'{$a->forum}\'.';
$string['numposts'] = '{$a} posts';
$string['numberofreplies'] = 'Number of replies: {$a}';
$string['olderdiscussions'] = 'Older discussions';
$string['oldertopics'] = 'Older topics';
$string['oldpostdays'] = 'Read after days';
$string['page-mod-forum-x'] = 'Any forum module page';
$string['page-mod-forum-view'] = 'Forum module main page';
$string['page-mod-forum-discuss'] = 'Forum module discussion thread page';
$string['parent'] = 'Show parent';
$string['parentofthispost'] = 'Parent of this post';
$string['permalink'] = 'Permalink';
$string['permanentlinktopost'] = 'Permanent link to this post';
$string['permanentlinktoparentpost'] = 'Permanent link to the parent of this post';
$string['postisprivatereply'] = 'This is a private reply. (Teachers and other users with the capability to view private replies can also see it.)';
$string['pindiscussion'] = 'Pin this discussion';
$string['pinupdated'] = 'The pin option has been updated.';
$string['posttomygroups'] = 'Post a copy to all groups';
$string['posttomygroups_help'] = 'Posts a copy of this message to all groups you have access to. Participants in groups you do not have access to will not see this post';
$string['prevdiscussiona'] = 'Previous discussion: {$a}';
$string['pluginadministration'] = 'Forum administration';
$string['pluginname'] = 'Forum';
$string['postadded'] = '<p>Your post was successfully added.</p> <p>You have {$a} to edit it if you want to make any changes.</p>';
$string['postaddedsuccess'] = 'Your post was successfully added.';
$string['postaddedtimeleft'] = 'You have {$a} to edit it if you want to make any changes.';
$string['postbymailsuccess'] = 'Your reply "{$a->subject}" was successfully posted: {$a->discussionurl}';
$string['postbymailsuccess_html'] = 'Your reply <a href="{$a->discussionurl}">{$a->subject}</a> was successfully posted.';
$string['postbyuser'] = '{$a->post} by {$a->user}';
$string['postincontext'] = 'See this post in context';
$string['postmailinfo'] = 'This is a copy of a message posted in {$a}.';
$string['postmailnow'] = '<p>This post will be mailed out immediately to all forum subscribers.</p>';
$string['postmailreply'] = 'To reply click on this link: {$a}';
$string['postmailsubject'] = '{$a->courseshortname}: {$a->subject}';
$string['postrating1'] = 'Mostly separate knowing';
$string['postrating2'] = 'Separate and connected';
$string['postrating3'] = 'Mostly connected knowing';
$string['posts'] = 'Posts';
$string['postsfrom'] = 'Posts from';
$string['postsmadebyuser'] = 'Posts made by {$a}';
$string['postsmadebyuserincourse'] = 'Posts made by {$a->fullname} in {$a->coursename}';
$string['postsmadeincourse'] = 'Posts made in {$a}';
$string['poststo'] = 'Posts to';
$string['posttoforum'] = 'Post to forum';
$string['postupdated'] = 'Your post was updated';
$string['potentialsubscribers'] = 'Potential subscribers';
$string['previoususer'] = 'Save changes and proceed to the previous user';
$string['privacy:digesttypenone'] = 'We do not hold any data relating to a preferred forum digest type for this forum.';
$string['privacy:digesttypepreference'] = 'You have chosen to receive the following forum digest type: "{$a->type}".';
$string['privacy:discussionsubscriptionpreference'] = 'You have chosen the following discussion subscription preference for this forum: "{$a->preference}"';
$string['privacy:metadata:core_tag'] = 'The forum makes use of the tag subsystem to support tagging of posts.';
$string['privacy:metadata:core_rating'] = 'The forum makes use of the rating subsystem to support the rating of posts.';
$string['privacy:metadata:forum_digests'] = 'Information about the digest preferences for each forum.';
$string['privacy:metadata:forum_digests:forum'] = 'The forum subscribed to.';
$string['privacy:metadata:forum_digests:maildigest'] = 'The digest preference.';
$string['privacy:metadata:forum_digests:userid'] = 'The ID of the user with the digest preference.';
$string['privacy:metadata:forum_discussion_subs'] = 'Information about the subscriptions to individual forum discussions';
$string['privacy:metadata:forum_discussion_subs:discussionid'] = 'The ID of the discussion that was subscribed to.';
$string['privacy:metadata:forum_discussion_subs:preference'] = 'The start time of the subscription.';
$string['privacy:metadata:forum_discussion_subs:userid'] = 'The ID of the user with the discussion subscription.';
$string['privacy:metadata:forum_discussions'] = 'Information about the individual forum discussions that a user has created';
$string['privacy:metadata:forum_discussions:assessed'] = 'TODOD - what does this field store';
$string['privacy:metadata:forum_discussions:name'] = 'The name of the discussion, as chosen by the author.';
$string['privacy:metadata:forum_discussions:timemodified'] = 'The time that the discussion was last modified.';
$string['privacy:metadata:forum_discussions:userid'] = 'The ID of the user who created the discussion';
$string['privacy:metadata:forum_discussions:usermodified'] = 'The ID of the user who last modified the discussion in some way.';
$string['privacy:metadata:forum_grades'] = 'Grade data for the forum';
$string['privacy:metadata:forum_grades:forum'] = 'The forum that was graded';
$string['privacy:metadata:forum_grades:grade'] = 'The grade awarded';
$string['privacy:metadata:forum_grades:userid'] = 'The user who was graded';
$string['privacy:metadata:forum_posts'] = 'Information about the digest preferences for each forum.';
$string['privacy:metadata:forum_posts:created'] = 'The time that the post was created.';
$string['privacy:metadata:forum_posts:discussion'] = 'The discussion that the post is in.';
$string['privacy:metadata:forum_posts:message'] = 'The message of the forum post.';
$string['privacy:metadata:forum_posts:modified'] = 'The time that the post was last modified.';
$string['privacy:metadata:forum_posts:parent'] = 'The parent post that was replied to.';
$string['privacy:metadata:forum_posts:subject'] = 'The subject of the forum post.';
$string['privacy:metadata:forum_posts:totalscore'] = 'The message of the forum post.';
$string['privacy:metadata:forum_posts:userid'] = 'The ID of the user who authored the forum post.';
$string['privacy:metadata:forum_posts:privatereplyto'] = 'The ID of the user this reply was sent to.';
$string['privacy:metadata:forum_queue'] = 'Temporary log of posts that will be mailed in digest form';
$string['privacy:metadata:forum_queue:discussionid'] = 'Forum discussion ID';
$string['privacy:metadata:forum_queue:postid'] = 'Forum post ID';
$string['privacy:metadata:forum_queue:timemodified'] = 'The modified time of the original post';
$string['privacy:metadata:forum_queue:userid'] = 'User who needs to be notified of the post';
$string['privacy:metadata:forum_read'] = 'Information about which posts have been read by the user.';
$string['privacy:metadata:forum_read:discussionid'] = 'The discussion that the post is in.';
$string['privacy:metadata:forum_read:firstread'] = 'The first time that the post was read.';
$string['privacy:metadata:forum_read:lastread'] = 'The most recent time that the post was read.';
$string['privacy:metadata:forum_read:postid'] = 'The post that was read.';
$string['privacy:metadata:forum_read:userid'] = 'The ID of the user that this record relates to.';
$string['privacy:metadata:forum_subscriptions'] = 'Information about which forums the user has subscribed to.';
$string['privacy:metadata:forum_subscriptions:forum'] = 'The forum that was subscribed to.';
$string['privacy:metadata:forum_subscriptions:userid'] = 'The ID of the user that this forum subscription relates to.';
$string['privacy:metadata:forum_track_prefs'] = 'Information about which forums the user has chosen to track post reads for.';
$string['privacy:metadata:forum_track_prefs:forumid'] = 'The forum that has read tracking enabled.';
$string['privacy:metadata:forum_track_prefs:userid'] = 'The ID of the user that this forum tracking preference relates to.';
$string['privacy:metadata:preference:autosubscribe'] = 'Whether to subscribe to discussions when replying to posts within them.';
$string['privacy:metadata:preference:forum_discussionlistsortorder'] = 'The preferred sorting order of the discussions list';
$string['privacy:metadata:preference:maildigest'] = 'The site-wide mail digest preference';
$string['privacy:metadata:preference:markasreadonnotification'] = 'Whether to mark forum posts as read when receiving them as messages.';
$string['privacy:metadata:preference:trackforums'] = 'Whether to enable read tracking.';
$string['privacy:postwasread'] = 'This post was first read on {$a->firstread} and most recently read on {$a->lastread}';
$string['privacy:readtrackingdisabled'] = 'You have chosen to not track posts you have read within this forum.';
$string['privacy:request:delete:discussion:name'] = 'Delete at the request of the author';
$string['privacy:request:delete:post:message'] = 'The content of this post has been deleted at the request of its author.';
$string['privacy:request:delete:post:subject'] = 'Delete at the request of the author';
$string['privacy:subscribedtoforum'] = 'You are subscribed to this forum.';
$string['privatereply'] = 'Reply privately';
$string['privatereply_help'] = 'When you reply privately, your post is also visible to users with the capability to view private replies, such as teachers.';
$string['processingdigest'] = 'Processing email digest for user {$a}';
$string['processingpost'] = 'Processing post {$a}';
$string['prune'] = 'Split';
$string['prunediscussion'] = 'Split discussion';
$string['prunedpost'] = 'A new discussion has been created from that post';
$string['pruneheading'] = 'Split the discussion and move this post to a new discussion';
$string['qandaforum'] = 'Q and A forum';
$string['qandanotify'] = 'This is a question and answer forum. To see other replies, you must first post your reply.';
$string['re'] = 'Re:';
$string['readtherest'] = 'Read the rest of this topic';
$string['removeallforumtags'] = 'Remove all forum tags';
$string['removefromfavourites'] = 'Unstar this discussion';
$string['replies'] = 'Replies';
$string['repliesmany'] = '{$a} replies so far';
$string['repliesone'] = '{$a} reply so far';
$string['reply'] = 'Reply';
$string['replyauthorself'] = '{$a} (you)';
$string['replyingtoauthor'] = 'Replying to {$a}...';
$string['replyplaceholder'] = 'Write your reply...';
$string['replyforum'] = 'Reply to forum';
$string['replytopostbyemail'] = 'You can reply to this via email.';
$string['replytouser'] = 'Use email address in reply';
$string['reply_handler'] = 'Reply to forum posts via email';
$string['reply_handler_name'] = 'Reply to forum posts';
$string['resetforums'] = 'Delete posts from';
$string['resetforumsall'] = 'Delete all posts';
$string['resetdigests'] = 'Delete all per-user forum digest preferences';
$string['resetsubscriptions'] = 'Delete all forum subscriptions';
$string['resettrackprefs'] = 'Delete all forum tracking preferences';
$string['rsssubscriberssdiscussions'] = 'RSS feed of discussions';
$string['rsssubscriberssposts'] = 'RSS feed of posts';
$string['rssarticles'] = 'Number of RSS recent articles';
$string['rssarticles_help'] = 'This setting specifies the number of articles (either discussions or posts) to include in the RSS feed. Between 5 and 20 generally acceptable.';
$string['rsstype'] = 'RSS feed for this activity';
$string['rsstype_help'] = 'To enable the RSS feed for this activity, select either discussions or posts to be included in the feed.';
$string['rsstypedefault'] = 'RSS feed type';
$string['search'] = 'Search';
$string['search:post'] = 'Forum - posts';
$string['search:activity'] = 'Forum - activity information';
$string['searchdatefrom'] = 'Posts must be newer than this';
$string['searchdateto'] = 'Posts must be older than this';
$string['searchforumintro'] = 'Please enter search terms into one or more of the following fields:';
$string['searchforums'] = 'Search forums';
$string['searchfullwords'] = 'These words should appear as whole words';
$string['searchnotwords'] = 'These words should NOT be included';
$string['searcholderposts'] = 'Search older posts...';
$string['searchphrase'] = 'This exact phrase must appear in the post';
$string['searchresults'] = 'Search results';
$string['searchsubject'] = 'These words should be in the subject';
$string['searchtags'] = 'Is tagged with';
$string['searchuser'] = 'This name should match the author';
$string['searchusers'] = 'Search users';
$string['searchuserid'] = 'The Moodle ID of the author';
$string['searchwhichforums'] = 'Choose which forums to search';
$string['searchwords'] = 'These words can appear anywhere in the post';
$string['seeallposts'] = 'See all posts made by this user';
$string['sendstudentnotificationsno'] = 'No';
$string['sendstudentnotificationsyes'] = 'Yes, send notification to student';
$string['sendstudentnotificationsdefault'] = 'Default setting for "Notify students"';
$string['sendstudentnotificationsdefault_help'] = 'Set the default value for the "Notify students" checkbox on the grading form.';
$string['settings'] = 'Settings';
$string['shortpost'] = 'Short post';
$string['showingcountoftotaldiscussions'] = 'List of discussions. Showing {$a->count} of {$a->total} discussions';
$string['showgraderpanel'] = 'Show grader panel';
$string['showpreviousrepliescount'] = 'Show previous replies ({$a})';
$string['showsubscribers'] = 'Show/edit current subscribers';
$string['showusersearch'] = 'Show user search';
$string['singleforum'] = 'A single simple discussion';
$string['smallmessage'] = '{$a->user} posted in {$a->forumname}';
$string['smallmessagedigest'] = 'Forum digest containing {$a} messages';
$string['startedby'] = 'Started by';
$string['subject'] = 'Subject';
$string['subplugintype_forumreport'] = 'Forum report';
$string['subplugintype_forumreport_plural'] = 'Forum reports';
$string['subscribe'] = 'Subscribe to forum';
$string['subscribediscussion'] = 'Subscribe to this discussion';
$string['subscribeall'] = 'Subscribe everyone to this forum';
$string['subscribeenrolledonly'] = 'Sorry, only enrolled users are allowed to subscribe to forum post notifications.';
$string['subscribed'] = 'Subscribed';
$string['subscribenone'] = 'Unsubscribe everyone from this forum';
$string['subscribers'] = 'Subscribers';
$string['subscriberstowithcount'] = 'Subscribers to "{$a->name}" ({$a->count})';
$string['subscribestart'] = 'Send me notifications of new posts in this forum';
$string['subscribestop'] = 'I don\'t want to be notified of new posts in this forum';
$string['subscription'] = 'Subscription';
$string['subscription_help'] = 'If you are subscribed to a forum it means you will receive notification of new forum posts. Usually you can choose whether you wish to be subscribed, though sometimes subscription is forced so that everyone receives notifications.';
$string['subscriptionandtracking'] = 'Subscription and tracking';
$string['subscriptionmode'] = 'Subscription mode';
$string['subscriptionmodeconfirm'] = 'Are you sure you want to change the subscription mode to {$a}?';
$string['subscriptionmode_help'] = 'When a participant is subscribed to a forum it means they will receive forum post notifications. There are 4 subscription mode options:

* Optional subscription - Participants can choose whether to be subscribed
* Forced subscription - Everyone is subscribed and cannot unsubscribe
* Auto subscription - Everyone is subscribed initially but can choose to unsubscribe at any time
* Subscription disabled - Subscriptions are not allowed';
$string['subscriptionoptional'] = 'Optional subscription';
$string['subscriptionforced'] = 'Forced subscription';
$string['subscriptionauto'] = 'Auto subscription';
$string['subscriptiondisabled'] = 'Subscription disabled';
$string['subscriptions'] = 'Subscriptions';
$string['tagarea_forum_posts'] = 'Forum posts';
$string['tagsdeleted'] = 'Forum tags have been deleted';
$string['thisforumisthrottled'] = 'This forum has a limit to the number of forum postings you can make in a given time period - this is currently set at {$a->blockafter} posting(s) in {$a->blockperiod}';
$string['thisforumisdue'] = 'The due date for posting to this forum was {$a}.';
$string['thisforumhasduedate'] = 'The due date for posting to this forum is {$a}.';
$string['timed'] = 'Timed';
$string['timeddiscussion'] = 'Timed discussion';
$string['timedhidden'] = 'Timed status: Hidden from students';
$string['timedposts'] = 'Timed posts';
$string['timedvisible'] = 'Timed status: Visible to all users';
$string['timestartenderror'] = 'Display end date cannot be earlier than the start date';
$string['togglediscussionmenu'] = 'Toggle the discussion menu';
$string['togglefullscreen'] = 'Toggle full screen';
$string['togglesettingsdrawer'] = 'Toggle settings drawer';
$string['trackforum'] = 'Track unread posts';
$string['trackreadposts_header'] = 'Forum tracking';
$string['tracking'] = 'Track';
$string['trackingoff'] = 'Off';
$string['trackingon'] = 'Forced';
$string['trackingoptional'] = 'Optional';
$string['trackingtype'] = 'Read tracking';
$string['trackingtype_help'] = 'Read tracking enables participants to check which posts they have not yet seen by highlighting any new posts.

If set to optional, participants can choose whether to turn tracking on or off for the forum. (Users must also enable forum tracking in their forum preferences.)

If \'Allow forced read tracking\' is enabled by a site administrator, then a further option is available - forced. This means that tracking is always on, regardless of users\' forum preferences.';
$string['unlockdiscussion'] = 'Unlock this discussion';
$string['unread'] = 'Unread';
$string['unreadpost'] = 'Unread post';
$string['unreadposts'] = 'Unread posts';
$string['unreadpostsnumber'] = '{$a} unread posts';
$string['unreadpostsone'] = '1 unread post';
$string['unsubscribe'] = 'Unsubscribe from forum';
$string['unsubscribelink'] = 'Unsubscribe from this forum: {$a}';
$string['unsubscribediscussion'] = 'Unsubscribe from this discussion';
$string['unsubscribediscussionlink'] = 'Unsubscribe from this discussion: {$a}';
$string['unsubscribeall'] = 'Unsubscribe from all forums';
$string['unsubscribeallconfirm'] = 'You are currently subscribed to {$a->forums} forums, and {$a->discussions} discussions. Do you really want to unsubscribe from all forums and discussions, and disable discussion auto-subscription?';
$string['unsubscribeallconfirmforums'] = 'You are currently subscribed to {$a->forums} forums. Do you really want to unsubscribe from all forums and disable discussion auto-subscription?';
$string['unsubscribeallconfirmdiscussions'] = 'You are currently subscribed to {$a->discussions} discussions. Do you really want to unsubscribe from all discussions and disable discussion auto-subscription?';
$string['unsubscribealldone'] = 'All optional forum subscriptions were removed. You will still receive notifications from forums with forced subscription. To manage forum notifications go to Messaging in My Profile Settings.';
$string['unsubscribeallempty'] = 'You are not subscribed to any forums. To disable all notifications from this server go to Messaging in My Profile Settings.';
$string['unsubscribed'] = 'Unsubscribed';
$string['unsubscribeshort'] = 'Unsubscribe';
$string['useexperimentalui'] = 'Use experimental nested discussion view';
$string['usermarksread'] = 'Manual message read marking';
$string['usernavigation'] = 'User navigation';
$string['usersforumposts'] = 'User\'s forum posts';
$string['unpindiscussion'] = 'Unpin this discussion';
$string['viewalldiscussions'] = 'View all discussions';
$string['viewparentpost'] = 'View parent post';
$string['viewthediscussion'] = 'View the discussion';
$string['warnafter'] = 'Post threshold for warning';
$string['warnafter_help'] = 'Students can be warned as they approach the maximum number of posts allowed in a given period. This setting specifies after how many posts they are warned. Users with the capability mod/forum:postwithoutthrottling are exempt from post limits.';
$string['warnformorepost'] = 'Warning! There is more than one discussion in this forum - using the most recent';
$string['yournewquestion'] = 'Your new question';
$string['yournewtopic'] = 'Your new discussion topic';
$string['yourreply'] = 'Your reply';
$string['forumsubjectdeleted'] = 'This forum post has been removed';
$string['forumbodydeleted'] = 'The content of this forum post has been removed and can no longer be accessed.';
$string['forumgrader'] = 'Forum grader';
$string['grade_forum_header'] = 'Whole forum grading';
$string['grade_forum_name'] = 'Whole forum';
$string['grade_forum_title'] = 'Grade';
$string['grade_rating_name'] = 'Rating';
$string['gradeusers'] = 'Grade users';
$string['graded'] = 'Graded';
$string['gradedby'] = 'Graded by';
$string['notgraded'] = 'Not graded';
$string['nowgradinguser'] = 'Now grading {$a}';
$string['gradeforrating'] = 'Grade for rating: {$a->str_long_grade}';
$string['gradeforratinghidden'] = 'Grade for rating hidden';
$string['gradeforwholeforum'] = 'Grade for forum: {$a->str_long_grade}';
$string['grading'] = 'Grading';
$string['gradingstatus'] = 'Grade status:';
$string['gradeforwholeforumhidden'] = 'Grade for forum hidden';
$string['gradeitemnameforwholeforum'] = '{$a->name} whole forum';
$string['gradeitemnameforrating'] = '{$a->name} rating';
$string['grades:gradesavedfor'] = 'Grade saved for {$a->fullname}';
$string['grades:gradesavefailed'] = 'Unable to save grade for {$a->fullname}: {$a->error}';
$string['notgraded'] = 'Not graded';
$string['nousersmatch'] = 'No user(s) found for given criteria';
$string['showmoreusers'] = 'Show more users';
$string['viewconversation'] = 'View discussion';
$string['viewgrades'] = 'View grades';

// Deprecated since Moodle 4.0.
$string['postmailinfolink'] = 'This is a copy of a message posted in {$a->coursename}.

To reply click on this link: {$a->replylink}';
