#!/bin/bash
shopt -s extglob

ROOT_DIR=/var/www/html/nextcloud

# Execution du cron nextcloud
sudo -u www-data php -f /var/www/html/nextcloud/cron.php

# Suppression des utilisateurs obsolètes
sudo -u www-data php  ${ROOT_DIR}/occ ldap:show-remnants > /tmp/remnantslst.txt
IFS=$'\n' read -d '' -r -a lines <<< $(</tmp/remnantslst.txt)
for line in "${lines[@]}"
do
    IFS=$'|' read -d '' -r -a array <<< $line

    # Suppresion des espaces
    userid="${array[1]%%*( )}"
    userid="${userid##*( )}"
    
    if [ ! -z "${userid}" ] && [ "${userid}" != "Nextcloud name" ]; then
        sudo -u www-data php  ${ROOT_DIR}/occ user:delete "${userid}"
    fi
done
