#!/bin/bash

ROOT_DIR=/var/www/html/nextcloud
DATA_DIR=/home/www-data/var/www/html/nextcloud
SOURCES_DIR=/var/www/nextcloud

VERSIONS=( 25.0.9 \
           24.0.1 \
           23.0.5 \
           22.2.8 \
           21.0.9 \
           20.0.14 \
           19.0.1 \
           18.0.4 \
           17.0.5 \
           16.0.9 \
           15.0.14 \
           14.0.3 \
           13.0.6 \
           12.0.3 )
VERSIONS_MAX_INDEX=$(( ${#VERSIONS[@]} - 1 ))
LAST_VERSION=${VERSIONS[0]}

PROJECT=nextcloud

# RAZ
if [ "$1" == "RAZ" ];then
    rm -rf /var/www/html/nextcloud
    rm -rf /home/www-data/var/www/html/nextcloud
    mysql_pwd.py 123456 root >/dev/null
    
    echo "DROP DATABASE nextcloud;" | mysql -uroot -p123456 -hlocalhost >/dev/null 2>&1 
    echo "CREATE DATABASE nextcloud CHARACTER SET utf8;" | mysql -uroot -p123456 -hlocalhost >/dev/null 2>&1 
    echo "ALTER USER 'nextcloud'@'localhost' IDENTIFIED BY 'changeme'; FLUSH PRIVILEGES;" | mysql -uroot -p123456 -hlocalhost >/dev/null 2>&1 

    CreoleCat -t nextcloud-config.php
fi

# Suppression des sources
find "$SOURCES_DIR" -type d -name "nextcloud-*" -exec rm -rf {} \; >/dev/null 2>&1

# Include des login de connexion bdd
. /var/www/nextcloud/nextcloud.db

# Include des variables templetisées dans genconfig
. /var/www/nextcloud/.env

function reconstruct_sources() {
    local start=$1
    local last_step
    local steps
    local base
    local target
    
    for step in $(seq 0 $VERSIONS_MAX_INDEX)
    do
        current_version=${VERSIONS[$step]}
        previous_version=${VERSIONS[$(( $step + 1 ))]}
        if [[ "$previous_version" = "$start" ]]
        then
            last_step=$current_version}
            break
        else
            steps[$step]="${SOURCES_DIR}/nextcloud-${current_version}-to-nextcloud-${previous_version}.patch"
        fi
    done

    ls ${steps[@]} >/dev/null 2>&1
    ls_result=$?

    if [[ -z "$last_step" ]] || [[ $ls_result -ne 0 ]]
    then
        echo "Impossible de reconstruire les sources nécessaires à la mise à jour"
        exit 1
    fi

    
    echo "Reconstruction des archives nécessaires à la mise à jour de ${PROJECT}."
    for patch in ${steps[@]}
    do
        patch_name=$(basename ${patch%.patch})
        base=${patch_name%-to-*}
        target=${patch_name#*-to-}
        bspatch "${SOURCES_DIR}/${base}.tar" "${SOURCES_DIR}/${target}.tar" "${patch}" 
    done

}

function one_step_upgrade() {
    local new_version=$1
    pushd "$SOURCES_DIR" >/dev/null
    tar xf "nextcloud-${new_version}.tar"
    popd >/dev/null
    cp -f "${ROOT_DIR}/config/config.php" /tmp/nextcloud-config.php
    rm -rf "${ROOT_DIR}"
    cp -rf "/var/www/nextcloud/nextcloud-${new_version}" "${ROOT_DIR}"
    cp -f /tmp/nextcloud-config.php "${ROOT_DIR}/config/config.php" 

    /bin/chown -R www-data:www-data "${ROOT_DIR}"
    /bin/chmod g+w "${ROOT_DIR}/config" -R
    /bin/chmod u+x "${ROOT_DIR}/occ"
    /bin/chmod g+w "${ROOT_DIR}/apps" -R
    /bin/chown -R www-data:www-data "${DATA_DIR}"    

    sudo -u www-data /var/www/html/nextcloud/occ upgrade

    pushd "$SOURCES_DIR" >/dev/null
    rm -rf "nextcloud-${new_version}"
    if [[ "nextcloud-${new_version}" != "nextcloud-${LAST_VERSION}" ]]
    then
        rm -f "nextcloud-${new_version}.tar"
    fi
    popd >/dev/null

    nextcloud_version=`grep "OC_VersionString" "/var/www/html/nextcloud/version.php" | awk -F "'" '{print $2}'`

}

if [ -f /var/www/html/nextcloud/version.php ];then
    nextcloud_version=`grep "OC_VersionString" "/var/www/html/nextcloud/version.php" | awk -F "'" '{print $2}'`
    if [[ "$nextcloud_version" != "$LAST_VERSION" ]]
    then
        reconstruct_sources "${nextcloud_version}"

        if [ "$nextcloud_version" == "19.0.1" ];then
            echo "    >> Installation de la version 20.0.14"
            one_step_upgrade "20.0.14"
        fi

        if [ "$nextcloud_version" == "20.0.14" ];then
            echo "    >> Installation de la version 21.0.9"
            one_step_upgrade "21.0.9"
        fi

        if [ "$nextcloud_version" == "21.0.9" ];then
            echo "    >> Installation de la version 22.2.8"
            one_step_upgrade "22.2.8"
        fi

        if [ "$nextcloud_version" == "22.2.8" ];then
            echo "    >> Installation de la version 23.0.5"
            one_step_upgrade "23.0.5"
        fi

        if [ "$nextcloud_version" == "23.0.5" ];then
            echo "    >> Installation de la version 24.0.1"
            one_step_upgrade "24.0.1"
        fi

        if [ "$nextcloud_version" == "24.0.1" ];then
            echo "    >> Installation de la version 25.0.9"
            one_step_upgrade "25.0.9"
        fi
        sudo -u www-data ${ROOT_DIR}/occ maintenance:repair -q         

        # Nettoyage du répertoire des sources
        pushd /var/www/nextcloud >/dev/null
        find ./ -type d -name "nextcloud-*" -exec rm -rf {} \;
        popd >/dev/null
    fi
else
    echo "    >> Installation de la version ${LAST_VERSION}"

    pushd "$SOURCES_DIR" >/dev/null
    tar xf "nextcloud-${LAST_VERSION}.tar"
    popd >/dev/null

    # Création du répertoire ${DATA_DIR}
    if [ ! -d "${DATA_DIR}" ];then
        mkdir -p /home/www-data/var/www/html
        /bin/cp -R /var/www/nextcloud/patch/envoledata "${DATA_DIR}"
        /bin/chown -R www-data:www-data "${DATA_DIR}"
    fi


    # Sauvegarder le fichier de config normalement appliqué après installation de 25.0.9
    cp -f /var/www/html/nextcloud/config/config.php /var/www/nextcloud/

    # Suppression du ficher de la version car propre a un upgrade
    rm -rf /var/www/nextcloud/nextcloud-25.0.9/config/config.php
    rm -rf /var/www/html/nextcloud
    
    # Appliquer les sources de la 25.0.9
    cp -rf /var/www/nextcloud/nextcloud-25.0.9 ${ROOT_DIR}

    # Placer les permissions
    /bin/chown -R www-data:www-data ${ROOT_DIR}
    /bin/chmod g+w ${ROOT_DIR}/config -R
    /bin/chmod u+x ${ROOT_DIR}/occ
    /bin/chmod g+w ${ROOT_DIR}/apps -R
    /bin/chown -R www-data:www-data ${DATA_DIR}      

    # Lancer l'installation
    sudo -u www-data php ${ROOT_DIR}/occ  maintenance:install --database-host "${dbhostNEXTCLOUD}" --database "mysql" --database-name "nextcloud"  --database-user "nextcloud" --database-pass "${dbpassNEXTCLOUD}" --admin-user "admin" --admin-pass "password" --data-dir "${DATA_DIR}"

    # Replacer la config normal
    mv -f /var/www/nextcloud/config.php /var/www/html/nextcloud/config/config.php
    
    # Placer les permissions
    /bin/chown -R www-data:www-data ${ROOT_DIR}
    /bin/chmod g+w ${ROOT_DIR}/config -R
    /bin/chmod u+x ${ROOT_DIR}/occ
    /bin/chmod g+w ${ROOT_DIR}/apps -R
    /bin/chown -R www-data:www-data ${DATA_DIR}      
    
    rm -rf "${SOURCES_DIR}/nextcloud-${LAST_VERSION}"

    echo "    >> Fin installation"
fi


echo "    >> Appliquer Patch Envole"
# Supprimer totalement les apps purement Envole pour les regenerer proprement en cas de relicat de codes
#/bin/rm -rf ${ROOT_DIR}/apps/occtools
/bin/rm -rf ${ROOT_DIR}/apps/user_cas

# # Appliquer les patchs
/bin/cp -rf /var/www/nextcloud/patch/user_cas             ${ROOT_DIR}/apps/
/bin/cp -rf /var/www/nextcloud/patch/core                 ${ROOT_DIR}/
# /bin/cp -rf /var/www/nextcloud/patch/user_ldap          ${ROOT_DIR}/apps/
# /bin/cp -rf /var/www/nextcloud/patch/occtools           ${ROOT_DIR}/apps/
# /bin/cp -rf /var/www/nextcloud/patch/lib                ${ROOT_DIR}/
# /bin/cp -rf /var/www/nextcloud/patch/htaccess/.htaccess ${ROOT_DIR}/

# Attribution des droits minimaux
echo "    >> Permissions"
/bin/chown -R www-data:www-data ${ROOT_DIR}
/bin/chmod g+w ${ROOT_DIR}/config -R
/bin/chmod u+x ${ROOT_DIR}/occ
/bin/chmod g+w ${ROOT_DIR}/apps -R
/bin/chown -R www-data:www-data ${DATA_DIR} 

sudo -u www-data /var/www/html/nextcloud/occ upgrade

echo "    >> Activation app LDAP"
sudo -u www-data php ${ROOT_DIR}/occ app:install user_ldap -q
sudo -u www-data php ${ROOT_DIR}/occ app:update user_ldap -q
sudo -u www-data php ${ROOT_DIR}/occ app:enable user_ldap -q
sudo -u www-data php /var/www/html/nextcloud/occ ldap:show-config s01 > /tmp/nextcloud-ldap.txt
if grep -q "Invalid configID" /tmp/nextcloud-ldap.txt;then
    sudo -u www-data php /var/www/html/nextcloud/occ ldap:create-empty-config -q
fi

sudo -u www-data php /var/www/html/nextcloud/occ config:app:set user_ldap bgjRefreshInterval --value=300 -q
sudo -u www-data php /var/www/html/nextcloud/occ config:app:set user_ldap cleanUpJobChunkSize --value=300 -q
sudo -u www-data php /var/www/html/nextcloud/occ config:app:set user_ldap background_sync_interval --value=300 -q
sudo -u www-data php /var/www/html/nextcloud/occ ldap:set-config s01 ldapAgentName "${ldapAgentName}"
sudo -u www-data php /var/www/html/nextcloud/occ ldap:set-config s01 ldapAgentPassword "${ldapAgentPassword}"
sudo -u www-data php /var/www/html/nextcloud/occ ldap:set-config s01 ldapBase "${ldapBase}"
sudo -u www-data php /var/www/html/nextcloud/occ ldap:set-config s01 ldapBaseGroups "${ldapBaseGroups}"
sudo -u www-data php /var/www/html/nextcloud/occ ldap:set-config s01 ldapBaseUsers "${ldapBaseUsers}"
sudo -u www-data php /var/www/html/nextcloud/occ ldap:set-config s01 ldapConfigurationActive "1"
sudo -u www-data php /var/www/html/nextcloud/occ ldap:set-config s01 ldapExperiencedAdmin "0"
sudo -u www-data php /var/www/html/nextcloud/occ ldap:set-config s01 ldapExpertUUIDUserAttr "${ldapExpertUUIDUserAttr}"
sudo -u www-data php /var/www/html/nextcloud/occ ldap:set-config s01 ldapGroupFilter "${ldapGroupFilter}"
sudo -u www-data php /var/www/html/nextcloud/occ ldap:set-config s01 ldapGroupFilterObjectclass "${ldapGroupFilterObjectclass}"
sudo -u www-data php /var/www/html/nextcloud/occ ldap:set-config s01 ldapGroupMemberAssocAttr "${ldapGroupMemberAssocAttr}"
sudo -u www-data php /var/www/html/nextcloud/occ ldap:set-config s01 ldapHost "${ldapHost}"
sudo -u www-data php /var/www/html/nextcloud/occ ldap:set-config s01 ldapLoginFilter "${ldapLoginFilter}"
sudo -u www-data php /var/www/html/nextcloud/occ ldap:set-config s01 ldapPort "${ldapPort}"
sudo -u www-data php /var/www/html/nextcloud/occ ldap:set-config s01 ldapUserFilter "${ldapUserFilter}"
sudo -u www-data php /var/www/html/nextcloud/occ ldap:set-config s01 ldapUserFilterObjectclass "${ldapUserFilterObjectclass}"
sudo -u www-data php /var/www/html/nextcloud/occ ldap:set-config s01 ldapEmailAttribute "${ldapEmailAttribute}"
sudo -u www-data php /var/www/html/nextcloud/occ ldap:set-config s01 ldapUserDisplayName "${ldapDisplaynameAttribute}"
sudo -u www-data php /var/www/html/nextcloud/occ ldap:set-config s01 ldapCacheTTL "300"
sudo -u www-data php /var/www/html/nextcloud/occ ldap:set-config s01 ldapPagingSize "0"

if [ "${ldapTLS}" == "oui" ]; then
sudo -u www-data php /var/www/html/nextcloud/occ ldap:set-config s01 ldapTLS "1"
else
sudo -u www-data php /var/www/html/nextcloud/occ ldap:set-config s01 ldapTLS "0"
fi

echo "    >> Activation app USER CAS"
sudo -u www-data php ${ROOT_DIR}/occ app:enable user_cas -q
sudo -u www-data php ${ROOT_DIR}/occ config:app:set user_cas cas_server_hostname --value=${cas_server_hostname} -q
if [[ -z ${cas_server_path} ]]
then
    sudo -u www-data php ${ROOT_DIR}/occ config:app:set user_cas cas_server_path --value='/' -q
else
    sudo -u www-data php ${ROOT_DIR}/occ config:app:set user_cas cas_server_path --value=${cas_server_path} -q
fi
sudo -u www-data php ${ROOT_DIR}/occ config:app:set user_cas cas_server_port --value=${cas_server_port} -q
sudo -u www-data php ${ROOT_DIR}/occ config:app:set user_cas cas_server_version --value=2.0 -q
sudo -u www-data php ${ROOT_DIR}/occ config:app:set user_cas cas_force_login --value=1 -q

echo "    >> Activation app CALENDAR"
sudo -u www-data php ${ROOT_DIR}/occ app:install calendar -q
sudo -u www-data php ${ROOT_DIR}/occ app:update calendar -q
sudo -u www-data php ${ROOT_DIR}/occ app:enable calendar -q

echo "    >> Activation app DECK"
sudo -u www-data php ${ROOT_DIR}/occ app:install deck -q
sudo -u www-data php ${ROOT_DIR}/occ app:update deck -q
sudo -u www-data php ${ROOT_DIR}/occ app:enable deck -q

echo "    >> Activation app DRAWIO"
sudo -u www-data php ${ROOT_DIR}/occ app:install drawio -q
sudo -u www-data php ${ROOT_DIR}/occ app:update drawio -q
sudo -u www-data php ${ROOT_DIR}/occ app:enable drawio -q
 
echo "    >> Activation app TASKS"
sudo -u www-data php ${ROOT_DIR}/occ app:install tasks -q
sudo -u www-data php ${ROOT_DIR}/occ app:update tasks -q
sudo -u www-data php ${ROOT_DIR}/occ app:enable tasks -q

echo "    >> Activation app FILES EXTERNAL"
sudo -u www-data php ${ROOT_DIR}/occ app:install files_external -q
sudo -u www-data php ${ROOT_DIR}/occ app:update files_external -q
sudo -u www-data php ${ROOT_DIR}/occ app:enable files_external -q

echo "    >> Activation app GROUPFOLDERS"
sudo -u www-data php ${ROOT_DIR}/occ app:install groupfolders -q
sudo -u www-data php ${ROOT_DIR}/occ app:update groupfolders -q
sudo -u www-data php ${ROOT_DIR}/occ app:enable groupfolders -q

echo "    >> Activation app FILES MINDMAP"
sudo -u www-data php ${ROOT_DIR}/occ app:install files_mindmap -q
sudo -u www-data php ${ROOT_DIR}/occ app:update files_mindmap -q
sudo -u www-data php ${ROOT_DIR}/occ app:enable files_mindmap -q

# 
# echo "    >> Activation app OCCTOOLS"
# sudo -u www-data php ${ROOT_DIR}/occ app:enable occtools -q
# 

# 
echo "    >> Activation Index"
sudo -u www-data php  ${ROOT_DIR}/occ db:add-missing-indices
yes | sudo -u www-data php  ${ROOT_DIR}/occ db:convert-filecache-bigint 2>&1 

echo "    >> Désactivé notification de mise à jour"
sudo -u www-data php  ${ROOT_DIR}/occ config:app:set updatenotification notify_groups --value="[]" -q

if [ ! -z "$files_external_host" ]; then
echo "    >> Création du point de montage Envole"
sudo -u www-data php  ${ROOT_DIR}/occ files_external:import /var/www/nextcloud/patch/mount.json -q 
fi

echo "    >> Execution tache CRON"
sudo -u www-data php -f /var/www/html/nextcloud/cron.php

# Forcer login LDAP = login Nextcloud 
echo "UPDATE oc_ldap_user_mapping SET owncloud_name=directory_uuid WHERE owncloud_name!=directory_uuid ;" | mysql -unextcloud -p${dbpassNEXTCLOUD} -h${dbhostNEXTCLOUD} -Dnextcloud >/dev/null 2>&1 

# Second admin
if [ ! -z "$uid_addadmin" ]; then
echo "    >> Second admin"
sudo -u www-data php ${ROOT_DIR}/occ group:adduser admin $uid_addadmin -q
fi

# Redemarrer le service nextcloud
systemctl restart nextcloud.service

echo ""




