#!/bin/bash

len_pf=26
TPUT=/usr/bin/tput

#test si TPUT est utilisable
if [ ! "$TERM" = "" ] && $TPUT hpa 60 >/dev/null 2>&1 && $TPUT setaf 1  >/dev/null 2>&1; then
    FANCYTTY=1
else
    FANCYTTY=0
fi



Pause() {
if [ "$ModeTxt" == "yes" ];then
    echo
elif [ "$ModeEad" == "yes" ];then
    echo "<br>"
else
    [ $FANCYTTY = 1 ] && $TPUT setaf 6
    echo " Appuyez sur Entrée pour continuer ..."
    [ $FANCYTTY = 1 ] && $TPUT sgr0
    read BiDon
fi
}

Echo() {
if [ "$ModeEad" != "yes" ];
then
    echo "$1"
else
    echo "$1<br>"
fi
}

EchoColor() {
if [ "$ModeTxt" == "yes" ];then
    echo "$1"
elif [ "$ModeEad" == "yes" ];then
    echo "<FONT color=\"$3\"> $1 </FONT><br>"
else
    [ $FANCYTTY = 1 ] && $TPUT setaf $2
    echo "$1"
    [ $FANCYTTY = 1 ] && $TPUT sgr0
fi
}

EchoRouge() {
    EchoColor "$1" "1" "red"
}

EchoVert() {
    EchoColor "$1" "2" "green"
}

EchoOrange() {
    EchoColor "$1" "3" "orange"
}

EchoBleu() {
    EchoColor "$1" "4" "blue"
}

EchoMagenta() {
    EchoColor "$1" "5" "magenta"
}

EchoCyan() {
    EchoColor "$1" "6" "cyan"
}

EchoBlanc() {
    EchoColor "$1" "7" "white"
}

EchoGras() {
if [ "$ModeTxt" == "yes" ];then
    echo "$1"
elif [ "$ModeEad" == "yes" ];then
    echo "<b> $1 </b><br>"
else
    [ $FANCYTTY = 1 ] && $TPUT bold
    echo "$1"
    [ $FANCYTTY = 1 ] && $TPUT sgr0
fi
}


QuestionOuiNon() {
    [ "$2" = "" ] && default="non" || default=$2

    read -p "$1 [oui/non] [$default] : " Rep
    
    if [ ! ${Rep} ] ;then
        Rep=$default
    fi

    #passe en minuscule
    Rep=`echo $Rep | tr A-Z a-z`
    if [ "$Rep" = "oui" -o "$Rep" = "o" -o "$Rep" = "yes" -o "$Rep" = "y" ];then
        echo 1
    else
        echo 0
    fi
}



Question() {
    default=$2
    read -p "$1 [$default] : " Rep
    if [ ! ${Rep} ] ;then
        Rep=$default
    fi
    echo ${Rep}
}


QuestionMandatory() {
    default=$2
    
    while [ ! ${Rep} ]
    do
        read -p "$1 [$default] : " Rep
        if [ ! ${Rep} ] ;then
            Rep=$default
        fi        
    done
    echo ${Rep}
}























