<?php
/**
 * @copyright Copyright (c) 2016, ownCloud, Inc.
 *
 * @author Arthur Schiwon <blizzz@arthur-schiwon.de>
 * @author Joas Schilling <coding@schilljs.com>
 * @author Morris Jobke <hey@morrisjobke.de>
 *
 * @license AGPL-3.0
 *
 * This code is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License, version 3,
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License, version 3,
 * along with this program.  If not, see <http://www.gnu.org/licenses/>
 *
 */

namespace OCA\OCCTools\Command;

use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Helper\Table;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use OCP\IDBConnection;

use OCA\User_LDAP\Helper;
use OCA\User_LDAP\LDAP;

class ClearUserPreference extends Command {
    protected $db;
    protected $gproxy;
    protected $gmapping;
    protected $access;
    protected $version;

	public function __construct(IDBConnection $db) {
        $this->db = $db;

        parent::__construct();
	}

	protected function configure() {
		$this
			->setName('occtools:clearuserpreference')
            ->setDescription('Clear user preference ')
            ->addArgument('userid',InputArgument::REQUIRED,'the user name preference to clear or all')
            ->addArgument('appid',InputArgument::REQUIRED,'the appid preference to clear')            
        ;
	}

	protected function execute(InputInterface $input, OutputInterface $output) {
		try {
			$userid = $input->getArgument('userid');
            $appid = $input->getArgument('appid');
		} catch (\Exception $e) {
			$output->writeln('<error>' . $e->getMessage(). '</error>');
		}

        if($userid!="all") {
            $delete = $this->db->getQueryBuilder();
            $delete ->delete('preferences')
                    ->where($delete->expr()->eq('userid', $delete->createNamedParameter($userid)))
                    ->andWhere($delete->expr()->eq('appid', $delete->createNamedParameter($appid)));
            $delete->execute();   
            $output->writeln("User pref cleared");         
        } else {
            $delete = $this->db->getQueryBuilder();
            $delete ->delete('preferences')
                    ->where($delete->expr()->eq('appid', $delete->createNamedParameter($appid)));
            $delete->execute();            
            $output->writeln('App pref cleared');
        }
    }
}
