<?php

namespace App\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Security\Core\User\UserInterface;
use Symfony\Bridge\Doctrine\Validator\Constraints\UniqueEntity;


/**
 * User
 * 
 * @ORM\Entity(repositoryClass="App\Repository\UserRepository")
 * @ORM\Table(name="user",uniqueConstraints={@ORM\UniqueConstraint(name="username", columns={"username"})})
 * @UniqueEntity("username", message="Ce nom d'utilisateur existe dèja")
 */

class User implements UserInterface, \Serializable
{
    /**
     * @var int
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="username", type="string", length=255)
     */
    private $username;

    /**
     * @var string
     *
     * @ORM\Column(name="password", type="string", length=255)
     */
    private $password;

    /**
     * @var array
     *
     * @ORM\Column(name="roles", type="array", length=255)
     */
    private $roles = array();

    /**
     * @ORM\Column(name="salt", type="string", length=255)
     */
    private $salt = '';

    /**
     * @ORM\Column(type="string", length=250, nullable=true)
     */
    private $firstname;

    /**
     * @ORM\Column(type="string", length=250)
     */
    private $lastname;
    private $displayname;

    /**
      * @ORM\Column(type="string", length=200, nullable=true, options={"default" : 0})
     */
    private $avatar;

    /**
     * @ORM\Column(type="string", length=250)
     */
    private $email;

    /**
     * @ORM\Column(type="string", length=250, nullable=true)
     */
    private $apikey;

    /**
     * @ORM\OneToMany(targetEntity="Scrum", mappedBy="user", cascade={"persist"}, orphanRemoval=true)
     */
    private $scrums; 

    /**
     * @ORM\OneToMany(targetEntity="Scrumwidget", mappedBy="user")
     */
    private $scrumwidgets; 

    /**
     * @ORM\OneToMany(targetEntity="Timeline", mappedBy="user", cascade={"persist"}, orphanRemoval=true)
     */
    private $timelines; 

    /**
     * @ORM\OneToMany(targetEntity="Mindmap", mappedBy="user", cascade={"persist"}, orphanRemoval=true)
     */
    private $mindmaps;

    /**
     * @ORM\OneToMany(targetEntity="Etherpad", mappedBy="user", cascade={"persist"}, orphanRemoval=true)
     */
    private $etherpads; 

    /**
     * @ORM\OneToMany(targetEntity="Ethercalc", mappedBy="user", cascade={"persist"}, orphanRemoval=true)
     */
    private $ethercalcs; 

    /**
     * @ORM\OneToMany(targetEntity="Whiteboard", mappedBy="user", cascade={"persist"}, orphanRemoval=true)
     */
    private $whiteboards; 

    /**
     * @ORM\OneToMany(targetEntity="Whiteboardwidget", mappedBy="user")
     */
    private $whiteboardwidgets; 

    /**
     * @ORM\OneToMany(targetEntity="Wordcloud", mappedBy="user", cascade={"persist"}, orphanRemoval=true)
     */
    private $wordclouds; 

    /**
     * @ORM\OneToMany(targetEntity="Wordcloudword", mappedBy="user")
     */
    private $wordcloudwords; 

    /**
     * @ORM\OneToMany(targetEntity="Message", mappedBy="user")
     */
    private $messages; 

    /**
     * @ORM\ManyToMany(targetEntity="Group", inversedBy="users", cascade={"persist"})
     * @ORM\JoinTable(name="usergroupe",
     *   joinColumns={@ORM\JoinColumn(name="user", referencedColumnName="id")},
     *   inverseJoinColumns={@ORM\JoinColumn(name="groupe", referencedColumnName="id")}
     * )
     */
    private $groups;

    /**
    * @ORM\ManyToMany(targetEntity="Scrum", mappedBy="users")
    */    
    protected $scrumshareds;      

    /**
    * @ORM\ManyToMany(targetEntity="Scrum", mappedBy="userwriters")
    */    
    protected $scrumsharedwriters;    

    /**
    * @ORM\ManyToMany(targetEntity="Scrum", mappedBy="userreaders")
    */    
    protected $scrumsharedreaders;    

    /**
    * @ORM\ManyToMany(targetEntity="Whiteboard", mappedBy="users")
    */    
    protected $whiteboardshareds;      

    /**
    * @ORM\ManyToMany(targetEntity="Whiteboard", mappedBy="userwriters")
    */    
    protected $whiteboardsharedwriters;    

    /**
    * @ORM\ManyToMany(targetEntity="Whiteboard", mappedBy="userreaders")
    */    
    protected $whiteboardsharedreaders;  

    /**
    * @ORM\ManyToMany(targetEntity="Wordcloud", mappedBy="users")
    */    
    protected $wordclouddshareds;      

    /**
    * @ORM\ManyToMany(targetEntity="Wordcloud", mappedBy="userwriters")
    */    
    protected $wordcloudsharedwriters;    

    /**
    * @ORM\ManyToMany(targetEntity="Wordcloud", mappedBy="userreaders")
    */    
    protected $wordcloudsharedreaders; 

    /**
    * @ORM\ManyToMany(targetEntity="Timeline", mappedBy="users")
    */    
    protected $timelineshareds;      

    /**
    * @ORM\ManyToMany(targetEntity="Timeline", mappedBy="userreaders")
    */    
    protected $timelinesharedreaders;  

    /**
    * @ORM\ManyToMany(targetEntity="Mindmap", mappedBy="users")
    */    
    protected $mindmapshareds;      

    /**
    * @ORM\ManyToMany(targetEntity="Mindmap", mappedBy="userreaders")
    */    
    protected $mindmapsharedreaders;  

    /**
    * @ORM\ManyToMany(targetEntity="Etherpad", mappedBy="users")
    */    
    protected $etherpadshareds;      

    /**
    * @ORM\ManyToMany(targetEntity="Ethercalc", mappedBy="users")
    */    
    protected $ethercalcshareds;  
    
    /**
     * @ORM\Column(name="preference", type="array", nullable=true)
     */
    private $preference;    

    
    public function __construct()
    {
        $this->groups = new ArrayCollection();
        $this->scrums = new ArrayCollection();
        $this->etherpads = new ArrayCollection();
        $this->ethercalcs = new ArrayCollection();
        $this->scrumshareds = new ArrayCollection();
        $this->scrumsharedwriters = new ArrayCollection();
        $this->scrumsharedreaders = new ArrayCollection();
        $this->etherpadshareds = new ArrayCollection();
        $this->ethercalcshareds = new ArrayCollection();
        $this->timelineshareds = new ArrayCollection();
        $this->timelinesharedreaders = new ArrayCollection();
        $this->timelines = new ArrayCollection();
        $this->mindmaps = new ArrayCollection();
        $this->mindmapshareds = new ArrayCollection();
        $this->mindmapsharedreaders = new ArrayCollection();
        $this->scrumwidgets = new ArrayCollection();
        $this->whiteboards = new ArrayCollection();
        $this->whiteboardwidgets = new ArrayCollection();
        $this->whiteboardshareds = new ArrayCollection();
        $this->whiteboardsharedwriters = new ArrayCollection();
        $this->whiteboardsharedreaders = new ArrayCollection();
        $this->messages = new ArrayCollection();
        $this->wordclouds = new ArrayCollection();
        $this->wordcloudwords = new ArrayCollection();
        $this->wordclouddshareds = new ArrayCollection();
        $this->wordcloudsharedwriters = new ArrayCollection();
        $this->wordcloudsharedreaders = new ArrayCollection();
    }

    public function getUsername(): ?string
    {
        return $this->username;
    }

    public function getSalt(): ?string
    {
        return $this->salt;
    }

    public function setPassword($password): self
    {
        if($password!=$this->password&&$password!=""&&!is_null($password)){
            $this->salt = uniqid(mt_rand(), true);
            $hash = "{SSHA}" . base64_encode(pack("H*", sha1($password . $this->salt)) . $this->salt);

            $this->password = $hash;
        }

        return $this;
    }

    public function getPassword(): ?string
    {
        return $this->password;
    }

    public function getRoles(): ?array
    {
        return $this->roles;
    }

    public function hasRole(string $role): ?bool
    {
        return in_array($role,$this->roles);
    }

    public function eraseCredentials()
    {
    }

    public function serialize()
    {
        return serialize(array(
            $this->id,
            $this->username,
            $this->password,
            $this->salt,
        ));
    }

    public function unserialize($serialized)
    {
        list (
            $this->id,
            $this->username,
            $this->password,
            $this->salt
        ) = unserialize($serialized, array('allowed_classes' => false));
    }

    public function getDisplayname()
    {
        return $this->firstname." ".$this->lastname;
    }

    public function setId(int $id): self
    {
        $this->id = $id;

        return $this;
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function setUsername(string $username): self
    {
        $this->username = $username;

        return $this;
    }


    public function setRoles(array $roles): self
    {
        $this->roles = $roles;

        return $this;
    }

    public function setSalt(string $salt): self
    {
        $this->salt = $salt;

        return $this;
    }

    public function getFirstname(): ?string
    {
        return $this->firstname;
    }

    public function setFirstname(?string $firstname): self
    {
        $this->firstname = $firstname;

        return $this;
    }

    public function getLastname(): ?string
    {
        return $this->lastname;
    }

    public function setLastname(?string $lastname): self
    {
        $this->lastname = $lastname;

        return $this;
    }

    public function getAvatar(): ?string
    {
        if($this->avatar)
            return $this->avatar;
        else
            return "noavatar.png";
    }

    public function setAvatar(?string $avatar): self
    {
        $this->avatar = $avatar;

        return $this;
    }

    public function getEmail(): ?string
    {
        return $this->email;
    }

    public function setEmail(string $email): self
    {
        $this->email = $email;

        return $this;
    }


    public function getApikey(): ?string
    {
        return $this->apikey;
    }

    public function setApikey(?string $apikey): self
    {
        $this->apikey = $apikey;

        return $this;
    }

    /**
     * @return Collection|Group[]
     */
    public function getGroups(): Collection
    {
        return $this->groups;
    }

    public function addGroup(Group $group): self
    {
        if (!$this->groups->contains($group)) {
            $this->groups[] = $group;
        }

        return $this;
    }

    public function removeGroup(Group $group): self
    {
        if ($this->groups->contains($group)) {
            $this->groups->removeElement($group);
        }

        return $this;
    }

    /**
     * @return Collection|Scrum[]
     */
    public function getScrums(): Collection
    {
        return $this->scrums;
    }

    public function addScrum(Scrum $scrum): self
    {
        if (!$this->scrums->contains($scrum)) {
            $this->scrums[] = $scrum;
            $scrum->setUser($this);
        }

        return $this;
    }

    public function removeScrum(Scrum $scrum): self
    {
        if ($this->scrums->contains($scrum)) {
            $this->scrums->removeElement($scrum);
            // set the owning side to null (unless already changed)
            if ($scrum->getUser() === $this) {
                $scrum->setUser(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|Etherpad[]
     */
    public function getEtherpads(): Collection
    {
        return $this->etherpads;
    }

    public function addEtherpad(Etherpad $etherpad): self
    {
        if (!$this->etherpads->contains($etherpad)) {
            $this->etherpads[] = $etherpad;
            $etherpad->setUser($this);
        }

        return $this;
    }

    public function removeEtherpad(Etherpad $etherpad): self
    {
        if ($this->etherpads->contains($etherpad)) {
            $this->etherpads->removeElement($etherpad);
            // set the owning side to null (unless already changed)
            if ($etherpad->getUser() === $this) {
                $etherpad->setUser(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|Ethercalc[]
     */
    public function getEthercalcs(): Collection
    {
        return $this->ethercalcs;
    }

    public function addEthercalc(Ethercalc $ethercalc): self
    {
        if (!$this->ethercalcs->contains($ethercalc)) {
            $this->ethercalcs[] = $ethercalc;
            $ethercalc->setUser($this);
        }

        return $this;
    }

    public function removeEthercalc(Ethercalc $ethercalc): self
    {
        if ($this->ethercalcs->contains($ethercalc)) {
            $this->ethercalcs->removeElement($ethercalc);
            // set the owning side to null (unless already changed)
            if ($ethercalc->getUser() === $this) {
                $ethercalc->setUser(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|Scrum[]
     */
    public function getScrumshareds(): Collection
    {
        return $this->scrumshareds;
    }

    public function addScrumshared(Scrum $scrumshared): self
    {
        if (!$this->scrumshareds->contains($scrumshared)) {
            $this->scrumshareds[] = $scrumshared;
            $scrumshared->addUser($this);
        }

        return $this;
    }

    public function removeScrumshared(Scrum $scrumshared): self
    {
        if ($this->scrumshareds->contains($scrumshared)) {
            $this->scrumshareds->removeElement($scrumshared);
            $scrumshared->removeUser($this);
        }

        return $this;
    }

    /**
     * @return Collection|Scrum[]
     */
    public function getScrumsharedwriters(): Collection
    {
        return $this->scrumsharedwriters;
    }

    public function addScrumsharedwriter(Scrum $scrumsharedwriter): self
    {
        if (!$this->scrumsharedwriters->contains($scrumsharedwriter)) {
            $this->scrumsharedwriters[] = $scrumsharedwriter;
            $scrumsharedwriter->addUserwriter($this);
        }

        return $this;
    }

    public function removeScrumsharedwriter(Scrum $scrumsharedwriter): self
    {
        if ($this->scrumsharedwriters->contains($scrumsharedwriter)) {
            $this->scrumsharedwriters->removeElement($scrumsharedwriter);
            $scrumsharedwriter->removeUserwriter($this);
        }

        return $this;
    }

    /**
     * @return Collection|Scrum[]
     */
    public function getScrumsharedreaders(): Collection
    {
        return $this->scrumsharedreaders;
    }

    public function addScrumsharedreader(Scrum $scrumsharedreader): self
    {
        if (!$this->scrumsharedreaders->contains($scrumsharedreader)) {
            $this->scrumsharedreaders[] = $scrumsharedreader;
            $scrumsharedreader->addUserreader($this);
        }

        return $this;
    }

    public function removeScrumsharedreader(Scrum $scrumsharedreader): self
    {
        if ($this->scrumsharedreaders->contains($scrumsharedreader)) {
            $this->scrumsharedreaders->removeElement($scrumsharedreader);
            $scrumsharedreader->removeUserreader($this);
        }

        return $this;
    }

    /**
     * @return Collection|Etherpad[]
     */
    public function getEtherpadshareds(): Collection
    {
        return $this->etherpadshareds;
    }

    public function addEtherpadshared(Etherpad $etherpadshared): self
    {
        if (!$this->etherpadshareds->contains($etherpadshared)) {
            $this->etherpadshareds[] = $etherpadshared;
            $etherpadshared->addUser($this);
        }

        return $this;
    }

    public function removeEtherpadshared(Etherpad $etherpadshared): self
    {
        if ($this->etherpadshareds->contains($etherpadshared)) {
            $this->etherpadshareds->removeElement($etherpadshared);
            $etherpadshared->removeUser($this);
        }

        return $this;
    }

    /**
     * @return Collection|Ethercalc[]
     */
    public function getEthercalcshareds(): Collection
    {
        return $this->ethercalcshareds;
    }

    public function addEthercalcshared(Ethercalc $ethercalcshared): self
    {
        if (!$this->ethercalcshareds->contains($ethercalcshared)) {
            $this->ethercalcshareds[] = $ethercalcshared;
            $ethercalcshared->addUser($this);
        }

        return $this;
    }

    public function removeEthercalcshared(Ethercalc $ethercalcshared): self
    {
        if ($this->ethercalcshareds->contains($ethercalcshared)) {
            $this->ethercalcshareds->removeElement($ethercalcshared);
            $ethercalcshared->removeUser($this);
        }

        return $this;
    }

    /**
     * @return Collection|Timeline[]
     */
    public function getTimelineshareds(): Collection
    {
        return $this->timelineshareds;
    }

    public function addTimelineshared(Timeline $timelineshared): self
    {
        if (!$this->timelineshareds->contains($timelineshared)) {
            $this->timelineshareds[] = $timelineshared;
            $timelineshared->addUser($this);
        }

        return $this;
    }

    public function removeTimelineshared(Timeline $timelineshared): self
    {
        if ($this->timelineshareds->contains($timelineshared)) {
            $this->timelineshareds->removeElement($timelineshared);
            $timelineshared->removeUser($this);
        }

        return $this;
    }

    /**
     * @return Collection|Timeline[]
     */
    public function getTimelinesharedreaders(): Collection
    {
        return $this->timelinesharedreaders;
    }

    public function addTimelinesharedreader(Timeline $timelinesharedreader): self
    {
        if (!$this->timelinesharedreaders->contains($timelinesharedreader)) {
            $this->timelinesharedreaders[] = $timelinesharedreader;
            $timelinesharedreader->addUserreader($this);
        }

        return $this;
    }

    public function removeTimelinesharedreader(Timeline $timelinesharedreader): self
    {
        if ($this->timelinesharedreaders->contains($timelinesharedreader)) {
            $this->timelinesharedreaders->removeElement($timelinesharedreader);
            $timelinesharedreader->removeUserreader($this);
        }

        return $this;
    }

    /**
     * @return Collection|Timeline[]
     */
    public function getTimelines(): Collection
    {
        return $this->timelines;
    }

    public function addTimeline(Timeline $timeline): self
    {
        if (!$this->timelines->contains($timeline)) {
            $this->timelines[] = $timeline;
            $timeline->setUser($this);
        }

        return $this;
    }

    public function removeTimeline(Timeline $timeline): self
    {
        if ($this->timelines->contains($timeline)) {
            $this->timelines->removeElement($timeline);
            // set the owning side to null (unless already changed)
            if ($timeline->getUser() === $this) {
                $timeline->setUser(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|Mindmap[]
     */
    public function getMindmaps(): Collection
    {
        return $this->mindmaps;
    }

    public function addMindmap(Mindmap $mindmap): self
    {
        if (!$this->mindmaps->contains($mindmap)) {
            $this->mindmaps[] = $mindmap;
            $mindmap->setUser($this);
        }

        return $this;
    }

    public function removeMindmap(Mindmap $mindmap): self
    {
        if ($this->mindmaps->contains($mindmap)) {
            $this->mindmaps->removeElement($mindmap);
            // set the owning side to null (unless already changed)
            if ($mindmap->getUser() === $this) {
                $mindmap->setUser(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|Mindmap[]
     */
    public function getMindmapshareds(): Collection
    {
        return $this->mindmapshareds;
    }

    public function addMindmapshared(Mindmap $mindmapshared): self
    {
        if (!$this->mindmapshareds->contains($mindmapshared)) {
            $this->mindmapshareds[] = $mindmapshared;
            $mindmapshared->addUser($this);
        }

        return $this;
    }

    public function removeMindmapshared(Mindmap $mindmapshared): self
    {
        if ($this->mindmapshareds->contains($mindmapshared)) {
            $this->mindmapshareds->removeElement($mindmapshared);
            $mindmapshared->removeUser($this);
        }

        return $this;
    }

    /**
     * @return Collection|Mindmap[]
     */
    public function getMindmapsharedreaders(): Collection
    {
        return $this->mindmapsharedreaders;
    }

    public function addMindmapsharedreader(Mindmap $mindmapsharedreader): self
    {
        if (!$this->mindmapsharedreaders->contains($mindmapsharedreader)) {
            $this->mindmapsharedreaders[] = $mindmapsharedreader;
            $mindmapsharedreader->addUserreader($this);
        }

        return $this;
    }

    public function removeMindmapsharedreader(Mindmap $mindmapsharedreader): self
    {
        if ($this->mindmapsharedreaders->contains($mindmapsharedreader)) {
            $this->mindmapsharedreaders->removeElement($mindmapsharedreader);
            $mindmapsharedreader->removeUserreader($this);
        }

        return $this;
    }

    /**
     * @return Collection|Scrumwidget[]
     */
    public function getScrumwidgets(): Collection
    {
        return $this->scrumwidgets;
    }

    public function addScrumwidget(Scrumwidget $scrumwidget): self
    {
        if (!$this->scrumwidgets->contains($scrumwidget)) {
            $this->scrumwidgets[] = $scrumwidget;
            $scrumwidget->setUser($this);
        }

        return $this;
    }

    public function removeScrumwidget(Scrumwidget $scrumwidget): self
    {
        if ($this->scrumwidgets->contains($scrumwidget)) {
            $this->scrumwidgets->removeElement($scrumwidget);
            // set the owning side to null (unless already changed)
            if ($scrumwidget->getUser() === $this) {
                $scrumwidget->setUser(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|Whiteboard[]
     */
    public function getWhiteboards(): Collection
    {
        return $this->whiteboards;
    }

    public function addWhiteboard(Whiteboard $whiteboard): self
    {
        if (!$this->whiteboards->contains($whiteboard)) {
            $this->whiteboards[] = $whiteboard;
            $whiteboard->setUser($this);
        }

        return $this;
    }

    public function removeWhiteboard(Whiteboard $whiteboard): self
    {
        if ($this->whiteboards->contains($whiteboard)) {
            $this->whiteboards->removeElement($whiteboard);
            // set the owning side to null (unless already changed)
            if ($whiteboard->getUser() === $this) {
                $whiteboard->setUser(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|Whiteboardwidget[]
     */
    public function getWhiteboardwidgets(): Collection
    {
        return $this->whiteboardwidgets;
    }

    public function addWhiteboardwidget(Whiteboardwidget $whiteboardwidget): self
    {
        if (!$this->whiteboardwidgets->contains($whiteboardwidget)) {
            $this->whiteboardwidgets[] = $whiteboardwidget;
            $whiteboardwidget->setUser($this);
        }

        return $this;
    }

    public function removeWhiteboardwidget(Whiteboardwidget $whiteboardwidget): self
    {
        if ($this->whiteboardwidgets->contains($whiteboardwidget)) {
            $this->whiteboardwidgets->removeElement($whiteboardwidget);
            // set the owning side to null (unless already changed)
            if ($whiteboardwidget->getUser() === $this) {
                $whiteboardwidget->setUser(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|Whiteboard[]
     */
    public function getWhiteboardshareds(): Collection
    {
        return $this->whiteboardshareds;
    }

    public function addWhiteboardshared(Whiteboard $whiteboardshared): self
    {
        if (!$this->whiteboardshareds->contains($whiteboardshared)) {
            $this->whiteboardshareds[] = $whiteboardshared;
            $whiteboardshared->addUser($this);
        }

        return $this;
    }

    public function removeWhiteboardshared(Whiteboard $whiteboardshared): self
    {
        if ($this->whiteboardshareds->contains($whiteboardshared)) {
            $this->whiteboardshareds->removeElement($whiteboardshared);
            $whiteboardshared->removeUser($this);
        }

        return $this;
    }

    /**
     * @return Collection|Whiteboard[]
     */
    public function getWhiteboardsharedwriters(): Collection
    {
        return $this->whiteboardsharedwriters;
    }

    public function addWhiteboardsharedwriter(Whiteboard $whiteboardsharedwriter): self
    {
        if (!$this->whiteboardsharedwriters->contains($whiteboardsharedwriter)) {
            $this->whiteboardsharedwriters[] = $whiteboardsharedwriter;
            $whiteboardsharedwriter->addUserwriter($this);
        }

        return $this;
    }

    public function removeWhiteboardsharedwriter(Whiteboard $whiteboardsharedwriter): self
    {
        if ($this->whiteboardsharedwriters->contains($whiteboardsharedwriter)) {
            $this->whiteboardsharedwriters->removeElement($whiteboardsharedwriter);
            $whiteboardsharedwriter->removeUserwriter($this);
        }

        return $this;
    }

    /**
     * @return Collection|Whiteboard[]
     */
    public function getWhiteboardsharedreaders(): Collection
    {
        return $this->whiteboardsharedreaders;
    }

    public function addWhiteboardsharedreader(Whiteboard $whiteboardsharedreader): self
    {
        if (!$this->whiteboardsharedreaders->contains($whiteboardsharedreader)) {
            $this->whiteboardsharedreaders[] = $whiteboardsharedreader;
            $whiteboardsharedreader->addUserreader($this);
        }

        return $this;
    }

    public function removeWhiteboardsharedreader(Whiteboard $whiteboardsharedreader): self
    {
        if ($this->whiteboardsharedreaders->contains($whiteboardsharedreader)) {
            $this->whiteboardsharedreaders->removeElement($whiteboardsharedreader);
            $whiteboardsharedreader->removeUserreader($this);
        }

        return $this;
    }

    /**
     * @return Collection|Message[]
     */
    public function getMessages(): Collection
    {
        return $this->messages;
    }

    public function addMessage(Message $message): self
    {
        if (!$this->messages->contains($message)) {
            $this->messages[] = $message;
            $message->setUser($this);
        }

        return $this;
    }

    public function removeMessage(Message $message): self
    {
        if ($this->messages->contains($message)) {
            $this->messages->removeElement($message);
            // set the owning side to null (unless already changed)
            if ($message->getUser() === $this) {
                $message->setUser(null);
            }
        }

        return $this;
    }

    public function getPreference(): ?array
    {
        return $this->preference;
    }

    public function setPreference(?array $preference): self
    {
        $this->preference = $preference;

        return $this;
    }

    /**
     * @return Collection|Wordcloud[]
     */
    public function getWordclouds(): Collection
    {
        return $this->wordclouds;
    }

    public function addWordcloud(Wordcloud $wordcloud): self
    {
        if (!$this->wordclouds->contains($wordcloud)) {
            $this->wordclouds[] = $wordcloud;
            $wordcloud->setUser($this);
        }

        return $this;
    }

    public function removeWordcloud(Wordcloud $wordcloud): self
    {
        if ($this->wordclouds->contains($wordcloud)) {
            $this->wordclouds->removeElement($wordcloud);
            // set the owning side to null (unless already changed)
            if ($wordcloud->getUser() === $this) {
                $wordcloud->setUser(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|Wordcloudword[]
     */
    public function getWordcloudwords(): Collection
    {
        return $this->wordcloudwords;
    }

    public function addWordcloudword(Wordcloudword $wordcloudword): self
    {
        if (!$this->wordcloudwords->contains($wordcloudword)) {
            $this->wordcloudwords[] = $wordcloudword;
            $wordcloudword->setUser($this);
        }

        return $this;
    }

    public function removeWordcloudword(Wordcloudword $wordcloudword): self
    {
        if ($this->wordcloudwords->contains($wordcloudword)) {
            $this->wordcloudwords->removeElement($wordcloudword);
            // set the owning side to null (unless already changed)
            if ($wordcloudword->getUser() === $this) {
                $wordcloudword->setUser(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|Wordcloud[]
     */
    public function getWordclouddshareds(): Collection
    {
        return $this->wordclouddshareds;
    }

    public function addWordclouddshared(Wordcloud $wordclouddshared): self
    {
        if (!$this->wordclouddshareds->contains($wordclouddshared)) {
            $this->wordclouddshareds[] = $wordclouddshared;
            $wordclouddshared->addUser($this);
        }

        return $this;
    }

    public function removeWordclouddshared(Wordcloud $wordclouddshared): self
    {
        if ($this->wordclouddshareds->contains($wordclouddshared)) {
            $this->wordclouddshareds->removeElement($wordclouddshared);
            $wordclouddshared->removeUser($this);
        }

        return $this;
    }

    /**
     * @return Collection|Wordcloud[]
     */
    public function getWordcloudsharedwriters(): Collection
    {
        return $this->wordcloudsharedwriters;
    }

    public function addWordcloudsharedwriter(Wordcloud $wordcloudsharedwriter): self
    {
        if (!$this->wordcloudsharedwriters->contains($wordcloudsharedwriter)) {
            $this->wordcloudsharedwriters[] = $wordcloudsharedwriter;
            $wordcloudsharedwriter->addUserwriter($this);
        }

        return $this;
    }

    public function removeWordcloudsharedwriter(Wordcloud $wordcloudsharedwriter): self
    {
        if ($this->wordcloudsharedwriters->contains($wordcloudsharedwriter)) {
            $this->wordcloudsharedwriters->removeElement($wordcloudsharedwriter);
            $wordcloudsharedwriter->removeUserwriter($this);
        }

        return $this;
    }

    /**
     * @return Collection|Wordcloud[]
     */
    public function getWordcloudsharedreaders(): Collection
    {
        return $this->wordcloudsharedreaders;
    }

    public function addWordcloudsharedreader(Wordcloud $wordcloudsharedreader): self
    {
        if (!$this->wordcloudsharedreaders->contains($wordcloudsharedreader)) {
            $this->wordcloudsharedreaders[] = $wordcloudsharedreader;
            $wordcloudsharedreader->addUserreader($this);
        }

        return $this;
    }

    public function removeWordcloudsharedreader(Wordcloud $wordcloudsharedreader): self
    {
        if ($this->wordcloudsharedreaders->contains($wordcloudsharedreader)) {
            $this->wordcloudsharedreaders->removeElement($wordcloudsharedreader);
            $wordcloudsharedreader->removeUserreader($this);
        }

        return $this;
    }
}
