<?php

namespace App\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use Symfony\Component\Validator\Constraints as Assert;

/**
 * Message
 *
 * @ORM\Table(name="message")
 * @ORM\Entity(repositoryClass="App\Repository\MessageRepository")
 */
class Message
{
    /**
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\Column(type="text")
     */
    private $message;

    /**
     * @ORM\Column(type="datetime")
     */
    private $submitdate;

    /**
     * @ORM\ManyToOne(targetEntity="User", inversedBy="messages")
     */
    private $user;

    /**
     * @ORM\ManyToOne(targetEntity="Scrumwidget", inversedBy="messages")
     */
    private $scrumwidget;

    /**
     * @ORM\ManyToOne(targetEntity="Whiteboardwidget", inversedBy="messages")
     */
    private $whiteboardwidget;

    public function __construct()
    {
        $this->submitdate = new \DateTime();
    }
        
    public function getId(): ?int
    {
        return $this->id;
    }

    public function setId(int $id): self
    {
        $this->id = $id;

        return $this;
    }
    
    public function getMessage(): ?string
    {
        return $this->message;
    }

    public function setMessage(string $message): self
    {
        $this->message = $message;

        return $this;
    }

    public function getSubmitdate(): ?\DateTimeInterface
    {
        return $this->submitdate;
    }

    public function setSubmitdate(\DateTimeInterface $submitdate): self
    {
        $this->submitdate = $submitdate;

        return $this;
    }

    public function getUser(): ?User
    {
        return $this->user;
    }

    public function setUser(?User $user): self
    {
        $this->user = $user;

        return $this;
    }

    public function getScrumwidget(): ?Scrumwidget
    {
        return $this->scrumwidget;
    }

    public function setScrumwidget(?Scrumwidget $scrumwidget): self
    {
        $this->scrumwidget = $scrumwidget;

        return $this;
    }

    public function getWhiteboardwidget(): ?Whiteboardwidget
    {
        return $this->whiteboardwidget;
    }

    public function setWhiteboardwidget(?Whiteboardwidget $whiteboardwidget): self
    {
        $this->whiteboardwidget = $whiteboardwidget;

        return $this;
    }
  
}