<?php

namespace App\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

/**
 * Scrum
 *
 * @ORM\Table(name="mindmap")
 * @ORM\Entity(repositoryClass="App\Repository\MindmapRepository")
 * 
 */
class Mindmap
{
    /**
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\Column(name="name", type="string", length=100)
     */
    private $title;

    /**
     * @ORM\Column(name="description", type="text", nullable=true)
     */
    private $description;
        
    /**
     * @ORM\Column(name="backgroundcolor", type="string", nullable=true)
     */
    private $backgroundcolor;
    
    /**
     * @ORM\Column(name="backgroundimage", type="string", nullable=true)
     */
    private $backgroundimage;
    
    /**
     * @ORM\Column(name="backgroundmode", type="string", nullable=true)
     */
    private $backgroundmode;   

    /**
     * @ORM\ManyToOne(targetEntity="User", inversedBy="mindmaps")
     */
    private $user;

    /**
     * @ORM\ManyToMany(targetEntity="Group", inversedBy="mindmaps", cascade={"persist"})
     * @ORM\JoinTable(name="mindmapgroupe",
     *   joinColumns={@ORM\JoinColumn(name="mindmap", referencedColumnName="id")},
     *   inverseJoinColumns={@ORM\JoinColumn(name="groupe", referencedColumnName="id")}
     * )
     */
    protected $groups;

    /**
     * @ORM\ManyToMany(targetEntity="Group", inversedBy="mindmapreaders", cascade={"persist"})
     * @ORM\JoinTable(name="mindmapgroupereader",
     *   joinColumns={@ORM\JoinColumn(name="mindmap", referencedColumnName="id")},
     *   inverseJoinColumns={@ORM\JoinColumn(name="groupe", referencedColumnName="id")}
     * )
     */
    protected $groupreaders;

    /**
     * @ORM\ManyToMany(targetEntity="User", inversedBy="mindmapshareds", cascade={"persist"})
     * @ORM\JoinTable(name="mindmapuser",
     *   joinColumns={@ORM\JoinColumn(name="mindmap", referencedColumnName="id")},
     *   inverseJoinColumns={@ORM\JoinColumn(name="user", referencedColumnName="id")}
     * )
     */
    protected $users;

    /**
     * @ORM\ManyToMany(targetEntity="User", inversedBy="mindmapsharedreaders", cascade={"persist"})
     * @ORM\JoinTable(name="mindmapuserreader",
     *   joinColumns={@ORM\JoinColumn(name="mindmap", referencedColumnName="id")},
     *   inverseJoinColumns={@ORM\JoinColumn(name="user", referencedColumnName="id")}
     * )
     */
    protected $userreaders;

    public function __construct()
    {
        $this->groups = new ArrayCollection();
        $this->groupreaders = new ArrayCollection();
        $this->users = new ArrayCollection();
        $this->userreaders = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function setId(int $id): self
    {
        $this->id = $id;

        return $this;
    }
    
    public function getTitle(): ?string
    {
        return $this->title;
    }

    public function setTitle(string $title): self
    {
        $this->title = $title;

        return $this;
    }

    public function getDescription(): ?string
    {
        return $this->description;
    }

    public function setDescription(?string $description): self
    {
        $this->description = $description;

        return $this;
    }

    public function getUser(): ?User
    {
        return $this->user;
    }

    public function setUser(?User $user): self
    {
        $this->user = $user;

        return $this;
    }

    /**
     * @return Collection|Group[]
     */
    public function getGroups(): Collection
    {
        return $this->groups;
    }

    public function addGroup(Group $group): self
    {
        if (!$this->groups->contains($group)) {
            $this->groups[] = $group;
        }

        return $this;
    }

    public function removeGroup(Group $group): self
    {
        if ($this->groups->contains($group)) {
            $this->groups->removeElement($group);
        }

        return $this;
    }

    /**
     * @return Collection|Group[]
     */
    public function getGroupreaders(): Collection
    {
        return $this->groupreaders;
    }

    public function addGroupreader(Group $groupreader): self
    {
        if (!$this->groupreaders->contains($groupreader)) {
            $this->groupreaders[] = $groupreader;
        }

        return $this;
    }

    public function removeGroupreader(Group $groupreader): self
    {
        if ($this->groupreaders->contains($groupreader)) {
            $this->groupreaders->removeElement($groupreader);
        }

        return $this;
    }

    /**
     * @return Collection|User[]
     */
    public function getUsers(): Collection
    {
        return $this->users;
    }

    public function addUser(User $user): self
    {
        if (!$this->users->contains($user)) {
            $this->users[] = $user;
        }

        return $this;
    }

    public function removeUser(User $user): self
    {
        if ($this->users->contains($user)) {
            $this->users->removeElement($user);
        }

        return $this;
    }

    /**
     * @return Collection|User[]
     */
    public function getUserreaders(): Collection
    {
        return $this->userreaders;
    }

    public function addUserreader(User $userreader): self
    {
        if (!$this->userreaders->contains($userreader)) {
            $this->userreaders[] = $userreader;
        }

        return $this;
    }

    public function removeUserreader(User $userreader): self
    {
        if ($this->userreaders->contains($userreader)) {
            $this->userreaders->removeElement($userreader);
        }

        return $this;
    }

    public function getBackgroundcolor(): ?string
    {
        return $this->backgroundcolor;
    }

    public function setBackgroundcolor(?string $backgroundcolor): self
    {
        $this->backgroundcolor = $backgroundcolor;

        return $this;
    }

    public function getBackgroundimage(): ?string
    {
        return $this->backgroundimage;
    }

    public function setBackgroundimage(?string $backgroundimage): self
    {
        $this->backgroundimage = $backgroundimage;

        return $this;
    }

    public function getBackgroundmode(): ?string
    {
        return $this->backgroundmode;
    }

    public function setBackgroundmode(?string $backgroundmode): self
    {
        $this->backgroundmode = $backgroundmode;

        return $this;
    }


}
