<?php

namespace App\Service;

class ethercalcService
{
    protected $url;
    protected $key;

    public function __construct($appWeburl, $appUrlethercalc)
    {
        $this->url = $appUrlethercalc;

        // Si url dans le meme domaine on ajoute l'url complète
        if(stripos($this->url,"http")===false) {
            $this->url = "https://".$appWeburl.$appUrlethercalc;        
        }
    }

    public function listAllCalcs() {
        $apiurl = $this->url."_rooms";
        $response=$this->api("GET",$apiurl,"");
        if(!$response||$response->code!="200") return false;
        else {
            $calcs=$response->body;
            foreach($calcs as $key => $calc) {
                if(stripos($calc,"_formdata")!==false) {
                    unset($calcs[$key]);
                }
            }
            return $calcs;
        }
    }

    public function exists($name) {
        $apiurl = $this->url."_exists/".$name;
        $response=$this->api("GET",$apiurl,"");
        if(!$response||$response->code!="200") return false;

        return $response->body;
    }
    public function createCalc($name) {
        $exists=$this->exists($name);
        if(!$exists) {
            $apiurl = $this->url."_";
            $data  = ["room"=>$name,"snapshot"=>$name];
            $body = \Unirest\Request\Body::json($data);  
            $response=$this->api("POST",$apiurl,$body);
            if(!$response||$response->code!="202") return false;
            else return true;  
        }

        return true;
    }

    public function deleteCalc($name) {
        $apiurl = $this->url."_/".$name;
        $query  = [];
    
        $response=$this->api("DELETE",$apiurl,$query);
        if(!$response||$response->code!="201") return false;
        else return true;        
    }

    private function api($method,$url,$query) {
        // Entete
        $headers = ['Accept' => 'application/json', 'Content-Type' => 'application/json'];
    
        // Paramétrage unirest
        \Unirest\Request::verifyPeer(false);
        \Unirest\Request::verifyHost(false);
        \Unirest\Request::timeout(5);
        
        $response = false;
        switch($method) {
            case "POST":
                // Tentative sans proxy
                try{
                    $response = \Unirest\Request::post($url,$headers,$query);
                }
                catch (\Exception $e) {
                    // On tente avec le proxy s'il y en a un
                    $proxyUse = $this->container->getParameter("proxyUse");
                    if($proxyUse) {
                        $proxyHost = $this->container->getParameter("proxyHost");
                        $proxyPort = $this->container->getParameter("proxyPort");
                        \Unirest\Request::proxy($proxyHost, $proxyPort, CURLPROXY_HTTP, true);

                        try{
                            $response = \Unirest\Request::post($url,$headers,$query);
                        }
                        catch (\Exception $e) {
                            return false;
                        }
                    }
                    else {
                        return false;
                    }            
                }
            break;

            case "GET":
                // Tentative sans proxy
                try{
                    $response = \Unirest\Request::get($url,$headers,$query);
                }
                catch (\Exception $e) {
                    // On tente avec le proxy s'il y en a un
                    $proxyUse = $this->container->getParameter("proxyUse");
                    if($proxyUse) {
                        $proxyHost = $this->container->getParameter("proxyHost");
                        $proxyPort = $this->container->getParameter("proxyPort");
                        \Unirest\Request::proxy($proxyHost, $proxyPort, CURLPROXY_HTTP, true);

                        try{
                            $response = \Unirest\Request::get($url,$headers,$query);
                        }
                        catch (\Exception $e) {
                            return false;
                        }
                    }
                    else {
                        return false;
                    }            
                }            
            break;

            case "DELETE":
                // Tentative sans proxy
                try{
                    $response = \Unirest\Request::delete($url,$headers,$query);
                }
                catch (\Exception $e) {
                    // On tente avec le proxy s'il y en a un
                    $proxyUse = $this->container->getParameter("proxyUse");
                    if($proxyUse) {
                        $proxyHost = $this->container->getParameter("proxyHost");
                        $proxyPort = $this->container->getParameter("proxyPort");
                        \Unirest\Request::proxy($proxyHost, $proxyPort, CURLPROXY_HTTP, true);

                        try{
                            
                            $response = \Unirest\Request::delete($url,$headers,$query);
                        }
                        catch (\Exception $e) {
                            return false;
                        }
                    }
                    else {
                        return false;
                    }            
                }
            break;            
        }

        return $response;
    }
}
