<?php

namespace App\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

/**
 * Scrum
 *
 * @ORM\Table(name="scrum")
 * @ORM\Entity(repositoryClass="App\Repository\ScrumRepository")
 * 
 */
class Scrum
{
    /**
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private $id;

    /**
     * @ORM\Column(name="name", type="string", length=100)
     */
    private $title;

    /**
     * @ORM\Column(name="backgroundcolor", type="string", nullable=true)
     */
    private $backgroundcolor;
    
    /**
     * @ORM\Column(name="backgroundimage", type="string", nullable=true)
     */
    private $backgroundimage;
    
    /**
     * @ORM\Column(name="backgroundmode", type="string", nullable=true)
     */
    private $backgroundmode;   
    
    /**
     * @ORM\Column(name="fgcomment", type="boolean")
     */
    private $fgcomment;
    
    /**
     * @ORM\ManyToOne(targetEntity="User", inversedBy="scrums")
     */
    private $user;

    /**
     * @ORM\OneToMany(targetEntity="Scrumcolumn", mappedBy="scrum", cascade={"persist"}, orphanRemoval=true)
     * @ORM\OrderBy({"roworder" = "ASC"})
     */
    private $scrumcolumns;

    /**
     * @ORM\ManyToMany(targetEntity="Group", inversedBy="scrums", cascade={"persist"})
     * @ORM\JoinTable(name="scrumgroupe",
     *   joinColumns={@ORM\JoinColumn(name="scrum", referencedColumnName="id")},
     *   inverseJoinColumns={@ORM\JoinColumn(name="groupe", referencedColumnName="id")}
     * )
     */
    protected $groups;

    /**
     * @ORM\ManyToMany(targetEntity="Group", inversedBy="scrumwriters", cascade={"persist"})
     * @ORM\JoinTable(name="scrumgroupewriter",
     *   joinColumns={@ORM\JoinColumn(name="scrum", referencedColumnName="id")},
     *   inverseJoinColumns={@ORM\JoinColumn(name="groupe", referencedColumnName="id")}
     * )
     */
    protected $groupwriters;

    /**
     * @ORM\ManyToMany(targetEntity="Group", inversedBy="scrumreaders", cascade={"persist"})
     * @ORM\JoinTable(name="scrumgroupereader",
     *   joinColumns={@ORM\JoinColumn(name="scrum", referencedColumnName="id")},
     *   inverseJoinColumns={@ORM\JoinColumn(name="groupe", referencedColumnName="id")}
     * )
     */
    protected $groupreaders;

    /**
     * @ORM\ManyToMany(targetEntity="User", inversedBy="scrumshareds", cascade={"persist"})
     * @ORM\JoinTable(name="scrumuser",
     *   joinColumns={@ORM\JoinColumn(name="scrum", referencedColumnName="id")},
     *   inverseJoinColumns={@ORM\JoinColumn(name="user", referencedColumnName="id")}
     * )
     */
    protected $users;

    /**
     * @ORM\ManyToMany(targetEntity="User", inversedBy="scrumsharedwriters", cascade={"persist"})
     * @ORM\JoinTable(name="scrumuserwriter",
     *   joinColumns={@ORM\JoinColumn(name="scrum", referencedColumnName="id")},
     *   inverseJoinColumns={@ORM\JoinColumn(name="user", referencedColumnName="id")}
     * )
     */
    protected $userwriters;

    /**
     * @ORM\ManyToMany(targetEntity="User", inversedBy="scrumsharedreaders", cascade={"persist"})
     * @ORM\JoinTable(name="scrumuserreader",
     *   joinColumns={@ORM\JoinColumn(name="scrum", referencedColumnName="id")},
     *   inverseJoinColumns={@ORM\JoinColumn(name="user", referencedColumnName="id")}
     * )
     */
    protected $userreaders;

    public function __construct()
    {
        $this->scrumcolumns = new ArrayCollection();
        $this->groups = new ArrayCollection();
        $this->groupwriters = new ArrayCollection();
        $this->groupreaders = new ArrayCollection();
        $this->users = new ArrayCollection();
        $this->userwriters = new ArrayCollection();
        $this->userreaders = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function setId(int $id): self
    {
        $this->id = $id;

        return $this;
    }
    
    public function getTitle(): ?string
    {
        return $this->title;
    }

    public function setTitle(string $title): self
    {
        $this->title = $title;

        return $this;
    }

    public function getUser(): ?User
    {
        return $this->user;
    }

    public function setUser(?User $user): self
    {
        $this->user = $user;

        return $this;
    }

    /**
     * @return Collection|Scrumcolumn[]
     */
    public function getScrumcolumns(): Collection
    {
        return $this->scrumcolumns;
    }

    public function addScrumcolumn(Scrumcolumn $scrumcolumn): self
    {
        if (!$this->scrumcolumns->contains($scrumcolumn)) {
            $this->scrumcolumns[] = $scrumcolumn;
            $scrumcolumn->setScrum($this);
        }

        return $this;
    }

    public function removeScrumcolumn(Scrumcolumn $scrumcolumn): self
    {
        if ($this->scrumcolumns->contains($scrumcolumn)) {
            $this->scrumcolumns->removeElement($scrumcolumn);
            // set the owning side to null (unless already changed)
            if ($scrumcolumn->getScrum() === $this) {
                $scrumcolumn->setScrum(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|Group[]
     */
    public function getGroups(): Collection
    {
        return $this->groups;
    }

    public function addGroup(Group $group): self
    {
        if (!$this->groups->contains($group)) {
            $this->groups[] = $group;
        }

        return $this;
    }

    public function removeGroup(Group $group): self
    {
        if ($this->groups->contains($group)) {
            $this->groups->removeElement($group);
        }

        return $this;
    }

    /**
     * @return Collection|Group[]
     */
    public function getGroupwriters(): Collection
    {
        return $this->groupwriters;
    }

    public function addGroupwriter(Group $groupwriter): self
    {
        if (!$this->groupwriters->contains($groupwriter)) {
            $this->groupwriters[] = $groupwriter;
        }

        return $this;
    }

    public function removeGroupwriter(Group $groupwriter): self
    {
        if ($this->groupwriters->contains($groupwriter)) {
            $this->groupwriters->removeElement($groupwriter);
        }

        return $this;
    }

    /**
     * @return Collection|Group[]
     */
    public function getGroupreaders(): Collection
    {
        return $this->groupreaders;
    }

    public function addGroupreader(Group $groupreader): self
    {
        if (!$this->groupreaders->contains($groupreader)) {
            $this->groupreaders[] = $groupreader;
        }

        return $this;
    }

    public function removeGroupreader(Group $groupreader): self
    {
        if ($this->groupreaders->contains($groupreader)) {
            $this->groupreaders->removeElement($groupreader);
        }

        return $this;
    }

    /**
     * @return Collection|User[]
     */
    public function getUsers(): Collection
    {
        return $this->users;
    }

    public function addUser(User $user): self
    {
        if (!$this->users->contains($user)) {
            $this->users[] = $user;
        }

        return $this;
    }

    public function removeUser(User $user): self
    {
        if ($this->users->contains($user)) {
            $this->users->removeElement($user);
        }

        return $this;
    }

    /**
     * @return Collection|User[]
     */
    public function getUserwriters(): Collection
    {
        return $this->userwriters;
    }

    public function addUserwriter(User $userwriter): self
    {
        if (!$this->userwriters->contains($userwriter)) {
            $this->userwriters[] = $userwriter;
        }

        return $this;
    }

    public function removeUserwriter(User $userwriter): self
    {
        if ($this->userwriters->contains($userwriter)) {
            $this->userwriters->removeElement($userwriter);
        }

        return $this;
    }
    
    /**
     * @return Collection|User[]
     */
    public function getUserreaders(): Collection
    {
        return $this->userreaders;
    }

    public function addUserreader(User $userreader): self
    {
        if (!$this->userreaders->contains($userreader)) {
            $this->userreaders[] = $userreader;
        }

        return $this;
    }

    public function removeUserreader(User $userreader): self
    {
        if ($this->userreaders->contains($userreader)) {
            $this->userreaders->removeElement($userreader);
        }

        return $this;
    }

    public function getFgcomment(): ?bool
    {
        return $this->fgcomment;
    }

    public function setFgcomment(bool $fgcomment): self
    {
        $this->fgcomment = $fgcomment;

        return $this;
    }

    public function getBackgroundcolor(): ?string
    {
        return $this->backgroundcolor;
    }

    public function setBackgroundcolor(?string $backgroundcolor): self
    {
        $this->backgroundcolor = $backgroundcolor;

        return $this;
    }

    public function getBackgroundimage(): ?string
    {
        return $this->backgroundimage;
    }

    public function setBackgroundimage(?string $backgroundimage): self
    {
        $this->backgroundimage = $backgroundimage;

        return $this;
    }

    public function getBackgroundmode(): ?string
    {
        return $this->backgroundmode;
    }

    public function setBackgroundmode(?string $backgroundmode): self
    {
        $this->backgroundmode = $backgroundmode;

        return $this;
    }



}
